/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.util.Arrays;
import javax.swing.JPanel;
import net.sourceforge.dvb.projectx.gui.CommonGui;

public class CutView
extends JPanel {
    private final int Top = 15;
    private final int Bottom = 188;
    private int[] image_data;
    private int width = 160;
    private int height = 90;
    private int sliderPosition = 175;
    private Object index_top = null;
    private Object index_bottom = null;
    private boolean matchingPoint = false;
    private boolean cut_top = true;
    private boolean cut_bottom = false;
    private boolean cut_match = false;
    private boolean action = false;
    private String string_bottom = "Next:";
    private String string_top = "Prev:";
    private String string_matchingpoint = "";
    private String[] string_in_out = new String[]{" -IN- ", " -OUT- "};
    private Image image_top;
    private Image image_bottom;
    private MemoryImageSource source_top;
    private MemoryImageSource source_bottom;
    private Color BackgroundColor;
    private Color RedColor;
    private Font font;

    public CutView() {
        this.image_data = new int[this.width * this.height];
        this.source_top = new MemoryImageSource(this.width, this.height, this.image_data, 0, this.width);
        this.source_top.setAnimated(true);
        this.image_top = this.createImage(this.source_top);
        this.source_bottom = new MemoryImageSource(this.width, this.height, this.image_data, 0, this.width);
        this.source_bottom.setAnimated(true);
        this.image_bottom = this.createImage(this.source_bottom);
        this.BackgroundColor = new Color(0, 35, 110);
        this.RedColor = new Color(255, 100, 100);
        this.font = new Font("Tahoma", 0, 12);
        this.setPreferredSize(new Dimension(350, 120));
        this.setMaximumSize(new Dimension(350, 120));
        this.setMinimumSize(new Dimension(350, 120));
        this.setBackground(Color.black);
        this.setVisible(true);
    }

    public void clearView(int n) {
        Arrays.fill(this.image_data, -11513776);
        this.updateView(n);
    }

    public void clearViews() {
        this.matchingPoint = false;
        this.clearView(15);
        this.clearView(188);
        CommonGui.getPicturePanel().setMixedPreviewPixel(null, 0);
    }

    public int getBottom() {
        return 188;
    }

    public Object getBottomIndex() {
        return this.index_bottom;
    }

    public Object getPreviewPosition() {
        if (this.sliderPosition < 168) {
            return this.getTopIndex();
        }
        if (this.sliderPosition > 182) {
            return this.getBottomIndex();
        }
        return null;
    }

    public int getTop() {
        return 15;
    }

    public Object getTopIndex() {
        return this.index_top;
    }

    public int getTransparencyValue() {
        double d = 1.5178571428571428;
        int n = 0;
        if (this.sliderPosition < 168) {
            n = -this.sliderPosition + 168;
        }
        if (this.sliderPosition > 182) {
            n = this.sliderPosition - 182;
        }
        n = (n = (int)(d *= (double)n)) > 255 ? 255 : n;
        return n;
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.BackgroundColor);
        graphics.fillRect(0, 0, 600, 120);
        graphics.setFont(this.font);
        graphics.setColor(this.cut_top ? Color.green : this.RedColor);
        graphics.drawRect(2, 14, this.width - 1, this.height + 1);
        graphics.drawString(this.string_top, 2, 11);
        graphics.setColor(this.cut_bottom ? Color.green : this.RedColor);
        graphics.drawRect(188, 14, this.width - 1, this.height + 1);
        graphics.drawString(this.string_bottom, 190, 11);
        if (this.matchingPoint) {
            graphics.setColor(this.cut_match ? Color.green : this.RedColor);
            graphics.drawString(this.string_matchingpoint, 2, 167);
        }
        graphics.drawImage(this.image_top, 2, 15, this);
        graphics.drawImage(this.image_bottom, 188, 15, this);
        this.paintSlider(graphics);
    }

    public void paintSlider(Graphics graphics) {
        int n = 6;
        graphics.setColor(this.cut_top ? Color.green : this.RedColor);
        graphics.fillRect(n, 110, 40, 6);
        graphics.fillRect(n + 44, 110, 32, 6);
        graphics.fillRect(n + 80, 110, 24, 6);
        graphics.fillRect(n + 108, 110, 16, 6);
        graphics.fillRect(n + 128, 110, 10, 6);
        graphics.fillRect(n + 142, 110, 6, 6);
        graphics.fillRect(n + 152, 110, 4, 6);
        graphics.setColor(this.cut_bottom ? Color.green : this.RedColor);
        graphics.fillRect(188, 110, 4, 6);
        graphics.fillRect(196, 110, 6, 6);
        graphics.fillRect(206, 110, 10, 6);
        graphics.fillRect(220, 110, 16, 6);
        graphics.fillRect(240, 110, 24, 6);
        graphics.fillRect(268, 110, 32, 6);
        graphics.fillRect(304, 110, 40, 6);
        graphics.setColor(Color.yellow);
        graphics.drawRect(this.sliderPosition - 7, 108, 14, 10);
    }

    private void scaleCutImage(int[] nArray) {
        int n = 512;
        int n2 = 288;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = (float)n2 / (float)this.height;
        float f4 = (float)n / (float)this.width;
        int n3 = 0;
        while (f < (float)n2 && n3 < this.height) {
            int n4 = n3 * this.width;
            int n5 = (int)f * n;
            int n6 = 0;
            while (f2 < (float)n && n6 < this.width) {
                this.image_data[n6 + n4] = nArray[(int)f2 + n5];
                f2 += f4;
                ++n6;
            }
            f += f3;
            ++n3;
            f2 = 0.0f;
        }
    }

    public void setImage(int[] nArray, Object[] objectArray, int n, int n2) {
        if (nArray == null) {
            this.clearView(n2);
            return;
        }
        this.scaleCutImage(nArray);
        this.updateView(n2, objectArray, n);
    }

    public void setMatchingPoint(boolean bl, Object[] objectArray, int n) {
        this.matchingPoint = bl;
        this.string_matchingpoint = this.matchingPoint ? "This: #" + (n + 1) + " @ " + objectArray[n] + this.string_in_out[n & 1] : "";
        this.cut_match = (n & 1) == 0;
    }

    public void setSlider(int n) {
        this.sliderPosition = n;
        this.repaint();
    }

    public void updateView(int n) {
        this.updateView(n, null, -1);
    }

    public void updateView(int n, Object[] objectArray, int n2) {
        if (n < 100) {
            this.source_top.newPixels();
            this.string_top = "Prev: " + (objectArray != null ? "#" + (n2 + 1) + " - " + objectArray[n2] + this.string_in_out[n2 & 1] : "= Collection Begin");
            this.cut_top = objectArray != null ? (n2 & 1) == 0 : (!this.matchingPoint ? this.cut_bottom ^ true : false);
            this.index_top = objectArray != null ? objectArray[n2] : null;
        } else {
            this.source_bottom.newPixels();
            this.string_bottom = "Next: " + (objectArray != null ? "#" + (n2 + 1) + " - " + objectArray[n2] + this.string_in_out[n2 & 1] : "= Collection End");
            this.cut_bottom = objectArray != null ? (n2 & 1) == 0 : false;
            this.index_bottom = objectArray != null ? objectArray[n2] : null;
        }
        this.repaint();
    }
}

