/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.gui.CommonGui;
import net.sourceforge.dvb.projectx.gui.UISwitchListener;
import net.sourceforge.dvb.projectx.parser.CommonParsing;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class SubpictureFrame
extends JFrame {
    String title = Resource.getString("subpicture.title");
    String info = "";
    private Picture picture;
    private JSlider slider;
    private ArrayList picture_indices = null;
    private int picture_index = 0;
    private byte[] picture_data = null;
    private int[] color_table = null;
    private int PreviewFlags = 0;
    private int horizontal_offset = 0;
    private int vertical_offset = 0;

    public SubpictureFrame() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SubpictureFrame.this.close();
            }
        });
        this.buildMenu();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.buildSizePanel(), "North");
        this.picture = new Picture();
        jPanel.add((Component)this.picture, "Center");
        jPanel.add((Component)this.buildSliderPanel(), "South");
        this.getContentPane().add("Center", jPanel);
        this.setTitle(this.title);
        ((Component)this).setBounds(200, 0, 726, 750);
        this.setResizable(false);
        UIManager.addPropertyChangeListener(new UISwitchListener(this.getRootPane()));
    }

    private int YUVtoRGB(int n) {
        int n2 = 0xFF & n >> 16;
        int n3 = 0xFF & n >> 8;
        int n4 = 0xFF & n;
        if (n2 == 0) {
            return 0;
        }
        int n5 = (int)((float)n2 + 1.402f * (float)(n3 - 128));
        int n6 = (int)((double)n2 - 0.34414 * (double)(n4 - 128) - 0.71414 * (double)(n3 - 128));
        int n7 = (int)((double)n2 + 1.722 * (double)(n4 - 128));
        int n8 = n5 < 0 ? 0 : (n5 = n5 > 255 ? 255 : n5);
        int n9 = n6 < 0 ? 0 : (n6 = n6 > 255 ? 255 : n6);
        n7 = n7 < 0 ? 0 : (n7 > 255 ? 255 : n7);
        int n10 = 255;
        return n10 << 24 | n5 << 16 | n6 << 8 | n7;
    }

    protected JMenu buildFileMenu() {
        JMenu jMenu = new JMenu();
        CommonGui.localize(jMenu, "Common.File");
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("use Preview Picture as Background");
        jCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreviewFlags = jCheckBoxMenuItem.getState() ? PreviewFlags | 1 : PreviewFlags & 0xFFFFFFFE;
                this.getPictureData(slider.getValue());
            }
        });
        jMenu.add(jCheckBoxMenuItem);
        final JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("use Letterbox");
        jCheckBoxMenuItem2.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        jCheckBoxMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreviewFlags = jCheckBoxMenuItem2.getState() ? PreviewFlags | 2 : PreviewFlags & 0xFFFFFFFD;
                this.getPictureData(slider.getValue());
            }
        });
        jMenu.add(jCheckBoxMenuItem2);
        final JCheckBoxMenuItem jCheckBoxMenuItem3 = new JCheckBoxMenuItem("don't show Multiple Areas Boundaries");
        jCheckBoxMenuItem3.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jCheckBoxMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreviewFlags = jCheckBoxMenuItem3.getState() ? PreviewFlags | 4 : PreviewFlags & 0xFFFFFFFB;
                this.getPictureData(slider.getValue());
            }
        });
        jMenu.add(jCheckBoxMenuItem3);
        final JCheckBoxMenuItem jCheckBoxMenuItem4 = new JCheckBoxMenuItem("don't apply Multiple Areas Replacements");
        jCheckBoxMenuItem4.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        jCheckBoxMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreviewFlags = jCheckBoxMenuItem4.getState() ? PreviewFlags | 8 : PreviewFlags & 0xFFFFFFF7;
                this.getPictureData(slider.getValue());
            }
        });
        jMenu.add(jCheckBoxMenuItem4);
        final JCheckBoxMenuItem jCheckBoxMenuItem5 = new JCheckBoxMenuItem("paint all as Opaque");
        jCheckBoxMenuItem5.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jCheckBoxMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreviewFlags = jCheckBoxMenuItem5.getState() ? PreviewFlags | 0x10 : PreviewFlags & 0xFFFFFFEF;
                this.getPictureData(slider.getValue());
            }
        });
        jMenu.add(jCheckBoxMenuItem5);
        jMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem();
        CommonGui.localize(jMenuItem, "Common.Close");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SubpictureFrame.this.close();
            }
        });
        jMenu.add(jMenuItem);
        return jMenu;
    }

    protected void buildMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.buildFileMenu());
        this.setJMenuBar(jMenuBar);
    }

    protected JPanel buildSizePanel() {
        JPanel jPanel = new JPanel();
        final JSlider jSlider = new JSlider();
        jSlider.setMajorTickSpacing(32);
        jSlider.setSnapToTicks(true);
        jSlider.setMaximum(1920);
        jSlider.setValue(0);
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                horizontal_offset = jSlider.getValue();
                this.repaintSubpicture();
            }
        });
        jPanel.add(new JLabel("Preview X Offset: "));
        jPanel.add(jSlider);
        final JSlider jSlider2 = new JSlider();
        jSlider2.setMajorTickSpacing(16);
        jSlider2.setSnapToTicks(true);
        jSlider2.setMaximum(1088);
        jSlider2.setValue(0);
        jSlider2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                vertical_offset = jSlider2.getValue();
                this.repaintSubpicture();
            }
        });
        jPanel.add(new JLabel("Preview Y Offset: "));
        jPanel.add(jSlider2);
        return jPanel;
    }

    protected JPanel buildSliderPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.slider = new JSlider();
        this.slider.setMajorTickSpacing(1);
        this.slider.setPaintTicks(true);
        this.slider.setSnapToTicks(true);
        this.slider.setMaximum(1);
        this.slider.setValue(0);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SubpictureFrame.this.getPictureData(SubpictureFrame.this.slider.getValue());
            }
        });
        jPanel.add(this.slider);
        return jPanel;
    }

    public void close() {
        this.resetPreview();
        this.dispose();
    }

    private void getPictureData(int n) {
        int n2;
        Object[] objectArray;
        this.picture_index = n;
        if (this.picture_index < 0 || this.picture_indices == null || this.picture_index >= this.picture_indices.size()) {
            return;
        }
        Long[] longArray = (Long[])this.picture_indices.get(this.picture_index);
        int n3 = longArray[0].intValue();
        int n4 = this.picture_data.length - n3;
        if (this.picture_index + 1 < this.picture_indices.size()) {
            objectArray = (Long[])this.picture_indices.get(this.picture_index + 1);
            n2 = objectArray[0].intValue();
            n4 = n2 - n3;
        }
        Common.getSubpictureClass().setColorTable(this.color_table);
        objectArray = new byte[n4];
        System.arraycopy(this.picture_data, n3, objectArray, 0, n4);
        this.PreviewFlags &= 0xFF;
        this.PreviewFlags |= (0xFFF & this.picture.getWidth()) << 20;
        this.PreviewFlags |= (0xFFF & this.picture.getHeight()) << 8;
        n2 = Common.getSubpictureClass().decode_picture((byte[])objectArray, 10, true, new String[2], (this.PreviewFlags & 1) == 1 ? CommonGui.getPicturePanel().getPreviewImage() : null, this.PreviewFlags);
        longArray[2] = new Long(n2 / 90);
        this.repaintSubpicture();
    }

    public void loadPreview(XInputFile xInputFile) {
        this.scanIFO(xInputFile.toString());
        if (this.scanData(xInputFile)) {
            this.show();
        }
    }

    public void repaintSubpicture() {
        this.picture.repaint();
    }

    public void resetPreview() {
        this.picture_indices = null;
        this.picture_index = 0;
        this.picture_data = null;
        this.color_table = null;
        this.info = "";
        this.slider.setMaximum(1);
        this.slider.setValue(0);
    }

    private boolean scanData(XInputFile xInputFile) {
        boolean bl = false;
        this.picture_indices = new ArrayList();
        try {
            if (!xInputFile.exists()) {
                return bl;
            }
            this.picture_data = new byte[(int)xInputFile.length()];
            this.info = xInputFile.toString();
            xInputFile.randomAccessSingleRead(this.picture_data, 0L);
            long l = 0L;
            int n = 0;
            while (n < this.picture_data.length) {
                if (this.picture_data[n] == 83 && this.picture_data[n + 1] == 80) {
                    l = CommonParsing.readPTS(this.picture_data, n + 2, 8, true, false);
                    this.picture_indices.add(new Long[]{new Long(n), new Long(CommonParsing.readPTS(this.picture_data, n + 2, 8, true, false) / 90L), null});
                    n += 8;
                }
                ++n;
            }
            this.slider.setMaximum(this.picture_indices.size() - 1);
        }
        catch (Exception exception) {
            this.slider.setMaximum(1);
            this.info = "file read error!";
            return bl;
        }
        this.slider.setValue(0);
        return bl ^ true;
    }

    private void scanIFO(String string) {
        try {
            String string2 = String.valueOf(string) + ".IFO";
            File file = new File(string2);
            if (!file.exists() && !(file = new File(String.valueOf(string.substring(0, string.lastIndexOf("."))) + ".IFO")).exists()) {
                this.color_table = null;
                return;
            }
            XInputFile xInputFile = new XInputFile(file);
            byte[] byArray = new byte[64];
            this.color_table = new int[16];
            xInputFile.randomAccessSingleRead(byArray, 4276L);
            int n = 0;
            int n2 = this.color_table.length;
            while (n < n2) {
                this.color_table[n] = this.YUVtoRGB(CommonParsing.getIntValue(byArray, n * 4, 4, false));
                ++n;
            }
        }
        catch (Exception exception) {
            this.color_table = null;
            Common.setExceptionMessage(exception);
        }
    }

    public void setFrameTitle(String string) {
        this.setTitle(String.valueOf(this.title) + " " + string);
        this.info = string;
    }

    public class Picture
    extends JPanel {
        private Font font = new Font("Tahoma", 0, 14);
        private int w = 720;
        private int h = 576;

        public Picture() {
            this.setBackground(Color.gray);
            this.setPreferredSize(new Dimension(this.w, 704));
            this.setMinimumSize(new Dimension(this.w, 704));
            this.setMaximumSize(new Dimension(this.w, 704));
        }

        public void paint(Graphics graphics) {
            this.paintPicture(graphics);
            this.paintInfoBackground(graphics);
            this.paintInfoField(graphics);
            this.paintPreviewInfo(graphics);
        }

        private void paintColorIndex(Graphics graphics) {
            graphics.setFont(this.font);
            int[] nArray = Common.getSubpictureClass().getColorTable(0);
            int n = 0;
            int n2 = 4;
            while (n < 16) {
                graphics.setColor(new Color(nArray[n]));
                graphics.fillRect(n2 + 20, 580, 12, 12);
                graphics.setColor(Color.white);
                graphics.drawString(Integer.toHexString(n).toUpperCase(), n2, 592);
                graphics.drawRect(n2 + 20, 580, 12, 12);
                ++n;
                n2 += 44;
            }
        }

        private void paintInfoBackground(Graphics graphics) {
            graphics.setColor(Color.black);
            graphics.fillRect(0, this.h, this.w, 140);
            graphics.setColor(Color.white);
            graphics.fillRect(0, this.h, this.w, 2);
        }

        private void paintInfoField(Graphics graphics) {
            graphics.setColor(Color.white);
            graphics.setFont(this.font);
            graphics.drawString(SubpictureFrame.this.info, 4, 608);
        }

        private void paintPicture(Graphics graphics) {
            Image image = Common.getSubpictureClass().getImage();
            if (image != null) {
                graphics.drawImage(image, -SubpictureFrame.this.horizontal_offset, -SubpictureFrame.this.vertical_offset, this);
            }
        }

        private void paintPreviewInfo(Graphics graphics) {
            if (SubpictureFrame.this.picture_indices == null) {
                return;
            }
            if (SubpictureFrame.this.picture_indices.size() == 0) {
                return;
            }
            Long[] longArray = (Long[])SubpictureFrame.this.picture_indices.get(SubpictureFrame.this.picture_index);
            String string = "Pos: " + longArray[0] + " / Picture: " + (SubpictureFrame.this.picture_index + 1) + " of " + SubpictureFrame.this.picture_indices.size() + " / " + Common.getSubpictureClass().isForced_Msg(1);
            graphics.setColor(Color.white);
            graphics.setFont(this.font);
            graphics.drawString(string, 4, 626);
            String string2 = "PTS In " + Common.formatTime_1(longArray[1]) + " Duration " + Common.formatTime_1(longArray[2]) + " PTS Out " + Common.formatTime_1(longArray[1] + longArray[2]);
            if (SubpictureFrame.this.picture_index + 1 < SubpictureFrame.this.picture_indices.size()) {
                Long[] longArray2 = (Long[])SubpictureFrame.this.picture_indices.get(SubpictureFrame.this.picture_index + 1);
                long l = longArray2[1] - (longArray[1] + longArray[2]);
                string2 = String.valueOf(string2) + " Next In " + Common.formatTime_1(longArray2[1]);
                string2 = l < 0L ? String.valueOf(string2) + " Overlap " + Common.formatTime_1(Math.abs(l)) : String.valueOf(string2) + " Gap " + Common.formatTime_1(l);
            } else {
                string2 = String.valueOf(string2) + " Next File End ";
            }
            graphics.drawString(string2, 4, 644);
            this.paintColorIndex(graphics);
        }
    }
}

