/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Choice;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;

public final class Waehrungen
implements Runnable {
    public static final int NONE = -1;
    public static final int DEM = 0;
    public static final int EUR = 1;
    public static final int ATS = 2;
    public static final int CHF = 3;
    public static final int USD = 4;
    public static final int GBP = 5;
    public static final int JPY = 6;
    private static final int MIN = 0;
    private static final int MAX = 6;
    public static final int COUNT = 7;
    public static final long PRECISION = 100L;
    private static final String[] IDS = new String[]{"DEM", "EUR", "ATS", "CHF", "USD", "GBP", "JPY"};
    private static final String[] NAMES = new String[]{"DM", "Euro", "\u00f6S", "sFr", "US-$", "GB-\u00a3", "Yen"};
    private static final String[] KUERZEL = new String[]{"DM", "\u20ac", "\u00f6S", "Fr", "$", "\u00a3", "\u00a5"};
    private static final String[] KURZHTML = new String[]{"DM", "&euro;", "&ouml;S", "Fr", "$", "&#163;", "&#165;"};
    private static final long CONVPREC = 100000000L;
    private static final long CONVROUND = 50000000L;
    private static final int NACHKOMMA = (int)Math.round(Math.log(1.0E8) / Math.log(10.0));
    private static final long DEM2EUR = 51129200L;
    private static final long EUR2DEM = 195583000L;
    private static final long ATS2EUR = 7267280L;
    private static final long EUR2ATS = 1376030000L;
    private static final String FIXDATE = "31.12.1998";
    private static final long CHF2EUR = 68111700L;
    private static final long EUR2CHF = 146805100L;
    private static final long USD2EUR = 93135900L;
    private static final long EUR2USD = 107370000L;
    private static final long GBP2EUR = 152500700L;
    private static final long EUR2GBP = 65611800L;
    private static final long JPY2EUR = 772848L;
    private static final long EUR2JPY = 12936330000L;
    private static final String VARDATE = "03.02.2003";
    private static final double DFAKTOR = 100.0;
    private static int listenWaehrung = -1;
    private static long[] rateEUR2X;
    private static long[] rateX2EUR;
    private static String[] dateEUR2X;
    private static String[] dateX2EUR;
    private static int rateSaveCount;
    private static boolean checked;

    static {
        rateSaveCount = 0;
        checked = false;
        new Thread(new Waehrungen()).start();
        Waehrungen.loadExchangeRates();
    }

    private Waehrungen() {
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public static Choice getChoice() {
        Choice choice = new Choice();
        int n = 0;
        while (n <= 6) {
            choice.addItem(String.valueOf(IDS[n]) + " (" + KUERZEL[n] + ")");
            ++n;
        }
        return choice;
    }

    public static long doubleToLong(String string) throws NumberFormatException {
        return Waehrungen.doubleToLong(NumUtil.getDouble(string));
    }

    public static long doubleToLong(double d) {
        return Math.round(d * 100.0);
    }

    public static double longToDouble(long l) {
        return (double)l / 100.0;
    }

    private static double sgn(double d) {
        if (d > 0.0) {
            return 1.0;
        }
        if (d < 0.0) {
            return -1.0;
        }
        return 0.0;
    }

    private static long sgn(long l) {
        if (l > 0L) {
            return 1L;
        }
        if (l < 0L) {
            return -1L;
        }
        return 0L;
    }

    public static boolean isValid(int n) {
        return n >= 0 && n <= 6;
    }

    public static String getString(long l, int n) {
        if (Waehrungen.isValid(n)) {
            return String.valueOf(NumUtil.get00String(l)) + " " + Waehrungen.getKuerzel(n);
        }
        return "<W\u00e4hrung?>";
    }

    public static long exchange(long l, int n, int n2) {
        if (n == n2) {
            return l;
        }
        if (n == 1) {
            if (n2 >= 0 && n2 <= 6) {
                long l2;
                long[] lArray = rateEUR2X;
                synchronized (lArray) {
                    l2 = rateEUR2X[n2];
                }
                if (l2 > 0L) {
                    return (l * l2 + Waehrungen.sgn(l) * 50000000L) / 100000000L;
                }
            }
        } else if (n2 == 1) {
            if (n >= 0 && n <= 6) {
                long l3;
                long[] lArray = rateX2EUR;
                synchronized (lArray) {
                    l3 = rateX2EUR[n];
                }
                if (l3 > 0L) {
                    return (l * l3 + Waehrungen.sgn(l) * 50000000L) / 100000000L;
                }
            }
        } else if (n >= 0 && n <= 6 && n2 >= 0 && n2 <= 6) {
            return Waehrungen.exchange(Waehrungen.exchange(l, n, 1), 1, n2);
        }
        return 0L;
    }

    public static synchronized void setExchangeRate(int n, int n2, double d, String string) {
        long l = d <= 0.0 ? -1L : Math.round(d * 1.0E8);
        System.out.println("  Wechselkurs: " + n + " -> " + n2 + " " + d + " " + l + "  (" + string + ")  (" + rateSaveCount + ")");
        if (n == 1) {
            if (n2 >= 0 && n2 <= 6) {
                long[] lArray = rateEUR2X;
                synchronized (lArray) {
                    Waehrungen.rateEUR2X[n2] = l;
                    Waehrungen.dateEUR2X[n2] = string;
                }
            }
        } else if (n2 == 1 && n >= 0 && n <= 6) {
            long[] lArray = rateX2EUR;
            synchronized (lArray) {
                Waehrungen.rateX2EUR[n] = l;
                Waehrungen.dateX2EUR[n] = string;
            }
        }
        if (--rateSaveCount <= 0) {
            Waehrungen.saveExchangeRates();
        }
        if (AktienMan.wechselkurse != null) {
            AktienMan.wechselkurse.update();
        }
    }

    public static String getExchangeRateEUR2X(int n) {
        if (n < 0 || n > 6 || n == 1) {
            return "";
        }
        String string = "1 EUR = ";
        long[] lArray = rateEUR2X;
        synchronized (lArray) {
            string = String.valueOf(string) + NumUtil.getString((double)rateEUR2X[n] / 1.0E8);
            string = String.valueOf(string) + " " + Waehrungen.index2Id(n) + " (" + dateEUR2X[n] + ")";
        }
        return string;
    }

    public static String getExchangeRate(int n, int n2) {
        if (n != n2) {
            if (n == 1) {
                if (n2 >= 0 && n2 <= 6) {
                    long[] lArray = rateEUR2X;
                    synchronized (lArray) {
                        String string = String.valueOf(NumUtil.getPrecisionString((double)rateEUR2X[n2] / 1.0E8, NACHKOMMA)) + " " + Waehrungen.index2Id(n2);
                        Object var4_6 = null;
                        return string;
                    }
                }
            } else if (n2 == 1 && n >= 0 && n <= 6) {
                long[] lArray = rateX2EUR;
                synchronized (lArray) {
                    String string = String.valueOf(NumUtil.getPrecisionString((double)rateX2EUR[n] / 1.0E8, NACHKOMMA)) + " " + Waehrungen.index2Id(1);
                    Object var4_7 = null;
                    return string;
                }
            }
        }
        return "";
    }

    public static String getExchangeDate(int n, int n2) {
        if (n != n2) {
            if (n == 1) {
                if (n2 >= 0 && n2 <= 6) {
                    long[] lArray = rateEUR2X;
                    synchronized (lArray) {
                        String string = dateEUR2X[n2];
                        Object var4_6 = null;
                        return string;
                    }
                }
            } else if (n2 == 1 && n >= 0 && n <= 6) {
                long[] lArray = rateX2EUR;
                synchronized (lArray) {
                    String string = dateX2EUR[n];
                    Object var4_7 = null;
                    return string;
                }
            }
        }
        return "";
    }

    public static synchronized void check(boolean bl) {
        block2: {
            if (!bl && checked) break block2;
            try {
                rateSaveCount = WechselkursLeser.start();
                checked = true;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static synchronized void loadExchangeRates() {
        rateEUR2X = new long[7];
        rateX2EUR = new long[7];
        dateEUR2X = new String[7];
        dateX2EUR = new String[7];
        long[] lArray = rateEUR2X;
        synchronized (lArray) {
            long[] lArray2 = rateX2EUR;
            synchronized (lArray2) {
                Waehrungen.rateEUR2X[1] = 100000000L;
                Waehrungen.rateEUR2X[0] = 195583000L;
                Waehrungen.rateEUR2X[2] = 1376030000L;
                Waehrungen.rateEUR2X[3] = 146805100L;
                Waehrungen.rateEUR2X[4] = 107370000L;
                Waehrungen.rateEUR2X[5] = 65611800L;
                Waehrungen.rateEUR2X[6] = 12936330000L;
                Waehrungen.rateX2EUR[1] = 100000000L;
                Waehrungen.rateX2EUR[0] = 51129200L;
                Waehrungen.rateX2EUR[2] = 7267280L;
                Waehrungen.rateX2EUR[3] = 68111700L;
                Waehrungen.rateX2EUR[4] = 93135900L;
                Waehrungen.rateX2EUR[5] = 152500700L;
                Waehrungen.rateX2EUR[6] = 772848L;
                int n = 0;
                while (n < 3) {
                    Waehrungen.dateEUR2X[n] = FIXDATE;
                    Waehrungen.dateX2EUR[n] = FIXDATE;
                    ++n;
                }
                int n2 = 3;
                while (n2 <= 6) {
                    Waehrungen.dateEUR2X[n2] = VARDATE;
                    Waehrungen.dateX2EUR[n2] = VARDATE;
                    ++n2;
                }
                BufferedReader bufferedReader = null;
                try {
                    try {
                        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FileUtil.getExchangeRateFile()), "UTF-8"));
                        XMLUtil.checkValidPrologue(bufferedReader);
                        String string = XMLUtil.nextDataLine(bufferedReader);
                        if (!string.startsWith("<exchangeRates")) {
                            throw new Exception("Unerwartetes Tag: " + string);
                        }
                        string = XMLUtil.nextDataLine(bufferedReader);
                        while (string.startsWith("<rate")) {
                            int n3 = -1;
                            int n4 = -1;
                            long l = -1L;
                            String string2 = "";
                            string = XMLUtil.nextDataLine(bufferedReader);
                            while (!string.startsWith("</rate")) {
                                if (string.startsWith("<date")) {
                                    string2 = XMLUtil.getValue(string, false);
                                } else if (string.startsWith("<from")) {
                                    n3 = Waehrungen.id2Index(XMLUtil.getValue(string, true));
                                } else if (string.startsWith("<to")) {
                                    n4 = Waehrungen.id2Index(XMLUtil.getValue(string, true));
                                } else if (string.startsWith("<value")) {
                                    l = XMLUtil.getLongValue(string);
                                }
                                string = XMLUtil.nextDataLine(bufferedReader);
                            }
                            System.out.println("Wechselkurs geladen: " + n3 + " -> " + n4 + " = " + l + " (" + string2 + ")");
                            if (n3 == 1) {
                                if (n4 >= 3 && n4 <= 6) {
                                    Waehrungen.rateEUR2X[n4] = l;
                                    Waehrungen.dateEUR2X[n4] = string2;
                                }
                            } else if (n4 == 1 && n3 >= 3 && n3 <= 6) {
                                Waehrungen.rateX2EUR[n3] = l;
                                Waehrungen.dateX2EUR[n3] = string2;
                            }
                            string = XMLUtil.nextDataLine(bufferedReader);
                        }
                        if (!string.startsWith("</exchangeRates")) {
                            throw new Exception("Unerwartetes Tag: " + string);
                        }
                    }
                    catch (Exception exception) {
                    }
                    Object var8_10 = null;
                    if (bufferedReader == null) return;
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    if (bufferedReader == null) throw throwable;
                    try {
                        bufferedReader.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
                {
                }
            }
            return;
        }
    }

    private static void saveExchangeRates() {
        long[] lArray = rateEUR2X;
        synchronized (lArray) {
            long[] lArray2 = rateX2EUR;
            synchronized (lArray2) {
                PrintWriter printWriter = null;
                try {
                    try {
                        printWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FileUtil.getExchangeRateFile()), "UTF-8")), false);
                        XMLUtil.writePrologue(printWriter);
                        XMLUtil.writeComment(printWriter, "ACHTUNG: Veraendern Sie diese Datei in keiner Weise, AktienMan kann derzeit noch keine beliebigen XML-Dokumente einlesen!");
                        XMLUtil.writeComment(printWriter, new Date().toString());
                        printWriter.println("<exchangeRates>");
                        printWriter.println();
                        int n = 3;
                        while (n <= 6) {
                            printWriter.println("<rate>");
                            printWriter.println("<from>EUR</from>");
                            printWriter.println("<to>" + Waehrungen.index2Id(n) + "</to>");
                            printWriter.println("<value>" + rateEUR2X[n] + "</value>");
                            printWriter.println("<date>" + dateEUR2X[n] + "</date>");
                            printWriter.println("</rate>");
                            printWriter.println();
                            printWriter.println("<rate>");
                            printWriter.println("<from>" + Waehrungen.index2Id(n) + "</from>");
                            printWriter.println("<to>EUR</to>");
                            printWriter.println("<value>" + rateX2EUR[n] + "</value>");
                            printWriter.println("<date>" + dateX2EUR[n] + "</date>");
                            printWriter.println("</rate>");
                            printWriter.println();
                            ++n;
                        }
                        printWriter.println("</exchangeRates>");
                        printWriter.flush();
                    }
                    catch (Exception exception) {
                    }
                    Object var6_4 = null;
                    if (printWriter != null) {
                        printWriter.close();
                    }
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    if (printWriter != null) {
                        printWriter.close();
                    }
                    throw throwable;
                }
            }
        }
    }

    public static synchronized int getStandardKaufwaehrung() {
        return AktienMan.properties.getInt("Konfig.StdWaehrung", 1);
    }

    public static synchronized int getVerkaufsWaehrung() {
        return Waehrungen.getListenWaehrung();
    }

    public static synchronized int getListenWaehrung() {
        if (listenWaehrung <= -1) {
            listenWaehrung = AktienMan.properties.getInt("Konfig.Listenwaehrung", 1);
        }
        return listenWaehrung;
    }

    public static synchronized void setListenWaehrung(int n) {
        AktienMan.properties.setInt("Konfig.Listenwaehrung", n);
        listenWaehrung = n;
    }

    public static String getKuerzel(int n) {
        if (n >= 0 && n < KUERZEL.length) {
            return KUERZEL[n];
        }
        return "";
    }

    public static String getName(int n) {
        if (n >= 0 && n < NAMES.length) {
            return NAMES[n];
        }
        return "";
    }

    public static int id2Index(String string) {
        if (string != null) {
            int n = 0;
            while (n < IDS.length) {
                if (string.equals(IDS[n])) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public static String index2Id(int n) {
        if (n >= 0 && n < IDS.length) {
            return IDS[n];
        }
        return "";
    }
}

