/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.constant;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.UnicodeString;
import org.apache.poi.hssf.record.constant.ErrorConstant;
import org.apache.poi.util.LittleEndian;

public final class ConstantValueParser {
    private static final int TYPE_EMPTY = 0;
    private static final int TYPE_NUMBER = 1;
    private static final int TYPE_STRING = 2;
    private static final int TYPE_BOOLEAN = 4;
    private static final int TYPE_ERROR_CODE = 16;
    private static final int TRUE_ENCODING = 1;
    private static final int FALSE_ENCODING = 0;
    private static final Object EMPTY_REPRESENTATION = null;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$constant$ErrorConstant;

    private ConstantValueParser() {
    }

    public static Object[] parse(RecordInputStream in, int nValues) {
        Object[] result = new Object[nValues];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ConstantValueParser.readAConstantValue(in);
        }
        return result;
    }

    private static Object readAConstantValue(RecordInputStream in) {
        byte grbit = in.readByte();
        switch (grbit) {
            case 0: {
                in.readLong();
                return EMPTY_REPRESENTATION;
            }
            case 1: {
                return new Double(in.readDouble());
            }
            case 2: {
                return in.readUnicodeString();
            }
            case 4: {
                return ConstantValueParser.readBoolean(in);
            }
            case 16: {
                int errCode = in.readUShort();
                in.readUShort();
                in.readInt();
                return ErrorConstant.valueOf(errCode);
            }
        }
        throw new RuntimeException("Unknown grbit value (" + grbit + ")");
    }

    private static Object readBoolean(RecordInputStream in) {
        byte val = (byte)in.readLong();
        switch (val) {
            case 0: {
                return Boolean.FALSE;
            }
            case 1: {
                return Boolean.TRUE;
            }
        }
        throw new RuntimeException("unexpected boolean encoding (" + val + ")");
    }

    public static int getEncodedSize(Object[] values) {
        int result = values.length * 1;
        for (int i = 0; i < values.length; ++i) {
            result += ConstantValueParser.getEncodedSize(values[i]);
        }
        return result;
    }

    private static int getEncodedSize(Object object) {
        if (object == EMPTY_REPRESENTATION) {
            return 8;
        }
        Class<?> cls = object.getClass();
        if (cls == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConstantValueParser.class$("java.lang.Boolean")) : class$java$lang$Boolean) || cls == (class$java$lang$Double == null ? (class$java$lang$Double = ConstantValueParser.class$("java.lang.Double")) : class$java$lang$Double) || cls == (class$org$apache$poi$hssf$record$constant$ErrorConstant == null ? (class$org$apache$poi$hssf$record$constant$ErrorConstant = ConstantValueParser.class$("org.apache.poi.hssf.record.constant.ErrorConstant")) : class$org$apache$poi$hssf$record$constant$ErrorConstant)) {
            return 8;
        }
        UnicodeString strVal = (UnicodeString)object;
        UnicodeString.UnicodeRecordStats urs = new UnicodeString.UnicodeRecordStats();
        strVal.getRecordSize(urs);
        return urs.recordSize;
    }

    public static void encode(byte[] data, int offset, Object[] values) {
        int currentOffset = offset;
        for (int i = 0; i < values.length; ++i) {
            currentOffset += ConstantValueParser.encodeSingleValue(data, currentOffset, values[i]);
        }
    }

    private static int encodeSingleValue(byte[] data, int offset, Object value) {
        if (value == EMPTY_REPRESENTATION) {
            LittleEndian.putByte(data, offset, 0);
            LittleEndian.putLong(data, offset + 1, 0L);
            return 9;
        }
        if (value instanceof Boolean) {
            Boolean bVal = (Boolean)value;
            LittleEndian.putByte(data, offset, 4);
            long longVal = bVal != false ? 1L : 0L;
            LittleEndian.putLong(data, offset + 1, longVal);
            return 9;
        }
        if (value instanceof Double) {
            Double dVal = (Double)value;
            LittleEndian.putByte(data, offset, 1);
            LittleEndian.putDouble(data, offset + 1, dVal);
            return 9;
        }
        if (value instanceof UnicodeString) {
            UnicodeString usVal = (UnicodeString)value;
            LittleEndian.putByte(data, offset, 2);
            UnicodeString.UnicodeRecordStats urs = new UnicodeString.UnicodeRecordStats();
            usVal.serialize(urs, offset + 1, data);
            return 1 + urs.recordSize;
        }
        if (value instanceof ErrorConstant) {
            ErrorConstant ecVal = (ErrorConstant)value;
            LittleEndian.putByte(data, offset, 16);
            LittleEndian.putUShort(data, offset + 1, ecVal.getErrorCode());
            LittleEndian.putUShort(data, offset + 3, 0);
            LittleEndian.putInt(data, offset + 5, 0);
            return 9;
        }
        throw new IllegalStateException("Unexpected value type (" + value.getClass().getName() + "'");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

