/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlNamespace;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import org.xml.sax.Attributes;

public class PubControl
extends ExtensionPoint {
    private Boolean draft;
    private XmlNamespace atomPubNs = Namespaces.getAtomPubNs();

    public boolean isDraft() {
        return this.draft != null && this.draft != false;
    }

    public void setDraft(Boolean draft) {
        this.draft = draft;
    }

    public void generateAtom(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        w.startElement(Namespaces.getAtomPubNs(), "control", null, null);
        if (this.isDraft()) {
            w.simpleElement(Namespaces.getAtomPubNs(), "draft", null, "yes");
        }
        this.generateExtensions(w, extProfile);
        w.endElement();
    }

    private class DraftHandler
    extends XmlParser.ElementHandler {
        private DraftHandler() {
        }

        public void processEndElement() throws ParseException {
            if (PubControl.this.draft != null) {
                throw new ParseException(CoreErrorDomain.ERR.duplicateDraft);
            }
            if (this.value.equals("yes")) {
                PubControl.this.draft = true;
            } else if (this.value.equals("no")) {
                PubControl.this.draft = false;
            } else {
                throw new ParseException(CoreErrorDomain.ERR.invalidDraft);
            }
        }
    }

    public class AtomHandler
    extends ExtensionPoint.ExtensionHandler {
        public AtomHandler(ExtensionProfile profile) {
            super(profile, PubControl.class);
        }

        public XmlParser.ElementHandler getChildHandler(String namespace, String localName, Attributes attrs) throws ParseException, IOException {
            if (namespace.equals(PubControl.this.atomPubNs.getUri())) {
                if (localName.equals("draft")) {
                    return new DraftHandler();
                }
            } else {
                return super.getChildHandler(namespace, localName, attrs);
            }
            return null;
        }
    }
}

