/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.blobsallad;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import org.yccheok.blobsallad.Vector;

public class PointMass {
    private Vector cur;
    private Vector prev;
    private double mass;
    private Vector force;
    private Vector result;
    private double friction;

    public PointMass(double cx, double cy, double mass) {
        this.cur = new Vector(cx, cy);
        this.prev = new Vector(cx, cy);
        this.mass = mass;
        this.force = new Vector(0.0, 0.0);
        this.result = new Vector(0.0, 0.0);
        this.friction = 0.01;
    }

    public double getXPos() {
        return this.cur.getX();
    }

    public double getYPos() {
        return this.cur.getY();
    }

    public Vector getPos() {
        return this.cur;
    }

    public double getXPrevPos() {
        return this.prev.getX();
    }

    public double getYPrevPos() {
        return this.prev.getY();
    }

    public Vector getPrevPos() {
        return this.prev;
    }

    public void addXPos(double dx) {
        this.cur.addX(dx);
    }

    public void addYPos(double dy) {
        this.cur.addY(dy);
    }

    public void setForce(Vector force) {
        this.force.set(force);
    }

    public void addForce(Vector force) {
        this.force.add(force);
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    public void move(double dt) {
        double dtdt = dt * dt;
        double a = this.force.getX() / this.mass;
        double c = this.cur.getX();
        double t = (2.0 - this.friction) * c - (1.0 - this.friction) * this.prev.getX() + a * dtdt;
        this.prev.setX(c);
        this.cur.setX(t);
        a = this.force.getY() / this.mass;
        c = this.cur.getY();
        t = (2.0 - this.friction) * c - (1.0 - this.friction) * this.prev.getY() + a * dtdt;
        this.prev.setY(c);
        this.cur.setY(t);
    }

    public double getVelocity() {
        double cXpX = this.cur.getX() - this.prev.getX();
        double cYpY = this.cur.getY() - this.prev.getY();
        return cXpX * cXpX + cYpY * cYpY;
    }

    public void setFriction(double friction) {
        this.friction = friction;
    }

    public void draw(Graphics graphics, double scaleFactor) {
        BasicStroke stroke = new BasicStroke(2.0f);
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setColor(Color.BLACK);
        g2d.setStroke(stroke);
        Arc2D.Double arc = new Arc2D.Double();
        arc.setArcByCenter(this.cur.getX() * scaleFactor, this.cur.getY() * scaleFactor, 4.0, 0.0, 360.0, 1);
        g2d.fill(arc);
    }
}

