/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.AjaxGoogleSearchEngine;
import org.yccheok.jstock.engine.MatchSetType;
import org.yccheok.jstock.engine.MatchType;
import org.yccheok.jstock.engine.SearchEngine;
import org.yccheok.jstock.engine.Subject;

public class AjaxGoogleSearchEngineMonitor
extends Subject<AjaxGoogleSearchEngineMonitor, MatchSetType> {
    private List<String> exchs;
    private final SearchEngine<MatchType> searchEngine = new AjaxGoogleSearchEngine();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final BlockingQueue<String> blockingQueue = new ArrayBlockingQueue<String>(128);
    private static final Log log = LogFactory.getLog(AjaxGoogleSearchEngineMonitor.class);

    public AjaxGoogleSearchEngineMonitor() {
        this.executor.submit(new SearchTask());
    }

    public synchronized void clearAndPut(String string) {
        if (this.executor.isShutdown()) {
            throw new RuntimeException("Executor is shutdown.");
        }
        this.blockingQueue.clear();
        try {
            this.blockingQueue.put(string);
        }
        catch (InterruptedException ex) {
            log.error(null, (Throwable)ex);
        }
    }

    public void stop() {
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(100L, TimeUnit.DAYS);
        }
        catch (InterruptedException ex) {
            log.error(null, (Throwable)ex);
        }
    }

    public void setExchs(List<String> exchs) {
        this.exchs = exchs;
    }

    private class SearchTask
    implements Runnable {
        private SearchTask() {
        }

        @Override
        public void run() {
            while (!AjaxGoogleSearchEngineMonitor.this.executor.isShutdown()) {
                try {
                    String string = (String)AjaxGoogleSearchEngineMonitor.this.blockingQueue.take();
                    ArrayList<String> queries = new ArrayList<String>();
                    queries.add(string);
                    HashSet<String> exchSet = new HashSet<String>();
                    HashSet<String> codeSet = new HashSet<String>();
                    ArrayList<MatchType> matchTypes = new ArrayList<MatchType>();
                    for (String exch : AjaxGoogleSearchEngineMonitor.this.exchs) {
                        queries.add(exch + ":" + string);
                        exchSet.add(exch);
                    }
                    for (String query : queries) {
                        List results = AjaxGoogleSearchEngineMonitor.this.searchEngine.searchAll(query);
                        for (MatchType matchType : results) {
                            String code;
                            if (!exchSet.contains(matchType.e) || codeSet.contains(code = matchType.e + ":" + matchType.t)) continue;
                            codeSet.add(code);
                            matchTypes.add(matchType);
                        }
                    }
                    Collections.sort(matchTypes, new Comparator<MatchType>(){

                        @Override
                        public int compare(MatchType o1, MatchType o2) {
                            return o1.t.compareTo(o2.t);
                        }
                    });
                    MatchSetType matchSet = MatchSetType.newInstance(string, matchTypes);
                    AjaxGoogleSearchEngineMonitor.this.notify(AjaxGoogleSearchEngineMonitor.this, matchSet);
                }
                catch (InterruptedException ex) {
                    log.error(null, (Throwable)ex);
                    break;
                }
            }
        }
    }
}

