/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.yccheok.jstock.engine.AbstractYahooStockServer;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockNotFoundException;
import org.yccheok.jstock.engine.Symbol;

public class BrazilYahooStockServer
extends AbstractYahooStockServer {
    private static final Pattern longSpacePattern = Pattern.compile("\\s\\s+");

    @Override
    protected String getYahooCSVBasedURL() {
        return "http://download.finance.yahoo.com/d/quotes.csv?s=";
    }

    @Override
    public List<Stock> getStocks(List<Code> codes) throws StockNotFoundException {
        List<Stock> tmp = super.getStocks(codes);
        ArrayList<Stock> stocks = new ArrayList<Stock>();
        for (Stock stock : tmp) {
            String name = longSpacePattern.matcher(stock.getName()).replaceAll("").trim();
            String symbol = longSpacePattern.matcher(stock.symbol.toString()).replaceAll("").trim();
            Stock s = new Stock(stock.code, Symbol.newInstance(symbol), name, stock.getBoard(), stock.getIndustry(), stock.getPrevPrice(), stock.getOpenPrice(), stock.getLastPrice(), stock.getHighPrice(), stock.getLowPrice(), stock.getVolume(), stock.getChangePrice(), stock.getChangePricePercentage(), stock.getLastVolume(), stock.getBuyPrice(), stock.getBuyQuantity(), stock.getSellPrice(), stock.getSellQuantity(), stock.getSecondBuyPrice(), stock.getSecondBuyQuantity(), stock.getSecondSellPrice(), stock.getSecondSellQuantity(), stock.getThirdBuyPrice(), stock.getThirdBuyQuantity(), stock.getThirdSellPrice(), stock.getThirdSellQuantity(), stock.getTimestamp());
            stocks.add(s);
        }
        return stocks;
    }

    @Override
    public Stock getStock(Code code) throws StockNotFoundException {
        Stock tmp = super.getStock(code);
        String name = longSpacePattern.matcher(tmp.getName()).replaceAll("").trim();
        String _symbol = longSpacePattern.matcher(tmp.symbol.toString()).replaceAll("").trim();
        Stock stock = new Stock(tmp.code, Symbol.newInstance(_symbol), name, tmp.getBoard(), tmp.getIndustry(), tmp.getPrevPrice(), tmp.getOpenPrice(), tmp.getLastPrice(), tmp.getHighPrice(), tmp.getLowPrice(), tmp.getVolume(), tmp.getChangePrice(), tmp.getChangePricePercentage(), tmp.getLastVolume(), tmp.getBuyPrice(), tmp.getBuyQuantity(), tmp.getSellPrice(), tmp.getSellQuantity(), tmp.getSecondBuyPrice(), tmp.getSecondBuyQuantity(), tmp.getSecondSellPrice(), tmp.getSecondSellQuantity(), tmp.getThirdBuyPrice(), tmp.getThirdBuyQuantity(), tmp.getThirdSellPrice(), tmp.getThirdSellQuantity(), tmp.getTimestamp());
        return stock;
    }
}

