/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.util.Calendar;
import java.util.Date;
import org.yccheok.jstock.engine.SimpleDate;
import org.yccheok.jstock.engine.Utils;

public class Duration {
    private long durationInDays = -1L;
    private final SimpleDate startDate;
    private final SimpleDate endDate;

    public Duration(SimpleDate startDate, SimpleDate endDate) {
        if (startDate.compareTo(endDate) > 0) {
            throw new IllegalArgumentException("startDate " + startDate + " should not after endDate " + endDate);
        }
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public Duration(Date startDate, Date endDate) {
        this(new SimpleDate(startDate), new SimpleDate(endDate));
    }

    public Duration(Calendar start, Calendar end) {
        this(start.getTime(), end.getTime());
    }

    public SimpleDate getStartDate() {
        return this.startDate;
    }

    public SimpleDate getEndDate() {
        return this.endDate;
    }

    public long getDurationInDays() {
        if (this.durationInDays < 0L) {
            this.durationInDays = Utils.getDifferenceInDays(this.startDate.getCalendar(), this.endDate.getCalendar());
        }
        return this.durationInDays;
    }

    public boolean isContains(Duration duration) {
        return this.startDate.compareTo(duration.startDate) <= 0 && this.endDate.compareTo(duration.endDate) >= 0;
    }

    public boolean isContains(SimpleDate date) {
        return this.startDate.compareTo(date) <= 0 && this.endDate.compareTo(date) >= 0;
    }

    public static Duration getTodayDurationByYears(int durationInYears) {
        if (durationInYears < 0) {
            throw new IllegalArgumentException("durationInYears must be a non-negative number");
        }
        Calendar calendar = Calendar.getInstance();
        SimpleDate end = new SimpleDate(calendar);
        calendar.add(1, -durationInYears);
        SimpleDate start = new SimpleDate(calendar);
        return new Duration(start, end);
    }

    public Duration getUnionDuration(Duration duration) {
        SimpleDate start = this.startDate.compareTo(duration.startDate) <= 0 ? this.startDate : duration.startDate;
        SimpleDate end = this.endDate.compareTo(duration.endDate) >= 0 ? this.endDate : duration.endDate;
        return new Duration(start, end);
    }

    public static Duration getDurationByDays(Date endDate, int durationInDays) {
        if (durationInDays < 0) {
            throw new IllegalArgumentException("durationInDays must be a non-negative number");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(endDate);
        SimpleDate end = new SimpleDate(calendar);
        calendar.add(5, -durationInDays);
        SimpleDate start = new SimpleDate(calendar);
        return new Duration(start, end);
    }

    public static Duration getTodayDurationByDays(int durationInDays) {
        if (durationInDays < 0) {
            throw new IllegalArgumentException("durationInDays must be a non-negative number");
        }
        Calendar calendar = Calendar.getInstance();
        SimpleDate end = new SimpleDate(calendar);
        calendar.add(5, -durationInDays);
        SimpleDate start = new SimpleDate(calendar);
        return new Duration(start, end);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.startDate.hashCode();
        result = 31 * result + this.startDate.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Duration)) {
            return false;
        }
        Duration duration = (Duration)o;
        return this.startDate.equals(duration.startDate) && this.endDate.equals(duration.endDate);
    }

    public String toString() {
        return Duration.class.getName() + "[startDate=" + this.startDate + ",endDate=" + this.endDate + "]";
    }
}

