/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.GoogleStockServer;
import org.yccheok.jstock.engine.Index;
import org.yccheok.jstock.engine.Market;
import org.yccheok.jstock.engine.MarketServer;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockNotFoundException;

public class GoogleMarketServer
implements MarketServer {
    private final GoogleStockServer googleStockServer = new GoogleStockServer();
    private static final Log log = LogFactory.getLog(GoogleMarketServer.class);

    @Override
    public Market getMarket(Index index) {
        ArrayList<Index> indices = new ArrayList<Index>();
        indices.add(index);
        List<Market> markets = this.getMarkets(indices);
        if (markets.size() == 1) {
            return markets.get(0);
        }
        return null;
    }

    @Override
    public List<Market> getMarkets(List<Index> indices) {
        List<Stock> stocks;
        HashMap<Code, Index> map = new HashMap<Code, Index>();
        ArrayList<Code> codes = new ArrayList<Code>();
        for (Index index : indices) {
            map.put(index.code, index);
            codes.add(index.code);
        }
        ArrayList<Market> markets = new ArrayList<Market>();
        try {
            stocks = this.googleStockServer.getStocks(codes);
        }
        catch (StockNotFoundException e) {
            log.error(null, (Throwable)e);
            return markets;
        }
        for (Stock stock : stocks) {
            Market market = Market.newInstance(stock, (Index)((Object)map.get(stock.code)));
            markets.add(market);
        }
        return markets;
    }
}

