/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Duration;
import org.yccheok.jstock.engine.GoogleStockServer;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockHistoryNotFoundException;
import org.yccheok.jstock.engine.StockHistoryServer;
import org.yccheok.jstock.engine.StockNotFoundException;
import org.yccheok.jstock.engine.StockServer;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.engine.Utils;

public class GoogleStockHistoryServer
implements StockHistoryServer {
    private static final int NUM_OF_RETRY = 1;
    private static final Duration DEFAULT_HISTORY_DURATION = Duration.getTodayDurationByYears(10);
    private final Map<Long, Stock> historyDatabase = new HashMap<Long, Stock>();
    private final List<Long> timestamps = new ArrayList<Long>();
    private final Code code;
    private final Code googleCode;
    private final StockServer stockServer = new GoogleStockServer();
    private final Duration duration;
    private static final Log log = LogFactory.getLog(GoogleStockHistoryServer.class);

    public GoogleStockHistoryServer(Code code) throws StockHistoryNotFoundException {
        this(code, DEFAULT_HISTORY_DURATION);
    }

    public GoogleStockHistoryServer(Code code, Duration duration) throws StockHistoryNotFoundException {
        String respond;
        this.code = code;
        this.duration = duration;
        this.googleCode = Utils.toGoogleFormat(code);
        StringBuilder stringBuilder = new StringBuilder("http://www.google.com/finance/getprices?f=d,c,v,o,h,l&i=86400&p=");
        stringBuilder.append("10Y&ts=").append(System.currentTimeMillis());
        String googleCodeStr = this.googleCode.toString();
        String[] result = googleCodeStr.split(":");
        try {
            if (result.length == 2) {
                stringBuilder.append("&q=");
                stringBuilder.append(URLEncoder.encode(result[1], "UTF-8"));
                stringBuilder.append("&x=");
                stringBuilder.append(URLEncoder.encode(result[0], "UTF-8"));
            } else {
                stringBuilder.append("&q=");
                stringBuilder.append(URLEncoder.encode(googleCodeStr, "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new StockHistoryNotFoundException(null, ex);
        }
        String location = stringBuilder.toString();
        boolean success = false;
        for (int retry = 0; !(retry >= 1 || (respond = org.yccheok.jstock.gui.Utils.getResponseBodyAsStringBasedOnProxyAuthOption(location)) != null && (success = this.parse(respond))); ++retry) {
        }
        if (!success) {
            throw new StockHistoryNotFoundException(code.toString());
        }
    }

    private boolean parse(String respond) {
        this.historyDatabase.clear();
        this.timestamps.clear();
        long startTimeInMilli = this.duration.getStartDate().getTime().getTime();
        long endTimeInMilli = this.duration.getEndDate().getTime().getTime();
        String[] stockDatas = respond.split("\r\n|\r|\n");
        double previousClosePrice = Double.MAX_VALUE;
        long time = 0L;
        Symbol symbol = Symbol.newInstance(this.code.toString());
        String name = symbol.toString();
        Stock.Board board = Stock.Board.Unknown;
        Stock.Industry industry = Stock.Industry.Unknown;
        Calendar calendar = null;
        boolean initialized = false;
        long TIMEZONE_OFFSET = 0L;
        for (String stockData : stockDatas) {
            String[] fields;
            if (stockData.isEmpty()) continue;
            char c = stockData.charAt(0);
            if (c != 'a' && !Character.isDigit(c)) {
                if (!stockData.startsWith("TIMEZONE_OFFSET") || (fields = stockData.split("=")).length != 2) continue;
                try {
                    TIMEZONE_OFFSET = Long.parseLong(fields[1]);
                }
                catch (NumberFormatException ex) {
                    log.error(null, (Throwable)ex);
                }
                continue;
            }
            fields = stockData.split(",");
            if (fields.length < 6) continue;
            long currentTime = 0L;
            String fields0 = fields[0];
            if (fields0.charAt(0) == 'a') {
                if (fields0.length() > 1) {
                    String timeStr = fields0.substring(1);
                    try {
                        time = Long.parseLong(timeStr);
                    }
                    catch (NumberFormatException ex) {
                        log.error(null, (Throwable)ex);
                        continue;
                    }
                    currentTime = time;
                }
            } else {
                int index = 0;
                try {
                    index = Integer.parseInt(fields0);
                }
                catch (NumberFormatException ex) {
                    log.error(null, (Throwable)ex);
                    continue;
                }
                currentTime = time + (long)(index * 60 * 60 * 24);
            }
            if (!initialized) {
                try {
                    Stock stock = this.stockServer.getStock(this.googleCode);
                    symbol = stock.symbol;
                    name = stock.getName();
                    board = stock.getBoard();
                    industry = stock.getIndustry();
                }
                catch (StockNotFoundException exp) {
                    log.error(null, (Throwable)exp);
                }
                calendar = Calendar.getInstance();
                initialized = true;
            }
            long currentTimeInMilli = currentTime * 1000L;
            currentTimeInMilli += TIMEZONE_OFFSET * 60L * 1000L;
            currentTimeInMilli = currentTimeInMilli / 1000L / 24L / 60L / 60L;
            currentTimeInMilli = currentTimeInMilli * 60L * 60L * 24L * 1000L;
            calendar.setTimeInMillis(currentTimeInMilli);
            int offset = -(calendar.get(15) + calendar.get(16));
            if ((currentTimeInMilli += (long)offset) < startTimeInMilli) continue;
            if (currentTimeInMilli > endTimeInMilli) break;
            double closePrice = 0.0;
            double highPrice = 0.0;
            double lowPrice = 0.0;
            double prevPrice = 0.0;
            double openPrice = 0.0;
            long volume = 0L;
            try {
                closePrice = Double.parseDouble(fields[1]);
                highPrice = Double.parseDouble(fields[2]);
                lowPrice = Double.parseDouble(fields[3]);
                openPrice = Double.parseDouble(fields[4]);
                prevPrice = previousClosePrice == Double.MAX_VALUE ? 0.0 : previousClosePrice;
                volume = Long.parseLong(fields[5]);
            }
            catch (NumberFormatException exp) {
                log.error(null, (Throwable)exp);
            }
            double changePrice = previousClosePrice == Double.MAX_VALUE ? 0.0 : closePrice - previousClosePrice;
            double changePricePercentage = previousClosePrice == Double.MAX_VALUE || previousClosePrice == 0.0 ? 0.0 : changePrice / previousClosePrice * 100.0;
            Stock stock = new Stock(this.code, symbol, name, board, industry, prevPrice, openPrice, closePrice, highPrice, lowPrice, volume, changePrice, changePricePercentage, 0, 0.0, 0, 0.0, 0, 0.0, 0, 0.0, 0, 0.0, 0, 0.0, 0, currentTimeInMilli);
            this.historyDatabase.put(currentTimeInMilli, stock);
            this.timestamps.add(currentTimeInMilli);
            previousClosePrice = closePrice;
        }
        return this.historyDatabase.size() > 0;
    }

    @Override
    public Stock getStock(long timestamp) {
        return this.historyDatabase.get(timestamp);
    }

    @Override
    public long getTimestamp(int index) {
        return this.timestamps.get(index);
    }

    @Override
    public int size() {
        return this.timestamps.size();
    }

    @Override
    public long getSharesIssued() {
        return 0L;
    }

    @Override
    public long getMarketCapital() {
        return 0L;
    }
}

