/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Duration;
import org.yccheok.jstock.engine.SimpleDate;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockHistoryNotFoundException;
import org.yccheok.jstock.engine.StockHistoryServer;
import org.yccheok.jstock.engine.StockNotFoundException;
import org.yccheok.jstock.engine.StockServer;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.engine.Utils;
import org.yccheok.jstock.engine.YahooStockServer;

public class KLSEInfoStockHistoryServer
implements StockHistoryServer {
    private static final ThreadLocal<NumberFormat> dateFormatThredLocal = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return new DecimalFormat("00");
        }
    };
    private static final ThreadLocal<SimpleDateFormat> simpleDateFormatThreadLocal = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    private static final int NUM_OF_RETRY = 2;
    private static final Duration DEFAULT_HISTORY_DURATION = Duration.getTodayDurationByYears(10);
    private static final String KLSE_INFO_BASED_URL = "http://www.klse.info/jstock/historical-prices?s=";
    private final Map<Long, Stock> historyDatabase = new HashMap<Long, Stock>();
    private final List<Long> timestamps = new ArrayList<Long>();
    private final Code code;
    private final Duration duration;
    private double previousClosePrice = Double.MAX_VALUE;
    private final StockServer stockServer = new YahooStockServer();
    private static final Log log = LogFactory.getLog(KLSEInfoStockHistoryServer.class);

    public KLSEInfoStockHistoryServer(Code code) throws StockHistoryNotFoundException {
        this(code, DEFAULT_HISTORY_DURATION);
    }

    public KLSEInfoStockHistoryServer(Code code, Duration duration) throws StockHistoryNotFoundException {
        if (code == null || duration == null) {
            throw new IllegalArgumentException("Code or duration cannot be null");
        }
        this.code = code;
        this.duration = duration;
        List<Duration> durations = this.toSmallerDurationPieces();
        try {
            boolean flag = false;
            for (Duration d : durations) {
                flag |= this.buildHistory(this.code, d);
            }
            if (!flag) {
                throw new StockHistoryNotFoundException(code.toString());
            }
        }
        catch (OutOfMemoryError exp) {
            log.error(null, (Throwable)exp);
            throw new StockHistoryNotFoundException("Out of memory", exp);
        }
    }

    @Override
    public Stock getStock(long timestamp) {
        return this.historyDatabase.get(timestamp);
    }

    @Override
    public long getTimestamp(int index) {
        return this.timestamps.get(index);
    }

    @Override
    public int size() {
        return this.timestamps.size();
    }

    @Override
    public long getSharesIssued() {
        return 0L;
    }

    @Override
    public long getMarketCapital() {
        return 0L;
    }

    private List<Duration> toSmallerDurationPieces() {
        ArrayList<Duration> durations = new ArrayList<Duration>();
        SimpleDate endDate = this.duration.getEndDate();
        SimpleDate startDate = this.duration.getStartDate();
        while (true) {
            SimpleDate tmpStartDate;
            if ((tmpStartDate = new SimpleDate(endDate.getYear() - 7, endDate.getMonth(), endDate.getDate())).compareTo(startDate) < 0) {
                if (startDate.compareTo(endDate) > 0) break;
                durations.add(0, new Duration(startDate, endDate));
                break;
            }
            durations.add(0, new Duration(tmpStartDate, endDate));
            Calendar newEndCalendar = tmpStartDate.getCalendar();
            newEndCalendar.add(6, -1);
            endDate = new SimpleDate(newEndCalendar);
        }
        return durations;
    }

    private boolean buildHistory(Code code, Duration theDuration) {
        String c;
        StringBuilder stringBuilder = new StringBuilder(KLSE_INFO_BASED_URL);
        try {
            c = URLEncoder.encode(Utils.toNonYahooFormat(code).toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return false;
        }
        stringBuilder.append(c);
        String endMonth = dateFormatThredLocal.get().format(theDuration.getEndDate().getMonth() + 1);
        String endDate = dateFormatThredLocal.get().format(theDuration.getEndDate().getDate());
        int endYear = theDuration.getEndDate().getYear();
        String startMonth = dateFormatThredLocal.get().format(theDuration.getStartDate().getMonth() + 1);
        String startDate = dateFormatThredLocal.get().format(theDuration.getStartDate().getDate());
        int startYear = theDuration.getStartDate().getYear();
        stringBuilder.append("&start=").append(endYear).append(endMonth).append(endDate).append("&end=").append(startYear).append(startMonth).append(startDate);
        String location = stringBuilder.toString();
        boolean success = false;
        for (int retry = 0; retry < 2; ++retry) {
            String respond = org.yccheok.jstock.gui.Utils.getResponseBodyAsStringBasedOnProxyAuthOptionWithAgentInfo(location);
            if (respond == null) continue;
            success = this.parse(respond);
            break;
        }
        return success;
    }

    private boolean parse(String respond) {
        long timestamp = System.currentTimeMillis();
        String[] stockDatas = respond.split("\r\n|\r|\n");
        int length = stockDatas.length;
        if (length <= 1) {
            return false;
        }
        Symbol symbol = Symbol.newInstance(this.code.toString());
        String name = symbol.toString();
        Stock.Board board = Stock.Board.Unknown;
        Stock.Industry industry = Stock.Industry.Unknown;
        try {
            Stock stock = this.stockServer.getStock(this.code);
            symbol = stock.symbol;
            name = stock.getName();
            board = stock.getBoard();
            industry = stock.getIndustry();
        }
        catch (StockNotFoundException exp) {
            log.error(null, (Throwable)exp);
        }
        for (int i = length - 1; i > 0; --i) {
            String[] fields = stockDatas[i].split(",");
            if (fields.length < 7) continue;
            try {
                timestamp = simpleDateFormatThreadLocal.get().parse(fields[0]).getTime();
            }
            catch (ParseException ex) {
                log.error(null, (Throwable)ex);
                continue;
            }
            double prevPrice = 0.0;
            double openPrice = 0.0;
            double highPrice = 0.0;
            double lowPrice = 0.0;
            double closePrice = 0.0;
            long volume = 0L;
            try {
                prevPrice = this.previousClosePrice == Double.MAX_VALUE ? 0.0 : this.previousClosePrice;
                openPrice = Double.parseDouble(fields[1]);
                highPrice = Double.parseDouble(fields[2]);
                lowPrice = Double.parseDouble(fields[3]);
                closePrice = Double.parseDouble(fields[4]);
                volume = Long.parseLong(fields[5]);
            }
            catch (NumberFormatException exp) {
                log.error(null, (Throwable)exp);
            }
            double changePrice = this.previousClosePrice == Double.MAX_VALUE ? 0.0 : closePrice - this.previousClosePrice;
            double changePricePercentage = this.previousClosePrice == Double.MAX_VALUE || this.previousClosePrice == 0.0 ? 0.0 : changePrice / this.previousClosePrice * 100.0;
            Stock stock = new Stock(this.code, symbol, name, board, industry, prevPrice, openPrice, closePrice, highPrice, lowPrice, volume, changePrice, changePricePercentage, 0, 0.0, 0, 0.0, 0, 0.0, 0, 0.0, 0, 0.0, 0, 0.0, 0, timestamp);
            this.historyDatabase.put(timestamp, stock);
            this.timestamps.add(timestamp);
            this.previousClosePrice = closePrice;
        }
        return this.historyDatabase.size() > 0;
    }
}

