/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.DividendServer;
import org.yccheok.jstock.engine.Duration;
import org.yccheok.jstock.engine.KLSEInfoStockHistoryServer;
import org.yccheok.jstock.engine.MarketServer;
import org.yccheok.jstock.engine.StockHistoryNotFoundException;
import org.yccheok.jstock.engine.StockHistoryServer;
import org.yccheok.jstock.engine.StockServer;
import org.yccheok.jstock.engine.StockServerFactory;
import org.yccheok.jstock.engine.YahooStockServerFactory;

public class KLSEInfoStockServerFactory
implements StockServerFactory {
    private final StockServerFactory stockServerFactory = YahooStockServerFactory.newInstance();
    private static final Log log = LogFactory.getLog(KLSEInfoStockServerFactory.class);

    private KLSEInfoStockServerFactory() {
    }

    public static StockServerFactory newInstance() {
        return new KLSEInfoStockServerFactory();
    }

    @Override
    public StockServer getStockServer() {
        return this.stockServerFactory.getStockServer();
    }

    @Override
    public StockHistoryServer getStockHistoryServer(Code code) {
        try {
            return new KLSEInfoStockHistoryServer(code);
        }
        catch (StockHistoryNotFoundException exp) {
            log.error(null, (Throwable)exp);
            return null;
        }
    }

    @Override
    public StockHistoryServer getStockHistoryServer(Code code, Duration duration) {
        try {
            return new KLSEInfoStockHistoryServer(code, duration);
        }
        catch (StockHistoryNotFoundException exp) {
            log.error(null, (Throwable)exp);
            return null;
        }
    }

    @Override
    public MarketServer getMarketServer() {
        return this.stockServerFactory.getMarketServer();
    }

    @Override
    public DividendServer getDividendServer() {
        return null;
    }
}

