/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.io.File;
import java.text.DecimalFormat;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Duration;
import org.yccheok.jstock.engine.StatementsStockHistoryServer;
import org.yccheok.jstock.engine.StockHistoryServer;
import org.yccheok.jstock.file.Statements;
import org.yccheok.jstock.gui.Utils;

public class StockHistorySerializer {
    private final String directory;

    public StockHistorySerializer(String directory) {
        Utils.createCompleteDirectoryHierarchyIfDoesNotExist(directory);
        this.directory = directory;
    }

    public boolean save(StockHistoryServer stockHistoryServer, Duration duration) {
        if (stockHistoryServer.size() == 0) {
            return false;
        }
        long timestamp = stockHistoryServer.getTimestamp(0);
        Code code = stockHistoryServer.getStock((long)timestamp).code;
        Statements statements = Statements.newInstanceFromStockHistoryServer(stockHistoryServer, true);
        File file = new File(this.getFileName(code, duration));
        return statements.saveAsCSVFile(file);
    }

    public StockHistoryServer load(Code code, Duration duration) {
        File file = new File(this.getFileName(code, duration));
        Statements statements = Statements.newInstanceFromCSVFile(file);
        return StatementsStockHistoryServer.newInstance(statements);
    }

    private String getFileName(Code code, Duration duration) {
        int startYear = duration.getStartDate().getYear();
        int startMonth = duration.getStartDate().getMonth() + 1;
        int startDay = duration.getStartDate().getDate();
        int endYear = duration.getEndDate().getYear();
        int endMonth = duration.getEndDate().getMonth() + 1;
        int endDay = duration.getEndDate().getDate();
        DecimalFormat decimalFormat = new DecimalFormat("00");
        String fileName = this.directory + File.separator + code + "-start_date=" + startYear + "-" + decimalFormat.format(startMonth) + "-" + decimalFormat.format(startDay) + "-end_date=" + endYear + "-" + decimalFormat.format(endMonth) + "-" + decimalFormat.format(endDay) + ".csv";
        return fileName;
    }
}

