/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.DividendServer;
import org.yccheok.jstock.engine.Duration;
import org.yccheok.jstock.engine.MarketServer;
import org.yccheok.jstock.engine.StockHistoryNotFoundException;
import org.yccheok.jstock.engine.StockHistoryServer;
import org.yccheok.jstock.engine.StockServer;
import org.yccheok.jstock.engine.StockServerFactory;
import org.yccheok.jstock.engine.YahooDividendServer;
import org.yccheok.jstock.engine.YahooMarketServer;
import org.yccheok.jstock.engine.YahooStockHistoryServer;
import org.yccheok.jstock.engine.YahooStockServer;

public class YahooStockServerFactory
implements StockServerFactory {
    private final StockServer stockServer = new YahooStockServer();
    private final MarketServer marketServer = new YahooMarketServer();
    private final DividendServer dividendServer = new YahooDividendServer();
    private static final Log log = LogFactory.getLog(YahooStockServerFactory.class);

    private YahooStockServerFactory() {
    }

    public static StockServerFactory newInstance() {
        return new YahooStockServerFactory();
    }

    @Override
    public StockServer getStockServer() {
        return this.stockServer;
    }

    @Override
    public StockHistoryServer getStockHistoryServer(Code code) {
        try {
            return new YahooStockHistoryServer(code);
        }
        catch (StockHistoryNotFoundException exp) {
            log.error(null, (Throwable)exp);
            return null;
        }
    }

    @Override
    public StockHistoryServer getStockHistoryServer(Code code, Duration duration) {
        try {
            return new YahooStockHistoryServer(code, duration);
        }
        catch (StockHistoryNotFoundException exp) {
            log.error(null, (Throwable)exp);
            return null;
        }
    }

    @Override
    public MarketServer getMarketServer() {
        return this.marketServer;
    }

    @Override
    public DividendServer getDividendServer() {
        return this.dividendServer;
    }
}

