/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.SimpleDate;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.gui.DeprecatedAbstractPortfolioTreeTableModel;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.MainFrame;
import org.yccheok.jstock.gui.treetable.BuyPortfolioTreeTableModelEx;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.portfolio.Contract;
import org.yccheok.jstock.portfolio.DecimalPlaces;
import org.yccheok.jstock.portfolio.DoubleWrapper;
import org.yccheok.jstock.portfolio.Portfolio;
import org.yccheok.jstock.portfolio.Transaction;
import org.yccheok.jstock.portfolio.TransactionSummary;

@Deprecated
public class BuyPortfolioTreeTableModel
extends DeprecatedAbstractPortfolioTreeTableModel {
    private Map<Code, Double> stockPrice = new ConcurrentHashMap<Code, Double>();
    private static final String[] cNames;
    private static final Class[] cTypes;

    public boolean split(StockInfo stockInfo, double ratio) {
        boolean status = false;
        Portfolio portfolio = (Portfolio)this.getRoot();
        int count = portfolio.getChildCount();
        TransactionSummary transactionSummary = null;
        for (int i = 0; i < count; ++i) {
            transactionSummary = (TransactionSummary)portfolio.getChildAt(i);
            assert (transactionSummary.getChildCount() > 0);
            Transaction transaction = (Transaction)transactionSummary.getChildAt(0);
            if (transaction.getStock().code.equals(stockInfo.code)) break;
        }
        if (null == transactionSummary) {
            return status;
        }
        int num = transactionSummary.getChildCount();
        for (int i = 0; i < num; ++i) {
            Transaction transaction = (Transaction)transactionSummary.getChildAt(i);
            double quantity = transaction.getQuantity() * ratio;
            double price = transaction.getPrice() / ratio;
            this.editTransaction(transaction.deriveWithQuantity(quantity).deriveWithPrice(price), transaction);
            status = true;
        }
        return status;
    }

    public boolean updateStockLastPrice(Code code, double price) {
        Transaction transaction;
        Portfolio portfolio = (Portfolio)this.getRoot();
        int count = portfolio.getChildCount();
        TransactionSummary transactionSummary = null;
        for (int i = 0; i < count; ++i) {
            TransactionSummary ts = (TransactionSummary)portfolio.getChildAt(i);
            assert (ts.getChildCount() > 0);
            transaction = (Transaction)ts.getChildAt(0);
            if (!transaction.getStock().code.equals(code)) continue;
            transactionSummary = ts;
            break;
        }
        if (null == transactionSummary) {
            this.stockPrice.remove(code);
            return false;
        }
        int num = transactionSummary.getChildCount();
        if (num == 0) {
            this.stockPrice.remove(code);
            return false;
        }
        this.stockPrice.put(code, price);
        for (int i = 0; i < num; ++i) {
            transaction = (Transaction)transactionSummary.getChildAt(i);
            this.modelSupport.fireChildChanged(new TreePath(this.getPathToRoot((TreeTableNode)transaction)), i, (Object)transaction);
        }
        this.fireTreeTableNodeChanged((TreeTableNode)transactionSummary);
        this.fireTreeTableNodeChanged(this.getRoot());
        return true;
    }

    public boolean updateStockLastPrice(Stock stock) {
        if (stock.getLastPrice() > 0.0) {
            return this.updateStockLastPrice(stock.code, stock.getLastPrice());
        }
        return this.updateStockLastPrice(stock.code, stock.getPrevPrice());
    }

    private double getCurrentPrice(Transaction transaction) {
        Code code = transaction.getStock().code;
        Double price = this.stockPrice.get(code);
        if (price == null) {
            return 0.0;
        }
        return price;
    }

    private double getCurrentValue(Transaction transaction) {
        Code code = transaction.getStock().code;
        Double price = this.stockPrice.get(code);
        if (price == null) {
            return 0.0;
        }
        return price * transaction.getQuantity();
    }

    private double getCurrentValue(TransactionSummary transactionSummary) {
        Transaction transaction = (Transaction)transactionSummary.getChildAt(0);
        Code code = transaction.getStock().code;
        Double price = this.stockPrice.get(code);
        if (price == null) {
            return 0.0;
        }
        return price * transactionSummary.getQuantity();
    }

    private double getCurrentPrice(TransactionSummary transactionSummary) {
        Transaction transaction = (Transaction)transactionSummary.getChildAt(0);
        return this.getCurrentPrice(transaction);
    }

    private double getGainLossValue(Portfolio portfolio) {
        return this.getCurrentValue(portfolio) - portfolio.getTotal();
    }

    private double getGainLossPercentage(Portfolio portfolio) {
        if (portfolio.getTotal() == 0.0) {
            return 0.0;
        }
        return (this.getCurrentValue(portfolio) - portfolio.getTotal()) / portfolio.getTotal() * 100.0;
    }

    private double getGainLossPercentage(TransactionSummary transactionSummary) {
        if (transactionSummary.getTotal() == 0.0) {
            return 0.0;
        }
        return (this.getCurrentValue(transactionSummary) - transactionSummary.getTotal()) / transactionSummary.getTotal() * 100.0;
    }

    public double getNetGainLossValue(TransactionSummary transactionSummary) {
        return this.getCurrentValue(transactionSummary) - transactionSummary.getNetTotal();
    }

    public double getNetGainLossPercentage(TransactionSummary transactionSummary) {
        if (transactionSummary.getTotal() == 0.0) {
            return 0.0;
        }
        return (this.getCurrentValue(transactionSummary) - transactionSummary.getNetTotal()) / transactionSummary.getNetTotal() * 100.0;
    }

    private double getGainLossPercentage(Transaction transaction) {
        if (transaction.getTotal() == 0.0) {
            return 0.0;
        }
        return (this.getCurrentValue(transaction) - transaction.getTotal()) / transaction.getTotal() * 100.0;
    }

    private double getNetGainLossValue(Transaction transaction) {
        return this.getCurrentValue(transaction) - transaction.getNetTotal();
    }

    private double getNetGainLossPercentage(Transaction transaction) {
        if (transaction.getNetTotal() == 0.0) {
            return 0.0;
        }
        return (this.getCurrentValue(transaction) - transaction.getNetTotal()) / transaction.getNetTotal() * 100.0;
    }

    public double getNetGainLossValue() {
        return this.getNetGainLossValue((Portfolio)this.getRoot());
    }

    private double getNetGainLossValue(Portfolio portfolio) {
        return this.getCurrentValue(portfolio) - portfolio.getNetTotal();
    }

    public double getNetGainLossPercentage() {
        return this.getNetGainLossPercentage((Portfolio)this.getRoot());
    }

    private double getNetGainLossPercentage(Portfolio portfolio) {
        if (portfolio.getNetTotal() == 0.0) {
            return 0.0;
        }
        return (this.getCurrentValue(portfolio) - portfolio.getNetTotal()) / portfolio.getNetTotal() * 100.0;
    }

    public double getNetPurchaseValue() {
        return ((Portfolio)this.getRoot()).getNetTotal();
    }

    private double getCurrentValue(Portfolio portfolio) {
        int count = portfolio.getChildCount();
        double result = 0.0;
        for (int i = 0; i < count; ++i) {
            TreeTableNode o = portfolio.getChildAt(i);
            assert (o instanceof TransactionSummary);
            TransactionSummary transactionSummary = (TransactionSummary)o;
            assert (transactionSummary.getChildCount() > 0);
            result += this.getCurrentValue(transactionSummary);
        }
        return result;
    }

    private double getPurchasePrice(TransactionSummary transactionSummary) {
        if (transactionSummary.getQuantity() == 0.0) {
            return 0.0;
        }
        return transactionSummary.getTotal() / transactionSummary.getQuantity();
    }

    private double getGainLossPrice(TransactionSummary transactionSummary) {
        if (transactionSummary.getQuantity() == 0.0) {
            return 0.0;
        }
        return this.getCurrentPrice(transactionSummary) - transactionSummary.getTotal() / transactionSummary.getQuantity();
    }

    private double getGainLossValue(TransactionSummary transactionSummary) {
        return this.getCurrentValue(transactionSummary) - transactionSummary.getTotal();
    }

    @Override
    public int getColumnCount() {
        assert (cNames.length == cTypes.length);
        return cNames.length;
    }

    @Override
    public Class getColumnClass(int column) {
        return cTypes[column];
    }

    @Override
    public String getColumnName(int column) {
        return cNames[column];
    }

    @Override
    public Object getValueAt(Object node, int column) {
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        if (node instanceof Portfolio) {
            Portfolio portfolio = (Portfolio)node;
            switch (column) {
                case 0: {
                    return GUIBundle.getString("PortfolioManagementJPanel_Buy");
                }
                case 5: {
                    if (!jStockOptions.isPenceToPoundConversionEnabled()) {
                        return portfolio.getTotal();
                    }
                    return portfolio.getTotal() / 100.0;
                }
                case 6: {
                    if (!jStockOptions.isPenceToPoundConversionEnabled()) {
                        return this.getCurrentValue(portfolio);
                    }
                    return this.getCurrentValue(portfolio) / 100.0;
                }
                case 8: {
                    if (!jStockOptions.isPenceToPoundConversionEnabled()) {
                        return this.getGainLossValue(portfolio);
                    }
                    return this.getGainLossValue(portfolio) / 100.0;
                }
                case 9: {
                    return new DoubleWrapper(DecimalPlaces.Two, this.getGainLossPercentage(portfolio));
                }
                case 10: {
                    return portfolio.getBroker();
                }
                case 11: {
                    return portfolio.getClearingFee();
                }
                case 12: {
                    return portfolio.getStampDuty();
                }
                case 13: {
                    if (!jStockOptions.isPenceToPoundConversionEnabled()) {
                        return portfolio.getNetTotal();
                    }
                    return portfolio.getNetTotal() / 100.0;
                }
                case 14: {
                    if (!jStockOptions.isPenceToPoundConversionEnabled()) {
                        return this.getNetGainLossValue(portfolio);
                    }
                    return this.getNetGainLossValue(portfolio) / 100.0;
                }
                case 15: {
                    return new DoubleWrapper(DecimalPlaces.Two, this.getNetGainLossPercentage(portfolio));
                }
                case 16: {
                    return portfolio.getComment();
                }
            }
            return null;
        }
        if (node instanceof TransactionSummary) {
            TransactionSummary transactionSummary = (TransactionSummary)node;
            if (transactionSummary.getChildCount() <= 0) {
                return null;
            }
            switch (column) {
                case 0: {
                    return ((Transaction)transactionSummary.getChildAt((int)0)).getStock().symbol;
                }
                case 2: {
                    return transactionSummary.getQuantity();
                }
                case 3: {
                    if (MainFrame.getInstance().getJStockOptions().isFourDecimalPlacesEnabled()) {
                        return new DoubleWrapper(DecimalPlaces.Four, this.getPurchasePrice(transactionSummary));
                    }
                    return new DoubleWrapper(DecimalPlaces.Three, this.getPurchasePrice(transactionSummary));
                }
                case 4: {
                    return this.getCurrentPrice(transactionSummary);
                }
                case 5: {
                    if (!jStockOptions.isPenceToPoundConversionEnabled()) {
                        return transactionSummary.getTotal();
                    }
                    return transactionSummary.getTotal() / 100.0;
                }
                case 6: {
                    if (!jStockOptions.isPenceToPoundConversionEnabled()) {
                        return this.getCurrentValue(transactionSummary);
                    }
                    return this.getCurrentValue(transactionSummary) / 100.0;
                }
                case 7: {
                    return this.getGainLossPrice(transactionSummary);
                }
                case 8: {
                    if (!jStockOptions.isPenceToPoundConversionEnabled()) {
                        return this.getGainLossValue(transactionSummary);
                    }
                    return this.getGainLossValue(transactionSummary) / 100.0;
                }
                case 9: {
                    return new DoubleWrapper(DecimalPlaces.Two, this.getGainLossPercentage(transactionSummary));
                }
                case 10: {
                    return transactionSummary.getBroker();
                }
                case 11: {
                    return transactionSummary.getClearingFee();
                }
                case 12: {
                    return transactionSummary.getStampDuty();
                }
                case 13: {
                    if (!jStockOptions.isPenceToPoundConversionEnabled()) {
                        return transactionSummary.getNetTotal();
                    }
                    return transactionSummary.getNetTotal() / 100.0;
                }
                case 14: {
                    if (!jStockOptions.isPenceToPoundConversionEnabled()) {
                        return this.getNetGainLossValue(transactionSummary);
                    }
                    return this.getNetGainLossValue(transactionSummary) / 100.0;
                }
                case 15: {
                    return new DoubleWrapper(DecimalPlaces.Two, this.getNetGainLossPercentage(transactionSummary));
                }
                case 16: {
                    return transactionSummary.getComment();
                }
            }
        }
        if (node instanceof Transaction) {
            Transaction transaction = (Transaction)node;
            switch (column) {
                case 0: {
                    return transaction.getStock().symbol;
                }
                case 1: {
                    return transaction.getDate();
                }
                case 2: {
                    return transaction.getQuantity();
                }
                case 3: {
                    return transaction.getPrice();
                }
                case 4: {
                    return this.getCurrentPrice(transaction);
                }
                case 5: {
                    if (!jStockOptions.isPenceToPoundConversionEnabled()) {
                        return transaction.getTotal();
                    }
                    return transaction.getTotal() / 100.0;
                }
                case 6: {
                    if (!jStockOptions.isPenceToPoundConversionEnabled()) {
                        return this.getCurrentValue(transaction);
                    }
                    return this.getCurrentValue(transaction) / 100.0;
                }
                case 7: {
                    return this.getCurrentPrice(transaction) - transaction.getPrice();
                }
                case 8: {
                    if (!jStockOptions.isPenceToPoundConversionEnabled()) {
                        return this.getCurrentValue(transaction) - transaction.getTotal();
                    }
                    return (this.getCurrentValue(transaction) - transaction.getTotal()) / 100.0;
                }
                case 9: {
                    return new DoubleWrapper(DecimalPlaces.Two, this.getGainLossPercentage(transaction));
                }
                case 10: {
                    return transaction.getBroker();
                }
                case 11: {
                    return transaction.getClearingFee();
                }
                case 12: {
                    return transaction.getStampDuty();
                }
                case 13: {
                    if (!jStockOptions.isPenceToPoundConversionEnabled()) {
                        return transaction.getNetTotal();
                    }
                    return transaction.getNetTotal() / 100.0;
                }
                case 14: {
                    if (!jStockOptions.isPenceToPoundConversionEnabled()) {
                        return this.getNetGainLossValue(transaction);
                    }
                    return this.getNetGainLossValue(transaction) / 100.0;
                }
                case 15: {
                    return new DoubleWrapper(DecimalPlaces.Two, this.getNetGainLossPercentage(transaction));
                }
                case 16: {
                    return transaction.getComment();
                }
            }
        }
        return null;
    }

    @Override
    public boolean isValidTransaction(Transaction transaction) {
        return transaction.getType() == Contract.Type.Buy;
    }

    public Map<Code, Double> getStockPrices() {
        return Collections.unmodifiableMap(this.stockPrice);
    }

    public BuyPortfolioTreeTableModelEx toBuyPortfolioTreeTableModelEx() {
        BuyPortfolioTreeTableModelEx buyPortfolioTreeTableModelEx = new BuyPortfolioTreeTableModelEx();
        buyPortfolioTreeTableModelEx.setRoot(this.getRoot());
        ((Portfolio)buyPortfolioTreeTableModelEx.getRoot()).setTreeTableModel((TreeTableModel)buyPortfolioTreeTableModelEx);
        for (Map.Entry<Code, Double> entry : this.stockPrice.entrySet()) {
            Code code = entry.getKey();
            Double price = entry.getValue();
            buyPortfolioTreeTableModelEx.updateStockLastPrice(code, price);
        }
        return buyPortfolioTreeTableModelEx;
    }

    private Object readResolve() {
        Portfolio portfolio = (Portfolio)this.getRoot();
        int count = portfolio.getChildCount();
        HashSet<Code> set = new HashSet<Code>();
        for (int i = 0; i < count; ++i) {
            TransactionSummary transactionSummary = (TransactionSummary)portfolio.getChildAt(i);
            assert (transactionSummary.getChildCount() > 0);
            Transaction transaction = (Transaction)transactionSummary.getChildAt(0);
            set.add(transaction.getStock().code);
        }
        Iterator<Code> it = this.stockPrice.keySet().iterator();
        while (it.hasNext()) {
            if (set.contains(it.next())) continue;
            it.remove();
        }
        return this;
    }

    static {
        String[] tmp = new String[]{GUIBundle.getString("PortfolioManagementJPanel_Stock"), GUIBundle.getString("PortfolioManagementJPanel_Date"), GUIBundle.getString("PortfolioManagementJPanel_Units"), GUIBundle.getString("PortfolioManagementJPanel_PurchasePrice"), GUIBundle.getString("PortfolioManagementJPanel_CurrentPrice"), GUIBundle.getString("PortfolioManagementJPanel_PurchaseValue"), GUIBundle.getString("PortfolioManagementJPanel_CurrentValue"), GUIBundle.getString("PortfolioManagementJPanel_GainLossPrice"), GUIBundle.getString("PortfolioManagementJPanel_GainLossValue"), GUIBundle.getString("PortfolioManagementJPanel_GainLossPercentage"), GUIBundle.getString("PortfolioManagementJPanel_Broker"), GUIBundle.getString("PortfolioManagementJPanel_ClearingFee"), GUIBundle.getString("PortfolioManagementJPanel_StampDuty"), GUIBundle.getString("PortfolioManagementJPanel_NetPurchaseValue"), GUIBundle.getString("PortfolioManagementJPanel_NetGainLossValue"), GUIBundle.getString("PortfolioManagementJPanel_NetGainLossPercentage"), GUIBundle.getString("PortfolioManagementJPanel_Comment")};
        cNames = tmp;
        cTypes = new Class[]{TreeTableModel.class, SimpleDate.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, String.class};
    }
}

