/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.NumberFormatter;
import net.sf.nachocalendar.CalendarFactory;
import net.sf.nachocalendar.components.DateField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.SimpleDate;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.MainFrame;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.portfolio.BrokingFirm;
import org.yccheok.jstock.portfolio.Contract;
import org.yccheok.jstock.portfolio.DecimalPlaces;
import org.yccheok.jstock.portfolio.Transaction;

public class NewSellTransactionJDialog
extends JDialog {
    private static final Log log = LogFactory.getLog(NewSellTransactionJDialog.class);
    private Transaction sellTransaction = null;
    private List<Transaction> buyTransactions = new ArrayList<Transaction>();
    private List<Transaction> resultSellTransactions = new ArrayList<Transaction>();
    private Stock stock;
    private Contract.Type type;
    private double buyValue = 0.0;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JFormattedTextField jFormattedTextField1;
    private JFormattedTextField jFormattedTextField2;
    private JFormattedTextField jFormattedTextField3;
    private JFormattedTextField jFormattedTextField4;
    private JFormattedTextField jFormattedTextField5;
    private JFormattedTextField jFormattedTextField6;
    private JFormattedTextField jFormattedTextField7;
    private JFormattedTextField jFormattedTextField8;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JSpinner jSpinner1;
    private JTextField jTextField1;

    public NewSellTransactionJDialog(Frame parent, boolean modal) {
        super(parent, modal);
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        boolean isFeeCalculationEnabled = jStockOptions.isFeeCalculationEnabled();
        if (isFeeCalculationEnabled) {
            this.initComponents();
        } else {
            this.initComponentsWithFeeCalculationDisabled();
        }
        if (this.shouldAutoCalculateBrokerFee()) {
            this.jFormattedTextField4.setEditable(false);
            this.jFormattedTextField5.setEditable(false);
            this.jFormattedTextField7.setEditable(false);
        }
    }

    private void setMaxSellQuantity(double maxSellQuantity) {
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)this.jSpinner1.getModel();
        spinnerNumberModel.setMaximum(Double.valueOf(maxSellQuantity));
    }

    private boolean shouldAutoCalculateBrokerFee() {
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        return jStockOptions.isAutoBrokerFeeCalculationEnabled() && jStockOptions.getSelectedBrokingFirm() != null;
    }

    private void initComponentsWithFeeCalculationDisabled() {
        this.jLabel8 = new JLabel();
        this.jFormattedTextField4 = this.getCurrencyJFormattedTextField(false);
        this.jLabel9 = new JLabel();
        this.jFormattedTextField5 = this.getCurrencyJFormattedTextField(false);
        this.jFormattedTextField7 = this.getCurrencyJFormattedTextField(false);
        this.jLabel11 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jTextField1 = new JTextField();
        this.jLabel2 = new JLabel();
        this.jSpinner1 = new JSpinner();
        this.jPanel3 = CalendarFactory.createDateField();
        this.jLabel4 = new JLabel();
        this.jFormattedTextField1 = this.getCurrencyJFormattedTextField(false);
        this.jFormattedTextField2 = this.getCurrencyJFormattedTextField(false);
        this.jFormattedTextField3 = this.getCurrencyJFormattedTextField(false);
        this.jLabel10 = new JLabel();
        this.jFormattedTextField6 = this.getCurrencyJFormattedTextField(true);
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jFormattedTextField8 = this.getCurrencyJFormattedTextField(true);
        this.jLabel12 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jButton3 = new JButton();
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.jLabel8.setText(bundle.getString("NewSellTransactionJDialog_Broker"));
        this.jFormattedTextField4.setValue(new Double(0.0));
        this.jFormattedTextField4.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                NewSellTransactionJDialog.this.jFormattedTextField4KeyTyped(evt);
            }
        });
        this.jLabel9.setText(bundle.getString("NewSellTransactionJDialog_Clearing"));
        this.jFormattedTextField5.setValue(new Double(0.0));
        this.jFormattedTextField5.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                NewSellTransactionJDialog.this.jFormattedTextField5KeyTyped(evt);
            }
        });
        this.jFormattedTextField7.setValue(new Double(0.0));
        this.jFormattedTextField7.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                NewSellTransactionJDialog.this.jFormattedTextField7KeyTyped(evt);
            }
        });
        this.jLabel11.setText(bundle.getString("NewSellTransactionJDialog_StampDuty"));
        this.setDefaultCloseOperation(2);
        this.setTitle(bundle.getString("NewSellTransactionJDialog_Sell"));
        this.setResizable(false);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(bundle.getString("NewSellTransactionJDialog_Transaction")));
        this.jTextField1.setEditable(false);
        this.jLabel2.setText(bundle.getString("NewBuyTransactionJDialog_Symbol"));
        this.jSpinner1.setModel(new SpinnerNumberModel((Number)100.0, Double.valueOf(0.001), null, (Number)100.0));
        this.jSpinner1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                NewSellTransactionJDialog.this.jSpinner1StateChanged(evt);
            }
        });
        this.jPanel3.setBackground(new Color(204, 255, 255));
        this.jPanel3.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        this.jPanel3.setPreferredSize(new Dimension(100, 20));
        this.jLabel4.setText(bundle.getString("NewBuyTransactionJDialog_Date"));
        this.jFormattedTextField1.setValue(new Double(0.0));
        this.jFormattedTextField1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                NewSellTransactionJDialog.this.jFormattedTextField1KeyTyped(evt);
            }
        });
        this.jFormattedTextField2.setEditable(false);
        this.jFormattedTextField2.setValue(new Double(0.0));
        this.jFormattedTextField3.setEditable(false);
        this.jFormattedTextField3.setValue(new Double(0.0));
        this.jLabel10.setFont(this.jLabel10.getFont().deriveFont(this.jLabel10.getFont().getStyle() | 1));
        this.jLabel10.setText(bundle.getString("NewSellTransactionJDialog_Profit%"));
        this.jFormattedTextField6.setEditable(false);
        this.jFormattedTextField6.setFont(this.jFormattedTextField6.getFont().deriveFont(this.jFormattedTextField6.getFont().getStyle() | 1));
        this.jFormattedTextField6.setValue(new Double(0.0));
        this.jLabel1.setText(bundle.getString("NewSellTransactionJDialog_Unit"));
        this.jLabel3.setText(bundle.getString("NewSellTransactionJDialog_Price"));
        this.jLabel5.setText(bundle.getString("NewSellTransactionJDialog_Value"));
        this.jLabel7.setText(bundle.getString("NewSellTransactionJDialog_BuyCost"));
        this.jFormattedTextField8.setEditable(false);
        this.jFormattedTextField8.setFont(this.jFormattedTextField8.getFont().deriveFont(this.jFormattedTextField8.getFont().getStyle() | 1));
        this.jFormattedTextField8.setValue(new Double(0.0));
        this.jLabel12.setFont(this.jLabel12.getFont().deriveFont(this.jLabel12.getFont().getStyle() | 1));
        this.jLabel12.setText(bundle.getString("NewSellTransactionJDialog_Profit$"));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel5).addComponent(this.jLabel7).addComponent(this.jLabel1).addComponent(this.jLabel4)).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField1, -1, 109, Short.MAX_VALUE).addComponent(this.jPanel3, -1, 109, Short.MAX_VALUE).addComponent(this.jSpinner1, -1, 109, Short.MAX_VALUE).addComponent(this.jFormattedTextField1, -1, 109, Short.MAX_VALUE).addComponent(this.jFormattedTextField2, -1, 109, Short.MAX_VALUE).addComponent(this.jFormattedTextField3, -1, 109, Short.MAX_VALUE))).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel12).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jFormattedTextField6, -1, 109, Short.MAX_VALUE).addComponent(this.jFormattedTextField8, -2, 79, -2)))).addGap(18, 18, 18)));
        jPanel2Layout.linkSize(0, this.jFormattedTextField1, this.jFormattedTextField2, this.jFormattedTextField3, this.jFormattedTextField6, this.jFormattedTextField8, this.jPanel3, this.jSpinner1, this.jTextField1);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextField1, -2, -1, -2)).addGap(12, 12, 12).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel3, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinner1, -2, -1, -2).addComponent(this.jLabel1)).addGap(9, 9, 9).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFormattedTextField1, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFormattedTextField2, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFormattedTextField3, -2, -1, -2).addComponent(this.jLabel7)).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFormattedTextField6, -2, -1, -2).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.jFormattedTextField8, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(1, this.jFormattedTextField1, this.jFormattedTextField2, this.jFormattedTextField3, this.jFormattedTextField6, this.jPanel3, this.jSpinner1, this.jTextField1);
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/apply.png")));
        this.jButton1.setText(bundle.getString("NewSellTransactionJDialog_OK"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewSellTransactionJDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton1);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/button_cancel.png")));
        this.jButton2.setText(bundle.getString("NewSellTransactionJDialog_Cancel"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewSellTransactionJDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton2);
        this.getContentPane().add((Component)this.jPanel4, "South");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(bundle.getString("NewSellTransactionJDialog_Stock")));
        this.jPanel1.setLayout(new FlowLayout(1, 15, 5));
        this.jLabel6.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/outbox.png")));
        this.jPanel1.add(this.jLabel6);
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/idea.png")));
        this.jButton3.setText(bundle.getString("NewSellTransactionJDialog_BestPrice"));
        this.jButton3.setToolTipText("Suggest the best selling price to break even.");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewSellTransactionJDialog.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton3);
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.pack();
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jTextField1 = new JTextField();
        this.jLabel2 = new JLabel();
        this.jSpinner1 = new JSpinner();
        this.jPanel3 = CalendarFactory.createDateField();
        this.jLabel4 = new JLabel();
        this.jFormattedTextField1 = this.getCurrencyJFormattedTextField(false);
        this.jFormattedTextField2 = this.getCurrencyJFormattedTextField(false);
        this.jFormattedTextField3 = this.getCurrencyJFormattedTextField(false);
        this.jFormattedTextField4 = this.getCurrencyJFormattedTextField(false);
        this.jFormattedTextField5 = this.getCurrencyJFormattedTextField(false);
        this.jLabel10 = new JLabel();
        this.jFormattedTextField6 = this.getPercentageJFormattedTextField();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jFormattedTextField7 = this.getCurrencyJFormattedTextField(false);
        this.jLabel11 = new JLabel();
        this.jFormattedTextField8 = this.getCurrencyJFormattedTextField(true);
        this.jLabel12 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jButton3 = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.setTitle(bundle.getString("NewSellTransactionJDialog_Sell"));
        this.setResizable(false);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(bundle.getString("NewSellTransactionJDialog_Transaction")));
        this.jTextField1.setEditable(false);
        this.jLabel2.setText(bundle.getString("NewBuyTransactionJDialog_Symbol"));
        this.jSpinner1.setModel(new SpinnerNumberModel((Number)100.0, Double.valueOf(0.001), null, (Number)100.0));
        JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)this.jSpinner1.getEditor();
        DecimalFormat decimalFormat = numberEditor.getFormat();
        decimalFormat.setMaximumFractionDigits(4);
        numberEditor.getTextField().addMouseListener(this.getJFormattedTextFieldMouseListener());
        this.jSpinner1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                NewSellTransactionJDialog.this.jSpinner1StateChanged(evt);
            }
        });
        this.jPanel3.setBackground(new Color(204, 255, 255));
        this.jPanel3.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        this.jPanel3.setPreferredSize(new Dimension(100, 20));
        this.jLabel4.setText(bundle.getString("NewBuyTransactionJDialog_Date"));
        this.jFormattedTextField1.setValue(new Double(0.0));
        this.jFormattedTextField1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                NewSellTransactionJDialog.this.jFormattedTextField1KeyTyped(evt);
            }
        });
        this.jFormattedTextField2.setEditable(false);
        this.jFormattedTextField2.setValue(new Double(0.0));
        this.jFormattedTextField3.setEditable(false);
        this.jFormattedTextField3.setValue(new Double(0.0));
        this.jFormattedTextField4.setValue(new Double(0.0));
        this.jFormattedTextField4.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                NewSellTransactionJDialog.this.jFormattedTextField4KeyTyped(evt);
            }
        });
        this.jFormattedTextField5.setValue(new Double(0.0));
        this.jFormattedTextField5.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                NewSellTransactionJDialog.this.jFormattedTextField5KeyTyped(evt);
            }
        });
        this.jLabel10.setFont(this.jLabel10.getFont().deriveFont(this.jLabel10.getFont().getStyle() | 1));
        this.jLabel10.setText(bundle.getString("NewSellTransactionJDialog_Profit%"));
        this.jFormattedTextField6.setEditable(false);
        this.jFormattedTextField6.setFont(this.jFormattedTextField6.getFont().deriveFont(this.jFormattedTextField6.getFont().getStyle() | 1));
        this.jFormattedTextField6.setValue(new Double(0.0));
        this.jLabel1.setText(bundle.getString("NewSellTransactionJDialog_Unit"));
        this.jLabel3.setText(bundle.getString("NewSellTransactionJDialog_Price"));
        this.jLabel5.setText(bundle.getString("NewSellTransactionJDialog_Value"));
        this.jLabel7.setText(bundle.getString("NewSellTransactionJDialog_BuyCost"));
        this.jLabel8.setText(bundle.getString("NewSellTransactionJDialog_Broker"));
        this.jLabel9.setText(bundle.getString("NewSellTransactionJDialog_Clearing"));
        this.jFormattedTextField7.setValue(new Double(0.0));
        this.jFormattedTextField7.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                NewSellTransactionJDialog.this.jFormattedTextField7KeyTyped(evt);
            }
        });
        this.jLabel11.setText(bundle.getString("NewSellTransactionJDialog_StampDuty"));
        this.jFormattedTextField8.setEditable(false);
        this.jFormattedTextField8.setFont(this.jFormattedTextField8.getFont().deriveFont(this.jFormattedTextField8.getFont().getStyle() | 1));
        this.jFormattedTextField8.setValue(new Double(0.0));
        this.jLabel12.setFont(this.jLabel12.getFont().deriveFont(this.jLabel12.getFont().getStyle() | 1));
        this.jLabel12.setText(bundle.getString("NewSellTransactionJDialog_Profit$"));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel5).addComponent(this.jLabel7).addComponent(this.jLabel8).addComponent(this.jLabel1).addComponent(this.jLabel4).addComponent(this.jLabel11).addComponent(this.jLabel12).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jFormattedTextField6, -1, 109, Short.MAX_VALUE).addComponent(this.jTextField1, -1, 109, Short.MAX_VALUE).addComponent(this.jPanel3, -1, 109, Short.MAX_VALUE).addComponent(this.jSpinner1, -1, 109, Short.MAX_VALUE).addComponent(this.jFormattedTextField1, -1, 109, Short.MAX_VALUE).addComponent(this.jFormattedTextField2, -1, 109, Short.MAX_VALUE).addComponent(this.jFormattedTextField3, -1, 109, Short.MAX_VALUE).addComponent(this.jFormattedTextField4, -1, 109, Short.MAX_VALUE).addComponent(this.jFormattedTextField5, -1, 109, Short.MAX_VALUE).addComponent(this.jFormattedTextField7, -2, 101, -2).addComponent(this.jFormattedTextField8, -2, 79, -2)).addGap(18, 18, 18)));
        jPanel2Layout.linkSize(0, this.jFormattedTextField1, this.jFormattedTextField2, this.jFormattedTextField3, this.jFormattedTextField4, this.jFormattedTextField5, this.jFormattedTextField6, this.jFormattedTextField7, this.jFormattedTextField8, this.jPanel3, this.jSpinner1, this.jTextField1);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextField1, -2, -1, -2)).addGap(12, 12, 12).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel3, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinner1, -2, -1, -2).addComponent(this.jLabel1)).addGap(9, 9, 9).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFormattedTextField1, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFormattedTextField2, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFormattedTextField3, -2, -1, -2).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFormattedTextField4, -2, -1, -2).addComponent(this.jLabel8)).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(14, 14, 14).addComponent(this.jLabel9)).addGroup(jPanel2Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jFormattedTextField5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.jFormattedTextField7, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 38, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFormattedTextField6, -2, -1, -2).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.jFormattedTextField8, -2, -1, -2))));
        jPanel2Layout.linkSize(1, this.jFormattedTextField1, this.jFormattedTextField2, this.jFormattedTextField3, this.jFormattedTextField4, this.jFormattedTextField5, this.jFormattedTextField6, this.jPanel3, this.jSpinner1, this.jTextField1);
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/apply.png")));
        this.jButton1.setText(bundle.getString("NewSellTransactionJDialog_OK"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewSellTransactionJDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton1);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/button_cancel.png")));
        this.jButton2.setText(bundle.getString("NewSellTransactionJDialog_Cancel"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewSellTransactionJDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton2);
        this.getContentPane().add((Component)this.jPanel4, "South");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(bundle.getString("NewSellTransactionJDialog_Stock")));
        this.jPanel1.setLayout(new FlowLayout(1, 15, 5));
        this.jLabel6.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/outbox.png")));
        this.jPanel1.add(this.jLabel6);
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/idea.png")));
        this.jButton3.setText(bundle.getString("NewSellTransactionJDialog_BestPrice"));
        this.jButton3.setToolTipText("Suggest the best selling price to break even.");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewSellTransactionJDialog.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton3);
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.pack();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.resultSellTransactions.clear();
        this.setVisible(false);
        this.dispose();
    }

    public void setBuyTransactions(List<Transaction> transactions) {
        if (this.sellTransaction != null) {
            throw new UnsupportedOperationException("You cannot sell transaction and edit transaction at the same time");
        }
        this.buyTransactions.clear();
        this.buyTransactions.addAll(transactions);
        Stock _stock = transactions.get(0).getStock();
        Symbol symbol = _stock.symbol;
        Date date = Calendar.getInstance().getTime();
        MainFrame mainFrame = MainFrame.getInstance();
        double price = mainFrame.getPortfolioManagementJPanel().getStockPrice(_stock);
        this.jTextField1.setText(symbol.toString());
        this.jTextField1.setCaretPosition(0);
        ((DateField)this.jPanel3).setValue((Object)date);
        double quantity = 0.0;
        for (Transaction transaction : transactions) {
            quantity += transaction.getQuantity();
        }
        this.jSpinner1.setValue(quantity);
        this.jFormattedTextField1.setValue(price);
        this.setMaxSellQuantity(quantity);
        this.stock = _stock;
        this.type = Contract.Type.Sell;
        this.updateBuyValueAfterSpinner(quantity);
        this.update();
    }

    private void updateBuyValueAfterSpinner(double spinnerQuantity) {
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        boolean isFeeCalculationEnabled = jStockOptions.isFeeCalculationEnabled();
        double sellQuantity = spinnerQuantity;
        if (this.sellTransaction != null) {
            this.buyValue = isFeeCalculationEnabled ? sellQuantity * this.sellTransaction.getReferencePrice() + this.sellTransaction.getReferenceBroker() + this.sellTransaction.getReferenceClearingFee() + this.sellTransaction.getReferenceStampDuty() : sellQuantity * this.sellTransaction.getReferencePrice();
            return;
        }
        double _buyValue = 0.0;
        for (Transaction buyTransaction : this.buyTransactions) {
            if (sellQuantity >= buyTransaction.getQuantity()) {
                _buyValue = isFeeCalculationEnabled ? (_buyValue += buyTransaction.getNetTotal()) : (_buyValue += buyTransaction.getTotal());
                sellQuantity -= buyTransaction.getQuantity();
                continue;
            }
            if (org.yccheok.jstock.portfolio.Utils.definitelyGreaterThan(sellQuantity, 0.0)) {
                _buyValue = isFeeCalculationEnabled ? (_buyValue += buyTransaction.getPrice() * sellQuantity + this.getGoodCurrencyDouble(buyTransaction.getBroker(), sellQuantity, buyTransaction.getQuantity()) + this.getGoodCurrencyDouble(buyTransaction.getClearingFee(), sellQuantity, buyTransaction.getQuantity()) + this.getGoodCurrencyDouble(buyTransaction.getStampDuty(), sellQuantity, buyTransaction.getQuantity())) : (_buyValue += buyTransaction.getPrice() * sellQuantity);
            }
            sellQuantity = 0.0;
            break;
        }
        this.buyValue = _buyValue;
    }

    private double getGoodCurrencyDouble(double value, double sellQuantity, double buyQuantity) {
        assert (sellQuantity <= buyQuantity);
        assert (org.yccheok.jstock.portfolio.Utils.definitelyGreaterThan(sellQuantity, 0.0));
        assert (org.yccheok.jstock.portfolio.Utils.definitelyGreaterThan(buyQuantity, 0.0));
        if (org.yccheok.jstock.portfolio.Utils.essentiallyEqual(sellQuantity, buyQuantity)) {
            return value;
        }
        String text = org.yccheok.jstock.portfolio.Utils.toEditCurrency(DecimalPlaces.Three, sellQuantity / buyQuantity * value);
        return Double.parseDouble(text);
    }

    private BigDecimal getGoodCurrencyBigDecimal(double value, double sellQuantity, double buyQuantity) {
        return new BigDecimal(this.getGoodCurrencyDouble(value, sellQuantity, buyQuantity));
    }

    public void setSellTransaction(Transaction transaction) {
        assert (transaction.getType() == Contract.Type.Sell);
        if (this.buyTransactions.size() > 0) {
            throw new UnsupportedOperationException("You cannot sell transaction and edit transaction at the same time");
        }
        if (transaction.getType() != Contract.Type.Sell) {
            throw new UnsupportedOperationException("You can only edit sell transaction");
        }
        this.sellTransaction = transaction;
        Stock _stock = transaction.getStock();
        Symbol symbol = _stock.symbol;
        Date date = transaction.getDate().getCalendar().getTime();
        double quantity = transaction.getQuantity();
        double price = transaction.getPrice();
        double value = transaction.getTotal();
        double brokerFee = transaction.getBroker();
        double clearingFee = transaction.getClearingFee();
        double stampDuty = transaction.getStampDuty();
        this.jTextField1.setText(symbol.toString());
        ((DateField)this.jPanel3).setValue((Object)date);
        this.jSpinner1.setValue(quantity);
        this.jFormattedTextField1.setValue(price);
        this.jFormattedTextField2.setValue(value);
        this.jFormattedTextField4.setValue(brokerFee);
        this.jFormattedTextField5.setValue(clearingFee);
        this.jFormattedTextField7.setValue(stampDuty);
        this.stock = transaction.getStock();
        this.type = Contract.Type.Sell;
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        boolean isFeeCalculationEnabled = jStockOptions.isFeeCalculationEnabled();
        this.buyValue = isFeeCalculationEnabled ? transaction.getNetReferenceTotal() : transaction.getReferenceTotal();
        this.update();
    }

    private List<Transaction> generateTransactions() {
        if (this.sellTransaction != null && this.buyTransactions.size() > 0) {
            throw new UnsupportedOperationException("You cannot sell transaction and edit transaction at the same time");
        }
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        if (this.sellTransaction != null) {
            DateField dateField = (DateField)this.jPanel3;
            SimpleDate date = new SimpleDate((Date)dateField.getValue());
            double unit = (Double)this.jSpinner1.getValue();
            double price = (Double)this.jFormattedTextField1.getValue();
            Contract.ContractBuilder builder = new Contract.ContractBuilder(this.sellTransaction.getStock(), date);
            Contract oldContract = this.sellTransaction.getContract();
            Contract contract = builder.type(this.type).quantity(unit).price(price).referencePrice(oldContract.getReferencePrice()).referenceBroker(oldContract.getReferenceBroker()).referenceClearingFee(oldContract.getReferenceClearingFee()).referenceStampDuty(oldContract.getReferenceStampDuty()).referenceDate(oldContract.getReferenceDate()).build();
            double brokerFeeValue = (Double)this.jFormattedTextField4.getValue();
            double stampDutyValue = (Double)this.jFormattedTextField7.getValue();
            double clearingFeeValue = (Double)this.jFormattedTextField5.getValue();
            Transaction t = new Transaction(contract, brokerFeeValue, stampDutyValue, clearingFeeValue);
            t.setComment(this.sellTransaction.getComment());
            transactions.add(t);
        } else {
            DateField dateField = (DateField)this.jPanel3;
            SimpleDate date = new SimpleDate((Date)dateField.getValue());
            double unit = (Double)this.jSpinner1.getValue();
            double price = (Double)this.jFormattedTextField1.getValue();
            double brokerFee = (Double)this.jFormattedTextField4.getValue();
            double stampDuty = (Double)this.jFormattedTextField7.getValue();
            double clearingFee = (Double)this.jFormattedTextField5.getValue();
            BigDecimal quantity = new BigDecimal(unit);
            boolean shouldBreakInNextRound = false;
            int i = 0;
            BigDecimal totalBrokerFee = new BigDecimal(0);
            BigDecimal totalStampDuty = new BigDecimal(0);
            BigDecimal totalClearingFee = new BigDecimal(0);
            for (Transaction buyTransaction : this.buyTransactions) {
                BigDecimal clearingFeeBigDecimal;
                BigDecimal stampDutyBigDecimal;
                BigDecimal brokerFeeBigDecimal;
                ++i;
                if (shouldBreakInNextRound) break;
                double realTransactionQuantity = 0.0;
                if (quantity.doubleValue() >= buyTransaction.getQuantity()) {
                    realTransactionQuantity = buyTransaction.getQuantity();
                    quantity = quantity.subtract(new BigDecimal(buyTransaction.getQuantity()));
                } else {
                    realTransactionQuantity = quantity.doubleValue();
                    quantity = BigDecimal.ZERO;
                    shouldBreakInNextRound = true;
                    if (!org.yccheok.jstock.portfolio.Utils.definitelyGreaterThan(realTransactionQuantity, 0.0)) break;
                }
                Contract.ContractBuilder builder = new Contract.ContractBuilder(buyTransaction.getStock(), date);
                double referenceBroker = buyTransaction.getBroker();
                double referenceClearingFee = buyTransaction.getClearingFee();
                double referenceStampDuty = buyTransaction.getStampDuty();
                double goodReferenceBroker = this.getGoodCurrencyDouble(referenceBroker, realTransactionQuantity, buyTransaction.getQuantity());
                double goodReferenceClearingFee = this.getGoodCurrencyDouble(referenceClearingFee, realTransactionQuantity, buyTransaction.getQuantity());
                double goodReferenceStampDuty = this.getGoodCurrencyDouble(referenceStampDuty, realTransactionQuantity, buyTransaction.getQuantity());
                Contract contract = builder.type(this.type).quantity(realTransactionQuantity).price(price).referencePrice(buyTransaction.getPrice()).referenceBroker(goodReferenceBroker).referenceClearingFee(goodReferenceClearingFee).referenceStampDuty(goodReferenceStampDuty).referenceDate(buyTransaction.getDate()).build();
                if (i != this.buyTransactions.size()) {
                    brokerFeeBigDecimal = this.getGoodCurrencyBigDecimal(brokerFee, realTransactionQuantity, unit);
                    stampDutyBigDecimal = this.getGoodCurrencyBigDecimal(stampDuty, realTransactionQuantity, unit);
                    clearingFeeBigDecimal = this.getGoodCurrencyBigDecimal(clearingFee, realTransactionQuantity, unit);
                    totalBrokerFee = totalBrokerFee.add(brokerFeeBigDecimal);
                    totalStampDuty = totalStampDuty.add(stampDutyBigDecimal);
                    totalClearingFee = totalClearingFee.add(clearingFeeBigDecimal);
                } else {
                    brokerFeeBigDecimal = new BigDecimal(brokerFee).subtract(totalBrokerFee).max(BigDecimal.ZERO);
                    stampDutyBigDecimal = new BigDecimal(stampDuty).subtract(totalStampDuty).max(BigDecimal.ZERO);
                    clearingFeeBigDecimal = new BigDecimal(clearingFee).subtract(totalClearingFee).max(BigDecimal.ZERO);
                }
                Transaction t = new Transaction(contract, brokerFeeBigDecimal.doubleValue(), stampDutyBigDecimal.doubleValue(), clearingFeeBigDecimal.doubleValue());
                t.setComment(buyTransaction.getComment());
                transactions.add(t);
            }
        }
        return transactions;
    }

    private boolean isValidInput() {
        if (this.jFormattedTextField1.getText().length() <= 0) {
            this.jFormattedTextField1.requestFocus();
            return false;
        }
        if (this.jFormattedTextField2.getText().length() <= 0) {
            this.jFormattedTextField2.requestFocus();
            return false;
        }
        if (this.jFormattedTextField4.getText().length() <= 0) {
            this.jFormattedTextField4.requestFocus();
            return false;
        }
        if (this.jFormattedTextField5.getText().length() <= 0) {
            this.jFormattedTextField5.requestFocus();
            return false;
        }
        if (this.jFormattedTextField7.getText().length() <= 0) {
            this.jFormattedTextField7.requestFocus();
            return false;
        }
        if (this.jFormattedTextField6.getText().length() <= 0) {
            this.jFormattedTextField6.requestFocus();
            return false;
        }
        return true;
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (!this.isValidInput()) {
            return;
        }
        this.commitEdit();
        this.resultSellTransactions = this.generateTransactions();
        this.setVisible(false);
        this.dispose();
    }

    private void update() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewSellTransactionJDialog.this._update();
            }
        });
    }

    private void _update() {
        this.commitEdit();
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        boolean isFeeCalculationEnabled = jStockOptions.isFeeCalculationEnabled();
        if (isFeeCalculationEnabled && this.shouldAutoCalculateBrokerFee()) {
            BrokingFirm brokingFirm = MainFrame.getInstance().getJStockOptions().getSelectedBrokingFirm();
            String name = this.jTextField1.getText();
            double unit = (Double)this.jSpinner1.getValue();
            double price = (Double)this.jFormattedTextField1.getValue();
            DateField dateField = (DateField)this.jPanel3;
            Date date = (Date)dateField.getValue();
            Contract.ContractBuilder builder = new Contract.ContractBuilder(Utils.getEmptyStock(Code.newInstance(name), Symbol.newInstance(name)), new SimpleDate(date));
            Contract contract = builder.type(Contract.Type.Sell).quantity(unit).price(price).build();
            double brokerFee = brokingFirm.brokerCalculate(contract);
            double clearingFee = brokingFirm.clearingFeeCalculate(contract);
            double stampDuty = brokingFirm.stampDutyCalculate(contract);
            this.jFormattedTextField4.setValue(brokerFee);
            this.jFormattedTextField5.setValue(clearingFee);
            this.jFormattedTextField7.setValue(stampDuty);
            double sellValue = price * unit;
            if (isFeeCalculationEnabled) {
                sellValue = sellValue - brokerFee - clearingFee - stampDuty;
            }
            double totalCost = this.buyValue;
            double netProfit = sellValue - totalCost;
            double netProfitPercentage = totalCost == 0.0 ? 0.0 : netProfit / totalCost * 100.0;
            this.jFormattedTextField2.setValue(sellValue);
            this.jFormattedTextField3.setValue(totalCost);
            this.jFormattedTextField6.setValue(netProfitPercentage);
            this.jFormattedTextField6.setForeground(Utils.getColor(netProfitPercentage, 0.0));
            this.jFormattedTextField8.setValue(netProfit);
            this.jFormattedTextField8.setForeground(Utils.getColor(netProfit, 0.0));
        } else {
            double unit = (Double)this.jSpinner1.getValue();
            double price = (Double)this.jFormattedTextField1.getValue();
            double brokerFee = (Double)this.jFormattedTextField4.getValue();
            double clearingFee = (Double)this.jFormattedTextField5.getValue();
            double stampDuty = (Double)this.jFormattedTextField7.getValue();
            double sellValue = price * unit;
            if (isFeeCalculationEnabled) {
                sellValue = sellValue - brokerFee - clearingFee - stampDuty;
            }
            double totalCost = this.buyValue;
            double netProfit = sellValue - totalCost;
            double netProfitPercentage = totalCost == 0.0 ? 0.0 : netProfit / totalCost * 100.0;
            this.jFormattedTextField2.setValue(sellValue);
            this.jFormattedTextField3.setValue(totalCost);
            this.jFormattedTextField6.setValue(netProfitPercentage);
            this.jFormattedTextField6.setForeground(Utils.getColor(netProfitPercentage, 0.0));
            this.jFormattedTextField8.setValue(netProfit);
            this.jFormattedTextField8.setForeground(Utils.getColor(netProfit, 0.0));
        }
    }

    private void jSpinner1StateChanged(ChangeEvent evt) {
        this.updateBuyValueAfterSpinner((Double)this.jSpinner1.getValue());
        this.update();
    }

    private void setPrice(double price) {
        this.jFormattedTextField1.setValue(price);
        this.update();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.setPrice(this.suggestBestSellingPrice());
    }

    private void jFormattedTextField1KeyTyped(KeyEvent evt) {
        this.update();
    }

    private void jFormattedTextField4KeyTyped(KeyEvent evt) {
        this.update();
    }

    private void jFormattedTextField5KeyTyped(KeyEvent evt) {
        this.update();
    }

    private void jFormattedTextField7KeyTyped(KeyEvent evt) {
        this.update();
    }

    private void commitEdit() {
        try {
            this.jFormattedTextField1.commitEdit();
            this.jFormattedTextField2.commitEdit();
            this.jFormattedTextField3.commitEdit();
            this.jFormattedTextField4.commitEdit();
            this.jFormattedTextField5.commitEdit();
            this.jFormattedTextField6.commitEdit();
            this.jFormattedTextField7.commitEdit();
            this.jFormattedTextField8.commitEdit();
        }
        catch (ParseException ex) {
            log.error(null, (Throwable)ex);
        }
    }

    private JFormattedTextField getPercentageJFormattedTextField() {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(2);
        format.setMinimumFractionDigits(2);
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(Double.class);
        JFormattedTextField formattedTextField = new JFormattedTextField(formatter);
        return formattedTextField;
    }

    private MouseListener getJFormattedTextFieldMouseListener() {
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(final MouseEvent e) {
                if (e.getClickCount() == 2) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTextField tf = (JTextField)e.getSource();
                        int offset = tf.viewToModel(e.getPoint());
                        tf.setCaretPosition(offset);
                    }
                });
            }
        };
        return ml;
    }

    private JFormattedTextField getCurrencyJFormattedTextField(boolean isNegativeAllowed) {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(4);
        NumberFormatter formatter = new NumberFormatter(format);
        if (!isNegativeAllowed) {
            formatter.setMinimum(Double.valueOf(0.0));
        } else {
            formatter.setMinimum(null);
        }
        formatter.setValueClass(Double.class);
        JFormattedTextField formattedTextField = new JFormattedTextField(formatter);
        formattedTextField.addMouseListener(this.getJFormattedTextFieldMouseListener());
        return formattedTextField;
    }

    public List<Transaction> getTransactions() {
        return this.resultSellTransactions;
    }

    public double suggestBestSellingPrice() {
        MainFrame mainFrame;
        double currentPrice;
        double stampDuty;
        double clearingFee;
        double expectedProfitPercentage = MainFrame.getInstance().getJStockOptions().getExpectedProfitPercentage();
        double unit = (Double)this.jSpinner1.getValue();
        if (unit <= 0.0) {
            return 0.0;
        }
        double _buyValue = this.buyValue;
        double brokerFee = (Double)this.jFormattedTextField4.getValue();
        double totalCost = _buyValue + brokerFee + (clearingFee = ((Double)this.jFormattedTextField5.getValue()).doubleValue()) + (stampDuty = ((Double)this.jFormattedTextField7.getValue()).doubleValue());
        double bestSellingValue = (1.0 + expectedProfitPercentage / 100.0) * totalCost;
        double bestPrice = bestSellingValue / unit;
        return bestPrice > (currentPrice = (mainFrame = MainFrame.getInstance()).getPortfolioManagementJPanel().getStockPrice(this.stock)) ? bestPrice : currentPrice;
    }
}

