/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXHeader;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.gui.Icons;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.LoadFromCloudJDialog;
import org.yccheok.jstock.gui.MainFrame;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.gui.analysis.MemoryLogJDialog;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.internationalization.MessagesBundle;
import org.yccheok.jstock.network.Utils;

public class SaveToCloudJDialog
extends JDialog {
    private volatile SwingWorker<Boolean, Status> saveToCloudTask = null;
    private final List<String> memoryLog = new ArrayList<String>();
    private static final Log log = LogFactory.getLog(LoadFromCloudJDialog.class);
    private JButton jButton1;
    private JButton jButton2;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPasswordField jPasswordField1;
    private JTextField jTextField1;
    private JXHeader jXHeader1;

    public SaveToCloudJDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.jLabel3.setVisible(false);
        this.jLabel4.setVisible(false);
        this.jLabel5.setVisible(false);
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        if (jStockOptions.isRememberGoogleAccountEnabled()) {
            this.jCheckBox1.setSelected(true);
            this.jTextField1.setText(Utils.decrypt(jStockOptions.getGoogleUsername()));
            this.jPasswordField1.setText(Utils.decrypt(jStockOptions.getGooglePassword()));
        }
    }

    private void initComponents() {
        this.jPanel5 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jXHeader1 = new JXHeader();
        this.jPanel3 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel1 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jLabel2 = new JLabel();
        this.jPasswordField1 = new JPasswordField();
        this.jLabel6 = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.setTitle(bundle.getString("SaveToCloudJDialog_Title"));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                SaveToCloudJDialog.this.formWindowClosed(evt);
            }
        });
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.getContentPane().add((Component)this.jPanel5, "West");
        this.getContentPane().add((Component)this.jPanel6, "East");
        this.jXHeader1.setDescription(bundle.getString("SaveToCloudJDialog_Description"));
        this.jXHeader1.setIcon((Icon)new ImageIcon(this.getClass().getResource("/images/32x32/upload_to_cloud.png")));
        this.jXHeader1.setTitle(bundle.getString("SaveToCloudJDialog_Title"));
        this.getContentPane().add((Component)this.jXHeader1, "North");
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/apply.png")));
        this.jButton1.setText(bundle.getString("SaveToCloudJDialog_OK"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveToCloudJDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton1);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/button_cancel.png")));
        this.jButton2.setText(bundle.getString("SaveToCloudJDialog_Cancel"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveToCloudJDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton2);
        this.getContentPane().add((Component)this.jPanel3, "Last");
        this.jPanel1.setLayout(new BorderLayout(5, 5));
        this.jPanel4.setLayout(new FlowLayout(0));
        this.jLabel3.setForeground(new Color(0, 0, 255));
        this.jLabel3.setText(bundle.getString("SaveToCloudJDialog_SavingToCloud..."));
        this.jPanel4.add(this.jLabel3);
        this.jLabel4.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/spinner.gif")));
        this.jPanel4.add(this.jLabel4);
        this.jLabel5.setText(bundle.getString("WizardDownloadlIndicatorJPanel_ViewLog"));
        this.jLabel3.setVisible(false);
        this.jLabel5.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SaveToCloudJDialog.this.jLabel5MouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SaveToCloudJDialog.this.jLabel5MouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SaveToCloudJDialog.this.jLabel5MouseExited(evt);
            }
        });
        this.jPanel4.add(this.jLabel5);
        this.jPanel1.add((Component)this.jPanel4, "South");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(bundle.getString("SaveToCloudJDialog_GoogleAccount")));
        this.jLabel1.setText(bundle.getString("SaveToCloudJDialog_Username"));
        this.jTextField1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveToCloudJDialog.this.jTextField1ActionPerformed(evt);
            }
        });
        this.jLabel2.setText(bundle.getString("SaveToCloudJDialog_Password"));
        this.jPasswordField1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveToCloudJDialog.this.jPasswordField1ActionPerformed(evt);
            }
        });
        this.jLabel6.setFont(this.jLabel6.getFont().deriveFont((float)this.jLabel6.getFont().getSize() - 1.0f));
        this.jLabel6.setText(bundle.getString("SaveToCloudJDialog_EmailExample"));
        this.jCheckBox1.setText(bundle.getString("SaveToCloudJDialog_KeepMeSignedIn"));
        this.jLabel7.setText(bundle.getString("SaveToCloudJDialog_ViewPrivacyInformation"));
        this.jLabel3.setVisible(false);
        this.jLabel7.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SaveToCloudJDialog.this.jLabel7MouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SaveToCloudJDialog.this.jLabel7MouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SaveToCloudJDialog.this.jLabel7MouseExited(evt);
            }
        });
        this.jLabel8.setText(bundle.getString("SaveToCloudJDialog_Or"));
        this.jLabel9.setText(bundle.getString("SaveToCloudJDialog_DownloadJStockAndroid"));
        this.jLabel9.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SaveToCloudJDialog.this.jLabel9MouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SaveToCloudJDialog.this.jLabel9MouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SaveToCloudJDialog.this.jLabel9MouseExited(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addGap(10, 10, 10).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPasswordField1, -1, 177, Short.MAX_VALUE).addComponent(this.jTextField1, -1, 177, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox1).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel7, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel9, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jPasswordField1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7, -2, -1, -2).addComponent(this.jLabel8).addComponent(this.jLabel9, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox1).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel1.add((Component)this.jPanel2, "Center");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.setSize(new Dimension(420, 331));
        this.setLocationRelativeTo(null);
    }

    private void formWindowClosed(WindowEvent evt) {
        this.cancel();
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        if (!this.jCheckBox1.isSelected()) {
            jStockOptions.setRememberGoogleAccountEnabled(false);
            jStockOptions.setGoogleUsername("");
            jStockOptions.setGooglePassword("");
        }
    }

    private void cancel() {
        if (this.saveToCloudTask != null) {
            this.saveToCloudTask.cancel(true);
            this.saveToCloudTask = null;
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jLabel5MouseClicked(MouseEvent evt) {
        MemoryLogJDialog memoryLogJDialog = new MemoryLogJDialog((Frame)MainFrame.getInstance(), true);
        memoryLogJDialog.setLocationRelativeTo(this);
        memoryLogJDialog.setLog(this.memoryLog);
        memoryLogJDialog.setVisible(true);
    }

    private void jLabel5MouseEntered(MouseEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void jLabel5MouseExited(MouseEvent evt) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        String username = this.jTextField1.getText().trim();
        if (username.length() == 0) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_username_cannot_be_empty"), MessagesBundle.getString("warning_title_username_cannot_be_empty"), 2);
            this.jTextField1.requestFocus();
            return;
        }
        if ((username = Utils.toEmailIfPossible(username)) == null) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_invalid_email_address"), MessagesBundle.getString("warning_title_invalid_email_address"), 2);
            this.jTextField1.requestFocus();
            return;
        }
        if (this.jPasswordField1.getPassword().length == 0) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_password_cannot_be_empty"), MessagesBundle.getString("warning_title_password_cannot_be_empty"), 2);
            this.jPasswordField1.requestFocus();
            return;
        }
        String password = new String(this.jPasswordField1.getPassword()).trim();
        if (password.length() == 0) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_password_cannot_be_empty"), MessagesBundle.getString("warning_title_password_cannot_be_empty"), 2);
            this.jPasswordField1.requestFocus();
            return;
        }
        this.jButton1.setEnabled(false);
        this.jTextField1.setEnabled(false);
        this.jPasswordField1.setEnabled(false);
        this.jCheckBox1.setEnabled(false);
        this.jLabel3.setText(GUIBundle.getString("SaveToCloudJDialog_PreparingData..."));
        this.jLabel4.setIcon(Icons.BUSY);
        this.jLabel3.setVisible(true);
        this.jLabel4.setVisible(true);
        this.saveToCloudTask = this.getSaveToCloudTask(username);
        this.saveToCloudTask.execute();
    }

    private void jLabel7MouseClicked(MouseEvent evt) {
        Utils.launchWebBrowser(org.yccheok.jstock.network.Utils.getURL(Utils.Type.PRIVACY_HTML));
    }

    private void jLabel7MouseEntered(MouseEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void jLabel7MouseExited(MouseEvent evt) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jPasswordField1ActionPerformed(ActionEvent evt) {
        this.jButton1ActionPerformed(evt);
    }

    private void jTextField1ActionPerformed(ActionEvent evt) {
        this.jButton1ActionPerformed(evt);
    }

    private void jLabel9MouseClicked(MouseEvent evt) {
        Utils.launchWebBrowser(org.yccheok.jstock.network.Utils.getURL(Utils.Type.ANDROID_HTML));
    }

    private void jLabel9MouseEntered(MouseEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void jLabel9MouseExited(MouseEvent evt) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private SwingWorker<Boolean, Status> getSaveToCloudTask(final String username) {
        SwingWorker<Boolean, Status> worker = new SwingWorker<Boolean, Status>(){

            @Override
            protected void done() {
                boolean result = false;
                if (!this.isCancelled()) {
                    try {
                        result = (Boolean)this.get();
                    }
                    catch (InterruptedException ex) {
                        log.error(null, (Throwable)ex);
                    }
                    catch (ExecutionException ex) {
                        log.error(null, (Throwable)ex);
                    }
                    catch (CancellationException ex) {
                        log.error(null, (Throwable)ex);
                    }
                }
                SaveToCloudJDialog.this.jButton1.setEnabled(true);
                SaveToCloudJDialog.this.jTextField1.setEnabled(true);
                SaveToCloudJDialog.this.jPasswordField1.setEnabled(true);
                SaveToCloudJDialog.this.jCheckBox1.setEnabled(true);
                if (result) {
                    JOptionPane.showMessageDialog(SaveToCloudJDialog.this, GUIBundle.getString("SaveToCloudJDialog_Success"));
                    JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
                    if (SaveToCloudJDialog.this.jCheckBox1.isSelected()) {
                        jStockOptions.setRememberGoogleAccountEnabled(true);
                        jStockOptions.setGoogleUsername(Utils.encrypt(username));
                        jStockOptions.setGooglePassword(Utils.encrypt(new String(SaveToCloudJDialog.this.jPasswordField1.getPassword())).trim());
                    }
                    SaveToCloudJDialog.this.setVisible(false);
                    SaveToCloudJDialog.this.dispose();
                }
            }

            @Override
            protected void process(List<Status> statuses) {
                for (Status status : statuses) {
                    SaveToCloudJDialog.this.writeToMemoryLog(status.message);
                    SaveToCloudJDialog.this.jLabel3.setText(status.message);
                    SaveToCloudJDialog.this.jLabel4.setIcon(status.icon);
                    SaveToCloudJDialog.this.jLabel3.setVisible(true);
                    SaveToCloudJDialog.this.jLabel4.setVisible(true);
                    if (status.icon == Icons.ERROR || status.icon == Icons.WARNING) {
                        SaveToCloudJDialog.this.jLabel3.setForeground(Color.RED);
                        SaveToCloudJDialog.this.jLabel5.setVisible(true);
                        continue;
                    }
                    SaveToCloudJDialog.this.jLabel3.setForeground(Color.BLUE);
                    SaveToCloudJDialog.this.jLabel5.setVisible(false);
                }
            }

            @Override
            protected Boolean doInBackground() {
                if (this.isCancelled()) {
                    return false;
                }
                SaveToCloudJDialog.this.memoryLog.clear();
                this.publish(Status.newInstance(GUIBundle.getString("SaveToCloudJDialog_PreparingData..."), Icons.BUSY));
                MainFrame.getInstance().commitBeforeSaveToCloud();
                File zipFile = SaveToCloudJDialog.this.getJStockZipFile();
                if (this.isCancelled()) {
                    return false;
                }
                if (zipFile == null) {
                    this.publish(Status.newInstance(GUIBundle.getString("SaveToCloudJDialog_PreparingDataFail"), Icons.ERROR));
                    return false;
                }
                this.publish(Status.newInstance(GUIBundle.getString("SaveToCloudJDialog_VerifyGoogleAccount..."), Icons.BUSY));
                String password = new String(SaveToCloudJDialog.this.jPasswordField1.getPassword()).trim();
                if (!Utils.saveToGoogleDoc(username, password, zipFile)) {
                    this.publish(Status.newInstance(GUIBundle.getString("SaveToCloudJDialog_VerifyGoogleAccountFail"), Icons.ERROR));
                    return false;
                }
                this.publish(Status.newInstance(GUIBundle.getString("SaveToCloudJDialog_Success"), Icons.OK));
                return true;
            }
        };
        return worker;
    }

    private static List<FileEx> getFileEx(List<FileEx> fileExs, String name, List<String> extensions) {
        return SaveToCloudJDialog.getFileEx(fileExs, name, extensions, null);
    }

    private static boolean hasExtensions(String fileName, List<String> extensions) {
        for (String extension : extensions) {
            if (!fileName.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    private static List<FileEx> getFileEx(List<FileEx> fileExs, String name, List<String> extensions, LastErrorCode lastErrorCode) {
        File dir = new File(Utils.getUserDataDirectory() + name);
        if (dir.isDirectory()) {
            String[] children;
            for (String child : children = dir.list()) {
                SaveToCloudJDialog.getFileEx(fileExs, name + File.separator + child, extensions, lastErrorCode);
            }
        } else if (!name.equalsIgnoreCase("config" + File.separator + "options.xml")) {
            if (name.contains("watchlist") && name.endsWith("realtimestock.csv")) {
                if (dir.length() < 0x1800000L) {
                    if (extensions == null || SaveToCloudJDialog.hasExtensions(name, extensions)) {
                        fileExs.add(FileEx.newInstance(dir, name));
                    }
                } else if (lastErrorCode != null) {
                    lastErrorCode.flag = true;
                }
            } else if (extensions == null || SaveToCloudJDialog.hasExtensions(name, extensions)) {
                fileExs.add(FileEx.newInstance(dir, name));
            }
        }
        return fileExs;
    }

    private boolean promptUserToContinue(List<Country> countryWithWatchlistFilesBeingIgnored) {
        String title;
        String message;
        if (countryWithWatchlistFilesBeingIgnored.isEmpty()) {
            return true;
        }
        int size = countryWithWatchlistFilesBeingIgnored.size();
        if (size == 1) {
            message = MessageFormat.format(MessagesBundle.getString("question_message_too_many_stocks_during_save_to_cloud_template"), new Object[]{countryWithWatchlistFilesBeingIgnored.get(0)});
            title = MessagesBundle.getString("question_title_too_many_stocks_during_save_to_cloud");
        } else {
            message = MessageFormat.format(MessagesBundle.getString("question_message_too_many_stocks_in_multiple_countries_during_save_to_cloud_template"), size);
            title = MessagesBundle.getString("question_title_too_many_stocks_in_multiple_countries_during_save_to_cloud");
        }
        final int[] choice = new int[]{1};
        if (SwingUtilities.isEventDispatchThread()) {
            choice[0] = JOptionPane.showConfirmDialog(this, message, title, 0);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        choice[0] = JOptionPane.showConfirmDialog(SaveToCloudJDialog.this, message, title, 0);
                    }
                });
            }
            catch (InterruptedException ex) {
                log.error(null, (Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                log.error(null, (Throwable)ex);
            }
        }
        return choice[0] == 0;
    }

    private static List<String> getExtensions(String name) {
        ArrayList<String> extensions = new ArrayList<String>();
        if (name.equals("config")) {
            extensions.add(".xml");
        } else if (name.equals("indicator")) {
            extensions.add(".xml");
        } else if (name.equals("logos")) {
            extensions.add(".jpg");
            extensions.add(".jpeg");
            extensions.add(".gif");
            extensions.add(".png");
            extensions.add(".bmp");
        } else if (name.equals("portfolios")) {
            extensions.add(".csv");
        } else if (name.equals("watchlist")) {
            extensions.add(".csv");
        } else if (name.equals("android")) {
            extensions.add(".csv");
            extensions.add(".json");
        } else {
            assert (false);
            throw new IllegalArgumentException(name);
        }
        return Collections.unmodifiableList(extensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getJStockZipFileForConversionErrorMessageJDialog(File destFile) {
        List<File> files = SaveToCloudJDialog.getUserDefinedDatabaseFiles();
        ArrayList<FileEx> fileExs = new ArrayList<FileEx>();
        for (File file : files) {
            String filename = file.getAbsolutePath();
            int index = filename.indexOf(Utils.getApplicationVersionString());
            if (index < 0) continue;
            String output = filename.substring(index + Utils.getApplicationVersionString().length() + File.separator.length());
            fileExs.add(FileEx.newInstance(file, output));
        }
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        JStockOptions insensitiveJStockOptions = jStockOptions.insensitiveClone();
        try {
            File tempJStockOptions = File.createTempFile(Utils.getJStockUUID(), ".xml");
            tempJStockOptions.deleteOnExit();
            Utils.toXML((Object)insensitiveJStockOptions, tempJStockOptions);
            fileExs.add(FileEx.newInstance(tempJStockOptions, "config" + File.separator + "options.xml"));
        }
        catch (IOException ex) {
            log.error(null, (Throwable)ex);
        }
        ArrayList<Country> countryWithWatchlistFilesBeingIgnored = new ArrayList<Country>();
        SaveToCloudJDialog.getFileEx(fileExs, "config", null);
        SaveToCloudJDialog.getFileEx(fileExs, "indicator", null);
        SaveToCloudJDialog.getFileEx(fileExs, "logos", null);
        for (Country country : Country.values()) {
            SaveToCloudJDialog.getFileEx(fileExs, (Object)((Object)country) + File.separator + "portfolios", null);
            SaveToCloudJDialog.getFileEx(fileExs, (Object)((Object)country) + File.separator + "config", null);
            LastErrorCode lastErrorCode = new LastErrorCode();
            SaveToCloudJDialog.getFileEx(fileExs, (Object)((Object)country) + File.separator + "watchlist", null, lastErrorCode);
            if (!lastErrorCode.flag) continue;
            countryWithWatchlistFilesBeingIgnored.add(country);
        }
        byte[] buf = new byte[1024];
        ZipOutputStream out = null;
        File temp = destFile;
        try {
            out = new ZipOutputStream(new FileOutputStream(temp));
            for (FileEx fileEx : fileExs) {
                FileInputStream in = null;
                try {
                    int len;
                    in = new FileInputStream(fileEx.input);
                    String zipEntryName = fileEx.output;
                    out.putNextEntry(Utils.getZipEntry(zipEntryName));
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                }
                catch (IOException exp) {
                    log.error(null, (Throwable)exp);
                }
                finally {
                    Utils.closeEntry(out);
                    Utils.close(in);
                }
            }
        }
        catch (IOException exp) {
            try {
                log.error(null, (Throwable)exp);
            }
            catch (Throwable throwable) {
                Utils.close(out);
                throw throwable;
            }
            Utils.close(out);
        }
        Utils.close(out);
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getJStockZipFile() {
        List<File> files = SaveToCloudJDialog.getUserDefinedDatabaseFiles();
        ArrayList<FileEx> fileExs = new ArrayList<FileEx>();
        for (File file : files) {
            String filename = file.getAbsolutePath();
            int index = filename.indexOf(Utils.getApplicationVersionString());
            if (index < 0) continue;
            String output = filename.substring(index + Utils.getApplicationVersionString().length() + File.separator.length());
            fileExs.add(FileEx.newInstance(file, output));
        }
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        JStockOptions insensitiveJStockOptions = jStockOptions.insensitiveClone();
        try {
            File tempJStockOptions = File.createTempFile(Utils.getJStockUUID(), ".xml");
            tempJStockOptions.deleteOnExit();
            Utils.toXML((Object)insensitiveJStockOptions, tempJStockOptions);
            fileExs.add(FileEx.newInstance(tempJStockOptions, "config" + File.separator + "options.xml"));
        }
        catch (IOException ex) {
            log.error(null, (Throwable)ex);
        }
        ArrayList<Country> countryWithWatchlistFilesBeingIgnored = new ArrayList<Country>();
        SaveToCloudJDialog.getFileEx(fileExs, "config", SaveToCloudJDialog.getExtensions("config"));
        SaveToCloudJDialog.getFileEx(fileExs, "indicator", SaveToCloudJDialog.getExtensions("indicator"));
        SaveToCloudJDialog.getFileEx(fileExs, "logos", SaveToCloudJDialog.getExtensions("logos"));
        SaveToCloudJDialog.getFileEx(fileExs, "android", SaveToCloudJDialog.getExtensions("android"));
        for (Country country : Country.values()) {
            SaveToCloudJDialog.getFileEx(fileExs, (Object)((Object)country) + File.separator + "portfolios", SaveToCloudJDialog.getExtensions("portfolios"));
            SaveToCloudJDialog.getFileEx(fileExs, (Object)((Object)country) + File.separator + "config", SaveToCloudJDialog.getExtensions("config"));
            LastErrorCode lastErrorCode = new LastErrorCode();
            SaveToCloudJDialog.getFileEx(fileExs, (Object)((Object)country) + File.separator + "watchlist", SaveToCloudJDialog.getExtensions("watchlist"), lastErrorCode);
            if (!lastErrorCode.flag) continue;
            countryWithWatchlistFilesBeingIgnored.add(country);
        }
        if (!this.promptUserToContinue(countryWithWatchlistFilesBeingIgnored)) {
            return null;
        }
        byte[] buf = new byte[1024];
        ZipOutputStream out = null;
        File temp = null;
        try {
            temp = File.createTempFile(Utils.getJStockUUID(), ".zip");
            temp.deleteOnExit();
            out = new ZipOutputStream(new FileOutputStream(temp));
            for (FileEx fileEx : fileExs) {
                FileInputStream in = null;
                try {
                    int len;
                    in = new FileInputStream(fileEx.input);
                    String zipEntryName = fileEx.output;
                    out.putNextEntry(Utils.getZipEntry(zipEntryName));
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                }
                catch (IOException exp) {
                    log.error(null, (Throwable)exp);
                }
                finally {
                    Utils.closeEntry(out);
                    Utils.close(in);
                }
            }
            Utils.close(out);
        }
        catch (IOException exp) {
            log.error(null, (Throwable)exp);
            File file = null;
            return file;
        }
        finally {
            Utils.close(out);
        }
        return temp;
    }

    private static List<File> getUserDefinedDatabaseFiles() {
        ArrayList<File> files = new ArrayList<File>();
        for (Country country : Country.values()) {
            File file = new File(Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "database" + File.separator + "user-defined-database.csv");
            if (!file.exists()) continue;
            files.add(file);
        }
        return files;
    }

    private void writeToMemoryLog(String message) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy hh:mm:ss a");
        String s = dateFormat.format(new Date()) + "\n" + message;
        this.memoryLog.add(s);
    }

    private static class LastErrorCode {
        boolean flag = false;

        private LastErrorCode() {
        }
    }

    private static class FileEx {
        final File input;
        final String output;

        private FileEx(File input, String output) {
            this.input = input;
            this.output = output;
        }

        public static FileEx newInstance(File input, String output) {
            return new FileEx(input, output);
        }
    }

    private static class Status {
        public final String message;
        public final Icon icon;

        private Status(String message, Icon icon) {
            if (message == null || icon == null) {
                throw new IllegalArgumentException("Method arguments cannot be null");
            }
            this.message = message;
            this.icon = icon;
        }

        public static Status newInstance(String message, Icon icon) {
            return new Status(message, icon);
        }
    }
}

