/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.yccheok.jstock.gui.JTableUtilities;

public class TableColumnSelectionPopupListener
extends MouseAdapter {
    private final List<String> columnNamesToBeIgnored;
    private int menuStartIndex;

    public TableColumnSelectionPopupListener(int menuStartIndex, String[] columnNamesToBeIgnored) {
        this.menuStartIndex = menuStartIndex;
        this.columnNamesToBeIgnored = Arrays.asList(columnNamesToBeIgnored);
    }

    public TableColumnSelectionPopupListener(int menuStartIndex) {
        this(menuStartIndex, new String[0]);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    private void maybeShowPopup(MouseEvent e) {
        Component component;
        if (e.isPopupTrigger() && (component = e.getComponent()) instanceof JTableHeader) {
            JTableHeader jTableHeader = (JTableHeader)component;
            JTable jTable1 = jTableHeader.getTable();
            this.getMyTableColumnSelectionPopupMenu(jTable1, e.getX()).show(component, e.getX(), e.getY());
        }
    }

    private JPopupMenu getMyTableColumnSelectionPopupMenu(final JTable jTable1, final int mouseXLocation) {
        JPopupMenu popup = new JPopupMenu();
        TableModel tableModel = jTable1.getModel();
        int col = tableModel.getColumnCount();
        for (int i = this.menuStartIndex; i < col; ++i) {
            String name = tableModel.getColumnName(i);
            if (this.columnNamesToBeIgnored.contains(name)) continue;
            boolean isVisible = true;
            try {
                TableColumn tableColumn = jTable1.getColumn(name);
            }
            catch (IllegalArgumentException exp) {
                isVisible = false;
            }
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(name, isVisible);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = evt.getActionCommand();
                    JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)evt.getSource();
                    if (!menuItem.isSelected()) {
                        JTableUtilities.removeTableColumn(jTable1, name);
                    } else {
                        TableColumnModel colModel = jTable1.getColumnModel();
                        int vColIndex = colModel.getColumnIndexAtX(mouseXLocation);
                        JTableUtilities.insertTableColumnFromModel(jTable1, name, vColIndex);
                    }
                }
            });
            popup.add(menuItem);
        }
        return popup;
    }
}

