/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import com.google.gdata.client.DocumentQuery;
import com.google.gdata.client.GoogleService;
import com.google.gdata.client.docs.DocsService;
import com.google.gdata.client.media.MediaService;
import com.google.gdata.client.media.ResumableGDataFileUploader;
import com.google.gdata.client.uploader.FileUploadData;
import com.google.gdata.client.uploader.ProgressListener;
import com.google.gdata.client.uploader.ResumableHttpFileUploader;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.Link;
import com.google.gdata.data.MediaContent;
import com.google.gdata.data.PlainTextConstruct;
import com.google.gdata.data.docs.DocumentListEntry;
import com.google.gdata.data.docs.DocumentListFeed;
import com.google.gdata.data.media.IMediaContent;
import com.google.gdata.data.media.MediaFileSource;
import com.google.gdata.data.media.MediaSource;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ServiceException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.thoughtworks.xstream.XStream;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.accessibility.Accessible;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.HyperlinkEvent;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.basic.BasicComboPopup;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.EmailValidator;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.swingx.util.OS;
import org.yccheok.jstock.analysis.Connection;
import org.yccheok.jstock.analysis.DoubleConstantOperator;
import org.yccheok.jstock.analysis.EqualityOperator;
import org.yccheok.jstock.analysis.Indicator;
import org.yccheok.jstock.analysis.OperatorIndicator;
import org.yccheok.jstock.analysis.SinkOperator;
import org.yccheok.jstock.analysis.StockOperator;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.file.Statement;
import org.yccheok.jstock.gui.AppLock;
import org.yccheok.jstock.gui.AutoCompleteJComboBox;
import org.yccheok.jstock.gui.CaptchaInputJDialog;
import org.yccheok.jstock.gui.JComboBoxLayerUI;
import org.yccheok.jstock.gui.JComboBoxPopupAdjustable;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.MainFrame;
import org.yccheok.jstock.gui.file.PortfolioSelectionJPanel;
import org.yccheok.jstock.internationalization.MessagesBundle;
import org.yccheok.jstock.network.Utils;

public class Utils {
    private static final ThreadLocal<DateFormat> commonDateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            DateFormat dateFormat = DateFormat.getDateInstance(2, Locale.ENGLISH);
            return dateFormat;
        }
    };
    private static final ThreadLocal<DateFormat> todayLastUpdateTimeFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("h:mm a");
        }
    };
    private static final ThreadLocal<DateFormat> otherDayLastUpdateTimeFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return DateFormat.getDateInstance(3);
        }
    };
    private static final HanyuPinyinOutputFormat DEFAULT_HANYU_PINYIN_OUTPUT_FORMAT = new HanyuPinyinOutputFormat();
    private static volatile List<String> NTPServers;
    private static final String APPLICATION_VERSION_STRING = "1.0.7";
    private static final String ABOUT_BOX_VERSION_STRING = "1.0.7j";
    private static final int CLOUD_FILE_VERSION_ID = 1107;
    private static final int APPLICATION_VERSION_ID = 1113;
    private static Executor zombiePool;
    private static final int NUM_OF_THREADS_ZOMBIE_POOL = 4;
    private static final HttpClient httpClient;
    private static final HttpClient httpClientWithAgentInfo;
    private static final int TEMP_DIR_ATTEMPTS = 10000;
    private static final Pattern googleDocTitlePattern;
    private static final Log log;

    private Utils() {
    }

    public static boolean hasSpecifiedLanguageFile(Locale locale) {
        if (Utils.isTraditionalChinese(locale)) {
            return true;
        }
        if (Utils.isSimplifiedChinese(locale)) {
            return true;
        }
        if (locale.getLanguage().equals(Locale.GERMAN.getLanguage())) {
            return true;
        }
        if (locale.getLanguage().equals(Locale.ENGLISH.getLanguage())) {
            return true;
        }
        if (locale.getLanguage().equals(Locale.ITALIAN.getLanguage())) {
            return true;
        }
        return locale.getLanguage().equals(Locale.FRENCH.getLanguage());
    }

    public static void adjustPopupWidth(JComboBox comboBox) {
        if (comboBox.getItemCount() == 0) {
            return;
        }
        Accessible comp = comboBox.getAccessibleContext().getAccessibleChild(0);
        if (!(comp instanceof BasicComboPopup)) {
            return;
        }
        BasicComboPopup popup = (BasicComboPopup)comp;
        JList<Object> list = popup.getList();
        JScrollPane scrollPane = Utils.getScrollPane(popup);
        if (list == null || scrollPane == null) {
            return;
        }
        int popupWidth = list.getPreferredSize().width + 5 + Utils.getScrollBarWidth(comboBox, scrollPane);
        Dimension scrollPaneSize = scrollPane.getPreferredSize();
        scrollPaneSize.width = popupWidth = Math.max(popupWidth, comboBox.getSize().width);
        scrollPane.setPreferredSize(scrollPaneSize);
        scrollPane.setMaximumSize(scrollPaneSize);
        if (comboBox instanceof JComboBoxPopupAdjustable) {
            ((JComboBoxPopupAdjustable)((Object)comboBox)).setPopupWidth(popupWidth);
        }
    }

    private static int getScrollBarWidth(JComboBox comboBox, JScrollPane scrollPane) {
        int scrollBarWidth = 0;
        if (comboBox.getItemCount() > comboBox.getMaximumRowCount()) {
            JScrollBar vertical = scrollPane.getVerticalScrollBar();
            scrollBarWidth = vertical.getPreferredSize().width;
        }
        return scrollBarWidth;
    }

    private static JScrollPane getScrollPane(BasicComboPopup popup) {
        JList<Object> list = popup.getList();
        Container c = SwingUtilities.getAncestorOfClass(JScrollPane.class, list);
        return (JScrollPane)c;
    }

    public static boolean restartApplication(MainFrame mainFrame) {
        File jarFile;
        String javaBin = System.getProperty("java.home") + "/bin/javaw";
        try {
            jarFile = new File(mainFrame.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (Exception e) {
            log.error(null, (Throwable)e);
            return false;
        }
        if (!jarFile.getName().endsWith(".jar") && !jarFile.getName().endsWith(".exe")) {
            return false;
        }
        String[] toExec = null;
        toExec = jarFile.getName().endsWith(".exe") ? new String[]{jarFile.getPath()} : new String[]{javaBin, "-jar", jarFile.getPath()};
        mainFrame.save();
        AppLock.unlock();
        try {
            Process p = Runtime.getRuntime().exec(toExec);
        }
        catch (Exception e) {
            log.error(null, (Throwable)e);
            return false;
        }
        mainFrame.setVisible(false);
        mainFrame.dispose();
        System.exit(0);
        return true;
    }

    public static long getGoogleServerTimestamp() {
        String _time = Utils.getUUIDValue(org.yccheok.jstock.network.Utils.getURL(Utils.Type.GET_TIME), "time");
        if (_time == null) {
            return 0L;
        }
        try {
            long time = Long.parseLong(_time);
            return time;
        }
        catch (NumberFormatException exp) {
            log.error(null, (Throwable)exp);
            return 0L;
        }
    }

    public static String toEndWithFileSeperator(String string) {
        if (string.endsWith(File.separator)) {
            return string;
        }
        return string + File.separator;
    }

    public static boolean extractZipFile(String zipFilePath, boolean overwrite) {
        return Utils.extractZipFile(new File(zipFilePath), overwrite);
    }

    public static boolean extractZipFile(File zipFilePath, boolean overwrite) {
        return Utils.extractZipFile(zipFilePath, Utils.getUserDataDirectory(), overwrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean extractZipFile(File zipFilePath, String destDirectory, boolean overwrite) {
        assert (destDirectory.endsWith(File.separator));
        FileInputStream inputStream = null;
        ZipInputStream zipInputStream = null;
        boolean status = true;
        try {
            inputStream = new FileInputStream(zipFilePath);
            zipInputStream = new ZipInputStream(inputStream);
            byte[] data = new byte[1024];
            while (true) {
                ZipEntry zipEntry = null;
                FileOutputStream outputStream = null;
                try {
                    zipEntry = zipInputStream.getNextEntry();
                    if (zipEntry == null) break;
                    String destination = destDirectory + zipEntry.getName();
                    if (!overwrite && Utils.isFileOrDirectoryExist(destination)) continue;
                    if (zipEntry.isDirectory()) {
                        Utils.createCompleteDirectoryHierarchyIfDoesNotExist(destination);
                        continue;
                    }
                    File file = new File(destination);
                    Utils.createCompleteDirectoryHierarchyIfDoesNotExist(file.getParentFile());
                    int size = zipInputStream.read(data);
                    if (size <= 0) continue;
                    outputStream = new FileOutputStream(destination);
                    do {
                        outputStream.write(data, 0, size);
                    } while ((size = zipInputStream.read(data)) >= 0);
                    continue;
                }
                catch (IOException exp) {
                    log.error(null, (Throwable)exp);
                    status = false;
                }
                finally {
                    Utils.close(outputStream);
                    Utils.closeEntry(zipInputStream);
                    continue;
                }
                break;
            }
        }
        catch (IOException exp) {
            try {
                log.error(null, (Throwable)exp);
                status = false;
            }
            catch (Throwable throwable) {
                Utils.close(zipInputStream);
                Utils.close(inputStream);
                throw throwable;
            }
            Utils.close(zipInputStream);
            Utils.close(inputStream);
        }
        Utils.close(zipInputStream);
        Utils.close(inputStream);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUUIDValue(String url, String key) {
        InputStreamAndMethod inputStreamAndMethod = Utils.getResponseBodyAsStreamBasedOnProxyAuthOption(url);
        if (inputStreamAndMethod.inputStream == null) {
            inputStreamAndMethod.method.releaseConnection();
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStreamAndMethod.inputStream);
        }
        catch (IOException exp) {
            log.error(null, (Throwable)exp);
            String string = null;
            return string;
        }
        catch (IllegalArgumentException exp) {
            log.error(null, (Throwable)exp);
            String string = null;
            return string;
        }
        finally {
            Utils.close(inputStreamAndMethod.inputStream);
            inputStreamAndMethod.method.releaseConnection();
        }
        String _id = properties.getProperty("id");
        if (_id == null) {
            log.info((Object)"UUID not found");
            return null;
        }
        String id = Utils.decrypt(_id);
        if (!id.equals(Utils.getJStockUUID())) {
            log.info((Object)"UUID doesn't match");
            return null;
        }
        String value = properties.getProperty(key);
        if (value == null) {
            log.info((Object)"Value not found");
            return null;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getUUIDValue(String url) {
        HashMap<String, String> map = new HashMap<String, String>();
        InputStreamAndMethod inputStreamAndMethod = Utils.getResponseBodyAsStreamBasedOnProxyAuthOption(url);
        if (inputStreamAndMethod.inputStream == null) {
            inputStreamAndMethod.method.releaseConnection();
            return Collections.emptyMap();
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStreamAndMethod.inputStream);
        }
        catch (IOException exp) {
            log.error(null, (Throwable)exp);
            Map<String, String> map2 = Collections.emptyMap();
            return map2;
        }
        catch (IllegalArgumentException exp) {
            log.error(null, (Throwable)exp);
            Map<String, String> map3 = Collections.emptyMap();
            return map3;
        }
        finally {
            Utils.close(inputStreamAndMethod.inputStream);
            inputStreamAndMethod.method.releaseConnection();
        }
        String _id = properties.getProperty("id");
        if (_id == null) {
            log.info((Object)"UUID not found");
            return Collections.emptyMap();
        }
        String id = Utils.decrypt(_id);
        if (!id.equals(Utils.getJStockUUID())) {
            log.info((Object)"UUID doesn't match");
            return Collections.emptyMap();
        }
        for (Object key : properties.keySet()) {
            if (key == null || key.equals("id")) continue;
            map.put(key.toString(), properties.getProperty(key.toString()));
        }
        return map;
    }

    public static ZipEntry getZipEntry(String zipEntryName) {
        return new ZipEntry(zipEntryName.replace(File.separator, "/"));
    }

    private static List<String> getNTPServers() {
        String[] s;
        List<String> defaultServer = Collections.unmodifiableList(Arrays.asList("time-a.nist.gov", "time-b.nist.gov", "time-nw.nist.gov"));
        List<String> servers = NTPServers;
        if (servers != null) {
            return servers;
        }
        String server = Utils.getUUIDValue(org.yccheok.jstock.network.Utils.getURL(Utils.Type.NTP_SERVER_TXT), "server");
        if (server != null && (s = server.split(",")).length > 0) {
            List<String> me = Collections.unmodifiableList(Arrays.asList(s));
            NTPServers = me;
            return me;
        }
        NTPServers = defaultServer;
        return defaultServer;
    }

    public static void launchWebBrowser(String address) {
        Desktop desktop;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            URL url = null;
            String string = address;
            try {
                url = new URL(string);
            }
            catch (MalformedURLException ex) {
                return;
            }
            try {
                desktop.browse(url.toURI());
            }
            catch (URISyntaxException ex) {
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
    }

    public static void launchWebBrowser(HyperlinkEvent evt) {
        if (HyperlinkEvent.EventType.ACTIVATED.equals(evt.getEventType())) {
            Desktop desktop;
            URL url = evt.getURL();
            if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                if (url == null) {
                    String string = "http://" + evt.getDescription();
                    try {
                        url = new URL(string);
                    }
                    catch (MalformedURLException ex) {
                        return;
                    }
                }
                try {
                    desktop.browse(url.toURI());
                }
                catch (URISyntaxException ex) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static Image getScaledImage(Image image, int maxWidth, int maxHeight) {
        image = new ImageIcon(image).getImage();
        int imgWidth = image.getWidth(null);
        int imgHeight = image.getHeight(null);
        int preferredWidth = Math.min(imgWidth, maxWidth);
        int preferredHeight = Math.min(imgHeight, maxHeight);
        double scaleX = (double)preferredWidth / (double)imgWidth;
        double scaleY = (double)preferredHeight / (double)imgHeight;
        double bestScale = Math.min(scaleX, scaleY);
        return image.getScaledInstance((int)((double)imgWidth * bestScale), (int)((double)imgHeight * bestScale), 4);
    }

    private static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = Utils.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException e) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static File createTempDir() {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        String baseName = System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 10000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + 9999 + ')');
    }

    public static boolean deleteDir(File dir, boolean deleteRoot) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = Utils.deleteDir(new File(dir, children[i]), true);
                if (success) continue;
                return false;
            }
        }
        if (deleteRoot) {
            return dir.delete();
        }
        return true;
    }

    public static boolean deleteDir(String dir, boolean deleteRoot) {
        return Utils.deleteDir(new File(dir), deleteRoot);
    }

    public static boolean createCompleteDirectoryHierarchyIfDoesNotExist(String directory) {
        return Utils.createCompleteDirectoryHierarchyIfDoesNotExist(new File(directory));
    }

    private static boolean createCompleteDirectoryHierarchyIfDoesNotExist(File f) {
        if (f == null) {
            return true;
        }
        if (!Utils.createCompleteDirectoryHierarchyIfDoesNotExist(f.getParentFile())) {
            return false;
        }
        String path = f.getAbsolutePath();
        return Utils.createDirectoryIfDoesNotExist(path);
    }

    private static boolean createDirectoryIfDoesNotExist(String directory) {
        File f = new File(directory);
        if (!f.exists()) {
            return f.mkdir();
        }
        return true;
    }

    public static boolean isFileOrDirectoryExist(String fileOrDirectory) {
        File f = new File(fileOrDirectory);
        return f.exists();
    }

    public static String getUserDataDirectory() {
        return System.getProperty("user.home") + File.separator + ".jstock" + File.separator + Utils.getApplicationVersionString() + File.separator;
    }

    public static String getHistoryDirectory() {
        return Utils.getHistoryDirectory(MainFrame.getInstance().getJStockOptions().getCountry());
    }

    public static String getHistoryDirectory(Country country) {
        return Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "history";
    }

    public static AlphaComposite makeComposite(float alpha) {
        int type = 3;
        return AlphaComposite.getInstance(type, alpha);
    }

    public static Color getColor(double price, double referencePrice) {
        boolean reverse = org.yccheok.jstock.engine.Utils.isFallBelowAndRiseAboveColorReverse();
        if (price < referencePrice) {
            if (reverse) {
                return JStockOptions.DEFAULT_HIGHER_NUMERICAL_VALUE_FOREGROUND_COLOR;
            }
            return JStockOptions.DEFAULT_LOWER_NUMERICAL_VALUE_FOREGROUND_COLOR;
        }
        if (price > referencePrice) {
            if (reverse) {
                return JStockOptions.DEFAULT_LOWER_NUMERICAL_VALUE_FOREGROUND_COLOR;
            }
            return JStockOptions.DEFAULT_HIGHER_NUMERICAL_VALUE_FOREGROUND_COLOR;
        }
        return JStockOptions.DEFAULT_NORMAL_TEXT_FOREGROUND_COLOR;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = Utils.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static Stock getEmptyStock(StockInfo stockInfo) {
        return Utils.getEmptyStock(stockInfo.code, stockInfo.symbol);
    }

    public static Stock getEmptyStock(Code code, Symbol symbol) {
        return new Stock(code, symbol, "", Stock.Board.Unknown, Stock.Industry.Unknown, 0.0, 0.0, 0.0, 0.0, 0.0, 0L, 0.0, 0.0, 0, 0.0, 0, 0.0, 0, 0.0, 0, 0.0, 0, 0.0, 0, 0.0, 0, System.currentTimeMillis());
    }

    public static void deleteAllOldFiles(File dir, int days) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                Utils.deleteAllOldFiles(new File(dir, children[i]), days);
            }
            if (dir.list().length == 0) {
                dir.delete();
            }
        } else {
            long today = System.currentTimeMillis();
            long timeStamp = dir.lastModified();
            long difMil = today - timeStamp;
            long milPerDay = 86400000L;
            long d = difMil / 86400000L;
            if (d >= (long)days) {
                dir.delete();
            }
        }
    }

    public static String getAboutBoxVersionString() {
        return ABOUT_BOX_VERSION_STRING;
    }

    public static String getApplicationVersionString() {
        return APPLICATION_VERSION_STRING;
    }

    public static String encrypt(String source) {
        if (source.length() <= 0) {
            return "";
        }
        StandardPBEStringEncryptor pbeStringEncryptor = new StandardPBEStringEncryptor();
        pbeStringEncryptor.setPassword(Utils.getJStockUUID());
        return pbeStringEncryptor.encrypt(source);
    }

    public static String decrypt(String source) {
        if (source.length() <= 0) {
            return "";
        }
        StandardPBEStringEncryptor pbeStringEncryptor = new StandardPBEStringEncryptor();
        pbeStringEncryptor.setPassword(Utils.getJStockUUID());
        try {
            return pbeStringEncryptor.decrypt(source);
        }
        catch (EncryptionOperationNotPossibleException exp) {
            log.error(null, (Throwable)exp);
            return "";
        }
    }

    public static String getJStockUUID() {
        return "fe78440e-e0fe-4efb-881d-264a01be483c";
    }

    private static String getCloudApplicationName() {
        return "JStock-1107";
    }

    private static String getGoogleDocTitle(long checksum, long date, int version) {
        return "jstock-" + Utils.getJStockUUID() + "-checksum=" + checksum + "-date=" + date + "-version=" + version + ".zip";
    }

    public static boolean isSimplifiedChinese(Locale locale) {
        return locale.getLanguage().equals(Locale.SIMPLIFIED_CHINESE.getLanguage()) && !locale.getCountry().equals(Locale.TRADITIONAL_CHINESE.getCountry());
    }

    public static boolean isTraditionalChinese(Locale locale) {
        return locale.getLanguage().equals(Locale.TRADITIONAL_CHINESE.getLanguage()) && locale.getCountry().equals(Locale.TRADITIONAL_CHINESE.getCountry());
    }

    public static boolean isMacOSX() {
        return OS.isMacOSX();
    }

    public static boolean isWindows7() {
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        return "Windows 7".equals(osName) && "6.1".equals(osVersion);
    }

    public static boolean isWindows8() {
        String osVersion = System.getProperty("os.version");
        return "6.2".equals(osVersion);
    }

    public static boolean isWindows() {
        String windowsString = "Windows";
        String osName = System.getProperty("os.name");
        if (osName == null) {
            return false;
        }
        return osName.regionMatches(true, 0, windowsString, 0, windowsString.length());
    }

    public static Executor getZoombiePool() {
        return zombiePool;
    }

    public static Indicator getLastPriceRiseAboveIndicator(double lastPrice) {
        StockOperator stockOperator = new StockOperator();
        stockOperator.setType(StockOperator.Type.LastPrice);
        DoubleConstantOperator doubleConstantOperator = new DoubleConstantOperator();
        doubleConstantOperator.setConstant(lastPrice);
        EqualityOperator equalityOperator = new EqualityOperator();
        equalityOperator.setEquality(EqualityOperator.Equality.GreaterOrEqual);
        SinkOperator sinkOperator = new SinkOperator();
        Connection stockToEqualityConnection = new Connection();
        Connection doubleConstantToEqualityConnection = new Connection();
        Connection equalityToSinkConnection = new Connection();
        stockOperator.addOutputConnection(stockToEqualityConnection, 0);
        equalityOperator.addInputConnection(stockToEqualityConnection, 0);
        doubleConstantOperator.addOutputConnection(doubleConstantToEqualityConnection, 0);
        equalityOperator.addInputConnection(doubleConstantToEqualityConnection, 1);
        equalityOperator.addOutputConnection(equalityToSinkConnection, 0);
        sinkOperator.addInputConnection(equalityToSinkConnection, 0);
        OperatorIndicator operatorIndicator = new OperatorIndicator();
        operatorIndicator.setName("RiseAbove");
        operatorIndicator.add(stockOperator);
        operatorIndicator.add(doubleConstantOperator);
        operatorIndicator.add(equalityOperator);
        operatorIndicator.add(sinkOperator);
        assert (operatorIndicator.getType() == OperatorIndicator.Type.AlertIndicator);
        operatorIndicator.preCalculate();
        return operatorIndicator;
    }

    public static Indicator getLastPriceFallBelowIndicator(double lastPrice) {
        StockOperator stockOperator = new StockOperator();
        stockOperator.setType(StockOperator.Type.LastPrice);
        DoubleConstantOperator doubleConstantOperator = new DoubleConstantOperator();
        doubleConstantOperator.setConstant(lastPrice);
        EqualityOperator equalityOperator = new EqualityOperator();
        equalityOperator.setEquality(EqualityOperator.Equality.LesserOrEqual);
        SinkOperator sinkOperator = new SinkOperator();
        Connection stockToEqualityConnection = new Connection();
        Connection doubleConstantToEqualityConnection = new Connection();
        Connection equalityToSinkConnection = new Connection();
        stockOperator.addOutputConnection(stockToEqualityConnection, 0);
        equalityOperator.addInputConnection(stockToEqualityConnection, 0);
        doubleConstantOperator.addOutputConnection(doubleConstantToEqualityConnection, 0);
        equalityOperator.addInputConnection(doubleConstantToEqualityConnection, 1);
        equalityOperator.addOutputConnection(equalityToSinkConnection, 0);
        sinkOperator.addInputConnection(equalityToSinkConnection, 0);
        OperatorIndicator operatorIndicator = new OperatorIndicator();
        operatorIndicator.setName("FallBelow");
        operatorIndicator.add(stockOperator);
        operatorIndicator.add(doubleConstantOperator);
        operatorIndicator.add(equalityOperator);
        operatorIndicator.add(sinkOperator);
        assert (operatorIndicator.getType() == OperatorIndicator.Type.AlertIndicator);
        operatorIndicator.preCalculate();
        return operatorIndicator;
    }

    public static void setDefaultLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException exp) {
            log.error(null, (Throwable)exp);
        }
        catch (InstantiationException exp) {
            log.error(null, (Throwable)exp);
        }
        catch (IllegalAccessException exp) {
            log.error(null, (Throwable)exp);
        }
        catch (UnsupportedLookAndFeelException exp) {
            log.error(null, (Throwable)exp);
        }
    }

    public static CloudFile loadFromGoogleDoc(String username, String password) {
        CaptchaRespond captchaRespond = null;
        DocsService client = new DocsService(Utils.getCloudApplicationName());
        while (true) {
            try {
                if (captchaRespond == null) {
                    client.setUserCredentials(username, password);
                    break;
                }
                client.setUserCredentials(username, password, captchaRespond.logintoken, captchaRespond.logincaptcha);
            }
            catch (GoogleService.CaptchaRequiredException ex) {
                log.error(null, (Throwable)ex);
                if ((captchaRespond = Utils.getCapchaRespond(ex)) != null) continue;
                return null;
            }
            catch (AuthenticationException ex) {
                log.error(null, (Throwable)ex);
                return null;
            }
            break;
        }
        try {
            URL feedUri = new URL("https://docs.google.com/feeds/default/private/full/");
            DocumentQuery query = new DocumentQuery(feedUri);
            DocumentListFeed allEntries = new DocumentListFeed();
            DocumentListFeed tempFeed = (DocumentListFeed)((Object)client.getFeed(query, DocumentListFeed.class));
            while (true) {
                allEntries.getEntries().addAll(tempFeed.getEntries());
                Link nextLink = tempFeed.getNextLink();
                if (nextLink == null || tempFeed.getEntries().isEmpty()) break;
                tempFeed = (DocumentListFeed)((Object)client.getFeed(new URL(nextLink.getHref()), DocumentListFeed.class));
            }
            DocumentListEntry documentListEntry = null;
            long checksum = 0L;
            long date = 0L;
            int version = 0;
            for (DocumentListEntry entry : allEntries.getEntries()) {
                String title = entry.getTitle().getPlainText();
                if (title == null) continue;
                Matcher matcher = googleDocTitlePattern.matcher(title);
                String _checksum = null;
                String _date = null;
                String _version = null;
                if (matcher.find() && matcher.groupCount() == 3) {
                    _checksum = matcher.group(1);
                    _date = matcher.group(2);
                    _version = matcher.group(3);
                }
                if (_checksum == null || _date == null || _version == null) continue;
                try {
                    checksum = Long.parseLong(_checksum);
                    date = Long.parseLong(_date);
                    version = Integer.parseInt(_version);
                }
                catch (NumberFormatException ex) {
                    log.error(null, (Throwable)ex);
                    continue;
                }
                documentListEntry = entry;
                File temp = File.createTempFile(Utils.getJStockUUID(), ".zip");
                temp.deleteOnExit();
                Utils.downloadFile(client, documentListEntry, temp);
                return CloudFile.newInstance(temp, checksum, date, version);
            }
        }
        catch (IOException ex) {
            log.error(null, (Throwable)ex);
            return null;
        }
        catch (ServiceException ex) {
            log.error(null, (Throwable)ex);
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadFile(DocsService client, DocumentListEntry entry, File file) throws IOException, MalformedURLException, ServiceException {
        MediaContent mc = (MediaContent)entry.getContent();
        MediaSource ms = client.getMedia((IMediaContent)mc);
        InputStream inStream = null;
        FileOutputStream outStream = null;
        try {
            int c;
            inStream = ms.getInputStream();
            outStream = new FileOutputStream(file);
            while ((c = inStream.read()) != -1) {
                outStream.write(c);
            }
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
            if (outStream != null) {
                outStream.flush();
                outStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloudFile loadFromCloud(String username, String password) {
        CaptchaRespond captchaRespond = null;
        while (true) {
            CloudFile cloudFile;
            CloudFile cloudFile2;
            String url = "https://jstock-cloud.appspot.com/DownloadServlet";
            PostMethod post = new PostMethod("https://jstock-cloud.appspot.com/DownloadServlet");
            InputStream inputStream = null;
            FileOutputStream outputStream = null;
            try {
                int len;
                String respond;
                org.yccheok.jstock.engine.Utils.setHttpClientProxyFromSystemProperties(httpClient);
                Utils.setHttpClientProxyCredentialsFromJStockOptions(httpClient);
                NameValuePair[] data = null;
                data = captchaRespond == null ? new NameValuePair[]{new NameValuePair("Email", username), new NameValuePair("Passwd", password)} : new NameValuePair[]{new NameValuePair("Email", username), new NameValuePair("Passwd", password), new NameValuePair("logintoken", captchaRespond.logintoken), new NameValuePair("logincaptcha", captchaRespond.logincaptcha)};
                post.setRequestBody(data);
                httpClient.executeMethod((HttpMethod)post);
                Header header = post.getResponseHeader("Content-Type");
                if (header == null || header.getValue() == null) {
                    CloudFile cloudFile3 = null;
                    return cloudFile3;
                }
                if (header.getValue().contains("text/plain")) {
                    respond = post.getResponseBodyAsString();
                    if (respond == null) {
                        CloudFile cloudFile4 = null;
                        return cloudFile4;
                    }
                    captchaRespond = Utils.getCapchaRespond(respond);
                    if (captchaRespond != null) continue;
                    CloudFile cloudFile5 = null;
                    return cloudFile5;
                }
                if (!header.getValue().equalsIgnoreCase("application/octet-stream")) {
                    respond = null;
                    return respond;
                }
                String _checksum = post.getResponseHeader("jstock-custom-checksum").getValue();
                String _date = post.getResponseHeader("jstock-custom-date").getValue();
                String _version = post.getResponseHeader("jstock-custom-version").getValue();
                if (_checksum == null || _date == null || _version == null) {
                    CloudFile cloudFile6 = null;
                    return cloudFile6;
                }
                long checksum = Long.parseLong(_checksum);
                long date = Long.parseLong(_date);
                int version = Integer.parseInt(_version);
                inputStream = post.getResponseBodyAsStream();
                File temp = File.createTempFile(Utils.getJStockUUID(), ".zip");
                temp.deleteOnExit();
                outputStream = new FileOutputStream(temp);
                byte[] buf = new byte[1024];
                while ((len = inputStream.read(buf)) > 0) {
                    ((OutputStream)outputStream).write(buf, 0, len);
                }
                cloudFile2 = CloudFile.newInstance(temp, checksum, date, version);
                Utils.close(outputStream);
            }
            catch (FileNotFoundException ex) {
                log.error(null, (Throwable)ex);
                cloudFile = null;
                return cloudFile;
            }
            catch (IOException ex) {
                log.error(null, (Throwable)ex);
                cloudFile = null;
                return cloudFile;
            }
            catch (NumberFormatException ex) {
                log.error(null, (Throwable)ex);
                cloudFile = null;
                return cloudFile;
            }
            finally {
                Utils.close(outputStream);
                Utils.close(inputStream);
                post.releaseConnection();
                continue;
            }
            Utils.close(inputStream);
            post.releaseConnection();
            return cloudFile2;
            break;
        }
    }

    private static CaptchaRespond getCapchaRespond(GoogleService.CaptchaRequiredException captchaRequiredException) {
        String CaptchaToken = captchaRequiredException.getCaptchaToken();
        String CaptchaUrl = captchaRequiredException.getCaptchaUrl();
        try {
            URL url = new URL("https://www.google.com/accounts/" + CaptchaUrl);
            BufferedImage image = ImageIO.read(url);
            CaptchaInputJDialog dialog = new CaptchaInputJDialog((Frame)MainFrame.getInstance(), image, true);
            dialog.setLocationRelativeTo(MainFrame.getInstance());
            dialog.setVisible(true);
            if (dialog.getCaptcha() == null || dialog.getCaptcha().length() <= 0) {
                return null;
            }
            return new CaptchaRespond(CaptchaToken, dialog.getCaptcha());
        }
        catch (Exception exp) {
            log.error(null, (Throwable)exp);
            return null;
        }
    }

    private static CaptchaRespond getCapchaRespond(String respond) {
        assert (respond != null);
        String[] res = respond.split("\\r?\\n");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String r : res) {
            String[] v = r.split("=", 2);
            if (v.length != 2) continue;
            v[0] = v[0].trim();
            v[1] = v[1].trim();
            if (v[0].length() == 0 || v[1].length() == 0) continue;
            map.put(v[0], v[1]);
        }
        if (map.containsKey("CaptchaToken") && map.containsKey("CaptchaUrl")) {
            String CaptchaToken = (String)map.get("CaptchaToken");
            String CaptchaUrl = (String)map.get("CaptchaUrl");
            try {
                URL url = new URL("https://www.google.com/accounts/" + CaptchaUrl);
                BufferedImage image = ImageIO.read(url);
                CaptchaInputJDialog dialog = new CaptchaInputJDialog((Frame)MainFrame.getInstance(), image, true);
                dialog.setLocationRelativeTo(MainFrame.getInstance());
                dialog.setVisible(true);
                if (dialog.getCaptcha() == null || dialog.getCaptcha().length() <= 0) {
                    return null;
                }
                return new CaptchaRespond(CaptchaToken, dialog.getCaptcha());
            }
            catch (Exception exp) {
                log.error(null, (Throwable)exp);
                return null;
            }
        }
        return null;
    }

    public static boolean saveToGoogleDoc(String username, String password, File file) {
        CaptchaRespond captchaRespond = null;
        DocsService client = new DocsService(Utils.getCloudApplicationName());
        while (true) {
            try {
                if (captchaRespond == null) {
                    client.setUserCredentials(username, password);
                    break;
                }
                client.setUserCredentials(username, password, captchaRespond.logintoken, captchaRespond.logincaptcha);
            }
            catch (GoogleService.CaptchaRequiredException ex) {
                log.error(null, (Throwable)ex);
                if ((captchaRespond = Utils.getCapchaRespond(ex)) != null) continue;
                return false;
            }
            catch (AuthenticationException ex) {
                log.error(null, (Throwable)ex);
                return false;
            }
            break;
        }
        try {
            URL feedUri = new URL("https://docs.google.com/feeds/default/private/full/");
            DocumentQuery query = new DocumentQuery(feedUri);
            DocumentListFeed allEntries = new DocumentListFeed();
            DocumentListFeed tempFeed = (DocumentListFeed)((Object)client.getFeed(query, DocumentListFeed.class));
            while (true) {
                allEntries.getEntries().addAll(tempFeed.getEntries());
                Link nextLink = tempFeed.getNextLink();
                if (nextLink == null || tempFeed.getEntries().isEmpty()) break;
                tempFeed = (DocumentListFeed)((Object)client.getFeed(new URL(nextLink.getHref()), DocumentListFeed.class));
            }
            DocumentListEntry documentListEntry = null;
            for (DocumentListEntry entry : allEntries.getEntries()) {
                String filename = entry.getFilename();
                if (filename == null) continue;
                Matcher matcher = googleDocTitlePattern.matcher(filename);
                String _checksum = null;
                String _date = null;
                String _version = null;
                if (matcher.find() && matcher.groupCount() == 3) {
                    _checksum = matcher.group(1);
                    _date = matcher.group(2);
                    _version = matcher.group(3);
                }
                if (_checksum == null || _date == null || _version == null) continue;
                try {
                    Long.parseLong(_checksum);
                    Long.parseLong(_date);
                    Integer.parseInt(_version);
                }
                catch (NumberFormatException ex) {
                    log.error(null, (Throwable)ex);
                    continue;
                }
                documentListEntry = entry;
                break;
            }
            long checksum = org.yccheok.jstock.analysis.Utils.getChecksum(file);
            long date = new Date().getTime();
            int version = Utils.getCloudFileVersionID();
            int MAX_CONCURRENT_UPLOADS = 10;
            int PROGRESS_UPDATE_INTERVAL = 1000;
            int DEFAULT_CHUNK_SIZE = 0xA00000;
            FileUploadProgressListener listener = new FileUploadProgressListener();
            ExecutorService executor = Executors.newFixedThreadPool(10);
            String contentType = DocumentListEntry.MediaType.fromFileName(file.getName()).getMimeType();
            MediaFileSource mediaFile = new MediaFileSource(file, contentType);
            URL createUploadUrl = new URL("https://docs.google.com/feeds/upload/create-session/default/private/full?convert=false");
            ResumableGDataFileUploader uploader = null;
            if (documentListEntry == null) {
                uploader = new ResumableGDataFileUploader.Builder((MediaService)client, createUploadUrl, mediaFile, null).title(Utils.getGoogleDocTitle(checksum, date, version)).chunkSize(0xA00000L).executor(executor).trackProgress((ProgressListener)listener, 1000L).build();
            } else {
                documentListEntry.setTitle(new PlainTextConstruct(Utils.getGoogleDocTitle(checksum, date, version)));
                uploader = new ResumableGDataFileUploader.Builder((MediaService)client, createUploadUrl, mediaFile, (IEntry)((Object)documentListEntry)).title(Utils.getGoogleDocTitle(checksum, date, version)).chunkSize(0xA00000L).executor(executor).trackProgress((ProgressListener)listener, 1000L).requestType(ResumableGDataFileUploader.RequestType.UPDATE).build();
            }
            uploader.start();
            listener.await();
            executor.shutdownNow();
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (MalformedURLException ex) {
            log.error(null, (Throwable)ex);
            return false;
        }
        catch (IOException ex) {
            log.error(null, (Throwable)ex);
            return false;
        }
        catch (ServiceException ex) {
            log.error(null, (Throwable)ex);
            return false;
        }
        catch (InterruptedException ex) {
            log.error(null, (Throwable)ex);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveToCloud(String username, String password, File file) {
        CaptchaRespond captchaRespond = null;
        while (true) {
            String url = "https://jstock-cloud.appspot.com/UploadServlet";
            PostMethod post = new PostMethod("https://jstock-cloud.appspot.com/UploadServlet");
            try {
                org.yccheok.jstock.engine.Utils.setHttpClientProxyFromSystemProperties(httpClient);
                Utils.setHttpClientProxyCredentialsFromJStockOptions(httpClient);
                Part[] parts = null;
                parts = captchaRespond == null ? new Part[]{new StringPart("Email", username), new StringPart("Passwd", password), new StringPart("Date", new Date().getTime() + ""), new StringPart("Checksum", org.yccheok.jstock.analysis.Utils.getChecksum(file) + ""), new StringPart("Version", Utils.getCloudFileVersionID() + ""), new FilePart("file", file)} : new Part[]{new StringPart("Email", username), new StringPart("Passwd", password), new StringPart("Date", new Date().getTime() + ""), new StringPart("Checksum", org.yccheok.jstock.analysis.Utils.getChecksum(file) + ""), new StringPart("Version", Utils.getCloudFileVersionID() + ""), new StringPart("logintoken", captchaRespond.logintoken), new StringPart("logincaptcha", captchaRespond.logincaptcha), new FilePart("file", file)};
                post.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, post.getParams()));
                httpClient.executeMethod((HttpMethod)post);
                String respond = post.getResponseBodyAsString();
                if (respond == null) {
                    boolean bl = false;
                    return bl;
                }
                if (respond.equals("OK")) {
                    boolean bl = true;
                    return bl;
                }
                captchaRespond = Utils.getCapchaRespond(respond);
                if (captchaRespond != null) continue;
                boolean bl = false;
                return bl;
            }
            catch (FileNotFoundException ex) {
                log.error(null, (Throwable)ex);
                boolean bl = false;
                return bl;
            }
            catch (IOException ex) {
                log.error(null, (Throwable)ex);
                boolean bl = false;
                return bl;
            }
            finally {
                post.releaseConnection();
                continue;
            }
            break;
        }
    }

    public static boolean isCloudFileCompatible(int cloudFileVersionId) {
        if (cloudFileVersionId == 1107) {
            return true;
        }
        return cloudFileVersionId >= 1051 && cloudFileVersionId <= 1106;
    }

    /*
     * Exception decompiling
     */
    public static String getPOSTResponseBodyAsStringBasedOnProxyAuthOption(String uri, String formData) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getResponseBodyAsStringBasedOnProxyAuthOption(String request) {
        return Utils._getResponseBodyAsStringBasedOnProxyAuthOption(httpClient, request);
    }

    public static String getResponseBodyAsStringBasedOnProxyAuthOptionWithAgentInfo(String request) {
        return Utils._getResponseBodyAsStringBasedOnProxyAuthOption(httpClientWithAgentInfo, request);
    }

    /*
     * Exception decompiling
     */
    private static String _getResponseBodyAsStringBasedOnProxyAuthOption(HttpClient client, String request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static InputStreamAndMethod getResponseBodyAsStreamBasedOnProxyAuthOption(String request) {
        org.yccheok.jstock.engine.Utils.setHttpClientProxyFromSystemProperties(httpClient);
        Utils.setHttpClientProxyCredentialsFromJStockOptions(httpClient);
        GetMethod method = new GetMethod(request);
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        InputStreamAndMethod inputStreamAndMethod = null;
        InputStream respond = null;
        GetMethod methodToClosed = method;
        try {
            if (jStockOptions.isProxyAuthEnabled()) {
                method.setFollowRedirects(false);
                httpClient.executeMethod((HttpMethod)method);
                int statuscode = method.getStatusCode();
                if (statuscode == 302 || statuscode == 301 || statuscode == 303 || statuscode == 307) {
                    GetMethod RedirectMethod;
                    Header header = method.getResponseHeader("location");
                    methodToClosed = RedirectMethod = new GetMethod(header.getValue());
                    method.releaseConnection();
                    try {
                        httpClient.executeMethod((HttpMethod)RedirectMethod);
                        respond = RedirectMethod.getResponseBodyAsStream();
                    }
                    catch (HttpException exp) {
                        log.error(null, (Throwable)exp);
                    }
                    catch (IOException exp) {
                        log.error(null, (Throwable)exp);
                    }
                } else {
                    methodToClosed = method;
                    respond = method.getResponseBodyAsStream();
                }
            } else {
                methodToClosed = method;
                httpClient.executeMethod((HttpMethod)method);
                respond = method.getResponseBodyAsStream();
            }
            inputStreamAndMethod = new InputStreamAndMethod(respond, (HttpMethod)methodToClosed);
        }
        catch (HttpException exp) {
            log.error(null, (Throwable)exp);
            inputStreamAndMethod = new InputStreamAndMethod(respond, (HttpMethod)methodToClosed);
        }
        catch (IOException exp2) {
            log.error(null, (Throwable)exp2);
            inputStreamAndMethod = new InputStreamAndMethod(respond, (HttpMethod)methodToClosed);
            {
                catch (Throwable throwable) {
                    inputStreamAndMethod = new InputStreamAndMethod(respond, (HttpMethod)methodToClosed);
                    throw throwable;
                }
            }
        }
        return inputStreamAndMethod;
    }

    private static void setHttpClientProxyCredentialsFromJStockOptions(HttpClient httpClient) {
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        if (!jStockOptions.isProxyAuthEnabled()) {
            httpClient.getState().clearCredentials();
        } else {
            httpClient.getState().setProxyCredentials(AuthScope.ANY, jStockOptions.getCredentials());
        }
    }

    public static String getFileExtension(String s) {
        String ext = "";
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static String getFileExtension(File f) {
        return Utils.getFileExtension(f.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationInfo getLatestApplicationInfo() {
        int version;
        String request = org.yccheok.jstock.network.Utils.getURL(Utils.Type.VERSION_INFORMATION_TXT);
        InputStreamAndMethod inputStreamAndMethod = Utils.getResponseBodyAsStreamBasedOnProxyAuthOption(request);
        if (inputStreamAndMethod.inputStream == null) {
            inputStreamAndMethod.method.releaseConnection();
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStreamAndMethod.inputStream);
        }
        catch (IOException exp) {
            log.error(null, (Throwable)exp);
            ApplicationInfo applicationInfo = null;
            return applicationInfo;
        }
        catch (IllegalArgumentException exp) {
            log.error(null, (Throwable)exp);
            ApplicationInfo applicationInfo = null;
            return applicationInfo;
        }
        finally {
            Utils.close(inputStreamAndMethod.inputStream);
            inputStreamAndMethod.method.releaseConnection();
        }
        String applicationVersionID = properties.getProperty("applicationVersionID");
        String windowsDownloadLink = properties.getProperty("windowsDownloadLink");
        String linuxDownloadLink = properties.getProperty("linuxDownloadLink");
        String macDownloadLink = properties.getProperty("macDownloadLink");
        String solarisDownloadLink = properties.getProperty("solarisDownloadLink");
        if (applicationVersionID == null || windowsDownloadLink == null || linuxDownloadLink == null || macDownloadLink == null || solarisDownloadLink == null) {
            return null;
        }
        try {
            version = Integer.parseInt(applicationVersionID);
        }
        catch (NumberFormatException exp) {
            log.error(null, (Throwable)exp);
            return null;
        }
        return new ApplicationInfo(version, windowsDownloadLink, linuxDownloadLink, macDownloadLink, solarisDownloadLink);
    }

    public static int getApplicationVersionID() {
        return 1113;
    }

    public static int getCloudFileVersionID() {
        return 1107;
    }

    public static String toHTML(String plainText) {
        plainText = plainText.replace(System.getProperty("line.separator"), "<br>");
        return "<html><head></head><body>" + plainText + "</body></html>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <A> A fromXML(Class c, Reader reader) {
        block4: {
            Object object;
            XStream xStream = new XStream();
            try {
                Object object2 = xStream.fromXML(reader);
                if (!c.isInstance(object2)) break block4;
                object = object2;
            }
            catch (Exception exp) {
                log.error(null, (Throwable)exp);
            }
            return (A)object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <A> A fromXML(Class<A> c, File file) {
        InputStreamReader reader;
        FileInputStream inputStream;
        block7: {
            Object object;
            block6: {
                XStream xStream = new XStream();
                inputStream = null;
                reader = null;
                try {
                    inputStream = new FileInputStream(file);
                    reader = new InputStreamReader((InputStream)inputStream, Charset.forName("UTF-8"));
                    Object object2 = xStream.fromXML((Reader)reader);
                    if (c.isInstance(object2)) {
                        object = object2;
                        Utils.close(reader);
                        break block6;
                    }
                    Utils.close(reader);
                    break block7;
                }
                catch (Exception exp) {
                    log.error(null, (Throwable)exp);
                    return null;
                }
            }
            Utils.close(inputStream);
            return (A)object;
        }
        Utils.close(inputStream);
        return null;
        finally {
            Utils.close(reader);
            Utils.close(inputStream);
        }
    }

    public static <A> A fromXML(Class<A> c, String filePath) {
        return Utils.fromXML(c, new File(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean toXML(Object object, File file) {
        XStream xStream = new XStream();
        FileOutputStream outputStream = null;
        OutputStreamWriter writer = null;
        try {
            outputStream = new FileOutputStream(file);
            writer = new OutputStreamWriter((OutputStream)outputStream, Charset.forName("UTF-8"));
            xStream.toXML(object, (Writer)writer);
            Utils.close(writer);
        }
        catch (Exception exp) {
            log.error(null, (Throwable)exp);
            boolean bl = false;
            return bl;
        }
        finally {
            Utils.close(writer);
            Utils.close(outputStream);
        }
        Utils.close(outputStream);
        return true;
    }

    public static boolean toXML(Object object, String filePath) {
        return Utils.toXML(object, new File(filePath));
    }

    public static File getStockInfoDatabaseMetaFile() {
        return new File(Utils.getUserDataDirectory() + "stock-info-database-meta.json");
    }

    public static String getExtraDataDirectory() {
        return Utils.getUserDataDirectory() + "extra" + File.separator;
    }

    public static String toHTMLFileSrcFormat(String fileName) {
        try {
            return new File(fileName).toURI().toURL().toString();
        }
        catch (MalformedURLException ex) {
            log.error(null, (Throwable)ex);
            return "file:" + fileName;
        }
    }

    public static FileEx promptSavePortfolioCSVAndExcelJFileChooser(final String suggestedFileName) {
        String parent;
        File file;
        String output;
        int result;
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        final JFileChooser chooser = new JFileChooser(jStockOptions.getLastFileIODirectory());
        final FileNameExtensionFilter csvFilter = new FileNameExtensionFilter("CSV Documents (*.csv)", "csv");
        FileNameExtensionFilter xlsFilter = new FileNameExtensionFilter("Microsoft Excel (*.xls)", "xls");
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addChoosableFileFilter(csvFilter);
        chooser.addChoosableFileFilter(xlsFilter);
        final PortfolioSelectionJPanel portfolioSelectionJPanel = new PortfolioSelectionJPanel();
        chooser.setAccessory(portfolioSelectionJPanel);
        chooser.addPropertyChangeListener("fileFilterChanged", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean flag = ((FileNameExtensionFilter)evt.getNewValue()).equals(csvFilter);
                portfolioSelectionJPanel.setEnabled(flag);
                chooser.setSelectedFile(chooser.getFileFilter().getDescription().equals(csvFilter.getDescription()) ? new File(portfolioSelectionJPanel.getSuggestedFileName()) : new File(suggestedFileName));
            }
        });
        portfolioSelectionJPanel.addJRadioButtonsActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                chooser.setSelectedFile(new File(portfolioSelectionJPanel.getSuggestedFileName()));
            }
        });
        HashMap<String, FileNameExtensionFilter> map = new HashMap<String, FileNameExtensionFilter>();
        map.put(csvFilter.getDescription(), csvFilter);
        map.put(xlsFilter.getDescription(), xlsFilter);
        FileNameExtensionFilter filter = (FileNameExtensionFilter)map.get(jStockOptions.getLastSavedFileNameExtensionDescription());
        if (filter != null) {
            chooser.setFileFilter(filter);
        }
        portfolioSelectionJPanel.setEnabled(chooser.getFileFilter().getDescription().equals(csvFilter.getDescription()));
        chooser.setSelectedFile(chooser.getFileFilter().getDescription().equals(csvFilter.getDescription()) ? new File(portfolioSelectionJPanel.getSuggestedFileName()) : new File(suggestedFileName));
        do {
            int returnVal;
            if ((returnVal = chooser.showSaveDialog(MainFrame.getInstance())) != 0) {
                return null;
            }
            file = chooser.getSelectedFile();
            if (file == null) {
                return null;
            }
            String extension = Utils.getFileExtension(file);
            if (!extension.equals("csv") && !extension.equals("xls")) {
                if (chooser.getFileFilter().getDescription().equals(csvFilter.getDescription())) {
                    file = new File(file.getAbsolutePath() + ".csv");
                } else if (chooser.getFileFilter().getDescription().equals(xlsFilter.getDescription())) {
                    file = new File(file.getAbsolutePath() + ".xls");
                } else {
                    return null;
                }
            }
            if (!file.exists()) break;
            output = MessageFormat.format(MessagesBundle.getString("question_message_replace_old_template"), file.getName());
        } while ((result = JOptionPane.showConfirmDialog(MainFrame.getInstance(), output, MessagesBundle.getString("question_title_replace_old"), 0, 3)) != 0);
        if ((parent = chooser.getSelectedFile().getParent()) != null) {
            jStockOptions.setLastFileIODirectory(parent);
        }
        if (Utils.getFileExtension(file).equals("csv")) {
            jStockOptions.setLastFileNameExtensionDescription(csvFilter.getDescription());
        } else if (Utils.getFileExtension(file).equals("xls")) {
            jStockOptions.setLastFileNameExtensionDescription(xlsFilter.getDescription());
        } else {
            return null;
        }
        return new FileEx(file, portfolioSelectionJPanel.getType());
    }

    public static JRadioButton getSelection(ButtonGroup group) {
        Enumeration<AbstractButton> e = group.getElements();
        while (e.hasMoreElements()) {
            JRadioButton b = (JRadioButton)e.nextElement();
            if (b.getModel() != group.getSelection()) continue;
            return b;
        }
        return null;
    }

    private static File promptOpenJFileChooser(FileNameExtensionFilter ... fileNameExtensionFilters) {
        int returnVal;
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        JFileChooser chooser = new JFileChooser(jStockOptions.getLastFileIODirectory());
        chooser.setAcceptAllFileFilterUsed(false);
        for (FileNameExtensionFilter fileNameExtensionFilter : fileNameExtensionFilters) {
            chooser.addChoosableFileFilter(fileNameExtensionFilter);
        }
        HashMap<String, FileNameExtensionFilter> map = new HashMap<String, FileNameExtensionFilter>();
        for (FileNameExtensionFilter fileNameExtensionFilter : fileNameExtensionFilters) {
            map.put(fileNameExtensionFilter.getDescription(), fileNameExtensionFilter);
        }
        FileNameExtensionFilter filter = (FileNameExtensionFilter)map.get(jStockOptions.getLastSavedFileNameExtensionDescription());
        if (filter != null) {
            chooser.setFileFilter(filter);
        }
        if ((returnVal = chooser.showOpenDialog(MainFrame.getInstance())) != 0) {
            return null;
        }
        File file = chooser.getSelectedFile();
        if (file == null || !file.exists()) {
            return null;
        }
        String parent = chooser.getSelectedFile().getParent();
        if (parent != null) {
            jStockOptions.setLastFileIODirectory(parent);
        }
        String extension = Utils.getFileExtension(file);
        for (FileNameExtensionFilter fileNameExtensionFilter : fileNameExtensionFilters) {
            String[] extensions = fileNameExtensionFilter.getExtensions();
            if (extensions.length <= 0 || !extension.equals(extensions[0])) continue;
            jStockOptions.setLastFileNameExtensionDescription(fileNameExtensionFilter.getDescription());
            return file;
        }
        return null;
    }

    public static void playAlertSound() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Clip clip = AudioSystem.getClip();
                    clip.addLineListener(new LineListener(){

                        @Override
                        public void update(LineEvent event) {
                            if (event.getType() == LineEvent.Type.STOP) {
                                event.getLine().close();
                            }
                        }
                    });
                    InputStream audioSrc = Utils.class.getResourceAsStream("/sounds/doorbell.wav");
                    BufferedInputStream bufferedIn = new BufferedInputStream(audioSrc);
                    AudioInputStream inputStream = AudioSystem.getAudioInputStream(bufferedIn);
                    clip.open(inputStream);
                    clip.start();
                }
                catch (Exception e) {
                    log.error(null, (Throwable)e);
                }
            }
        }).start();
    }

    public static File promptOpenCSVAndExcelJFileChooser() {
        FileNameExtensionFilter csvFilter = new FileNameExtensionFilter("CSV Documents (*.csv)", "csv");
        FileNameExtensionFilter xlsFilter = new FileNameExtensionFilter("Microsoft Excel (*.xls)", "xls");
        return Utils.promptOpenJFileChooser(csvFilter, xlsFilter);
    }

    public static File promptOpenZippedJFileChooser() {
        FileNameExtensionFilter zippedFilter = new FileNameExtensionFilter("Zipped Files (*.zip)", "zip");
        return Utils.promptOpenJFileChooser(zippedFilter);
    }

    public static String stockPriceDecimalFormat(Object value) {
        DecimalFormat decimalFormat = new DecimalFormat("0.00#");
        return decimalFormat.format(value);
    }

    public static String stockPriceDecimalFormat(double value) {
        DecimalFormat decimalFormat = new DecimalFormat("0.00#");
        return decimalFormat.format(value);
    }

    private static File promptSaveJFileChooser(String suggestedFileName, FileNameExtensionFilter ... fileNameExtensionFilters) {
        String parent;
        File file;
        String output;
        int result;
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        JFileChooser chooser = new JFileChooser(jStockOptions.getLastFileIODirectory());
        chooser.setAcceptAllFileFilterUsed(false);
        for (FileNameExtensionFilter fileNameExtensionFilter : fileNameExtensionFilters) {
            chooser.addChoosableFileFilter(fileNameExtensionFilter);
        }
        chooser.setSelectedFile(new File(suggestedFileName));
        HashMap<String, FileNameExtensionFilter> map = new HashMap<String, FileNameExtensionFilter>();
        for (FileNameExtensionFilter fileNameExtensionFilter : fileNameExtensionFilters) {
            map.put(fileNameExtensionFilter.getDescription(), fileNameExtensionFilter);
        }
        FileNameExtensionFilter filter = (FileNameExtensionFilter)map.get(jStockOptions.getLastSavedFileNameExtensionDescription());
        if (filter != null) {
            chooser.setFileFilter(filter);
        }
        do {
            String[] extensions;
            int returnVal;
            if ((returnVal = chooser.showSaveDialog(MainFrame.getInstance())) != 0) {
                return null;
            }
            file = chooser.getSelectedFile();
            if (file == null) {
                return null;
            }
            String extension = Utils.getFileExtension(file);
            boolean found = false;
            block3: for (FileNameExtensionFilter fileNameExtensionFilter : fileNameExtensionFilters) {
                for (String e : extensions = fileNameExtensionFilter.getExtensions()) {
                    if (!e.equals(extension)) continue;
                    found = true;
                    break block3;
                }
            }
            if (!found) {
                for (FileNameExtensionFilter fileNameExtensionFilter : fileNameExtensionFilters) {
                    extensions = fileNameExtensionFilter.getExtensions();
                    if (extensions.length <= 0) continue;
                    String e = extensions[0];
                    if (!chooser.getFileFilter().getDescription().equals(fileNameExtensionFilter.getDescription())) continue;
                    if (e.startsWith(".")) {
                        file = new File(file.getAbsolutePath() + e);
                        break;
                    }
                    file = new File(file.getAbsolutePath() + "." + e);
                    break;
                }
            }
            if (!file.exists()) break;
            output = MessageFormat.format(MessagesBundle.getString("question_message_replace_old_template"), file.getName());
        } while ((result = JOptionPane.showConfirmDialog(MainFrame.getInstance(), output, MessagesBundle.getString("question_title_replace_old"), 0, 3)) != 0);
        if ((parent = chooser.getSelectedFile().getParent()) != null) {
            jStockOptions.setLastFileIODirectory(parent);
        }
        String e = Utils.getFileExtension(file);
        for (FileNameExtensionFilter fileNameExtensionFilter : fileNameExtensionFilters) {
            String[] extensions = fileNameExtensionFilter.getExtensions();
            if (extensions.length <= 0 || !e.equals(extensions[0])) continue;
            jStockOptions.setLastFileNameExtensionDescription(fileNameExtensionFilter.getDescription());
            break;
        }
        return file;
    }

    public static File promptSaveZippedJFileChooser(String suggestedFileName) {
        FileNameExtensionFilter zippedFilter = new FileNameExtensionFilter("Zipped Files (*.zip)", "zip");
        return Utils.promptSaveJFileChooser(suggestedFileName, zippedFilter);
    }

    public static Font getBoldFont(Font font) {
        return font.deriveFont(font.getStyle() | 1);
    }

    public static File promptSaveCSVAndExcelJFileChooser(String suggestedFileName) {
        FileNameExtensionFilter csvFilter = new FileNameExtensionFilter("CSV Documents (*.csv)", "csv");
        FileNameExtensionFilter xlsFilter = new FileNameExtensionFilter("Microsoft Excel (*.xls)", "xls");
        return Utils.promptSaveJFileChooser(suggestedFileName, csvFilter, xlsFilter);
    }

    public static boolean closeEntry(ZipOutputStream zipOutputStream) {
        if (null != zipOutputStream) {
            try {
                zipOutputStream.closeEntry();
            }
            catch (IOException ex) {
                log.error(null, (Throwable)ex);
                return false;
            }
        }
        return true;
    }

    public static JXLayer<JComboBox> getBusyJXLayer(AutoCompleteJComboBox autoCompleteJComboBox) {
        JXLayer layer = new JXLayer((Component)autoCompleteJComboBox);
        JComboBoxLayerUI<AutoCompleteJComboBox> jComboBoxLayerUI = new JComboBoxLayerUI<AutoCompleteJComboBox>();
        layer.setUI(jComboBoxLayerUI);
        autoCompleteJComboBox.attachBusyObserver(jComboBoxLayerUI);
        return layer;
    }

    public static void closeEntry(ZipInputStream zipInputStream) {
        if (null != zipInputStream) {
            try {
                zipInputStream.closeEntry();
            }
            catch (IOException ex) {
                log.error(null, (Throwable)ex);
            }
        }
    }

    public static void close(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (IOException ex) {
                log.error(null, (Throwable)ex);
            }
        }
    }

    public static String toEmailIfPossible(String username) {
        if (!EmailValidator.getInstance().isValid(username)) {
            username = username + "@gmail.com";
            if (!EmailValidator.getInstance().isValid(username)) {
                return null;
            }
        }
        return username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int numOfLines(File file, boolean skipMetadata) {
        int line = 0;
        int metaLineNumber = 0;
        LineNumberReader lnr = null;
        try {
            lnr = new LineNumberReader(new FileReader(file));
            if (skipMetadata) {
                String key;
                String[] tokens;
                String nextLine = lnr.readLine();
                while (nextLine != null && (tokens = nextLine.split("=", 2)).length == 2 && (key = tokens[0].trim()).length() > 0) {
                    ++metaLineNumber;
                    nextLine = lnr.readLine();
                }
            }
            lnr.skip(Long.MAX_VALUE);
            line = lnr.getLineNumber();
        }
        catch (IOException ex) {
            try {
                log.error(null, (Throwable)ex);
            }
            catch (Throwable throwable) {
                Utils.close(lnr);
                throw throwable;
            }
            Utils.close(lnr);
        }
        Utils.close(lnr);
        return line - metaLineNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String downloadAsString(String location) {
        InputStreamAndMethod inputStreamAndMethod = Utils.getResponseBodyAsStreamBasedOnProxyAuthOption(location);
        if (inputStreamAndMethod.inputStream == null) {
            inputStreamAndMethod.method.releaseConnection();
            return null;
        }
        try {
            Scanner s = new Scanner(inputStreamAndMethod.inputStream, "UTF-8").useDelimiter("\\A");
            String string = s.hasNext() ? s.next() : null;
            return string;
        }
        finally {
            Utils.close(inputStreamAndMethod.inputStream);
            inputStreamAndMethod.method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File downloadAsTempFile(String location) {
        block7: {
            File file;
            InputStreamAndMethod inputStreamAndMethod = Utils.getResponseBodyAsStreamBasedOnProxyAuthOption(location);
            if (inputStreamAndMethod.inputStream == null) {
                inputStreamAndMethod.method.releaseConnection();
                return null;
            }
            FileOutputStream out = null;
            File temp = null;
            try {
                int len;
                temp = File.createTempFile(Utils.getJStockUUID(), null);
                temp.deleteOnExit();
                out = new FileOutputStream(temp);
                byte[] buf = new byte[1024];
                while ((len = inputStreamAndMethod.inputStream.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                file = temp;
                Utils.close(out);
            }
            catch (IOException ex) {
                log.error(null, (Throwable)ex);
                break block7;
            }
            finally {
                Utils.close(out);
                Utils.close(inputStreamAndMethod.inputStream);
                inputStreamAndMethod.method.releaseConnection();
            }
            Utils.close(inputStreamAndMethod.inputStream);
            inputStreamAndMethod.method.releaseConnection();
            return file;
        }
        return null;
    }

    public static List<String> toHanyuPinyin(String chinese) {
        if (chinese.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<StringBuilder> stringBuilders = null;
        int length = chinese.length();
        for (int i = 0; i < length; ++i) {
            char c = chinese.charAt(i);
            String[] pinyins = null;
            HashSet<Character> set = new HashSet<Character>();
            if (CharUtils.isAscii((char)c)) {
                if (CharUtils.isAsciiAlphanumeric((char)c)) {
                    set.add(Character.valueOf(c));
                }
            } else {
                try {
                    pinyins = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)DEFAULT_HANYU_PINYIN_OUTPUT_FORMAT);
                    if (pinyins != null) {
                        for (String pinyin : pinyins) {
                            set.add(Character.valueOf(pinyin.charAt(0)));
                        }
                    }
                }
                catch (BadHanyuPinyinOutputFormatCombination ex) {
                    log.error(null, (Throwable)ex);
                }
            }
            ArrayList<StringBuilder> tmps = stringBuilders;
            stringBuilders = new ArrayList<StringBuilder>();
            if (tmps == null) {
                for (Character character : set) {
                    StringBuilder me = new StringBuilder();
                    me.append(character);
                    stringBuilders.add(me);
                }
                continue;
            }
            for (Character character : set) {
                for (StringBuilder tmp : tmps) {
                    StringBuilder me = new StringBuilder();
                    me.append((CharSequence)tmp);
                    me.append(character);
                    stringBuilders.add(me);
                }
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        if (stringBuilders != null) {
            for (StringBuilder stringBuilder : stringBuilders) {
                result.add(stringBuilder.toString());
            }
        }
        return result;
    }

    public static String getDefaultCurrencySymbol() {
        return "$";
    }

    public static DateFormat getCommonDateFormat() {
        return commonDateFormat.get();
    }

    public static boolean isToday(long timestamp) {
        Calendar calendar = Calendar.getInstance();
        int date = calendar.get(5);
        int month = calendar.get(2);
        int year = calendar.get(1);
        calendar.setTimeInMillis(timestamp);
        int _date = calendar.get(5);
        int _month = calendar.get(2);
        int _year = calendar.get(1);
        return date == _date && month == _month && year == _year;
    }

    private static Gson getGsonForStockInfoDatabaseMeta() {
        Gson gson = new GsonBuilder().registerTypeAdapter(new TypeToken<EnumMap<Country, Long>>(){}.getType(), new EnumMapInstanceCreator(Country.class)).create();
        return gson;
    }

    public static Map<Country, Long> loadStockInfoDatabaseMeta(String json) {
        Gson gson = Utils.getGsonForStockInfoDatabaseMeta();
        Map stockInfoDatabaseMeta = null;
        try {
            stockInfoDatabaseMeta = (Map)gson.fromJson(json, new TypeToken<EnumMap<Country, Long>>(){}.getType());
        }
        catch (JsonSyntaxException ex) {
            log.error(null, (Throwable)ex);
        }
        if (stockInfoDatabaseMeta == null) {
            return Collections.emptyMap();
        }
        return stockInfoDatabaseMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Country, Long> loadStockInfoDatabaseMeta(File stockInfoDatabaseMetaFile) {
        Gson gson = Utils.getGsonForStockInfoDatabaseMeta();
        Map stockInfoDatabaseMeta = null;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(stockInfoDatabaseMetaFile), "UTF-8"));
            try {
                stockInfoDatabaseMeta = (Map)gson.fromJson((Reader)reader, new TypeToken<EnumMap<Country, Long>>(){}.getType());
            }
            finally {
                reader.close();
            }
        }
        catch (IOException ex) {
            log.error(null, (Throwable)ex);
        }
        catch (JsonSyntaxException ex) {
            log.error(null, (Throwable)ex);
        }
        if (stockInfoDatabaseMeta == null) {
            return Collections.emptyMap();
        }
        return stockInfoDatabaseMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveStockInfoDatabaseMeta(File stockInfoDatabaseMetaFile, Map<Country, Long> stockInfoDatabaseMeta) {
        Gson gson = Utils.getGsonForStockInfoDatabaseMeta();
        String string = gson.toJson(stockInfoDatabaseMeta);
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(stockInfoDatabaseMetaFile), "UTF-8"));
            try {
                writer.write(string);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException ex) {
            log.error(null, (Throwable)ex);
            return false;
        }
        return true;
    }

    public static DateFormat getTodayLastUpdateTimeFormat() {
        return todayLastUpdateTimeFormat.get();
    }

    public static DateFormat getOtherDayLastUpdateTimeFormat() {
        return otherDayLastUpdateTimeFormat.get();
    }

    static {
        DEFAULT_HANYU_PINYIN_OUTPUT_FORMAT.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        DEFAULT_HANYU_PINYIN_OUTPUT_FORMAT.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        DEFAULT_HANYU_PINYIN_OUTPUT_FORMAT.setVCharType(HanyuPinyinVCharType.WITH_V);
        NTPServers = null;
        zombiePool = Executors.newFixedThreadPool(4);
        MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager = new MultiThreadedHttpConnectionManager();
        multiThreadedHttpConnectionManager.getParams().setMaxTotalConnections(128);
        multiThreadedHttpConnectionManager.getParams().setDefaultMaxConnectionsPerHost(128);
        httpClient = new HttpClient((HttpConnectionManager)multiThreadedHttpConnectionManager);
        httpClient.getParams().setParameter("http.protocol.single-cookie-header", (Object)true);
        httpClient.getParams().setCookiePolicy("compatibility");
        multiThreadedHttpConnectionManager.getParams().setMaxConnectionsPerHost(httpClient.getHostConfiguration(), 128);
        multiThreadedHttpConnectionManager = new MultiThreadedHttpConnectionManager();
        multiThreadedHttpConnectionManager.getParams().setMaxTotalConnections(128);
        multiThreadedHttpConnectionManager.getParams().setDefaultMaxConnectionsPerHost(128);
        httpClientWithAgentInfo = new HttpClient((HttpConnectionManager)multiThreadedHttpConnectionManager);
        httpClientWithAgentInfo.getParams().setParameter("http.useragent", (Object)"JStock-1.0.6o");
        httpClientWithAgentInfo.getParams().setParameter("http.protocol.single-cookie-header", (Object)true);
        httpClientWithAgentInfo.getParams().setCookiePolicy("compatibility");
        multiThreadedHttpConnectionManager.getParams().setMaxConnectionsPerHost(httpClientWithAgentInfo.getHostConfiguration(), 128);
        googleDocTitlePattern = Pattern.compile("jstock-" + Utils.getJStockUUID() + "-checksum=([0-9]+)-date=([0-9]+)-version=([0-9]+)\\.zip", 2);
        log = LogFactory.getLog(Utils.class);
    }

    public static class ApplicationInfo {
        public final int applicationVersionID;
        public final String windowsDownloadLink;
        public final String linuxDownloadLink;
        public final String macDownloadLink;
        public final String solarisDownloadLink;

        public ApplicationInfo(int applicationVersionID, String windowsDownloadLink, String linuxDownloadLink, String macDownloadLink, String solarisDownloadLink) {
            this.applicationVersionID = applicationVersionID;
            this.windowsDownloadLink = windowsDownloadLink;
            this.linuxDownloadLink = linuxDownloadLink;
            this.macDownloadLink = macDownloadLink;
            this.solarisDownloadLink = solarisDownloadLink;
        }
    }

    private static class EnumMapInstanceCreator<K extends Enum<K>, V>
    implements InstanceCreator<EnumMap<K, V>> {
        private final Class<K> enumClazz;

        public EnumMapInstanceCreator(Class<K> enumClazz) {
            this.enumClazz = enumClazz;
        }

        public EnumMap<K, V> createInstance(Type type) {
            return new EnumMap(this.enumClazz);
        }
    }

    public static class FileEx {
        public final File file;
        public final Statement.Type type;

        public FileEx(File file, Statement.Type type) {
            this.file = file;
            this.type = type;
        }
    }

    public static class InputStreamAndMethod {
        public final InputStream inputStream;
        public final HttpMethod method;

        public InputStreamAndMethod(InputStream inputStream, HttpMethod method) {
            this.inputStream = inputStream;
            this.method = method;
        }
    }

    private static class FileUploadProgressListener
    implements ProgressListener {
        private final CountDownLatch countDownLatch = new CountDownLatch(1);

        private FileUploadProgressListener() {
        }

        @Override
        public synchronized void progressChanged(ResumableHttpFileUploader uploader) {
            String fileId = ((FileUploadData)uploader.getData()).getFileName();
            switch (uploader.getUploadState()) {
                case COMPLETE: 
                case CLIENT_ERROR: {
                    this.countDownLatch.countDown();
                    log.info((Object)(fileId + ": Completed"));
                    break;
                }
                case IN_PROGRESS: {
                    log.info((Object)(fileId + ":" + String.format("%3.0f", uploader.getProgress() * 100.0) + "%"));
                    break;
                }
                case NOT_STARTED: {
                    log.info((Object)(fileId + ":" + "Not Started"));
                }
            }
        }

        public void await() throws InterruptedException {
            this.countDownLatch.await();
        }
    }

    private static class CaptchaRespond {
        public final String logintoken;
        public final String logincaptcha;

        public CaptchaRespond(String logintoken, String logincaptcha) {
            this.logintoken = logintoken;
            this.logincaptcha = logincaptcha;
        }
    }

    public static class CloudFile {
        public final File file;
        public final long checksum;
        public final long date;
        public final int version;

        private CloudFile(File file, long checksum, long date, int version) {
            this.file = file;
            this.checksum = checksum;
            this.date = date;
            this.version = version;
        }

        public static CloudFile newInstance(File file, long checksum, long date, int version) {
            return new CloudFile(file, checksum, date, version);
        }
    }
}

