/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.portfolio;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.NumberFormatter;
import net.sf.nachocalendar.CalendarFactory;
import net.sf.nachocalendar.components.DateField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.SimpleDate;
import org.yccheok.jstock.gui.portfolio.AutoDividendJPanel;
import org.yccheok.jstock.portfolio.DecimalPlaces;
import org.yccheok.jstock.portfolio.Dividend;
import org.yccheok.jstock.portfolio.Utils;

public class AutoDividendRowJPanel
extends JPanel {
    private static final Log log = LogFactory.getLog(AutoDividendRowJPanel.class);
    private final Dividend dividend;
    private final AutoDividendJPanel autoDividendJPanel;
    private Box.Filler filler1;
    private JCheckBox jCheckBox1;
    private JFormattedTextField jFormattedTextField2;
    private JPanel jPanel1;

    public AutoDividendRowJPanel(AutoDividendJPanel autoDividendJPanel, Dividend dividend) {
        this.initComponents();
        this.dividend = dividend;
        this.autoDividendJPanel = autoDividendJPanel;
        DateField dateField = (DateField)this.jPanel1;
        dateField.setValue((Object)dividend.date.getTime());
        this.jFormattedTextField2.setValue(dividend.amount);
    }

    private MouseListener getJFormattedTextFieldMouseListener() {
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(final MouseEvent e) {
                if (e.getClickCount() == 2) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTextField tf = (JTextField)e.getSource();
                        int offset = tf.viewToModel(e.getPoint());
                        tf.setCaretPosition(offset);
                    }
                });
            }
        };
        return ml;
    }

    private JFormattedTextField getCurrencyJFormattedTextField() {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(3);
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setMinimum(Double.valueOf(0.0));
        formatter.setValueClass(Double.class);
        JFormattedTextField formattedTextField = new JFormattedTextField(formatter);
        formattedTextField.addMouseListener(this.getJFormattedTextFieldMouseListener());
        return formattedTextField;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.jCheckBox1.setEnabled(enabled);
        this.jFormattedTextField2.setEnabled(enabled && this.jCheckBox1.isSelected());
        this.jPanel1.setEnabled(enabled && this.jCheckBox1.isSelected());
    }

    public boolean isSelected() {
        return this.jCheckBox1.isSelected();
    }

    public Dividend getDividend() {
        double value = this.getAmount();
        DateField dateField = (DateField)this.jPanel1;
        SimpleDate date = new SimpleDate((Date)dateField.getValue());
        return new Dividend(this.dividend.stockInfo, value, date);
    }

    public double getAmount() {
        Object value = this.jFormattedTextField2.getValue();
        if (value instanceof Double) {
            return (Double)value;
        }
        return 0.0;
    }

    private void initComponents() {
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 0));
        this.jCheckBox1 = new JCheckBox();
        this.jPanel1 = CalendarFactory.createDateField();
        this.jFormattedTextField2 = this.getCurrencyJFormattedTextField();
        this.setLayout(new FlowLayout(0));
        this.add(this.filler1);
        this.jCheckBox1.setSelected(true);
        this.jCheckBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                AutoDividendRowJPanel.this.jCheckBox1ItemStateChanged(evt);
            }
        });
        this.add(this.jCheckBox1);
        this.jPanel1.setMinimumSize(new Dimension(80, 20));
        this.jPanel1.setPreferredSize(new Dimension(80, 20));
        this.add(this.jPanel1);
        this.jFormattedTextField2.setMinimumSize(new Dimension(80, 20));
        this.jFormattedTextField2.setPreferredSize(new Dimension(80, 20));
        this.jFormattedTextField2.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                AutoDividendRowJPanel.this.jFormattedTextField2KeyTyped(evt);
            }
        });
        this.add(this.jFormattedTextField2);
    }

    private void jCheckBox1ItemStateChanged(ItemEvent evt) {
        boolean enabled = evt.getStateChange() == 1;
        this.jFormattedTextField2.setEnabled(enabled);
        this.jPanel1.setEnabled(enabled);
        this.autoDividendJPanel.updateJCheckBoxColor();
        this.autoDividendJPanel.updateTotalLabel();
    }

    public void updateTaxInfo(double tax, double taxRate) {
        double value = this.dividend.amount - tax - this.dividend.amount * taxRate / 100.0;
        value = Math.max(value, 0.0);
        String text = Utils.toEditCurrency(DecimalPlaces.Three, value);
        value = Double.parseDouble(text);
        this.jFormattedTextField2.setValue(value);
    }

    private void jFormattedTextField2KeyTyped(KeyEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    AutoDividendRowJPanel.this.jFormattedTextField2.commitEdit();
                }
                catch (ParseException ex) {
                    log.error(null, (Throwable)ex);
                }
                AutoDividendRowJPanel.this.autoDividendJPanel.updateTotalLabel();
            }
        });
    }
}

