/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.portfolio;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import org.jdesktop.swingx.JXHeader;
import org.yccheok.jstock.gui.JTableUtilities;
import org.yccheok.jstock.gui.MainFrame;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.gui.portfolio.CommentJDialog;
import org.yccheok.jstock.gui.portfolio.DepositSummaryTableModel;
import org.yccheok.jstock.gui.table.CurrencyRenderer;
import org.yccheok.jstock.gui.table.NonEmptyDoubleEditor;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.portfolio.Commentable;
import org.yccheok.jstock.portfolio.DecimalPlaces;
import org.yccheok.jstock.portfolio.DepositSummary;

public class DepositSummaryJDialog
extends JDialog {
    private DepositSummary depositSummary;
    private DepositSummary depositSummaryAfterPressingOK = null;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JXHeader jXHeader1;

    public DepositSummaryJDialog(Frame parent, boolean modal, DepositSummary depositSummary) {
        super(parent, modal);
        this.depositSummary = new DepositSummary(depositSummary);
        this.depositSummaryAfterPressingOK = null;
        this.initComponents();
    }

    private void initComponents() {
        this.jXHeader1 = new JXHeader();
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel5 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jPanel8 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jPanel6 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.setTitle(bundle.getString("DepositSummaryJDialog_CashDepositAndWithdrawal"));
        this.setResizable(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DepositSummaryJDialog.this.formMouseClicked(evt);
            }
        });
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.jXHeader1.setDescription(bundle.getString("DepositSummaryJDialog_Description"));
        this.jXHeader1.setIcon((Icon)new ImageIcon(this.getClass().getResource("/images/32x32/money.png")));
        this.jXHeader1.setTitle(bundle.getString("DepositSummaryJDialog_Cash"));
        this.getContentPane().add((Component)this.jXHeader1, "North");
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/apply.png")));
        this.jButton1.setText(bundle.getString("DepositSummaryJDialog_OK"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DepositSummaryJDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton1);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/button_cancel.png")));
        this.jButton2.setText(bundle.getString("DepositSummaryJDialog_Cancel"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DepositSummaryJDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton2);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel2.setLayout(new BorderLayout(5, 5));
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jTable1.setModel(new DepositSummaryTableModel(this.depositSummary));
        CurrencyRenderer currencyRenderer = new CurrencyRenderer();
        NonEmptyDoubleEditor currencyEditor = new NonEmptyDoubleEditor();
        currencyRenderer.setHorizontalAlignment(4);
        ((JTextField)currencyEditor.getComponent()).setHorizontalAlignment(4);
        this.jTable1.setDefaultEditor(Double.class, currencyEditor);
        this.jTable1.setDefaultRenderer(Double.class, currencyRenderer);
        JTableUtilities.setDateEditorAndRendererForRow(this.jTable1, 0);
        this.jTable1.setAutoCreateRowSorter(true);
        this.jTable1.addMouseListener(new TableRowPopupListener());
        this.jTable1.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DepositSummaryJDialog.this.jTable1PropertyChange(evt);
            }
        });
        this.jTable1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DepositSummaryJDialog.this.jTable1KeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        this.jPanel5.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.jPanel5.setLayout(new BorderLayout());
        this.jPanel7.setLayout(new BorderLayout(2, 0));
        this.jPanel4.setLayout(new GridLayout(2, 1, 2, 2));
        this.jLabel2.setText(bundle.getString("DepositSummaryJDialog_Deposit"));
        this.jPanel4.add(this.jLabel2);
        this.jLabel1.setText(bundle.getString("DepositSummary_Withdraw"));
        this.jLabel1.setHorizontalTextPosition(0);
        this.jPanel4.add(this.jLabel1);
        this.jPanel7.add((Component)this.jPanel4, "West");
        this.jPanel8.setLayout(new GridLayout(2, 1, 2, 2));
        this.jLabel5.setFont(this.jLabel5.getFont().deriveFont(this.jLabel5.getFont().getStyle() | 1));
        this.jLabel5.setHorizontalAlignment(11);
        this.jPanel8.add(this.jLabel5);
        this.jLabel3.setFont(this.jLabel3.getFont().deriveFont(this.jLabel3.getFont().getStyle() | 1));
        this.jLabel3.setHorizontalAlignment(11);
        this.jPanel8.add(this.jLabel3);
        this.jPanel7.add((Component)this.jPanel8, "East");
        this.jPanel5.add((Component)this.jPanel7, "West");
        this.jPanel6.setLayout(new FlowLayout(2, 2, 0));
        this.jLabel4.setText(bundle.getString("DepositSummaryJDialog_Total"));
        this.jPanel6.add(this.jLabel4);
        this.jLabel6.setFont(this.jLabel6.getFont().deriveFont(this.jLabel6.getFont().getStyle() | 1));
        this.jPanel6.add(this.jLabel6);
        this.jPanel5.add((Component)this.jPanel6, "East");
        this.jPanel2.add((Component)this.jPanel5, "South");
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/filenew.png")));
        this.jButton3.setText(bundle.getString("DepositSummaryJDialog_New"));
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DepositSummaryJDialog.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton3);
        this.jButton4.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/editdelete.png")));
        this.jButton4.setText(bundle.getString("DepositSummaryJDialog_Delete"));
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DepositSummaryJDialog.this.jButton4ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton4);
        this.jPanel2.add((Component)this.jPanel3, "First");
        this.getContentPane().add((Component)this.jPanel2, "Center");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 306) / 2, (screenSize.height - 373) / 2, 306, 373);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.addNewDeposit();
    }

    private void formMouseClicked(MouseEvent evt) {
        this.clearAllTablesSelection();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.deleteSelectedDeposit();
    }

    private void jTable1KeyPressed(KeyEvent evt) {
        if (127 == evt.getKeyCode()) {
            this.deleteSelectedDeposit();
            return;
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        boolean status;
        TableCellEditor tableCellEditor = this.jTable1.getCellEditor();
        if (tableCellEditor != null && !(status = tableCellEditor.stopCellEditing())) {
            return;
        }
        this.depositSummaryAfterPressingOK = this.depositSummary;
        org.yccheok.jstock.portfolio.Utils.removeMeaninglessRecords(this.depositSummaryAfterPressingOK);
        this.setVisible(false);
        this.dispose();
    }

    public DepositSummary getDepositSummary() {
        return this.depositSummary;
    }

    public DepositSummary getDepositSummaryAfterPressingOK() {
        return this.depositSummaryAfterPressingOK;
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.depositSummaryAfterPressingOK = null;
        this.setVisible(false);
        this.dispose();
    }

    private void jTable1PropertyChange(PropertyChangeEvent evt) {
        double totalDeposit = org.yccheok.jstock.portfolio.Utils.getTotalDeposit(this.depositSummary);
        double totalWithdraw = org.yccheok.jstock.portfolio.Utils.getTotalWithdraw(this.depositSummary);
        double total = this.depositSummary.getTotal();
        this.jLabel5.setForeground(Utils.getColor(totalDeposit, 0.0));
        this.jLabel3.setForeground(Utils.getColor(totalWithdraw, 0.0));
        this.jLabel6.setForeground(Utils.getColor(total, 0.0));
        this.jLabel5.setText(org.yccheok.jstock.portfolio.Utils.toCurrencyWithSymbol(DecimalPlaces.Three, totalDeposit));
        this.jLabel3.setText(org.yccheok.jstock.portfolio.Utils.toCurrencyWithSymbol(DecimalPlaces.Three, totalWithdraw));
        this.jLabel6.setText(org.yccheok.jstock.portfolio.Utils.toCurrencyWithSymbol(DecimalPlaces.Three, total));
    }

    private void addNewDeposit() {
        int modelIndex = ((DepositSummaryTableModel)this.jTable1.getModel()).addNewDeposit();
        this.clearAllTablesSelection();
        int selectedViewIndex = this.jTable1.getRowSorter().convertRowIndexToView(modelIndex);
        this.jTable1.getSelectionModel().setSelectionInterval(selectedViewIndex, selectedViewIndex);
        JTableUtilities.scrollToVisible(this.jTable1, selectedViewIndex, 0);
    }

    private void deleteSelectedDeposit() {
        int[] rows = this.jTable1.getSelectedRows();
        DepositSummaryTableModel depositSummaryTableModel = (DepositSummaryTableModel)this.jTable1.getModel();
        Arrays.sort(rows);
        for (int i = rows.length - 1; i >= 0; --i) {
            int row = rows[i];
            if (row < 0) continue;
            int modelIndex = this.jTable1.getRowSorter().convertRowIndexToModel(row);
            depositSummaryTableModel.removeRow(modelIndex);
        }
    }

    private void clearAllTablesSelection() {
        this.jTable1.getSelectionModel().clearSelection();
    }

    private String getSelectedSecondColumnString() {
        if (this.jTable1.getSelectedRowCount() != 1) {
            return null;
        }
        int viewIndex = this.jTable1.convertColumnIndexToView(1);
        String string = org.yccheok.jstock.portfolio.Utils.toCurrencyWithSymbol(DecimalPlaces.Three, this.jTable1.getValueAt(this.jTable1.getSelectedRow(), viewIndex));
        return string;
    }

    private Commentable getSelectedCommentable() {
        if (this.jTable1.getSelectedRowCount() != 1) {
            return null;
        }
        int viewIndex = this.jTable1.getSelectedRow();
        int index = this.jTable1.convertRowIndexToModel(viewIndex);
        return ((DepositSummaryTableModel)this.jTable1.getModel()).getDeposit(index);
    }

    private void showCommentJDialog(Commentable commentable, String title) {
        if (commentable == null) {
            return;
        }
        MainFrame mainFrame = MainFrame.getInstance();
        CommentJDialog commentJDialog = new CommentJDialog((Frame)mainFrame, true, commentable);
        commentJDialog.setTitle(title);
        commentJDialog.setLocationRelativeTo(this);
        commentJDialog.setVisible(true);
    }

    private JPopupMenu getMyJTablePopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("DepositSummary_New"), new ImageIcon(this.getClass().getResource("/images/16x16/filenew.png")));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DepositSummaryJDialog.this.addNewDeposit();
            }
        });
        popup.add(menuItem);
        final Commentable commentable = this.getSelectedCommentable();
        final String text = this.getSelectedSecondColumnString();
        if (commentable != null && text != null) {
            popup.addSeparator();
            menuItem = new JMenuItem(ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("DepositSummary_Note..."), new ImageIcon(this.getClass().getResource("/images/16x16/sticky.png")));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DepositSummaryJDialog.this.showCommentJDialog(commentable, MessageFormat.format(GUIBundle.getString("DepositSummaryJDialog_NoteFor_template"), text));
                }
            });
            popup.add(menuItem);
        }
        if (this.jTable1.getSelectedRowCount() >= 1) {
            popup.addSeparator();
            menuItem = new JMenuItem(ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("DepositSummaryJDialog_Delete"), new ImageIcon(this.getClass().getResource("/images/16x16/editdelete.png")));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DepositSummaryJDialog.this.deleteSelectedDeposit();
                }
            });
            popup.add(menuItem);
        }
        return popup;
    }

    private String getDepositSummaryText() {
        if (this.depositSummary != null) {
            return MessageFormat.format(GUIBundle.getString("DepositSummaryJDialog_TotalDepositIs_template"), org.yccheok.jstock.portfolio.Utils.toCurrencyWithSymbol(DecimalPlaces.Three, this.depositSummary.getTotal()));
        }
        return "";
    }

    private class TableRowPopupListener
    extends MouseAdapter {
        private TableRowPopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                DepositSummaryJDialog.this.getMyJTablePopupMenu().show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

