/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.network;

import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;

public class Utils {
    private static final Map<Type, String> map = new EnumMap<Type, String>(Type.class);
    private static final Map<Type, String> zh_map = new EnumMap<Type, String>(Type.class);
    private static final String JSTOCK_STATIC_SERVER = "http://jstock-static.appspot.com/";
    private static final String JSTOCK_WEBAPP_SERVER = "http://jstock-webapp.appspot.com/";

    private Utils() {
    }

    public static String getURL(Type type) {
        Locale defaultLocale = Locale.getDefault();
        if (org.yccheok.jstock.gui.Utils.isSimplifiedChinese(defaultLocale)) {
            return zh_map.get((Object)type);
        }
        return map.get((Object)type);
    }

    public static String getJStockStaticServer() {
        return JSTOCK_STATIC_SERVER;
    }

    static {
        map.put(Type.CHAT_SERVER_TXT, "http://jstock-static.appspot.com/servers_information/chat_server.txt");
        map.put(Type.NTP_SERVER_TXT, "http://jstock-static.appspot.com/servers_information/ntp_server.txt");
        map.put(Type.NEWS_INFORMATION_TXT, "http://jstock-static.appspot.com/news_information/index.txt");
        map.put(Type.VERSION_INFORMATION_TXT, "http://jstock-static.appspot.com/version_information/index.txt");
        map.put(Type.CURRENCY_CODE_TXT, "http://jstock-static.appspot.com/currency_information/currency_code.txt");
        map.put(Type.MODULE_INDICATOR_DOWNLOAD_MANAGER_XML, "http://jstock-static.appspot.com/module_indicators/indicator_download_manager.xml");
        map.put(Type.ALERT_INDICATOR_DOWNLOAD_MANAGER_XML, "http://jstock-static.appspot.com/alert_indicators/indicator_download_manager.xml");
        map.put(Type.HELP_STOCK_DATABASE_HTML, "http://www.jstock.org/help_real_time_info.html?utm_source=jstock&utm_medium=database_dialog#new-database");
        map.put(Type.PRIVACY_HTML, "http://jstock.org/privacy.html");
        map.put(Type.HELP_HTML, "http://jstock.org/help.html?utm_source=jstock&utm_medium=help_menu");
        map.put(Type.MA_INDICATOR_HTML, "http://jstock.org/ma_indicator.html?utm_source=jstock&utm_medium=chart_dialog");
        map.put(Type.GET_TIME, "http://jstock-webapp.appspot.com/get-time.py");
        map.put(Type.OPTIONS, "http://jstock-static.appspot.com/options_information/options.txt");
        map.put(Type.DONATE_HTML, "http://jstock.org/donation.html?utm_source=jstock&utm_medium=help_menu");
        map.put(Type.CONTRIBUTE_HTML, "http://jstock.org/help_faq.html?utm_source=jstock&utm_medium=help_menu#contribution");
        map.put(Type.HELP_KEYBOARD_SHORTCUTS_HTML, "http://jstock.org/help_faq.html?utm_source=jstock&utm_medium=help_menu#keyboard-shortcuts");
        map.put(Type.ANDROID_HTML, "http://goo.gl/VAm6Mx");
        map.put(Type.STOCK_INFO_DATABASE_META, "http://jstock-static.appspot.com/stocks_information/stock-info-database-meta.json");
        zh_map.put(Type.CHAT_SERVER_TXT, "http://jstock-static.appspot.com/servers_information/chat_server.txt");
        zh_map.put(Type.NTP_SERVER_TXT, "http://jstock-static.appspot.com/servers_information/ntp_server.txt");
        zh_map.put(Type.NEWS_INFORMATION_TXT, "http://jstock-static.appspot.com/news_information/zh/index.txt");
        zh_map.put(Type.VERSION_INFORMATION_TXT, "http://jstock-static.appspot.com/version_information/zh/index.txt");
        zh_map.put(Type.CURRENCY_CODE_TXT, "http://jstock-static.appspot.com/currency_information/currency_code.txt");
        zh_map.put(Type.MODULE_INDICATOR_DOWNLOAD_MANAGER_XML, "http://jstock-static.appspot.com/module_indicators/zh/indicator_download_manager.xml");
        zh_map.put(Type.ALERT_INDICATOR_DOWNLOAD_MANAGER_XML, "http://jstock-static.appspot.com/alert_indicators/zh/indicator_download_manager.xml");
        zh_map.put(Type.HELP_STOCK_DATABASE_HTML, "http://jstock.org/zh/help_stock_database.html?utm_source=jstock&utm_medium=database_dialog");
        zh_map.put(Type.PRIVACY_HTML, "http://jstock.org/zh/privacy.html");
        zh_map.put(Type.HELP_HTML, "http://jstock.org/zh/help.html?utm_source=jstock&utm_medium=help_menu");
        zh_map.put(Type.MA_INDICATOR_HTML, "http://jstock.org/zh/ma_indicator.html?utm_source=jstock&utm_medium=chart_dialog");
        zh_map.put(Type.GET_TIME, "http://jstock-webapp.appspot.com/get-time.py");
        zh_map.put(Type.OPTIONS, "http://jstock-static.appspot.com/options_information/options.txt");
        zh_map.put(Type.DONATE_HTML, "http://jstock.org/zh/donation.html?utm_source=jstock&utm_medium=help_menu");
        zh_map.put(Type.CONTRIBUTE_HTML, "http://jstock.org/zh/help_faq.html?utm_source=jstock&utm_medium=help_menu#contribution");
        zh_map.put(Type.HELP_KEYBOARD_SHORTCUTS_HTML, "http://jstock.org/zh/help_faq.html?utm_source=jstock&utm_medium=help_menu#keyboard-shortcuts");
        zh_map.put(Type.ANDROID_HTML, "http://goo.gl/VAm6Mx");
        zh_map.put(Type.STOCK_INFO_DATABASE_META, "http://jstock-static.appspot.com/stocks_information/stock-info-database-meta.json");
        assert (map.size() == Type.values().length);
        assert (zh_map.size() == Type.values().length);
    }

    public static enum Type {
        NEWS_INFORMATION_TXT,
        CHAT_SERVER_TXT,
        NTP_SERVER_TXT,
        VERSION_INFORMATION_TXT,
        CURRENCY_CODE_TXT,
        MODULE_INDICATOR_DOWNLOAD_MANAGER_XML,
        ALERT_INDICATOR_DOWNLOAD_MANAGER_XML,
        HELP_STOCK_DATABASE_HTML,
        PRIVACY_HTML,
        HELP_HTML,
        MA_INDICATOR_HTML,
        GET_TIME,
        OPTIONS,
        DONATE_HTML,
        CONTRIBUTE_HTML,
        HELP_KEYBOARD_SHORTCUTS_HTML,
        ANDROID_HTML,
        STOCK_INFO_DATABASE_META;

    }
}

