/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.portfolio;

import java.util.EnumMap;
import java.util.Map;
import javax.swing.ImageIcon;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.portfolio.DecimalPlaces;
import org.yccheok.jstock.portfolio.Utils;

public class Activity {
    private final Type type;
    private final double amount;
    private Map<Param, Object> paramToObject = new EnumMap<Param, Object>(Param.class);

    private Activity(Builder builder) {
        this.type = builder.type;
        this.amount = builder.amount;
        this.paramToObject = builder.paramToObject;
    }

    public Object get(Param param) {
        return this.paramToObject.get((Object)param);
    }

    public Type getType() {
        return this.type;
    }

    public double getAmount() {
        return this.amount;
    }

    public String toString() {
        Stock stock = (Stock)this.get(Param.Stock);
        if (stock != null) {
            return stock.symbol.toString() + " " + this.type.toString().toLowerCase() + " " + Utils.toCurrencyWithSymbol(DecimalPlaces.Three, this.amount);
        }
        return this.type.toString().toLowerCase() + " " + Utils.toCurrencyWithSymbol(DecimalPlaces.Three, this.amount);
    }

    public static class Builder {
        private final Type type;
        private final double amount;
        private Map<Param, Object> paramToObject = new EnumMap<Param, Object>(Param.class);

        public Builder(Type type, double amount) {
            this.type = type;
            this.amount = amount;
        }

        public Builder put(Param param, Object value) {
            this.paramToObject.put(param, value);
            return this;
        }

        public Activity build() {
            return new Activity(this);
        }
    }

    public static enum Type {
        Deposit("/images/16x16/money.png"),
        Buy("/images/16x16/inbox.png"),
        Sell("/images/16x16/outbox.png"),
        Dividend("/images/16x16/money2.png");

        private ImageIcon icon;

        private Type(String fileName) {
            this.icon = new ImageIcon(((Object)((Object)this)).getClass().getResource(fileName));
        }

        public ImageIcon getIcon() {
            return this.icon;
        }
    }

    public static enum Param {
        Stock,
        StockInfo,
        Quantity;

    }
}

