/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.portfolio;

import org.yccheok.jstock.portfolio.Broker;
import org.yccheok.jstock.portfolio.Contract;
import org.yccheok.jstock.portfolio.Utils;

public class SimpleBroker
implements Broker {
    private double maximumRate;
    private double minimumRate;
    private double rate;
    private String name;

    public SimpleBroker(String name, double maximumRate, double minimumRate, double rate) {
        this.name = name;
        this.maximumRate = maximumRate;
        this.minimumRate = minimumRate;
        this.rate = rate;
    }

    public SimpleBroker(SimpleBroker simpleBroker) {
        this.name = simpleBroker.getName();
        this.maximumRate = simpleBroker.getMaximumRate();
        this.minimumRate = simpleBroker.getMinimumRate();
        this.rate = simpleBroker.getRate();
    }

    @Override
    public double calculate(Contract contact) {
        double result = contact.getTotal() * this.getRate() / 100.0;
        if (result < this.minimumRate) {
            return this.minimumRate;
        }
        if (!Utils.essentiallyEqual(this.maximumRate, 0.0) && result > this.maximumRate) {
            return this.maximumRate;
        }
        return result;
    }

    public double getMaximumRate() {
        return this.maximumRate;
    }

    public double getMinimumRate() {
        return this.minimumRate;
    }

    public double getRate() {
        return this.rate;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public void setMaximumRate(double maximumRate) {
        this.maximumRate = maximumRate;
    }

    public void setMinimumRate(double minimumRate) {
        this.minimumRate = minimumRate;
    }

    public void setRate(double rate) {
        this.rate = rate;
    }
}

