/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.portfolio;

import org.yccheok.jstock.portfolio.ClearingFee;
import org.yccheok.jstock.portfolio.Contract;

public class SimpleClearingFee
implements ClearingFee {
    private double maximumRate;
    private double minimumRate;
    private double rate;
    private String name;

    public SimpleClearingFee(String name, double maximumRate, double minimumRate, double rate) {
        this.name = name;
        this.maximumRate = maximumRate;
        this.minimumRate = minimumRate;
        this.rate = rate;
    }

    public SimpleClearingFee(SimpleClearingFee simpleClearingFee) {
        this.name = simpleClearingFee.getName();
        this.maximumRate = simpleClearingFee.getMaximumRate();
        this.minimumRate = simpleClearingFee.getMinimumRate();
        this.rate = simpleClearingFee.getRate();
    }

    @Override
    public double calculate(Contract contact) {
        double result = contact.getTotal() * this.getRate() / 100.0;
        if (result < this.getMinimumRate()) {
            return this.getMinimumRate();
        }
        if (result > this.getMaximumRate()) {
            return this.getMaximumRate();
        }
        return result;
    }

    public double getMaximumRate() {
        return this.maximumRate;
    }

    public double getMinimumRate() {
        return this.minimumRate;
    }

    public double getRate() {
        return this.rate;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public void setMaximumRate(double maximumRate) {
        this.maximumRate = maximumRate;
    }

    public void setMinimumRate(double minimumRate) {
        this.minimumRate = minimumRate;
    }

    public void setRate(double rate) {
        this.rate = rate;
    }
}

