/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.sparta;

import com.hp.hpl.sparta.Element;
import com.hp.hpl.sparta.EmptyEnumeration;
import com.hp.hpl.sparta.Node;
import com.hp.hpl.sparta.ParseException;
import com.hp.hpl.sparta.Sparta;
import com.hp.hpl.sparta.XPathVisitor;
import com.hp.hpl.sparta.xpath.Step;
import com.hp.hpl.sparta.xpath.XPath;
import com.hp.hpl.sparta.xpath.XPathException;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Document
extends Node {
    private static final boolean DEBUG = false;
    private static final Integer ONE = new Integer(1);
    static final Enumeration EMPTY = new EmptyEnumeration();
    private Element rootElement_ = null;
    private String systemId_;
    private Sparta.Cache indices_ = Sparta.newCache();
    private Vector observers_ = new Vector();
    private final Hashtable indexible_ = null;

    Document(String string) {
        this.systemId_ = string;
    }

    public Document() {
        this.systemId_ = "MEMORY";
    }

    public Object clone() {
        Document document = new Document(this.systemId_);
        document.rootElement_ = (Element)this.rootElement_.clone();
        return document;
    }

    public String getSystemId() {
        return this.systemId_;
    }

    public void setSystemId(String string) {
        this.systemId_ = string;
        this.notifyObservers();
    }

    public String toString() {
        return this.systemId_;
    }

    public Element getDocumentElement() {
        return this.rootElement_;
    }

    public void setDocumentElement(Element element) {
        this.rootElement_ = element;
        this.rootElement_.setOwnerDocument(this);
        this.notifyObservers();
    }

    private XPathVisitor visitor(String string, boolean bl) throws XPathException {
        if (string.charAt(0) != '/') {
            string = "/" + string;
        }
        return this.visitor(XPath.get(string), bl);
    }

    XPathVisitor visitor(XPath xPath, boolean bl) throws XPathException {
        if (xPath.isStringValue() != bl) {
            String string = bl ? "evaluates to element not string" : "evaluates to string not element";
            throw new XPathException(xPath, "\"" + xPath + "\" evaluates to " + string);
        }
        return new XPathVisitor(this, xPath);
    }

    public Enumeration xpathSelectElements(String string) throws ParseException {
        try {
            if (string.charAt(0) != '/') {
                string = "/" + string;
            }
            XPath xPath = XPath.get(string);
            this.monitor(xPath);
            return this.visitor(xPath, false).getResultEnumeration();
        }
        catch (XPathException xPathException) {
            throw new ParseException("XPath problem", xPathException);
        }
    }

    void monitor(XPath xPath) throws XPathException {
    }

    public Enumeration xpathSelectStrings(String string) throws ParseException {
        try {
            return this.visitor(string, true).getResultEnumeration();
        }
        catch (XPathException xPathException) {
            throw new ParseException("XPath problem", xPathException);
        }
    }

    public Element xpathSelectElement(String string) throws ParseException {
        try {
            if (string.charAt(0) != '/') {
                string = "/" + string;
            }
            XPath xPath = XPath.get(string);
            this.monitor(xPath);
            return this.visitor(xPath, false).getFirstResultElement();
        }
        catch (XPathException xPathException) {
            throw new ParseException("XPath problem", xPathException);
        }
    }

    public String xpathSelectString(String string) throws ParseException {
        try {
            return this.visitor(string, true).getFirstResultString();
        }
        catch (XPathException xPathException) {
            throw new ParseException("XPath problem", xPathException);
        }
    }

    public boolean xpathEnsure(String string) throws ParseException {
        try {
            if (this.xpathSelectElement(string) != null) {
                return false;
            }
            XPath xPath = XPath.get(string);
            int n = 0;
            Enumeration enumeration = xPath.getSteps();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement();
                ++n;
            }
            Enumeration enumeration2 = xPath.getSteps();
            Step step = (Step)enumeration2.nextElement();
            Step[] stepArray = new Step[n - 1];
            int n2 = 0;
            while (n2 < stepArray.length) {
                stepArray[n2] = (Step)enumeration2.nextElement();
                ++n2;
            }
            if (this.rootElement_ == null) {
                Element element = this.makeMatching(null, step, string);
                this.setDocumentElement(element);
            } else {
                Element element = this.xpathSelectElement("/" + step);
                if (element == null) {
                    throw new ParseException("Existing root element <" + this.rootElement_.getTagName() + "...> does not match first step \"" + step + "\" of \"" + string);
                }
            }
            if (stepArray.length == 0) {
                return true;
            }
            return this.rootElement_.xpathEnsure(XPath.get(false, stepArray).toString());
        }
        catch (XPathException xPathException) {
            throw new ParseException(string, xPathException);
        }
    }

    public boolean xpathHasIndex(String string) {
        return this.indices_.get(string) != null;
    }

    public Index xpathGetIndex(String string) throws ParseException {
        try {
            Index index = (Index)this.indices_.get(string);
            if (index == null) {
                XPath xPath = XPath.get(string);
                index = new Index(xPath);
                this.indices_.put(string, index);
            }
            return index;
        }
        catch (XPathException xPathException) {
            throw new ParseException("XPath problem", xPathException);
        }
    }

    public void addObserver(Observer observer) {
        this.observers_.addElement(observer);
    }

    public void deleteObserver(Observer observer) {
        this.observers_.removeElement(observer);
    }

    public void toString(Writer writer) throws IOException {
        this.rootElement_.toString(writer);
    }

    void notifyObservers() {
        Enumeration enumeration = this.observers_.elements();
        while (enumeration.hasMoreElements()) {
            ((Observer)enumeration.nextElement()).update(this);
        }
    }

    public void toXml(Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\" ?>\n");
        this.rootElement_.toXml(writer);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Document)) {
            return false;
        }
        Document document = (Document)object;
        return this.rootElement_.equals(document.rootElement_);
    }

    protected int computeHashCode() {
        return this.rootElement_.hashCode();
    }

    public static interface Observer {
        public void update(Document var1);
    }

    public class Index
    implements Observer {
        private transient Sparta.Cache dict_ = null;
        private final XPath xpath_;
        private final String attrName_;

        Index(XPath xPath) throws XPathException {
            this.attrName_ = xPath.getIndexingAttrName();
            this.xpath_ = xPath;
            Document.this.addObserver(this);
        }

        public synchronized Enumeration get(String string) throws ParseException {
            Vector vector;
            if (this.dict_ == null) {
                this.regenerate();
            }
            return (vector = (Vector)this.dict_.get(string)) == null ? EMPTY : vector.elements();
        }

        public synchronized int size() throws ParseException {
            if (this.dict_ == null) {
                this.regenerate();
            }
            return this.dict_.size();
        }

        public synchronized void update(Document document) {
            this.dict_ = null;
        }

        private void regenerate() throws ParseException {
            try {
                this.dict_ = Sparta.newCache();
                Enumeration enumeration = Document.this.visitor(this.xpath_, false).getResultEnumeration();
                while (enumeration.hasMoreElements()) {
                    Element element = (Element)enumeration.nextElement();
                    String string = element.getAttribute(this.attrName_);
                    Vector<Element> vector = (Vector<Element>)this.dict_.get(string);
                    if (vector == null) {
                        vector = new Vector<Element>(1);
                        this.dict_.put(string, vector);
                    }
                    vector.addElement(element);
                }
            }
            catch (XPathException xPathException) {
                throw new ParseException("XPath problem", xPathException);
            }
        }
    }
}

