/*
 * Decompiled with CFR 0.152.
 */
package com.tictactec.ta.lib.test;

import com.tictactec.ta.lib.Core;
import com.tictactec.ta.lib.MInteger;
import com.tictactec.ta.lib.RetCode;
import com.tictactec.ta.lib.meta.TaFuncClosure;
import com.tictactec.ta.lib.meta.TaFuncMetaInfo;
import com.tictactec.ta.lib.test.CombinationGenerator;
import com.tictactec.ta.lib.test.InputData;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestAbstractClosure
extends Assert
implements TaFuncClosure {
    List<InputData> originalData;
    List<InputData> testData;
    Core taCore;
    InputData curInputData;

    public TestAbstractClosure(Core taCore, List<InputData> data) {
        this.taCore = taCore;
        this.originalData = data;
        this.testData = new ArrayList<InputData>();
        for (InputData id : this.originalData) {
            this.testData.add(new InputData(id));
        }
    }

    @Override
    public void execute(TaFuncMetaInfo mi) throws Exception {
        int n = this.testData.size();
        int i = 0;
        while (i < n) {
            this.execute(mi, this.testData.get(i), this.originalData.get(i));
            ++i;
        }
    }

    void execute(TaFuncMetaInfo mi, InputData inputData, InputData originalInputData) throws Exception {
        this.curInputData = inputData;
        Object[] inArs = this.getInputParamters(mi, inputData);
        Object[] options = this.getDefaultOptions(mi);
        List<Object[]> optionsCombination = new CombinationGenerator().getAllCombinations(options);
        for (Object[] ops : optionsCombination) {
            this.execute(mi, inputData, originalInputData, inArs, ops);
        }
    }

    void execute(TaFuncMetaInfo mi, InputData inputData, InputData originalInputData, Object[] inArs, Object[] options) throws Exception {
        int lookback = 0;
        Object[] outArs = this.getOutputParameters(mi, inputData.size(), lookback);
        MInteger outBegIdx = new MInteger();
        MInteger outNbElement = new MInteger();
        int startIndex = 0;
        int endIndex = inputData.size() - 1;
        RetCode retCode = mi.call(this.taCore, inArs, startIndex, endIndex, outArs, outBegIdx, outNbElement, options);
        TestAbstractClosure.assertEquals((Object)((Object)retCode), (Object)((Object)RetCode.Success));
        assert (this.verifyOutputData(mi, outArs));
        assert (this.verifyInputData(inputData, originalInputData));
        retCode = mi.call(this.taCore, inArs, 0, 0, outArs, outBegIdx, outNbElement, options);
        TestAbstractClosure.assertEquals((Object)((Object)retCode), (Object)((Object)RetCode.Success));
        TestAbstractClosure.assertEquals((int)outBegIdx.value, (int)0);
    }

    Object[] getInputParamters(TaFuncMetaInfo mi, InputData inputData) {
        Class[] inVarTypes = mi.getInVarTypes();
        Object[] ret = new Object[inVarTypes.length];
        int i = 0;
        while (i < inVarTypes.length) {
            if (inVarTypes[i].equals(double[].class)) {
                ret[i] = inputData.getDoubleData();
            } else if (inVarTypes[i].equals(float[].class)) {
                ret[i] = inputData.getFloatData();
            } else if (inVarTypes[i].equals(int[].class)) {
                ret[i] = inputData.getIntData();
            } else {
                TestAbstractClosure.fail((String)("Invalid input type : " + inVarTypes[i]));
            }
            ++i;
        }
        return ret;
    }

    Object[] getOutputParameters(TaFuncMetaInfo mi, int inSize, int lookback) {
        int outSize = inSize;
        Class[] outVarTypes = mi.getOutVarTypes();
        Object[] ret = new Object[outVarTypes.length];
        int i = 0;
        while (i < outVarTypes.length) {
            if (outVarTypes[i].equals(double[].class)) {
                ret[i] = new double[outSize];
                Arrays.fill((double[])ret[i], -3.0E37);
            } else if (outVarTypes[i].equals(float[].class)) {
                ret[i] = new float[outSize];
                Arrays.fill((float[])ret[i], -3.0E37f);
            } else if (outVarTypes[i].equals(int[].class)) {
                ret[i] = new int[outSize];
                Arrays.fill((int[])ret[i], -2147483647);
            } else {
                TestAbstractClosure.fail((String)("Invalid output type : " + outVarTypes[i]));
            }
            ++i;
        }
        return ret;
    }

    Object[] getDefaultOptions(TaFuncMetaInfo mi) throws IllegalArgumentException, IllegalAccessException {
        Class[] optionTypes = mi.getOptionTypes();
        Object[] ret = new Object[optionTypes.length];
        int i = 0;
        while (i < optionTypes.length) {
            if (optionTypes[i].equals(Double.TYPE)) {
                ret[i] = -4.0E37;
            } else if (optionTypes[i].equals(Float.TYPE)) {
                ret[i] = -4.0E37;
            } else if (optionTypes[i].equals(Integer.TYPE)) {
                ret[i] = Integer.MIN_VALUE;
            } else if (optionTypes[i].isEnum()) {
                ret[i] = this.getAllEnumMembers(optionTypes[i]);
            } else {
                TestAbstractClosure.fail((String)("Invalid option type : " + optionTypes[i]));
            }
            ++i;
        }
        return ret;
    }

    Enum[] getAllEnumMembers(Class clazz) throws IllegalArgumentException, IllegalAccessException {
        Field[] flds = clazz.getFields();
        Enum[] ret = new Enum[flds.length];
        int i = 0;
        while (i < flds.length) {
            ret[i] = (Enum)flds[i].get(clazz);
            ++i;
        }
        return ret;
    }

    boolean verifyOutputData(TaFuncMetaInfo mi, Object[] outArs) {
        Class[] outVarTypes = mi.getOutVarTypes();
        int i = 0;
        while (i < outVarTypes.length) {
            if (outVarTypes[i].equals(double[].class)) {
                double[] ar = (double[])outArs[i];
                int j = 0;
                double[] dArray = ar;
                int n = 0;
                int n2 = dArray.length;
                while (n < n2) {
                    double d = dArray[n];
                    if (Double.isNaN(d) || Double.isInfinite(d)) {
                        System.out.println("----------->" + mi.toString() + "[" + j + "]=" + d + ":" + this.curInputData.getName());
                    }
                    ++j;
                    ++n;
                }
            } else if (!outVarTypes[i].equals(float[].class) && !outVarTypes[i].equals(int[].class)) {
                TestAbstractClosure.fail((String)("invalid output type : " + outVarTypes[i]));
            }
            ++i;
        }
        return true;
    }

    boolean verifyInputData(InputData inputData, InputData originalInputData) {
        return Arrays.equals(inputData.getDoubleData(), originalInputData.getDoubleData()) && Arrays.equals(inputData.getFloatData(), originalInputData.getFloatData()) && Arrays.equals(inputData.getIntData(), originalInputData.getIntData());
    }
}

