/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app;

import java.awt.BorderLayout;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.View;

public abstract class AbstractView
extends JPanel
implements View {
    private Application application;
    protected JFileChooser saveChooser;
    protected JFileChooser openChooser;
    protected File file;
    protected ExecutorService executor;
    private HashMap<String, Action> actions;
    private boolean hasUnsavedChanges;
    protected Preferences preferences = Preferences.userNodeForPackage(this.getClass());
    private int multipleOpenId = 1;
    private boolean isShowing;
    private String title;

    @Override
    public void init() {
    }

    @Override
    public void start() {
    }

    @Override
    public void activate() {
    }

    @Override
    public void deactivate() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void dispose() {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public void setApplication(Application newValue) {
        Application oldValue = this.application;
        this.application = newValue;
        this.firePropertyChange("application", oldValue, newValue);
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void setFile(File newValue) {
        File oldValue = this.file;
        this.file = newValue;
        if (this.preferences != null && newValue != null) {
            this.preferences.put("projectFile", newValue.getPath());
        }
        this.firePropertyChange("file", oldValue, newValue);
    }

    @Override
    public JFileChooser getOpenChooser() {
        if (this.openChooser == null) {
            this.openChooser = this.createOpenChooser();
        }
        return this.openChooser;
    }

    protected JFileChooser createOpenChooser() {
        JFileChooser c = new JFileChooser();
        if (this.preferences != null) {
            c.setSelectedFile(new File(this.preferences.get("projectFile", System.getProperty("user.home"))));
        }
        return c;
    }

    @Override
    public JFileChooser getSaveChooser() {
        if (this.saveChooser == null) {
            this.saveChooser = this.createSaveChooser();
        }
        return this.saveChooser;
    }

    @Override
    public boolean canSaveTo(File file) {
        return true;
    }

    protected JFileChooser createSaveChooser() {
        JFileChooser c = new JFileChooser();
        if (this.preferences != null) {
            c.setCurrentDirectory(new File(this.preferences.get("projectFile", System.getProperty("user.home"))));
        }
        return c;
    }

    @Override
    public boolean hasUnsavedChanges() {
        return this.hasUnsavedChanges;
    }

    protected void setHasUnsavedChanges(boolean newValue) {
        boolean oldValue = this.hasUnsavedChanges;
        this.hasUnsavedChanges = newValue;
        this.firePropertyChange("hasUnsavedChanges", oldValue, newValue);
    }

    @Override
    public Action getAction(String id) {
        return this.actions == null ? null : this.actions.get(id);
    }

    @Override
    public void putAction(String id, Action action) {
        if (this.actions == null) {
            this.actions = new HashMap();
        }
        if (action == null) {
            this.actions.remove(id);
        } else {
            this.actions.put(id, action);
        }
    }

    @Override
    public void execute(Runnable worker) {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor();
        }
        this.executor.execute(worker);
    }

    @Override
    public void setMultipleOpenId(int newValue) {
        int oldValue = this.multipleOpenId;
        this.multipleOpenId = newValue;
        this.firePropertyChange("multipleOpenId", oldValue, newValue);
    }

    @Override
    public int getMultipleOpenId() {
        return this.multipleOpenId;
    }

    @Override
    public void setShowing(boolean newValue) {
        boolean oldValue = this.isShowing;
        this.isShowing = newValue;
        this.firePropertyChange("showing", oldValue, newValue);
    }

    @Override
    public boolean isShowing() {
        return this.isShowing;
    }

    @Override
    public void markChangesAsSaved() {
        this.setHasUnsavedChanges(false);
    }

    @Override
    public void setTitle(String newValue) {
        String oldValue = this.title;
        this.title = newValue;
        this.firePropertyChange("title", oldValue, newValue);
    }

    @Override
    public String getTitle() {
        return this.title;
    }
}

