/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.JobAttributes;
import java.awt.PageAttributes;
import java.awt.PrintJob;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.PrinterResolution;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.PrintableView;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.AbstractViewAction;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.util.Methods;
import org.jhotdraw.util.ResourceBundleUtil;

public class PrintAction
extends AbstractViewAction {
    public static final String ID = "file.print";

    public PrintAction(Application app) {
        super(app);
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        labels.configureAction(this, ID);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        View view = this.getActiveView();
        view.setEnabled(false);
        if (System.getProperty("apple.awt.graphics.UseQuartz", "false").equals("true")) {
            this.printQuartz();
        } else {
            this.printJava2D();
        }
        view.setEnabled(true);
    }

    public void printJava2D() {
        Pageable pageable = ((PrintableView)this.getActiveView()).createPageable();
        if (pageable == null) {
            throw new InternalError("View does not have a method named java.awt.Pageable createPageable()");
        }
        try {
            PrinterJob job = PrinterJob.getPrinterJob();
            HashPrintRequestAttributeSet attr = new HashPrintRequestAttributeSet();
            attr.add(new PrinterResolution(300, 300, 100));
            job.setPageable(pageable);
            if (job.printDialog()) {
                try {
                    job.print();
                }
                catch (PrinterException e) {
                    String message = e.getMessage() == null ? e.toString() : e.getMessage();
                    View view = this.getActiveView();
                    ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
                    JSheet.showMessageSheet(view.getComponent(), "<html>" + UIManager.getString("OptionPane.css") + "<b>" + labels.getString("couldntPrint") + "</b><br>" + (message == null ? "" : message));
                }
            } else {
                System.out.println("JOB ABORTED!");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void printJava2DAlternative() {
        Pageable pageable = (Pageable)Methods.invokeGetter((Object)this.getActiveView(), "createPageable", null);
        if (pageable == null) {
            throw new InternalError("View does not have a method named java.awt.Pageable createPageable()");
        }
        try {
            PrinterJob job = PrinterJob.getPrinterJob();
            HashPrintRequestAttributeSet attr = new HashPrintRequestAttributeSet();
            attr.add(new PrinterResolution(300, 300, 100));
            job.setPageable(pageable);
            if (job.printDialog(attr)) {
                try {
                    job.print();
                }
                catch (PrinterException e) {
                    ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
                    JSheet.showMessageSheet(this.getActiveView().getComponent(), labels.getFormatted("couldntPrint", e));
                }
            } else {
                System.out.println("JOB ABORTED!");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void printQuartz() {
        Frame frame = (Frame)SwingUtilities.getWindowAncestor(this.getActiveView().getComponent());
        final Pageable pageable = (Pageable)Methods.invokeGetter((Object)this.getActiveView(), "createPageable", null);
        double resolution = 300.0;
        JobAttributes jobAttr = new JobAttributes();
        PageAttributes pageAttr = new PageAttributes();
        pageAttr.setMedia(PageAttributes.MediaType.A4);
        pageAttr.setPrinterResolution(300);
        final PrintJob pj = frame.getToolkit().getPrintJob(frame, "Job Title", jobAttr, pageAttr);
        this.getActiveView().setEnabled(false);
        new Worker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object construct() {
                Paper paper = new Paper();
                paper.setSize((double)pj.getPageDimension().width / 300.0 * 72.0, (double)pj.getPageDimension().height / 300.0 * 72.0);
                paper.setImageableArea(64.0, 32.0, paper.getWidth() - 96.0, paper.getHeight() - 64.0);
                PageFormat pageFormat = new PageFormat();
                pageFormat.setPaper(paper);
                try {
                    int n = pageable.getNumberOfPages();
                    for (int i = 0; i < n; ++i) {
                        PageFormat pf = pageable.getPageFormat(i);
                        pf = pageFormat;
                        Graphics g = pj.getGraphics();
                        if (g instanceof Graphics2D) {
                            pageable.getPrintable(i).print(g, pf, i);
                        } else {
                            BufferedImage buf = new BufferedImage((int)(pf.getImageableWidth() * 300.0 / 72.0), (int)(pf.getImageableHeight() * 300.0 / 72.0), 1);
                            Graphics2D bufG = buf.createGraphics();
                            bufG.setBackground(Color.WHITE);
                            bufG.fillRect(0, 0, buf.getWidth(), buf.getHeight());
                            bufG.scale(4.166666666666667, 4.166666666666667);
                            bufG.translate(-pf.getImageableX(), -pf.getImageableY());
                            pageable.getPrintable(i).print(bufG, pf, i);
                            bufG.dispose();
                            g.drawImage(buf, (int)(pf.getImageableX() * 300.0 / 72.0), (int)(pf.getImageableY() * 300.0 / 72.0), null);
                            buf.flush();
                        }
                        g.dispose();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                finally {
                    pj.end();
                }
                return null;
            }

            @Override
            public void finished(Object value) {
                PrintAction.this.getActiveView().setEnabled(true);
            }
        }.start();
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && this.getActiveView() instanceof PrintableView;
    }
}

