/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.jhotdraw.draw.AbstractFigure;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BoundsOutlineHandle;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.CompositeFigureEvent;
import org.jhotdraw.draw.CompositeFigureListener;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureAdapter;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.Layouter;
import org.jhotdraw.draw.TransformHandleKit;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.util.ReversedList;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public abstract class AbstractCompositeFigure
extends AbstractFigure
implements CompositeFigure {
    protected Layouter layouter;
    protected ArrayList<Figure> children = new ArrayList();
    protected transient Rectangle2D.Double cachedDrawingArea;
    protected transient Rectangle2D.Double cachedBounds;
    protected EventHandler eventHandler = this.createEventHandler();

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        if (detailLevel == 0) {
            handles.add(new BoundsOutlineHandle(this, true, false));
            TransformHandleKit.addScaleMoveTransformHandles(this, handles);
        }
        return handles;
    }

    protected EventHandler createEventHandler() {
        return new EventHandler();
    }

    @Override
    public boolean add(Figure figure) {
        this.add(this.getChildCount(), figure);
        return true;
    }

    @Override
    public void add(int index, Figure figure) {
        this.basicAdd(index, figure);
        if (this.getDrawing() != null) {
            figure.addNotify(this.getDrawing());
        }
        this.fireFigureAdded(figure, index);
        this.invalidate();
    }

    public void addAll(Collection<? extends Figure> figures) {
        this.addAll(this.getChildCount(), figures);
    }

    public final void addAll(int index, Collection<? extends Figure> figures) {
        for (Figure figure : figures) {
            this.basicAdd(index++, figure);
            if (this.getDrawing() != null) {
                figure.addNotify(this.getDrawing());
            }
            this.fireFigureAdded(figure, index);
        }
        this.invalidate();
    }

    @Override
    public void basicAdd(Figure figure) {
        this.basicAdd(this.getChildCount(), figure);
    }

    public void basicAddAll(int index, Collection<? extends Figure> newFigures) {
        for (Figure figure : newFigures) {
            this.basicAdd(index++, figure);
        }
    }

    @Override
    public void addNotify(Drawing drawing) {
        super.addNotify(drawing);
        for (Figure child : this.getChildren()) {
            child.addNotify(drawing);
        }
    }

    @Override
    public void removeNotify(Drawing drawing) {
        super.removeNotify(drawing);
        for (Figure child : new LinkedList<Figure>(this.getChildren())) {
            child.removeNotify(drawing);
        }
    }

    @Override
    public boolean remove(Figure figure) {
        int index = this.children.indexOf(figure);
        if (index == -1) {
            return false;
        }
        this.basicRemoveChild(index);
        if (this.getDrawing() != null) {
            figure.removeNotify(this.getDrawing());
        }
        this.fireFigureRemoved(figure, index);
        return true;
    }

    @Override
    public Figure removeChild(int index) {
        Figure removed = this.basicRemoveChild(index);
        if (this.getDrawing() != null) {
            removed.removeNotify(this.getDrawing());
        }
        return removed;
    }

    public void removeAll(Collection<? extends Figure> figures) {
        for (Figure figure : new LinkedList<Figure>(figures)) {
            this.remove(figure);
        }
    }

    @Override
    public void removeAllChildren() {
        this.willChange();
        for (Figure f : new LinkedList<Figure>(this.getChildren())) {
            if (this.getDrawing() != null) {
                f.removeNotify(this.getDrawing());
            }
            int n = this.basicRemove(f);
        }
        this.changed();
    }

    @Override
    public void basicRemoveAllChildren() {
        for (Figure f : new LinkedList<Figure>(this.getChildren())) {
            this.basicRemove(f);
        }
    }

    public void basicRemoveAll(Collection<? extends Figure> figures) {
        for (Figure figure : figures) {
            this.basicRemove(figure);
        }
    }

    public synchronized void sendToBack(Figure figure) {
        if (this.basicRemove(figure) != -1) {
            this.basicAdd(0, figure);
            this.fireAreaInvalidated(figure.getDrawingArea());
        }
    }

    public synchronized void bringToFront(Figure figure) {
        if (this.basicRemove(figure) != -1) {
            this.basicAdd(figure);
            this.fireAreaInvalidated(figure.getDrawingArea());
        }
    }

    @Override
    public void transform(AffineTransform tx) {
        for (Figure f : this.getChildren()) {
            f.transform(tx);
        }
        this.invalidate();
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        Rectangle2D.Double oldBounds = this.getBounds();
        Rectangle2D.Double newBounds = new Rectangle2D.Double(Math.min(anchor.x, lead.x), Math.min(anchor.y, lead.y), Math.abs(anchor.x - lead.x), Math.abs(anchor.y - lead.y));
        double sx = newBounds.width / oldBounds.width;
        double sy = newBounds.height / oldBounds.height;
        AffineTransform tx = new AffineTransform();
        tx.translate(-oldBounds.x, -oldBounds.y);
        if (!(Double.isNaN(sx) || Double.isNaN(sy) || Double.isInfinite(sx) || Double.isInfinite(sy) || sx == 1.0 && sy == 1.0 || sx < 1.0E-4 || sy < 1.0E-4)) {
            this.transform(tx);
            tx.setToIdentity();
            tx.scale(sx, sy);
            this.transform(tx);
            tx.setToIdentity();
        }
        tx.translate(newBounds.x, newBounds.y);
        this.transform(tx);
    }

    public List<Figure> getChildrenFrontToBack() {
        return this.children.size() == 0 ? new LinkedList() : new ReversedList<Figure>(this.getChildren());
    }

    @Override
    public <T> void setAttribute(AttributeKey<T> key, T value) {
        for (Figure child : this.getChildren()) {
            child.setAttribute(key, value);
        }
        this.invalidate();
    }

    @Override
    public <T> T getAttribute(AttributeKey<T> name) {
        return null;
    }

    @Override
    public Map<AttributeKey, Object> getAttributes() {
        return new HashMap<AttributeKey, Object>();
    }

    @Override
    public Object getAttributesRestoreData() {
        LinkedList<Object> data = new LinkedList<Object>();
        for (Figure child : this.getChildren()) {
            data.add(child.getAttributesRestoreData());
        }
        return data;
    }

    @Override
    public void restoreAttributesTo(Object newData) {
        Iterator data = ((LinkedList)newData).iterator();
        for (Figure child : this.getChildren()) {
            child.restoreAttributesTo(data.next());
        }
    }

    @Override
    public boolean contains(Figure f) {
        return this.children.contains(f);
    }

    @Override
    public boolean contains(Point2D.Double p) {
        if (AttributeKeys.TRANSFORM.get(this) != null) {
            try {
                p = (Point2D.Double)AttributeKeys.TRANSFORM.get(this).inverseTransform(p, new Point2D.Double());
            }
            catch (NoninvertibleTransformException ex) {
                InternalError error = new InternalError(ex.getMessage());
                error.initCause(ex);
                throw error;
            }
        }
        if (this.getDrawingArea().contains(p)) {
            for (Figure child : this.getChildrenFrontToBack()) {
                if (!child.isVisible() || !child.contains(p)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Figure findFigureInside(Point2D.Double p) {
        if (this.getDrawingArea().contains(p)) {
            Figure found = null;
            for (Figure child : this.getChildrenFrontToBack()) {
                if (!child.isVisible() || (found = child.findFigureInside(p)) == null) continue;
                return found;
            }
        }
        return null;
    }

    public Figure findChild(Point2D.Double p) {
        if (this.getBounds().contains(p)) {
            Object found = null;
            for (Figure child : this.getChildrenFrontToBack()) {
                if (!child.isVisible() || !child.contains(p)) continue;
                return child;
            }
        }
        return null;
    }

    public int findChildIndex(Point2D.Double p) {
        Figure child = this.findChild(p);
        return child == null ? -1 : this.children.indexOf(child);
    }

    @Override
    public Layouter getLayouter() {
        return this.layouter;
    }

    @Override
    public void layout() {
        if (this.getLayouter() != null) {
            Rectangle2D.Double bounds = this.getBounds();
            Point2D.Double p = new Point2D.Double(bounds.x, bounds.y);
            Rectangle2D.Double r = this.getLayouter().layout(this, p, p);
            this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width, r.y + r.height));
            this.invalidate();
        }
    }

    @Override
    public void setLayouter(Layouter newLayouter) {
        this.layouter = newLayouter;
    }

    @Override
    public Dimension2DDouble getPreferredSize() {
        if (this.layouter != null) {
            Rectangle2D.Double r = this.layouter.calculateLayout(this, this.getStartPoint(), this.getEndPoint());
            return new Dimension2DDouble(r.width, r.height);
        }
        return super.getPreferredSize();
    }

    @Override
    public void draw(Graphics2D g) {
        Rectangle clipBounds = g.getClipBounds();
        if (clipBounds != null) {
            for (Figure child : this.getChildren()) {
                if (!child.isVisible() || !child.getDrawingArea().intersects(clipBounds)) continue;
                child.draw(g);
            }
        } else {
            for (Figure child : this.getChildren()) {
                if (!child.isVisible()) continue;
                child.draw(g);
            }
        }
    }

    @Override
    public Collection<Figure> getDecomposition() {
        LinkedList<Figure> list = new LinkedList<Figure>();
        list.add(this);
        list.addAll(this.getChildren());
        return list;
    }

    @Override
    public void read(DOMInput in) throws IOException {
        in.openElement("children");
        for (int i = 0; i < in.getElementCount(); ++i) {
            this.basicAdd((Figure)in.readObject(i));
        }
        in.closeElement();
    }

    @Override
    public void write(DOMOutput out) throws IOException {
        out.openElement("children");
        for (Figure child : this.getChildren()) {
            out.writeObject(child);
        }
        out.closeElement();
    }

    @Override
    public void restoreTransformTo(Object geometry) {
        LinkedList list = (LinkedList)geometry;
        Iterator i = list.iterator();
        for (Figure child : this.getChildren()) {
            child.restoreTransformTo(i.next());
        }
        this.invalidate();
    }

    @Override
    public Object getTransformRestoreData() {
        LinkedList<Object> list = new LinkedList<Object>();
        for (Figure child : this.getChildren()) {
            list.add(child.getTransformRestoreData());
        }
        return list;
    }

    @Override
    protected void validate() {
        super.validate();
        this.layout();
    }

    @Override
    public void basicAdd(int index, Figure figure) {
        this.children.add(index, figure);
        figure.addFigureListener(this.eventHandler);
    }

    @Override
    public Figure basicRemoveChild(int index) {
        Figure figure = this.children.remove(index);
        figure.removeFigureListener(this.eventHandler);
        this.invalidate();
        return figure;
    }

    @Override
    public List<Figure> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public Figure getChild(int index) {
        return this.children.get(index);
    }

    @Override
    public AbstractCompositeFigure clone() {
        AbstractCompositeFigure that = (AbstractCompositeFigure)super.clone();
        that.children = new ArrayList();
        that.eventHandler = that.createEventHandler();
        for (Figure thisChild : this.children) {
            Figure thatChild = (Figure)thisChild.clone();
            that.children.add(thatChild);
            thatChild.addFigureListener(that.eventHandler);
        }
        return that;
    }

    @Override
    protected void invalidate() {
        this.cachedBounds = null;
        this.cachedDrawingArea = null;
    }

    @Override
    public int basicRemove(Figure child) {
        int index = this.children.indexOf(child);
        if (index != -1) {
            this.basicRemoveChild(index);
        }
        return index;
    }

    @Override
    public int indexOf(Figure child) {
        return this.children.indexOf(child);
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        if (this.cachedDrawingArea == null) {
            if (this.getChildCount() == 0) {
                this.cachedDrawingArea = new Rectangle2D.Double();
            } else {
                for (Figure f : this.children) {
                    if (this.cachedDrawingArea == null || this.cachedDrawingArea.isEmpty()) {
                        this.cachedDrawingArea = f.getDrawingArea();
                        continue;
                    }
                    this.cachedDrawingArea.add(f.getDrawingArea());
                }
            }
        }
        return (Rectangle2D.Double)this.cachedDrawingArea.clone();
    }

    @Override
    public Rectangle2D.Double getBounds() {
        if (this.cachedBounds == null) {
            if (this.getChildCount() == 0) {
                this.cachedBounds = new Rectangle2D.Double();
            } else {
                for (Figure f : this.children) {
                    if (this.cachedBounds == null || this.cachedBounds.isEmpty()) {
                        this.cachedBounds = f.getBounds();
                        continue;
                    }
                    this.cachedBounds.add(f.getBounds());
                }
            }
        }
        return (Rectangle2D.Double)this.cachedBounds.clone();
    }

    protected void fireFigureAdded(Figure f, int zIndex) {
        CompositeFigureEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CompositeFigureListener.class) continue;
            if (event == null) {
                event = new CompositeFigureEvent(this, f, f.getDrawingArea(), zIndex);
            }
            ((CompositeFigureListener)listeners[i + 1]).figureAdded(event);
        }
    }

    protected void fireFigureRemoved(Figure f, int zIndex) {
        CompositeFigureEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CompositeFigureListener.class) continue;
            if (event == null) {
                event = new CompositeFigureEvent(this, f, f.getDrawingArea(), zIndex);
            }
            ((CompositeFigureListener)listeners[i + 1]).figureRemoved(event);
        }
    }

    @Override
    public void removeCompositeFigureListener(CompositeFigureListener listener) {
        this.listenerList.remove(CompositeFigureListener.class, listener);
    }

    @Override
    public void addCompositeFigureListener(CompositeFigureListener listener) {
        this.listenerList.add(CompositeFigureListener.class, listener);
    }

    protected class EventHandler
    extends FigureAdapter
    implements UndoableEditListener,
    Serializable {
        protected EventHandler() {
        }

        @Override
        public void figureRequestRemove(FigureEvent e) {
            AbstractCompositeFigure.this.remove(e.getFigure());
        }

        @Override
        public void figureChanged(FigureEvent e) {
            Rectangle2D.Double invalidatedArea = AbstractCompositeFigure.this.getDrawingArea();
            invalidatedArea.add(e.getInvalidatedArea());
            AbstractCompositeFigure.this.invalidate();
            AbstractCompositeFigure.this.validate();
            invalidatedArea.add(AbstractCompositeFigure.this.getDrawingArea());
            AbstractCompositeFigure.this.fireFigureChanged(invalidatedArea);
        }

        @Override
        public void areaInvalidated(FigureEvent e) {
            AbstractCompositeFigure.this.fireAreaInvalidated(e);
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            AbstractCompositeFigure.this.fireUndoableEditHappened(e.getEdit());
        }

        @Override
        public void attributeChanged(FigureEvent e) {
            AbstractCompositeFigure.this.invalidate();
        }

        @Override
        public void figureAdded(FigureEvent e) {
            AbstractCompositeFigure.this.invalidate();
        }

        @Override
        public void figureRemoved(FigureEvent e) {
            AbstractCompositeFigure.this.invalidate();
        }
    }
}

