/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.app.EditableComponent;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.CompositeFigureEvent;
import org.jhotdraw.draw.CompositeFigureListener;
import org.jhotdraw.draw.Constrainer;
import org.jhotdraw.draw.DefaultDrawingViewTransferHandler;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureAdapter;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.FigureSelectionListener;
import org.jhotdraw.draw.GridConstrainer;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.HandleEvent;
import org.jhotdraw.draw.HandleListener;
import org.jhotdraw.draw.Options;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.util.ReversedList;

public class DefaultDrawingView
extends JComponent
implements DrawingView,
EditableComponent {
    private static final boolean DEBUG = false;
    private Drawing drawing;
    private Set<Figure> dirtyFigures = new HashSet<Figure>();
    private Set<Figure> selectedFigures = new LinkedHashSet<Figure>();
    private LinkedList<Handle> selectionHandles = new LinkedList();
    private boolean isConstrainerVisible = false;
    private Constrainer visibleConstrainer = new GridConstrainer(8.0, 8.0);
    private Constrainer invisibleConstrainer = new GridConstrainer();
    private Handle secondaryHandleOwner;
    private Handle activeHandle;
    private LinkedList<Handle> secondaryHandles = new LinkedList();
    private boolean handlesAreValid = true;
    private transient Dimension cachedPreferredSize;
    private double scaleFactor = 1.0;
    private Point2D.Double translate = new Point2D.Double(0.0, 0.0);
    private int detailLevel;
    private DrawingEditor editor;
    private JLabel emptyDrawingLabel;
    private FigureListener handleInvalidator = new FigureAdapter(){

        @Override
        public void figureHandlesChanged(FigureEvent e) {
            DefaultDrawingView.this.invalidateHandles();
        }
    };
    private ChangeListener changeHandler = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent evt) {
            DefaultDrawingView.this.repaint();
        }
    };
    private transient Rectangle2D.Double cachedDrawingArea;
    private EventHandler eventHandler;
    protected BufferedImage backgroundTile;
    private ButtonGroup buttonGroup1;

    @Override
    public void repaintHandles() {
        this.validateHandles();
        Rectangle r = null;
        for (Handle h : this.getSelectionHandles()) {
            if (r == null) {
                r = h.getDrawingArea();
                continue;
            }
            r.add(h.getDrawingArea());
        }
        for (Handle h : this.getSecondaryHandles()) {
            if (r == null) {
                r = h.getDrawingArea();
                continue;
            }
            r.add(h.getDrawingArea());
        }
        if (r != null) {
            this.repaint(r);
        }
    }

    public DefaultDrawingView() {
        this.initComponents();
        this.eventHandler = this.createEventHandler();
        this.setToolTipText("dummy");
        this.setFocusable(true);
        this.addFocusListener(this.eventHandler);
        this.setTransferHandler(new DefaultDrawingViewTransferHandler());
    }

    protected EventHandler createEventHandler() {
        return new EventHandler();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.setLayout(null);
        this.setBackground(new Color(255, 255, 255));
    }

    @Override
    public Drawing getDrawing() {
        return this.drawing;
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        if (this.getEditor() != null && this.getEditor().getTool() != null) {
            return this.getEditor().getTool().getToolTipText(this, evt);
        }
        return null;
    }

    public void setEmptyDrawingMessage(String newValue) {
        String oldValue;
        String string = oldValue = this.emptyDrawingLabel == null ? null : this.emptyDrawingLabel.getText();
        if (newValue == null) {
            this.emptyDrawingLabel = null;
        } else {
            this.emptyDrawingLabel = new JLabel(newValue);
            this.emptyDrawingLabel.setHorizontalAlignment(0);
        }
        this.firePropertyChange("emptyDrawingMessage", oldValue, newValue);
        this.repaint();
    }

    public String getEmptyDrawingMessage() {
        return this.emptyDrawingLabel == null ? null : this.emptyDrawingLabel.getText();
    }

    @Override
    public void paintComponent(Graphics gr) {
        Graphics2D g = (Graphics2D)gr;
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, Options.isFractionalMetrics() ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, Options.isTextAntialiased() ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.drawBackground(g);
        this.drawConstrainer(g);
        this.drawDrawing(g);
        this.drawHandles(g);
        this.drawTool(g);
    }

    @Override
    public void printComponent(Graphics gr) {
        Graphics2D g = (Graphics2D)gr;
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, Options.isFractionalMetrics() ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, Options.isTextAntialiased() ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.drawDrawing(g);
    }

    protected void drawBackground(Graphics2D g) {
        Color canvasColor;
        int x = (int)(-this.translate.x * this.scaleFactor);
        int y = (int)(-this.translate.y * this.scaleFactor);
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.drawing == null) {
            canvasColor = this.getBackground();
        } else {
            canvasColor = AttributeKeys.CANVAS_FILL_COLOR.get(this.drawing);
            if (canvasColor != null) {
                canvasColor = new Color(canvasColor.getRGB() & 0xFFFFFF | (int)(AttributeKeys.CANVAS_FILL_OPACITY.get(this.drawing) * 255.0) << 24, true);
            }
        }
        if (canvasColor == null || canvasColor.getAlpha() != 255) {
            g.setPaint(this.getBackgroundPaint(x, y));
            g.fillRect(x, y, w - x, h - y);
        }
        if (canvasColor != null) {
            g.setColor(canvasColor);
            g.fillRect(x, y, w - x, h - y);
        }
        Color outerBackground = new Color(0xF0F0F0);
        if (y > 0) {
            g.setColor(outerBackground);
            g.fillRect(0, 0, w, y);
        }
        if (x > 0) {
            g.setColor(outerBackground);
            g.fillRect(0, y, x, h - y);
        }
        if (this.getDrawing() != null) {
            Double cw = AttributeKeys.CANVAS_WIDTH.get(this.getDrawing());
            Double ch = AttributeKeys.CANVAS_HEIGHT.get(this.getDrawing());
            if (cw != null && ch != null) {
                Point lowerRight = this.drawingToView(new Point2D.Double(cw, ch));
                if (lowerRight.x < w) {
                    g.setColor(outerBackground);
                    g.fillRect(lowerRight.x, y, w - lowerRight.x, h - y);
                }
                if (lowerRight.y < h) {
                    g.setColor(outerBackground);
                    g.fillRect(x, lowerRight.y, w - x, h - lowerRight.y);
                }
            }
        }
    }

    protected void drawConstrainer(Graphics2D g) {
        this.getConstrainer().draw(g, this);
    }

    protected void drawDrawing(Graphics2D gr) {
        if (this.drawing != null) {
            if (this.drawing.getChildCount() == 0 && this.emptyDrawingLabel != null) {
                this.emptyDrawingLabel.setBounds(0, 0, this.getWidth(), this.getHeight());
                this.emptyDrawingLabel.paint(gr);
            } else {
                Graphics2D g = (Graphics2D)gr.create();
                AffineTransform tx = g.getTransform();
                tx.translate(-this.translate.x * this.scaleFactor, -this.translate.y * this.scaleFactor);
                tx.scale(this.scaleFactor, this.scaleFactor);
                g.setTransform(tx);
                this.drawing.setFontRenderContext(g.getFontRenderContext());
                this.drawing.draw(g);
                g.dispose();
            }
        }
    }

    protected void drawHandles(Graphics2D g) {
        if (this.editor != null && this.editor.getActiveView() == this) {
            this.validateHandles();
            for (Handle h : this.getSelectionHandles()) {
                h.draw(g);
            }
            for (Handle h : this.getSecondaryHandles()) {
                h.draw(g);
            }
        }
    }

    protected void drawTool(Graphics2D g) {
        if (this.editor != null && this.editor.getActiveView() == this && this.editor.getTool() != null) {
            this.editor.getTool().draw(g);
        }
    }

    @Override
    public void setDrawing(Drawing newValue) {
        Drawing oldValue = this.drawing;
        if (this.drawing != null) {
            this.drawing.removeCompositeFigureListener(this.eventHandler);
            this.drawing.removeFigureListener(this.eventHandler);
            this.clearSelection();
        }
        this.drawing = newValue;
        if (this.drawing != null) {
            this.drawing.addCompositeFigureListener(this.eventHandler);
            this.drawing.addFigureListener(this.eventHandler);
        }
        this.invalidateDimension();
        if (this.getParent() != null) {
            this.getParent().validate();
            if (this.getParent() instanceof JViewport) {
                JViewport vp = (JViewport)this.getParent();
                Rectangle2D.Double r = this.getDrawingArea();
                vp.setViewPosition(this.drawingToView(new Point2D.Double(Math.min(0.0, -r.x), Math.min(0.0, -r.y))));
            }
        }
        this.firePropertyChange("drawing", oldValue, newValue);
        this.validateViewTranslation();
        this.revalidate();
        this.repaint();
    }

    protected void repaintDrawingArea(Rectangle2D.Double r) {
        Rectangle vr = this.drawingToView(r);
        vr.grow(1, 1);
        this.repaint(vr);
    }

    @Override
    public void invalidate() {
        this.invalidateDimension();
        super.invalidate();
    }

    @Override
    public void addToSelection(Figure figure) {
        HashSet<Figure> oldSelection = new HashSet<Figure>(this.selectedFigures);
        if (this.selectedFigures.add(figure)) {
            figure.addFigureListener(this.handleInvalidator);
            HashSet<Figure> newSelection = new HashSet<Figure>(this.selectedFigures);
            Rectangle invalidatedArea = null;
            if (this.handlesAreValid && this.getEditor() != null) {
                for (Handle h : figure.createHandles(this.detailLevel)) {
                    h.setView(this);
                    this.selectionHandles.add(h);
                    h.addHandleListener(this.eventHandler);
                    if (invalidatedArea == null) {
                        invalidatedArea = h.getDrawingArea();
                        continue;
                    }
                    invalidatedArea.add(h.getDrawingArea());
                }
            }
            this.fireSelectionChanged(oldSelection, newSelection);
            if (invalidatedArea != null) {
                this.repaint(invalidatedArea);
            }
        }
    }

    @Override
    public void addToSelection(Collection<Figure> figures) {
        HashSet<Figure> oldSelection = new HashSet<Figure>(this.selectedFigures);
        HashSet<Figure> newSelection = new HashSet<Figure>(this.selectedFigures);
        boolean selectionChanged = false;
        Rectangle invalidatedArea = null;
        for (Figure figure : figures) {
            if (!this.selectedFigures.add(figure)) continue;
            selectionChanged = true;
            newSelection.add(figure);
            figure.addFigureListener(this.handleInvalidator);
            if (!this.handlesAreValid || this.getEditor() == null) continue;
            for (Handle h : figure.createHandles(this.detailLevel)) {
                h.setView(this);
                this.selectionHandles.add(h);
                h.addHandleListener(this.eventHandler);
                if (invalidatedArea == null) {
                    invalidatedArea = h.getDrawingArea();
                    continue;
                }
                invalidatedArea.add(h.getDrawingArea());
            }
        }
        if (selectionChanged) {
            this.fireSelectionChanged(oldSelection, newSelection);
            if (invalidatedArea != null) {
                this.repaint(invalidatedArea);
            }
        }
    }

    @Override
    public void removeFromSelection(Figure figure) {
        HashSet<Figure> oldSelection = new HashSet<Figure>(this.selectedFigures);
        if (this.selectedFigures.remove(figure)) {
            HashSet<Figure> newSelection = new HashSet<Figure>(this.selectedFigures);
            this.invalidateHandles();
            figure.removeFigureListener(this.handleInvalidator);
            this.fireSelectionChanged(oldSelection, newSelection);
            this.repaint();
        }
    }

    @Override
    public void toggleSelection(Figure figure) {
        if (this.selectedFigures.contains(figure)) {
            this.removeFromSelection(figure);
        } else {
            this.addToSelection(figure);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.setCursor(Cursor.getPredefinedCursor(b ? 0 : 3));
    }

    @Override
    public void selectAll() {
        HashSet<Figure> oldSelection = new HashSet<Figure>(this.selectedFigures);
        this.selectedFigures.clear();
        for (Figure figure : this.drawing.getChildren()) {
            if (!figure.isSelectable()) continue;
            this.selectedFigures.add(figure);
        }
        HashSet<Figure> newSelection = new HashSet<Figure>(this.selectedFigures);
        this.invalidateHandles();
        this.fireSelectionChanged(oldSelection, newSelection);
        this.repaint();
    }

    @Override
    public void clearSelection() {
        if (this.getSelectionCount() > 0) {
            HashSet<Figure> oldSelection = new HashSet<Figure>(this.selectedFigures);
            this.selectedFigures.clear();
            HashSet<Figure> newSelection = new HashSet<Figure>(this.selectedFigures);
            this.invalidateHandles();
            this.fireSelectionChanged(oldSelection, newSelection);
        }
    }

    @Override
    public boolean isFigureSelected(Figure checkFigure) {
        return this.selectedFigures.contains(checkFigure);
    }

    @Override
    public Set<Figure> getSelectedFigures() {
        return Collections.unmodifiableSet(this.selectedFigures);
    }

    @Override
    public int getSelectionCount() {
        return this.selectedFigures.size();
    }

    private List<Handle> getSelectionHandles() {
        this.validateHandles();
        return Collections.unmodifiableList(this.selectionHandles);
    }

    private List<Handle> getSecondaryHandles() {
        this.validateHandles();
        return Collections.unmodifiableList(this.secondaryHandles);
    }

    private void invalidateHandles() {
        if (this.handlesAreValid) {
            this.handlesAreValid = false;
            Rectangle invalidatedArea = null;
            for (Handle handle : this.selectionHandles) {
                handle.removeHandleListener(this.eventHandler);
                if (invalidatedArea == null) {
                    invalidatedArea = handle.getDrawingArea();
                } else {
                    invalidatedArea.add(handle.getDrawingArea());
                }
                handle.dispose();
            }
            for (Handle handle : this.secondaryHandles) {
                handle.removeHandleListener(this.eventHandler);
                if (invalidatedArea == null) {
                    invalidatedArea = handle.getDrawingArea();
                } else {
                    invalidatedArea.add(handle.getDrawingArea());
                }
                handle.dispose();
            }
            this.selectionHandles.clear();
            this.secondaryHandles.clear();
            this.setActiveHandle(null);
            if (invalidatedArea != null) {
                this.repaint(invalidatedArea);
            }
        }
    }

    private void validateHandles() {
        if (!this.handlesAreValid && this.getEditor() != null) {
            this.handlesAreValid = true;
            this.selectionHandles.clear();
            Rectangle invalidatedArea = null;
            int level = this.detailLevel;
            do {
                for (Figure figure : this.getSelectedFigures()) {
                    for (Handle handle : figure.createHandles(level)) {
                        handle.setView(this);
                        this.selectionHandles.add(handle);
                        handle.addHandleListener(this.eventHandler);
                        if (invalidatedArea == null) {
                            invalidatedArea = handle.getDrawingArea();
                            continue;
                        }
                        invalidatedArea.add(handle.getDrawingArea());
                    }
                }
            } while (level-- > 0 && this.selectionHandles.size() == 0);
            this.detailLevel = level + 1;
            if (invalidatedArea != null) {
                this.repaint(invalidatedArea);
            }
        }
    }

    @Override
    public Handle findHandle(Point p) {
        this.validateHandles();
        for (Handle handle : new ReversedList<Handle>(this.getSecondaryHandles())) {
            if (!handle.contains(p)) continue;
            return handle;
        }
        for (Handle handle : new ReversedList<Handle>(this.getSelectionHandles())) {
            if (!handle.contains(p)) continue;
            return handle;
        }
        return null;
    }

    @Override
    public Collection<Handle> getCompatibleHandles(Handle master) {
        this.validateHandles();
        HashSet<Figure> owners = new HashSet<Figure>();
        LinkedList<Handle> compatibleHandles = new LinkedList<Handle>();
        owners.add(master.getOwner());
        compatibleHandles.add(master);
        for (Handle handle : this.getSelectionHandles()) {
            if (owners.contains(handle.getOwner()) || !handle.isCombinableWith(master)) continue;
            owners.add(handle.getOwner());
            compatibleHandles.add(handle);
        }
        return compatibleHandles;
    }

    @Override
    public Figure findFigure(Point p) {
        return this.getDrawing().findFigure(this.viewToDrawing(p));
    }

    @Override
    public Collection<Figure> findFigures(Rectangle r) {
        return this.getDrawing().findFigures(this.viewToDrawing(r));
    }

    @Override
    public Collection<Figure> findFiguresWithin(Rectangle r) {
        return this.getDrawing().findFiguresWithin(this.viewToDrawing(r));
    }

    @Override
    public void addFigureSelectionListener(FigureSelectionListener fsl) {
        this.listenerList.add(FigureSelectionListener.class, fsl);
    }

    @Override
    public void removeFigureSelectionListener(FigureSelectionListener fsl) {
        this.listenerList.remove(FigureSelectionListener.class, fsl);
    }

    protected void fireSelectionChanged(Set<Figure> oldValue, Set<Figure> newValue) {
        if (this.listenerList.getListenerCount() > 0) {
            FigureSelectionEvent event = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != FigureSelectionListener.class) continue;
                if (event == null) {
                    event = new FigureSelectionEvent(this, oldValue, newValue);
                }
                ((FigureSelectionListener)listeners[i + 1]).selectionChanged(event);
            }
        }
    }

    protected void invalidateDimension() {
        this.cachedPreferredSize = null;
        this.cachedDrawingArea = null;
    }

    @Override
    public Constrainer getConstrainer() {
        return this.isConstrainerVisible() ? this.visibleConstrainer : this.invisibleConstrainer;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.cachedPreferredSize == null) {
            Rectangle2D.Double r = this.getDrawingArea();
            Double cw = this.getDrawing() == null ? null : AttributeKeys.CANVAS_WIDTH.get(this.getDrawing());
            Double ch = this.getDrawing() == null ? null : AttributeKeys.CANVAS_HEIGHT.get(this.getDrawing());
            Insets insets = this.getInsets();
            this.cachedPreferredSize = cw == null || ch == null ? new Dimension((int)((Math.max(0.0, r.x) + r.width) * this.scaleFactor) + insets.left + insets.right, (int)((Math.max(0.0, r.y) + r.height) * this.scaleFactor) + insets.top + insets.bottom) : new Dimension((int)(Math.max(Math.max(0.0, r.x) + r.width, cw) * this.scaleFactor) + insets.left + insets.right, (int)(Math.max(Math.max(0.0, r.y) + r.height, ch) * this.scaleFactor) + insets.top + insets.bottom);
            this.validateViewTranslation();
        }
        return (Dimension)this.cachedPreferredSize.clone();
    }

    protected Rectangle2D.Double getDrawingArea() {
        if (this.cachedDrawingArea == null) {
            this.cachedDrawingArea = this.drawing != null ? this.drawing.getDrawingArea() : new Rectangle2D.Double();
        }
        return (Rectangle2D.Double)this.cachedDrawingArea.clone();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.validateViewTranslation();
    }

    private void validateViewTranslation() {
        if (this.getDrawing() == null) {
            this.translate.y = 0.0;
            this.translate.x = 0.0;
            return;
        }
        Point2D.Double oldTranslate = (Point2D.Double)this.translate.clone();
        int width = this.getWidth();
        int height = this.getHeight();
        Insets insets = this.getInsets();
        Rectangle2D.Double r = this.getDrawingArea();
        Double cw = AttributeKeys.CANVAS_WIDTH.get(this.getDrawing());
        Double ch = AttributeKeys.CANVAS_HEIGHT.get(this.getDrawing());
        if (cw == null || ch == null) {
            this.translate.x = Math.min(0.0, r.x);
            this.translate.y = Math.min(0.0, r.y);
        } else {
            Dimension preferred = this.getPreferredSize();
            if (cw != null && ch != null) {
                if (cw * this.scaleFactor < (double)width) {
                    this.translate.x = ((double)width / this.scaleFactor - cw) / -2.0;
                }
                if (ch * this.scaleFactor < (double)height) {
                    this.translate.y = ((double)height / this.scaleFactor - ch) / -2.0;
                }
            }
            if (r.y - this.translate.y < (double)insets.top / this.scaleFactor) {
                this.translate.y = r.y;
            } else if (r.y - this.translate.y + r.height > (double)(height - insets.bottom) / this.scaleFactor) {
                this.translate.y = r.y + r.height - (double)(height - insets.bottom) / this.scaleFactor;
            }
            if (r.x - this.translate.x < (double)insets.left / this.scaleFactor) {
                this.translate.x = r.x;
            } else if (r.x - this.translate.x + r.width > (double)(width - insets.right) / this.scaleFactor) {
                this.translate.x = r.x + r.width - (double)(width - insets.right) / this.scaleFactor;
            }
        }
        if (!oldTranslate.equals(this.translate)) {
            this.fireViewTransformChanged();
            this.repaint();
        }
    }

    @Override
    public Point drawingToView(Point2D.Double p) {
        return new Point((int)((p.x - this.translate.x) * this.scaleFactor), (int)((p.y - this.translate.y) * this.scaleFactor));
    }

    @Override
    public Point2D.Double viewToDrawing(Point p) {
        return new Point2D.Double((double)p.x / this.scaleFactor + this.translate.x, (double)p.y / this.scaleFactor + this.translate.y);
    }

    @Override
    public Rectangle drawingToView(Rectangle2D.Double r) {
        return new Rectangle((int)((r.x - this.translate.x) * this.scaleFactor), (int)((r.y - this.translate.y) * this.scaleFactor), (int)(r.width * this.scaleFactor), (int)(r.height * this.scaleFactor));
    }

    @Override
    public Rectangle2D.Double viewToDrawing(Rectangle r) {
        return new Rectangle2D.Double((double)r.x / this.scaleFactor + this.translate.x, (double)r.y / this.scaleFactor + this.translate.y, (double)r.width / this.scaleFactor, (double)r.height / this.scaleFactor);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public double getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public void setScaleFactor(double newValue) {
        double oldValue = this.scaleFactor;
        this.scaleFactor = newValue;
        this.validateViewTranslation();
        this.firePropertyChange("scaleFactor", oldValue, newValue);
        this.invalidate();
        this.invalidateHandles();
        if (this.getParent() != null) {
            this.getParent().validate();
        }
        this.repaint();
    }

    protected void fireViewTransformChanged() {
        for (Handle handle : this.selectionHandles) {
            handle.viewTransformChanged();
        }
        for (Handle handle : this.secondaryHandles) {
            handle.viewTransformChanged();
        }
    }

    @Override
    public void setHandleDetailLevel(int newValue) {
        if (newValue != this.detailLevel) {
            this.detailLevel = newValue;
            this.invalidateHandles();
            this.validateHandles();
        }
    }

    @Override
    public int getHandleDetailLevel() {
        return this.detailLevel;
    }

    @Override
    public AffineTransform getDrawingToViewTransform() {
        AffineTransform t = new AffineTransform();
        t.scale(this.scaleFactor, this.scaleFactor);
        t.translate(-this.translate.x, -this.translate.y);
        return t;
    }

    @Override
    public void delete() {
        LinkedList deletionEvents = new LinkedList();
        final List<Figure> deletedFigures = this.drawing.sort(this.getSelectedFigures());
        for (Figure f : deletedFigures) {
            if (f.isRemovable()) continue;
            this.getToolkit().beep();
            return;
        }
        final int[] deletedFigureIndices = new int[deletedFigures.size()];
        for (int i = 0; i < deletedFigureIndices.length; ++i) {
            deletedFigureIndices[i] = this.drawing.indexOf(deletedFigures.get(i));
        }
        this.clearSelection();
        this.getDrawing().removeAll(deletedFigures);
        this.getDrawing().fireUndoableEditHappened(new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                return labels.getString("edit.delete.text");
            }

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                DefaultDrawingView.this.clearSelection();
                Drawing d = DefaultDrawingView.this.getDrawing();
                for (int i = 0; i < deletedFigureIndices.length; ++i) {
                    d.add(deletedFigureIndices[i], (Figure)deletedFigures.get(i));
                }
                DefaultDrawingView.this.addToSelection(deletedFigures);
            }

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                for (int i = 0; i < deletedFigureIndices.length; ++i) {
                    DefaultDrawingView.this.drawing.remove((Figure)deletedFigures.get(i));
                }
            }
        });
    }

    @Override
    public void duplicate() {
        List<Figure> sorted = this.getDrawing().sort(this.getSelectedFigures());
        HashMap<Figure, Figure> originalToDuplicateMap = new HashMap<Figure, Figure>(sorted.size());
        this.clearSelection();
        final ArrayList<Figure> duplicates = new ArrayList<Figure>(sorted.size());
        AffineTransform tx = new AffineTransform();
        tx.translate(5.0, 5.0);
        for (Figure f : sorted) {
            Figure d = (Figure)f.clone();
            d.transform(tx);
            duplicates.add(d);
            originalToDuplicateMap.put(f, d);
            this.drawing.add(d);
        }
        for (Figure f : duplicates) {
            f.remap(originalToDuplicateMap, false);
        }
        this.addToSelection(duplicates);
        this.getDrawing().fireUndoableEditHappened(new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                return labels.getString("edit.duplicate.text");
            }

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                DefaultDrawingView.this.getDrawing().removeAll(duplicates);
            }

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                DefaultDrawingView.this.getDrawing().addAll(duplicates);
            }
        });
    }

    @Override
    public void removeNotify(DrawingEditor editor) {
        this.editor = null;
        this.repaint();
    }

    @Override
    public void addNotify(DrawingEditor editor) {
        DrawingEditor oldValue = editor;
        this.editor = editor;
        this.firePropertyChange("editor", oldValue, editor);
        this.invalidateHandles();
        this.repaint();
    }

    @Override
    public void setVisibleConstrainer(Constrainer newValue) {
        Constrainer oldValue = this.visibleConstrainer;
        this.visibleConstrainer = newValue;
        this.firePropertyChange("visibleConstrainer", oldValue, newValue);
    }

    @Override
    public Constrainer getVisibleConstrainer() {
        return this.visibleConstrainer;
    }

    @Override
    public void setInvisibleConstrainer(Constrainer newValue) {
        Constrainer oldValue = this.invisibleConstrainer;
        this.invisibleConstrainer = newValue;
        this.firePropertyChange("invisibleConstrainer", oldValue, newValue);
    }

    @Override
    public Constrainer getInvisibleConstrainer() {
        return this.invisibleConstrainer;
    }

    @Override
    public void setConstrainerVisible(boolean newValue) {
        boolean oldValue = this.isConstrainerVisible;
        this.isConstrainerVisible = newValue;
        this.firePropertyChange("constrainerVisible", oldValue, newValue);
        this.repaint();
    }

    @Override
    public boolean isConstrainerVisible() {
        return this.isConstrainerVisible;
    }

    protected Paint getBackgroundPaint(int x, int y) {
        if (this.backgroundTile == null) {
            this.backgroundTile = new BufferedImage(16, 16, 1);
            Graphics2D g = this.backgroundTile.createGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, 16, 16);
            g.setColor(new Color(0xDFDFDF));
            g.fillRect(0, 0, 8, 8);
            g.fillRect(8, 8, 8, 8);
            g.dispose();
        }
        return new TexturePaint(this.backgroundTile, new Rectangle(x, y, this.backgroundTile.getWidth(), this.backgroundTile.getHeight()));
    }

    @Override
    public DrawingEditor getEditor() {
        return this.editor;
    }

    @Override
    public void setActiveHandle(Handle newValue) {
        Handle oldValue = this.activeHandle;
        if (oldValue != null) {
            this.repaint(oldValue.getDrawingArea());
        }
        this.activeHandle = newValue;
        if (newValue != null) {
            this.repaint(newValue.getDrawingArea());
        }
        this.firePropertyChange("activeHandle", oldValue, newValue);
    }

    @Override
    public Handle getActiveHandle() {
        return this.activeHandle;
    }

    private class EventHandler
    implements FigureListener,
    CompositeFigureListener,
    HandleListener,
    FocusListener {
        private EventHandler() {
        }

        @Override
        public void figureAdded(CompositeFigureEvent evt) {
            if (DefaultDrawingView.this.drawing.getChildCount() == 1 && DefaultDrawingView.this.getEmptyDrawingMessage() != null) {
                DefaultDrawingView.this.repaint();
            } else {
                DefaultDrawingView.this.repaintDrawingArea(evt.getInvalidatedArea());
            }
            DefaultDrawingView.this.invalidateDimension();
        }

        @Override
        public void figureRemoved(CompositeFigureEvent evt) {
            if (DefaultDrawingView.this.drawing.getChildCount() == 0 && DefaultDrawingView.this.getEmptyDrawingMessage() != null) {
                DefaultDrawingView.this.repaint();
            } else {
                DefaultDrawingView.this.repaintDrawingArea(evt.getInvalidatedArea());
            }
            DefaultDrawingView.this.removeFromSelection(evt.getChildFigure());
            DefaultDrawingView.this.invalidateDimension();
        }

        @Override
        public void areaInvalidated(FigureEvent evt) {
            DefaultDrawingView.this.repaintDrawingArea(evt.getInvalidatedArea());
            DefaultDrawingView.this.invalidateDimension();
        }

        @Override
        public void areaInvalidated(HandleEvent evt) {
            DefaultDrawingView.this.repaint(evt.getInvalidatedArea());
            DefaultDrawingView.this.invalidateDimension();
        }

        @Override
        public void handleRequestSecondaryHandles(HandleEvent e) {
            DefaultDrawingView.this.secondaryHandleOwner = e.getHandle();
            DefaultDrawingView.this.secondaryHandles.clear();
            DefaultDrawingView.this.secondaryHandles.addAll(DefaultDrawingView.this.secondaryHandleOwner.createSecondaryHandles());
            for (Handle h : DefaultDrawingView.this.secondaryHandles) {
                h.setView(DefaultDrawingView.this);
                h.addHandleListener(DefaultDrawingView.this.eventHandler);
            }
            DefaultDrawingView.this.repaint();
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (DefaultDrawingView.this.editor != null) {
                DefaultDrawingView.this.editor.setActiveView(DefaultDrawingView.this);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void handleRequestRemove(HandleEvent e) {
            DefaultDrawingView.this.selectionHandles.remove(e.getHandle());
            e.getHandle().dispose();
            DefaultDrawingView.this.invalidateHandles();
            DefaultDrawingView.this.repaint(e.getInvalidatedArea());
        }

        @Override
        public void attributeChanged(FigureEvent e) {
            if (e.getSource() == DefaultDrawingView.this.drawing) {
                if (e.getAttribute().equals(AttributeKeys.CANVAS_HEIGHT) || e.getAttribute().equals(AttributeKeys.CANVAS_WIDTH)) {
                    DefaultDrawingView.this.validateViewTranslation();
                }
                DefaultDrawingView.this.repaint();
            } else {
                DefaultDrawingView.this.repaintDrawingArea(e.getInvalidatedArea());
            }
        }

        @Override
        public void figureHandlesChanged(FigureEvent e) {
        }

        @Override
        public void figureChanged(FigureEvent e) {
            DefaultDrawingView.this.repaintDrawingArea(e.getInvalidatedArea());
        }

        @Override
        public void figureAdded(FigureEvent e) {
        }

        @Override
        public void figureRemoved(FigureEvent e) {
        }

        @Override
        public void figureRequestRemove(FigureEvent e) {
        }
    }
}

