/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.LinkedList;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.SelectAreaTracker;

public class DefaultSelectAreaTracker
extends AbstractTool
implements SelectAreaTracker {
    private Rectangle rubberband = new Rectangle();
    private Color rubberbandColor = Color.BLACK;
    private Stroke rubberbandStroke = new BasicStroke();
    private LinkedList<Handle> hoverHandles = new LinkedList();
    private Figure hoverFigure = null;

    @Override
    public void mousePressed(MouseEvent evt) {
        super.mousePressed(evt);
        this.clearRubberBand();
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.selectGroup(evt.isShiftDown());
        this.clearRubberBand();
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        Rectangle invalidatedArea = (Rectangle)this.rubberband.clone();
        this.rubberband.setBounds(Math.min(this.anchor.x, evt.getX()), Math.min(this.anchor.y, evt.getY()), Math.abs(this.anchor.x - evt.getX()), Math.abs(this.anchor.y - evt.getY()));
        invalidatedArea = invalidatedArea.isEmpty() ? (Rectangle)this.rubberband.clone() : invalidatedArea.union(this.rubberband);
        this.fireAreaInvalidated(invalidatedArea);
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.clearRubberBand();
        Point point = evt.getPoint();
        DrawingView view = this.editor.findView((Container)evt.getSource());
        this.updateCursor(view, point);
        if (view == null || this.editor.getActiveView() != view) {
            this.clearHoverHandles();
        } else {
            Figure figure = null;
            Point2D.Double p = view.viewToDrawing(point);
            for (Figure f : view.getSelectedFigures()) {
                if (!f.contains(p)) continue;
                figure = f;
            }
            if (figure == null) {
                figure = view.findFigure(point);
                while (figure != null && !figure.isSelectable()) {
                    figure = view.getDrawing().findFigureBehind(p, figure);
                }
            }
            this.updateHoverHandles(view, figure);
        }
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        DrawingView view = this.editor.findView((Container)evt.getSource());
        this.updateHoverHandles(view, null);
    }

    private void clearRubberBand() {
        if (!this.rubberband.isEmpty()) {
            this.fireAreaInvalidated(this.rubberband);
            this.rubberband.width = -1;
        }
    }

    @Override
    public void draw(Graphics2D g) {
        g.setStroke(this.rubberbandStroke);
        g.setColor(this.rubberbandColor);
        g.drawRect(this.rubberband.x, this.rubberband.y, this.rubberband.width - 1, this.rubberband.height - 1);
        if (this.hoverHandles.size() > 0 && !this.getView().isFigureSelected(this.hoverFigure)) {
            for (Handle h : this.hoverHandles) {
                h.draw(g);
            }
        }
    }

    private void selectGroup(boolean toggle) {
        Collection<Figure> figures = this.getView().findFiguresWithin(this.rubberband);
        for (Figure f : figures) {
            if (!f.isSelectable()) continue;
            this.getView().addToSelection(f);
        }
    }

    protected void clearHoverHandles() {
        this.updateHoverHandles(null, null);
    }

    protected void updateHoverHandles(DrawingView view, Figure f) {
        if (f != this.hoverFigure) {
            Rectangle r = null;
            if (this.hoverFigure != null) {
                for (Handle h : this.hoverHandles) {
                    if (r == null) {
                        r = h.getDrawingArea();
                    } else {
                        r.add(h.getDrawingArea());
                    }
                    h.setView(null);
                    h.dispose();
                }
                this.hoverHandles.clear();
            }
            this.hoverFigure = f;
            if (this.hoverFigure != null && f.isSelectable()) {
                this.hoverHandles.addAll(this.hoverFigure.createHandles(-1));
                for (Handle h : this.hoverHandles) {
                    h.setView(view);
                    if (r == null) {
                        r = h.getDrawingArea();
                        continue;
                    }
                    r.add(h.getDrawingArea());
                }
            }
            if (r != null) {
                r.grow(1, 1);
                this.fireAreaInvalidated(r);
            }
        }
    }

    @Override
    public void activate(DrawingEditor editor) {
        super.activate(editor);
        this.clearHoverHandles();
    }

    @Override
    public void deactivate(DrawingEditor editor) {
        super.deactivate(editor);
        this.clearHoverHandles();
    }
}

