/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.CreationTool;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.ImageHolderFigure;
import org.jhotdraw.gui.Worker;

public class ImageTool
extends CreationTool {
    protected FileDialog fileDialog;
    protected JFileChooser fileChooser;
    protected boolean useFileDialog;
    protected Thread workerThread;

    public ImageTool(ImageHolderFigure prototype) {
        super(prototype);
    }

    public ImageTool(ImageHolderFigure prototype, Map<AttributeKey, Object> attributes) {
        super(prototype, attributes);
    }

    public void setUseFileDialog(boolean newValue) {
        this.useFileDialog = newValue;
        if (this.useFileDialog) {
            this.fileChooser = null;
        } else {
            this.fileDialog = null;
        }
    }

    public boolean isUseFileDialog() {
        return this.useFileDialog;
    }

    @Override
    public void activate(DrawingEditor editor) {
        File file;
        super.activate(editor);
        if (this.workerThread != null) {
            try {
                this.workerThread.join();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        if (this.useFileDialog) {
            this.getFileDialog().setVisible(true);
            file = this.getFileDialog().getFile() != null ? new File(this.getFileDialog().getDirectory(), this.getFileDialog().getFile()) : null;
        } else {
            file = this.getFileChooser().showOpenDialog(this.getView().getComponent()) == 0 ? this.getFileChooser().getSelectedFile() : null;
        }
        if (file != null) {
            final ImageHolderFigure loaderFigure = (ImageHolderFigure)this.prototype.clone();
            Worker worker = new Worker(){

                @Override
                public Object construct() {
                    try {
                        loaderFigure.loadImage(file);
                    }
                    catch (Throwable t) {
                        return t;
                    }
                    return null;
                }

                @Override
                public void finished(Object value) {
                    if (value instanceof Throwable) {
                        Throwable t = (Throwable)value;
                        JOptionPane.showMessageDialog(ImageTool.this.getView().getComponent(), t.getMessage(), null, 0);
                        ImageTool.this.getDrawing().remove(ImageTool.this.createdFigure);
                        ImageTool.this.fireToolDone();
                    } else {
                        try {
                            if (ImageTool.this.createdFigure == null) {
                                ((ImageHolderFigure)ImageTool.this.prototype).setImage(loaderFigure.getImageData(), loaderFigure.getBufferedImage());
                            } else {
                                ((ImageHolderFigure)ImageTool.this.createdFigure).setImage(loaderFigure.getImageData(), loaderFigure.getBufferedImage());
                            }
                        }
                        catch (IOException ex) {
                            JOptionPane.showMessageDialog(ImageTool.this.getView().getComponent(), ex.getMessage(), null, 0);
                        }
                    }
                }
            };
            this.workerThread = new Thread(worker);
            this.workerThread.start();
        } else if (this.isToolDoneAfterCreation()) {
            this.fireToolDone();
        }
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
        }
        return this.fileChooser;
    }

    private FileDialog getFileDialog() {
        if (this.fileDialog == null) {
            this.fileDialog = new FileDialog(new Frame());
        }
        return this.fileDialog;
    }
}

