/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.geom.GeneralPath;
import org.jhotdraw.draw.AbstractLineDecoration;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
import org.jhotdraw.xml.DOMStorable;

public class PerpendicularBar
extends AbstractLineDecoration
implements DOMStorable {
    private double height;

    public PerpendicularBar() {
        this(10.0);
    }

    public PerpendicularBar(double height) {
        super(false, true, false);
        this.height = height;
    }

    @Override
    protected GeneralPath getDecoratorPath(Figure f) {
        GeneralPath path = new GeneralPath();
        double halfHeight = this.height / 2.0;
        path.moveTo((float)halfHeight, 0.0f);
        path.lineTo((float)(-halfHeight), 0.0f);
        return path;
    }

    @Override
    protected double getDecoratorPathRadius(Figure f) {
        return 0.5;
    }

    @Override
    public void read(DOMInput in) {
        this.height = in.getAttribute("height", 10);
    }

    @Override
    public void write(DOMOutput out) {
        out.addAttribute("height", this.height);
    }
}

