/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.geom.Point2D;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.HandleAttributeKeys;
import org.jhotdraw.draw.RoundRectangleFigure;
import org.jhotdraw.draw.RoundRectangleRadiusUndoableEdit;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.undo.CompositeEdit;
import org.jhotdraw.util.ResourceBundleUtil;

public class RoundRectangleRadiusHandle
extends AbstractHandle {
    private static final int OFFSET = 6;
    private Point originalArc;
    CompositeEdit edit;

    public RoundRectangleRadiusHandle(Figure owner) {
        super(owner);
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.getEditor().getTool().supportsHandleInteraction()) {
            this.drawDiamond(g, this.getEditor().getHandleAttribute(HandleAttributeKeys.ATTRIBUTE_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.ATTRIBUTE_HANDLE_STROKE_COLOR));
        } else {
            this.drawDiamond(g, this.getEditor().getHandleAttribute(HandleAttributeKeys.ATTRIBUTE_HANDLE_FILL_COLOR_DISABLED), this.getEditor().getHandleAttribute(HandleAttributeKeys.ATTRIBUTE_HANDLE_STROKE_COLOR_DISABLED));
        }
    }

    @Override
    protected Rectangle basicGetBounds() {
        Rectangle r = new Rectangle(this.locate());
        int h = this.getHandlesize();
        r.x -= h / 2;
        r.y -= h / 2;
        r.width = r.height = h;
        return r;
    }

    private Point locate() {
        RoundRectangleFigure owner = (RoundRectangleFigure)this.getOwner();
        Rectangle r = this.view.drawingToView(owner.getBounds());
        Point arc = this.view.drawingToView(new Point2D.Double(owner.getArcWidth(), owner.getArcHeight()));
        return new Point(r.x + arc.x / 2 + 6, r.y + arc.y / 2 + 6);
    }

    @Override
    public void trackStart(Point anchor, int modifiersEx) {
        RoundRectangleFigure owner = (RoundRectangleFigure)this.getOwner();
        this.originalArc = this.view.drawingToView(new Point2D.Double(owner.getArcWidth(), owner.getArcHeight()));
    }

    @Override
    public void trackStep(Point anchor, Point lead, int modifiersEx) {
        int dx = lead.x - anchor.x;
        int dy = lead.y - anchor.y;
        RoundRectangleFigure owner = (RoundRectangleFigure)this.getOwner();
        Rectangle r = this.view.drawingToView(owner.getBounds());
        Point viewArc = new Point(Geom.range(0, r.width, 2 * (this.originalArc.x / 2 + dx)), Geom.range(0, r.height, 2 * (this.originalArc.y / 2 + dy)));
        Point2D.Double arc = this.view.viewToDrawing(viewArc);
        owner.willChange();
        owner.setArc(arc.x, arc.y);
        owner.changed();
    }

    @Override
    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
        int dx = lead.x - anchor.x;
        int dy = lead.y - anchor.y;
        RoundRectangleFigure owner = (RoundRectangleFigure)this.getOwner();
        Rectangle r = this.view.drawingToView(owner.getBounds());
        Point viewArc = new Point(Geom.range(0, r.width, 2 * (this.originalArc.x / 2 + dx)), Geom.range(0, r.height, 2 * (this.originalArc.y / 2 + dy)));
        Point2D.Double oldArc = this.view.viewToDrawing(this.originalArc);
        Point2D.Double newArc = this.view.viewToDrawing(viewArc);
        this.fireUndoableEditHappened(new RoundRectangleRadiusUndoableEdit(owner, oldArc, newArc));
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        RoundRectangleFigure owner = (RoundRectangleFigure)this.getOwner();
        Point2D.Double oldArc = new Point2D.Double(owner.getArcWidth(), owner.getArcHeight());
        Point2D.Double newArc = new Point2D.Double(owner.getArcWidth(), owner.getArcHeight());
        switch (evt.getKeyCode()) {
            case 38: {
                if (newArc.y > 0.0) {
                    newArc.y = Math.max(0.0, newArc.y - 1.0);
                }
                evt.consume();
                break;
            }
            case 40: {
                newArc.y += 1.0;
                evt.consume();
                break;
            }
            case 37: {
                if (newArc.x > 0.0) {
                    newArc.x = Math.max(0.0, newArc.x - 1.0);
                }
                evt.consume();
                break;
            }
            case 39: {
                newArc.x += 1.0;
                evt.consume();
            }
        }
        if (!newArc.equals(oldArc)) {
            owner.willChange();
            owner.setArc(newArc.x, newArc.y);
            owner.changed();
            this.fireUndoableEditHappened(new RoundRectangleRadiusUndoableEdit(owner, oldArc, newArc));
        }
    }

    @Override
    public String getToolTipText(Point p) {
        return ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels").getString("handle.roundRectangleRadius.toolTipText");
    }
}

