/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.text.JTextComponent;
import javax.swing.undo.AbstractUndoableEdit;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.util.ResourceBundleUtil;

public class AttributeToggler<T>
extends AbstractAction {
    private DrawingEditor editor;
    private AttributeKey<T> key;
    private T value1;
    private T value2;
    private Action compatibleTextAction;

    public AttributeToggler(DrawingEditor editor, AttributeKey<T> key, T value1, T value2) {
        this(editor, key, value1, value2, null);
    }

    public AttributeToggler(DrawingEditor editor, AttributeKey<T> key, T value1, T value2, Action compatibleTextAction) {
        this.editor = editor;
        this.key = key;
        this.value1 = value1;
        this.value2 = value2;
        this.compatibleTextAction = compatibleTextAction;
    }

    public DrawingView getView() {
        return this.editor.getActiveView();
    }

    public DrawingEditor getEditor() {
        return this.editor;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Component focusOwner;
        if (this.compatibleTextAction != null && (focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner()) != null && focusOwner instanceof JTextComponent) {
            this.compatibleTextAction.actionPerformed(evt);
            return;
        }
        Iterator<Figure> i = this.getView().getSelectedFigures().iterator();
        T toggleValue = this.value1;
        if (i.hasNext()) {
            Figure f = i.next();
            T attr = this.key.get(f);
            if (this.value1 == null && attr == null || this.value1 != null && attr != null && attr.equals(this.value1)) {
                toggleValue = this.value2;
            }
        }
        final T newValue = toggleValue;
        final ArrayList<Figure> selectedFigures = new ArrayList<Figure>(this.getView().getSelectedFigures());
        final ArrayList<Object> restoreData = new ArrayList<Object>(selectedFigures.size());
        for (Figure figure : selectedFigures) {
            restoreData.add(figure.getAttributesRestoreData());
            this.key.set(figure, newValue);
        }
        AbstractUndoableEdit edit = new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                String name = (String)AttributeToggler.this.getValue("undoPresentationName");
                if (name == null) {
                    name = (String)AttributeToggler.this.getValue("Name");
                }
                if (name == null) {
                    ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                    name = labels.getString("attribute.text");
                }
                return name;
            }

            @Override
            public void undo() {
                super.undo();
                Iterator iRestore = restoreData.iterator();
                for (Figure figure : selectedFigures) {
                    figure.willChange();
                    figure.restoreAttributesTo(iRestore.next());
                    figure.changed();
                }
            }

            @Override
            public void redo() {
                super.redo();
                for (Figure figure : selectedFigures) {
                    restoreData.add(figure.getAttributesRestoreData());
                    AttributeToggler.this.key.set(figure, newValue);
                }
            }
        };
        this.getView().getDrawing().fireUndoableEditHappened(edit);
    }
}

