/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.draw.action.SendToBackAction;

public class BringToFrontAction
extends AbstractSelectedAction {
    public static String ID = "edit.bringToFront";

    public BringToFrontAction(DrawingEditor editor) {
        super(editor);
        this.labels.configureAction(this, ID);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final DrawingView view = this.getView();
        final LinkedList<Figure> figures = new LinkedList<Figure>(view.getSelectedFigures());
        BringToFrontAction.bringToFront(view, figures);
        this.fireUndoableEditHappened(new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                return BringToFrontAction.this.labels.getTextProperty(ID);
            }

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                BringToFrontAction.bringToFront(view, figures);
            }

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                SendToBackAction.sendToBack(view, figures);
            }
        });
    }

    public static void bringToFront(DrawingView view, Collection<Figure> figures) {
        Drawing drawing = view.getDrawing();
        for (Figure figure : drawing.sort(figures)) {
            drawing.bringToFront(figure);
        }
    }
}

