/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.odg.figures;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.ResizeHandleKit;
import org.jhotdraw.draw.TransformHandleKit;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.samples.odg.Gradient;
import org.jhotdraw.samples.odg.ODGAttributeKeys;
import org.jhotdraw.samples.odg.figures.ODGAttributedFigure;
import org.jhotdraw.samples.odg.figures.ODGFigure;

public class ODGEllipseFigure
extends ODGAttributedFigure
implements ODGFigure {
    private Ellipse2D.Double ellipse;
    private transient Shape cachedTransformedShape;

    public ODGEllipseFigure() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public ODGEllipseFigure(double x, double y, double width, double height) {
        this.ellipse = new Ellipse2D.Double(x, y, width, height);
        ODGAttributeKeys.setDefaults(this);
    }

    @Override
    protected void drawFill(Graphics2D g) {
        g.fill(this.ellipse);
    }

    @Override
    protected void drawStroke(Graphics2D g) {
        g.draw(this.ellipse);
    }

    public double getX() {
        return this.ellipse.x;
    }

    public double getY() {
        return this.ellipse.y;
    }

    public double getWidth() {
        return this.ellipse.getWidth();
    }

    public double getHeight() {
        return this.ellipse.getHeight();
    }

    @Override
    public Rectangle2D.Double getBounds() {
        return (Rectangle2D.Double)this.ellipse.getBounds2D();
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double r;
        Rectangle2D rx = this.getTransformedShape().getBounds2D();
        Rectangle2D.Double double_ = r = rx instanceof Rectangle2D.Double ? (Rectangle2D.Double)rx : new Rectangle2D.Double(rx.getX(), rx.getY(), rx.getWidth(), rx.getHeight());
        if (ODGAttributeKeys.TRANSFORM.get(this) == null) {
            double g = ODGAttributeKeys.getPerpendicularHitGrowth(this) * 2.0;
            Geom.grow(r, g, g);
        } else {
            double strokeTotalWidth = AttributeKeys.getStrokeTotalWidth(this);
            double width = strokeTotalWidth / 2.0;
            Geom.grow(r, width *= Math.max(((AffineTransform)ODGAttributeKeys.TRANSFORM.get(this)).getScaleX(), ((AffineTransform)ODGAttributeKeys.TRANSFORM.get(this)).getScaleY()), width);
        }
        return r;
    }

    @Override
    public boolean contains(Point2D.Double p) {
        return this.getTransformedShape().contains(p);
    }

    private Shape getTransformedShape() {
        if (this.cachedTransformedShape == null) {
            this.cachedTransformedShape = ODGAttributeKeys.TRANSFORM.get(this) == null ? this.ellipse : ((AffineTransform)ODGAttributeKeys.TRANSFORM.get(this)).createTransformedShape(this.ellipse);
        }
        return this.cachedTransformedShape;
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        this.ellipse.x = Math.min(anchor.x, lead.x);
        this.ellipse.y = Math.min(anchor.y, lead.y);
        this.ellipse.width = Math.max(0.1, Math.abs(lead.x - anchor.x));
        this.ellipse.height = Math.max(0.1, Math.abs(lead.y - anchor.y));
    }

    @Override
    public void transform(AffineTransform tx) {
        if (ODGAttributeKeys.TRANSFORM.get(this) != null || (tx.getType() & 1) != tx.getType()) {
            if (ODGAttributeKeys.TRANSFORM.get(this) == null) {
                ODGAttributeKeys.TRANSFORM.basicSetClone(this, tx);
            } else {
                AffineTransform t = (AffineTransform)ODGAttributeKeys.TRANSFORM.getClone(this);
                t.preConcatenate(tx);
                ODGAttributeKeys.TRANSFORM.basicSet(this, t);
            }
        } else {
            Gradient g;
            Point2D.Double anchor = this.getStartPoint();
            Point2D.Double lead = this.getEndPoint();
            this.setBounds((Point2D.Double)tx.transform(anchor, anchor), (Point2D.Double)tx.transform(lead, lead));
            if (ODGAttributeKeys.FILL_GRADIENT.get(this) != null && !ODGAttributeKeys.FILL_GRADIENT.get(this).isRelativeToFigureBounds()) {
                g = ODGAttributeKeys.FILL_GRADIENT.getClone(this);
                g.transform(tx);
                ODGAttributeKeys.FILL_GRADIENT.basicSet(this, g);
            }
            if (ODGAttributeKeys.STROKE_GRADIENT.get(this) != null && !ODGAttributeKeys.STROKE_GRADIENT.get(this).isRelativeToFigureBounds()) {
                g = ODGAttributeKeys.STROKE_GRADIENT.getClone(this);
                g.transform(tx);
                ODGAttributeKeys.STROKE_GRADIENT.basicSet(this, g);
            }
        }
        this.invalidate();
    }

    @Override
    public void restoreTransformTo(Object geometry) {
        Object[] restoreData = (Object[])geometry;
        this.ellipse = (Ellipse2D.Double)((Ellipse2D.Double)restoreData[0]).clone();
        ODGAttributeKeys.TRANSFORM.basicSetClone(this, (AffineTransform)restoreData[1]);
        ODGAttributeKeys.FILL_GRADIENT.basicSetClone(this, (Gradient)restoreData[2]);
        ODGAttributeKeys.STROKE_GRADIENT.basicSetClone(this, (Gradient)restoreData[3]);
        this.invalidate();
    }

    @Override
    public Object getTransformRestoreData() {
        return new Object[]{this.ellipse.clone(), ODGAttributeKeys.TRANSFORM.getClone(this), ODGAttributeKeys.FILL_GRADIENT.getClone(this), ODGAttributeKeys.STROKE_GRADIENT.getClone(this)};
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        switch (detailLevel % 2) {
            case 0: {
                ResizeHandleKit.addResizeHandles(this, handles);
                break;
            }
            case 1: {
                TransformHandleKit.addTransformHandles(this, handles);
                break;
            }
        }
        return handles;
    }

    @Override
    public boolean canConnect() {
        return false;
    }

    @Override
    public Connector findConnector(Point2D.Double p, ConnectionFigure prototype) {
        return null;
    }

    @Override
    public Connector findCompatibleConnector(Connector c, boolean isStartConnector) {
        return null;
    }

    @Override
    public ODGEllipseFigure clone() {
        ODGEllipseFigure that = (ODGEllipseFigure)super.clone();
        that.ellipse = (Ellipse2D.Double)this.ellipse.clone();
        that.cachedTransformedShape = null;
        return that;
    }

    @Override
    public boolean isEmpty() {
        Rectangle2D.Double b = this.getBounds();
        return b.width <= 0.0 || b.height <= 0.0;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.cachedTransformedShape = null;
    }
}

