/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class AccountEditorPane
extends JPanel {
    PLCash parent;
    Account account;
    boolean newAccount = false;
    boolean dataChanged = false;
    int index = 0;
    private JTextField balanceTextField;
    private JButton beginButton;
    private JButton cancelButton;
    private JTextField checkNumberTextField;
    private JButton closeButton;
    private JButton commitButton;
    private JTextField creditLimitTextField;
    private JButton deleteButton;
    private JTextField descriptionTextField;
    private JButton endButton;
    private JTextField fileNameTextField;
    private JCheckBox includeTotalInListCheckBox;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JTextField nameTextField;
    private JButton newButton;
    private JButton nextButton;
    private JCheckBox oneLineModeCheckBox;
    private JButton previousButton;
    private JTextField priceDateTextField;
    private JTextField recentPriceTextField;
    private JTextField recordNumTextField;
    private JButton renameButton;
    private JComboBox securityComboBox;
    private JTextField shareBalanceTextField;
    private JCheckBox showInListCheckBox;
    private JTextField statementBalanceDateTextField;
    private JTextField statementBalanceTextField;
    private JTextField subTypeTextField;
    private JTextField transactionsTextField;
    private JComboBox typeComboBox;

    public AccountEditorPane(PLCash pLCash) {
        this.parent = pLCash;
        this.initComponents();
        this.refreshLists();
        this.dataChanged = false;
    }

    public void refreshLists() {
        this.securityComboBox.removeAllItems();
        this.securityComboBox.addItem("");
        this.parent.securityHandler.setupComboBox(this.securityComboBox, "");
    }

    public void loadForm(int n) {
        this.index = n;
        this.account = this.parent.accountPanel.getAccount(n);
        this.newAccount = this.account == null;
        this.setupForm();
    }

    private void setupForm() {
        this.parent.commonCode.loadComboBox(this.typeComboBox, Account.accountName, 6, 0);
        if (!this.newAccount) {
            this.nameTextField.setEnabled(false);
            this.typeComboBox.setEnabled(false);
            this.subTypeTextField.setEnabled(false);
        } else {
            this.nameTextField.setEnabled(true);
            this.typeComboBox.setEnabled(true);
            this.subTypeTextField.setEnabled(true);
            this.account = new Account(this.parent);
            this.account.type = 0;
        }
        this.nameTextField.setText(this.account.db_Name);
        this.typeComboBox.setSelectedIndex(this.account.type);
        this.fileNameTextField.setText(this.account.db_FileName);
        this.subTypeTextField.setText(this.account.db_SubType);
        this.checkNumberTextField.setText(String.valueOf(this.account.db_CheckNumber));
        this.transactionsTextField.setText(String.valueOf(this.account.db_Transactions));
        this.descriptionTextField.setText(this.account.db_Description);
        this.securityComboBox.setSelectedItem(this.account.db_Security);
        this.creditLimitTextField.setText(this.parent.commonCode.getCurrencyDollarCentString(this.account.db_CreditLimit, false));
        this.oneLineModeCheckBox.setSelected(this.account.db_OneLineMode);
        this.showInListCheckBox.setSelected(this.account.db_ShowInList);
        this.includeTotalInListCheckBox.setSelected(this.account.db_IncludeTotalInList);
        this.shareBalanceTextField.setText(this.parent.commonCode.getCurrencyDollarCentString(this.account.db_ShareBalance, true));
        this.recentPriceTextField.setText(this.parent.commonCode.getCurrencyDollarCentString(this.account.db_MostRecentPrice, false));
        this.priceDateTextField.setText(this.parent.commonCode.displayDateForTime(this.account.db_MostRecentPriceDate));
        this.balanceTextField.setText(this.parent.commonCode.getCurrencyDollarCentString(this.account.db_Balance, false));
        this.statementBalanceDateTextField.setText(this.parent.commonCode.displayDateForTime(this.account.db_StatementBalanceDate));
        this.statementBalanceTextField.setText(this.parent.commonCode.getCurrencyDollarCentString(this.account.db_StatementBalance, false));
        this.setChanged(false);
        this.showCount();
    }

    private void showCount() {
        String string = "";
        int n = this.parent.accountPanel.getListSize();
        string = this.index >= n || n == 0 ? "New account" : this.index + 1 + " of " + n + " accounts";
        this.recordNumTextField.setText(string);
    }

    private void commit() {
        this.account.db_Name = this.nameTextField.getText().trim();
        if (this.newAccount) {
            if (this.account.db_Name.trim().length() == 0) {
                JOptionPane.showMessageDialog(this.parent, "Please enter an account name.", "No Account Name", 2);
                return;
            }
            if (this.parent.accountHandler.getAccountByName(this.account.db_Name) != null) {
                JOptionPane.showMessageDialog(this.parent, "The account name you have chosen\nis already in use. Please choose a\ndifferent name.", "Duplicate Account Names", 2);
                return;
            }
        }
        this.account.type = this.typeComboBox.getSelectedIndex();
        this.account.setType(this.account.type);
        this.account.db_FileName = Account.createAccountFileName(this.account.type, this.account.db_Name);
        this.account.db_SubType = this.subTypeTextField.getText();
        this.account.db_CheckNumber = this.parent.commonCode.zeroFailParseInteger(this.checkNumberTextField.getText());
        this.account.db_Transactions = this.parent.commonCode.zeroFailParseInteger(this.transactionsTextField.getText());
        this.account.db_Description = this.descriptionTextField.getText();
        this.account.db_Security = (String)this.securityComboBox.getSelectedItem();
        this.account.db_CreditLimit = this.parent.commonCode.zeroFailParseDouble(this.creditLimitTextField.getText());
        this.account.db_OneLineMode = this.oneLineModeCheckBox.isSelected();
        this.account.db_ShowInList = this.showInListCheckBox.isSelected();
        this.account.db_IncludeTotalInList = this.includeTotalInListCheckBox.isSelected();
        this.account.db_StatementBalanceDate = this.parent.commonCode.timeForDisplayDateLenient(this.statementBalanceDateTextField.getText());
        this.account.db_StatementBalance = this.parent.commonCode.zeroFailParseDouble(this.statementBalanceTextField.getText());
        if (this.newAccount) {
            this.parent.accountHandler.addAccount(this.account, this.parent.programValues.db_DataFilePath);
            this.account.setDataChanged();
        }
        this.parent.accountPanel.setupTable();
        this.parent.accountPanel.scrollToRow(this.index, true);
        int n = this.parent.accountPanel.indexForAccount(this.account);
        if (n < 0) {
            if (this.index >= 0 && this.index < this.parent.accountPanel.getListSize()) {
                n = this.index;
            } else if (this.index >= this.parent.accountPanel.getListSize()) {
                n = this.index - 1;
            } else {
                this.dataChanged = false;
                this.closeThisWindow();
            }
        }
        this.loadForm(n);
    }

    private void setChanged(boolean bl) {
        this.dataChanged = bl;
        this.commitButton.setEnabled(bl);
        this.cancelButton.setEnabled(bl);
    }

    private void cancel() {
        int n = JOptionPane.showConfirmDialog(this.parent, "Discard Changes?", "Account Changed", 2);
        if (n == 0) {
            this.loadForm(this.parent.accountPanel.indexForAccount(this.account));
        }
    }

    public boolean checkChanged() {
        boolean bl = false;
        if (this.dataChanged) {
            Object[] objectArray = new String[]{"Save", "Discard", "Cancel"};
            int n = JOptionPane.showOptionDialog(this.parent, "You have made changes to the present account.", "Account Changed", -1, 2, null, objectArray, objectArray[0]);
            if (n == 0) {
                this.commit();
            }
            if (n != 2) {
                this.dataChanged = false;
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private void changeAccount(int n, boolean bl) {
        int n2;
        if (!this.checkChanged()) {
            return;
        }
        int n3 = n2 = bl ? n : this.index + n;
        if (n2 < 0 || n2 >= this.parent.accountPanel.getListSize()) {
            this.parent.beep();
        } else {
            this.loadForm(n2);
            this.parent.accountPanel.scrollToRow(n2, true);
        }
    }

    private void toBegin() {
        this.changeAccount(0, true);
    }

    private void toEnd() {
        this.changeAccount(this.parent.accountPanel.getListSize() - 1, true);
    }

    private void newAccount() {
        this.loadForm(this.parent.accountPanel.getListSize());
    }

    private void renameAccount() {
        if (this.parent.accountHandler.renameAccountPrompt(this.account)) {
            this.loadForm(this.parent.accountPanel.indexForAccount(this.account));
        }
    }

    private void deleteAccount() {
        if (this.parent.accountHandler.deleteAccountPrompt(this.account)) {
            this.parent.closeEditWindow();
            this.parent.accountPanel.setupTable();
        }
    }

    private void closeThisWindow() {
        if (this.checkChanged()) {
            this.parent.closeEditWindow();
        }
    }

    private void help_accountEdit() {
        this.parent.launchHelp("BasicOperations.html#Creating_a_new_account");
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.nameTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.fileNameTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.typeComboBox = new JComboBox();
        this.jLabel4 = new JLabel();
        this.checkNumberTextField = new JTextField();
        this.subTypeTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.transactionsTextField = new JTextField();
        this.jLabel7 = new JLabel();
        this.descriptionTextField = new JTextField();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.creditLimitTextField = new JTextField();
        this.securityComboBox = new ActiveComboBox(this.parent, false);
        this.jPanel4 = new JPanel();
        this.shareBalanceTextField = new JTextField();
        this.jLabel11 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel16 = new JLabel();
        this.balanceTextField = new JTextField();
        this.showInListCheckBox = new JCheckBox();
        this.jLabel15 = new JLabel();
        this.statementBalanceTextField = new JTextField();
        this.jLabel17 = new JLabel();
        this.recentPriceTextField = new JTextField();
        this.oneLineModeCheckBox = new JCheckBox();
        this.jLabel13 = new JLabel();
        this.statementBalanceDateTextField = new JTextField();
        this.priceDateTextField = new JTextField();
        this.jLabel18 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel10 = new JLabel();
        this.includeTotalInListCheckBox = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.deleteButton = new MyJButton();
        this.renameButton = new MyJButton();
        this.beginButton = new MyJButton();
        this.previousButton = new MyJButton();
        this.recordNumTextField = new JTextField();
        this.nextButton = new MyJButton();
        this.endButton = new MyJButton();
        this.newButton = new MyJButton();
        this.commitButton = new MyJButton();
        this.cancelButton = new MyJButton();
        this.jButton1 = new MyJButton();
        this.closeButton = new MyJButton();
        this.setBorder(BorderFactory.createTitledBorder("Account Editor"));
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridLayout(1, 0));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel1.setText("Account Name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.jLabel1, gridBagConstraints);
        this.nameTextField.setToolTipText("Enter an account name");
        this.nameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                AccountEditorPane.this.nameTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.nameTextField, gridBagConstraints);
        this.jLabel2.setText("File name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.jLabel2, gridBagConstraints);
        this.fileNameTextField.setEditable(false);
        this.fileNameTextField.setToolTipText("Base file name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.fileNameTextField, gridBagConstraints);
        this.jLabel3.setText("Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.jLabel3, gridBagConstraints);
        this.typeComboBox.setToolTipText("Choose an account type");
        this.typeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                AccountEditorPane.this.typeComboBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.typeComboBox, gridBagConstraints);
        this.jLabel4.setText("Subtype");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.jLabel4, gridBagConstraints);
        this.checkNumberTextField.setHorizontalAlignment(4);
        this.checkNumberTextField.setToolTipText("Beginning check number");
        this.checkNumberTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                AccountEditorPane.this.checkNumberTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.checkNumberTextField, gridBagConstraints);
        this.subTypeTextField.setToolTipText("Retained only for Quicken compatibility");
        this.subTypeTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                AccountEditorPane.this.subTypeTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.subTypeTextField, gridBagConstraints);
        this.jLabel5.setText("Check Number");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setText("Transactions");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.jLabel6, gridBagConstraints);
        this.transactionsTextField.setEditable(false);
        this.transactionsTextField.setHorizontalAlignment(4);
        this.transactionsTextField.setToolTipText("Number of transactions in account");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.transactionsTextField, gridBagConstraints);
        this.jLabel7.setText("Description");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.jLabel7, gridBagConstraints);
        this.descriptionTextField.setToolTipText("Account number, contact, phone, etc.");
        this.descriptionTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                AccountEditorPane.this.descriptionTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.descriptionTextField, gridBagConstraints);
        this.jLabel8.setText("Security");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.jLabel8, gridBagConstraints);
        this.jLabel9.setText("Credit Limit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.jLabel9, gridBagConstraints);
        this.creditLimitTextField.setHorizontalAlignment(4);
        this.creditLimitTextField.setToolTipText("If a credit limit exists, enter it here");
        this.creditLimitTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                AccountEditorPane.this.creditLimitTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.creditLimitTextField, gridBagConstraints);
        this.securityComboBox.setEditable(true);
        this.securityComboBox.setToolTipText("Investment accounts: choose a security");
        this.securityComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                AccountEditorPane.this.securityComboBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.securityComboBox, gridBagConstraints);
        this.jPanel1.add(this.jPanel3);
        this.jPanel4.setLayout(new GridBagLayout());
        this.shareBalanceTextField.setEditable(false);
        this.shareBalanceTextField.setHorizontalAlignment(4);
        this.shareBalanceTextField.setText("0.0");
        this.shareBalanceTextField.setToolTipText("Only applies to investments");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.shareBalanceTextField, gridBagConstraints);
        this.jLabel11.setText("Show in list");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.jLabel11, gridBagConstraints);
        this.jLabel14.setText("Share Balance");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.jLabel14, gridBagConstraints);
        this.jLabel16.setText("Statement Balance Date");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.jLabel16, gridBagConstraints);
        this.balanceTextField.setEditable(false);
        this.balanceTextField.setHorizontalAlignment(4);
        this.balanceTextField.setText("0.0");
        this.balanceTextField.setToolTipText("Account balance to date");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.balanceTextField, gridBagConstraints);
        this.showInListCheckBox.setToolTipText("Show this acount in account list");
        this.showInListCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                AccountEditorPane.this.showInListCheckBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.showInListCheckBox, gridBagConstraints);
        this.jLabel15.setText("Newest Price");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.jLabel15, gridBagConstraints);
        this.statementBalanceTextField.setHorizontalAlignment(4);
        this.statementBalanceTextField.setText("0.0");
        this.statementBalanceTextField.setToolTipText("Balance of most recent reconcilation");
        this.statementBalanceTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                AccountEditorPane.this.statementBalanceTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.statementBalanceTextField, gridBagConstraints);
        this.jLabel17.setText("Statement Balance");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.jLabel17, gridBagConstraints);
        this.recentPriceTextField.setEditable(false);
        this.recentPriceTextField.setHorizontalAlignment(4);
        this.recentPriceTextField.setText("0.0");
        this.recentPriceTextField.setToolTipText("Most recent known price (investments)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.recentPriceTextField, gridBagConstraints);
        this.oneLineModeCheckBox.setToolTipText("Show  each transacttion on one line");
        this.oneLineModeCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                AccountEditorPane.this.oneLineModeCheckBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.oneLineModeCheckBox, gridBagConstraints);
        this.jLabel13.setText("Balance");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.jLabel13, gridBagConstraints);
        this.statementBalanceDateTextField.setHorizontalAlignment(4);
        this.statementBalanceDateTextField.setText("1/1/01");
        this.statementBalanceDateTextField.setToolTipText("Date of most recent reconciliation");
        this.statementBalanceDateTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                AccountEditorPane.this.statementBalanceDateTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.statementBalanceDateTextField, gridBagConstraints);
        this.priceDateTextField.setEditable(false);
        this.priceDateTextField.setHorizontalAlignment(4);
        this.priceDateTextField.setToolTipText("Date of most recent known price");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.priceDateTextField, gridBagConstraints);
        this.jLabel18.setText("Newest Price Date");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.jLabel18, gridBagConstraints);
        this.jLabel12.setText("Total in list");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.jLabel12, gridBagConstraints);
        this.jLabel10.setText("One line display mode");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.jLabel10, gridBagConstraints);
        this.includeTotalInListCheckBox.setToolTipText("Include this account's balance in overall total");
        this.includeTotalInListCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                AccountEditorPane.this.includeTotalInListCheckBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel4.add((Component)this.includeTotalInListCheckBox, gridBagConstraints);
        this.jPanel1.add(this.jPanel4);
        this.add((Component)this.jPanel1, "North");
        this.jPanel2.setLayout(new GridBagLayout());
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Delete.png")));
        this.deleteButton.setToolTipText("Delete this account");
        this.deleteButton.setMinimumSize(new Dimension(34, 30));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountEditorPane.this.deleteButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.deleteButton, gridBagConstraints);
        this.renameButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/DocumentDraw.png")));
        this.renameButton.setToolTipText("Rename this account");
        this.renameButton.setMinimumSize(new Dimension(34, 30));
        this.renameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountEditorPane.this.renameButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.renameButton, gridBagConstraints);
        this.beginButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/VCRBegin.png")));
        this.beginButton.setToolTipText("First account");
        this.beginButton.setMinimumSize(new Dimension(34, 30));
        this.beginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountEditorPane.this.beginButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.beginButton, gridBagConstraints);
        this.previousButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/VCRBack.png")));
        this.previousButton.setToolTipText("Previous account");
        this.previousButton.setMinimumSize(new Dimension(34, 30));
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountEditorPane.this.previousButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.previousButton, gridBagConstraints);
        this.recordNumTextField.setEditable(false);
        this.recordNumTextField.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.recordNumTextField, gridBagConstraints);
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/VCRForward.png")));
        this.nextButton.setToolTipText("Next account");
        this.nextButton.setMinimumSize(new Dimension(34, 30));
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountEditorPane.this.nextButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.nextButton, gridBagConstraints);
        this.endButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/VCREnd.png")));
        this.endButton.setToolTipText("Last account");
        this.endButton.setMinimumSize(new Dimension(34, 30));
        this.endButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountEditorPane.this.endButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.endButton, gridBagConstraints);
        this.newButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/New.png")));
        this.newButton.setToolTipText("New Account");
        this.newButton.setMinimumSize(new Dimension(34, 30));
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountEditorPane.this.newButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.newButton, gridBagConstraints);
        this.commitButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/DocumentIn.png")));
        this.commitButton.setToolTipText("Commit changes to account");
        this.commitButton.setMinimumSize(new Dimension(34, 30));
        this.commitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountEditorPane.this.commitButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.commitButton, gridBagConstraints);
        this.cancelButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Undo.png")));
        this.cancelButton.setToolTipText("Revert to original values");
        this.cancelButton.setMinimumSize(new Dimension(34, 30));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountEditorPane.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.cancelButton, gridBagConstraints);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/icons/Help.png")));
        this.jButton1.setToolTipText("Provide context-sensitive help");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountEditorPane.this.jButton1ActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.jButton1, gridBagConstraints);
        this.closeButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/FolderOut.png")));
        this.closeButton.setToolTipText("Close this window");
        this.closeButton.setMinimumSize(new Dimension(34, 30));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountEditorPane.this.closeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.closeButton, gridBagConstraints);
        this.add((Component)this.jPanel2, "Center");
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        this.help_accountEdit();
    }

    private void securityComboBoxItemStateChanged(ItemEvent itemEvent) {
        this.setChanged(true);
    }

    private void endButtonActionPerformed(ActionEvent actionEvent) {
        this.toEnd();
    }

    private void beginButtonActionPerformed(ActionEvent actionEvent) {
        this.toBegin();
    }

    private void renameButtonActionPerformed(ActionEvent actionEvent) {
        this.renameAccount();
    }

    private void deleteButtonActionPerformed(ActionEvent actionEvent) {
        this.deleteAccount();
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.closeThisWindow();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.cancel();
    }

    private void commitButtonActionPerformed(ActionEvent actionEvent) {
        this.commit();
    }

    private void subTypeTextFieldKeyTyped(KeyEvent keyEvent) {
        this.setChanged(true);
    }

    private void typeComboBoxItemStateChanged(ItemEvent itemEvent) {
        this.setChanged(true);
    }

    private void includeTotalInListCheckBoxItemStateChanged(ItemEvent itemEvent) {
        this.setChanged(true);
    }

    private void showInListCheckBoxItemStateChanged(ItemEvent itemEvent) {
        this.setChanged(true);
    }

    private void oneLineModeCheckBoxItemStateChanged(ItemEvent itemEvent) {
        this.setChanged(true);
    }

    private void nameTextFieldKeyTyped(KeyEvent keyEvent) {
        this.setChanged(true);
    }

    private void statementBalanceTextFieldKeyTyped(KeyEvent keyEvent) {
        this.setChanged(true);
    }

    private void statementBalanceDateTextFieldKeyTyped(KeyEvent keyEvent) {
        this.setChanged(true);
    }

    private void creditLimitTextFieldKeyTyped(KeyEvent keyEvent) {
        this.setChanged(true);
    }

    private void descriptionTextFieldKeyTyped(KeyEvent keyEvent) {
        this.setChanged(true);
    }

    private void checkNumberTextFieldKeyTyped(KeyEvent keyEvent) {
        this.setChanged(true);
    }

    private void newButtonActionPerformed(ActionEvent actionEvent) {
        this.newAccount();
    }

    private void nextButtonActionPerformed(ActionEvent actionEvent) {
        this.changeAccount(1, false);
    }

    private void previousButtonActionPerformed(ActionEvent actionEvent) {
        this.changeAccount(-1, false);
    }
}

