/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public final class AccountSelectionPanel
extends JPanel {
    PLCash parent;
    Vector accountList;
    Font displayFont;
    private EmptyBorder tableCellBorder;
    MyTableCellRenderer tableRenderer;
    String[] columnNames = new String[]{"Type", "Name", "Transactions", "Balance"};
    private JMenuItem newMenuItem;
    private JScrollPane scrollPane;
    private JMenuItem closeAllMenuItem;
    private JMenuItem editMenuItem;
    private JCheckBox showAllCheckBox;
    private JTable accountTable;
    private JMenuItem refreshMenuItem;
    private JLabel totalLabel;
    private JMenuItem openMenuItem;
    private JPanel jPanel1;
    private JPopupMenu popupMenu;

    public AccountSelectionPanel(PLCash pLCash) {
        this.parent = pLCash;
        this.initComponents();
        this.displayFont = new Font("Monospaced", 0, this.parent.programValues.db_TableFontSize);
        this.accountTable.setFont(this.displayFont);
        this.accountTable.getTableHeader().setFont(this.displayFont);
        this.tableCellBorder = new EmptyBorder(0, 2, 0, 2);
        this.showAllAccounts(this.parent.programValues.db_ShowAllAccounts);
        this.setupTable();
    }

    public void setupTable() {
        Object object;
        int n;
        Vector<String> vector = new Vector<String>(Arrays.asList(this.columnNames));
        this.accountList = new Vector();
        String[] stringArray = this.parent.accountHandler.getAccountFileNames();
        for (n = 0; n < stringArray.length; ++n) {
            object = this.parent.accountHandler.getAccountByFileName(stringArray[n]);
            if (!this.showAllAccounts() && !((Account)object).db_ShowInList) continue;
            this.accountList.add(object);
        }
        n = this.accountList.size();
        object = new DefaultTableModel(vector, n){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        try {
            this.tableRenderer = new MyTableCellRenderer();
            this.accountTable.setDefaultRenderer(Class.forName("java.lang.Object"), this.tableRenderer);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        this.accountTable.setModel((TableModel)object);
        this.setColumnWidths();
        this.accountTable.requestFocus();
        this.updateTotal();
    }

    private void setColumnWidths() {
    }

    public void updateTotal() {
        String[] stringArray = this.parent.accountHandler.getAccountFileNames();
        double d = 0.0;
        for (int i = 0; i < stringArray.length; ++i) {
            Account account = this.parent.accountHandler.getAccountByFileName(stringArray[i]);
            if (!account.db_IncludeTotalInList) continue;
            d += account.db_Balance;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        stringBuffer.append("Overall Total: ");
        stringBuffer.append(this.parent.commonCode.wrapHTMLColorOnDouble(d, this.parent.programValues.db_BoldCurrencyColor, this.parent.programValues.db_RedColor, false));
        stringBuffer.append("</html>");
        this.totalLabel.setText(stringBuffer.toString());
    }

    public int getListSize() {
        return this.accountList.size();
    }

    public Account getAccount(int n) {
        if (n < 0 || n >= this.getListSize()) {
            return null;
        }
        return (Account)this.accountList.get(n);
    }

    public void scrollToRow(Account account, boolean bl) {
        this.scrollToRow(this.indexForAccount(account), bl);
    }

    public void scrollToRow(int n, boolean bl) {
        int n2 = this.accountTable.getRowCount();
        int n3 = n - 1;
        int n4 = n + 1;
        n3 = n3 >= n2 ? n2 - 1 : n3;
        n3 = n3 < 0 ? 0 : n3;
        n4 = n4 >= n2 ? n2 - 1 : n4;
        n4 = n4 < 0 ? 0 : n4;
        Rectangle rectangle = this.accountTable.getCellRect(n3, 0, true);
        Rectangle rectangle2 = this.accountTable.getCellRect(n4, 0, true);
        rectangle.add(rectangle2);
        final Rectangle rectangle3 = new Rectangle(rectangle);
        if (rectangle3 != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AccountSelectionPanel.this.accountTable.scrollRectToVisible(rectangle3);
                }
            });
        }
        if (bl) {
            n = n >= n2 ? n2 - 1 : n;
            int n5 = n = n < 0 ? 0 : n;
            if (n2 == 0) {
                return;
            }
            this.accountTable.setRowSelectionInterval(n, n);
        }
    }

    private void actOnTableChange(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.openAccount();
        } else if (this.parent.accountEditorOpen()) {
            this.editAccount();
        }
    }

    private Account getSelectedAccount() {
        Object var1_1 = null;
        int n = this.accountTable.getSelectedRow();
        if (n >= 0 && n < this.accountList.size()) {
            return (Account)this.accountList.get(n);
        }
        return null;
    }

    private void openAccount() {
        Account account = this.getSelectedAccount();
        if (account != null) {
            this.parent.displayHandler.addTest(account);
        }
    }

    private void handleMenu(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public int indexForAccount(Account account) {
        return this.accountList.indexOf(account);
    }

    private void editAccount() {
        Account account = this.getSelectedAccount();
        if (account != null) {
            this.parent.loadAccountEditorPane(account);
        }
    }

    private void showAllAccounts(JCheckBox jCheckBox) {
        this.parent.programValues.db_ShowAllAccounts = jCheckBox.isSelected();
        int n = this.accountTable.getSelectedRow();
        Account account = this.getAccount(n);
        this.setupTable();
        if (n >= 0) {
            this.scrollToRow(account, true);
        }
    }

    private void showAllAccounts(boolean bl) {
        this.parent.programValues.db_ShowAllAccounts = bl;
        this.showAllCheckBox.setSelected(bl);
    }

    private boolean showAllAccounts() {
        return this.parent.programValues.db_ShowAllAccounts;
    }

    private void newAccount() {
        this.parent.loadAccountEditorPane(null);
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.openMenuItem = new JMenuItem();
        this.editMenuItem = new JMenuItem();
        this.closeAllMenuItem = new JMenuItem();
        this.newMenuItem = new JMenuItem();
        this.refreshMenuItem = new JMenuItem();
        this.scrollPane = new JScrollPane();
        this.accountTable = new JTable();
        this.jPanel1 = new JPanel();
        this.totalLabel = new JLabel();
        this.showAllCheckBox = new JCheckBox();
        this.openMenuItem.setText("Open Account");
        this.openMenuItem.setToolTipText("Open selected account to edit transactions");
        this.openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountSelectionPanel.this.openMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.openMenuItem);
        this.editMenuItem.setText("Edit Account");
        this.editMenuItem.setToolTipText("Edit selected account's properties");
        this.editMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountSelectionPanel.this.editMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.editMenuItem);
        this.closeAllMenuItem.setText("Close All");
        this.closeAllMenuItem.setToolTipText("Close all open accounts");
        this.closeAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountSelectionPanel.this.closeAllMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.closeAllMenuItem);
        this.newMenuItem.setText("New Account");
        this.newMenuItem.setToolTipText("Create a new bank account");
        this.newMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountSelectionPanel.this.newMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.newMenuItem);
        this.refreshMenuItem.setText("Refresh");
        this.refreshMenuItem.setToolTipText("Update this display");
        this.refreshMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountSelectionPanel.this.refreshMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.refreshMenuItem);
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder("Account List"));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                AccountSelectionPanel.this.formComponentShown(componentEvent);
            }
        });
        this.scrollPane.setBackground(new Color(255, 255, 255));
        this.scrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                AccountSelectionPanel.this.scrollPaneMousePressed(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                AccountSelectionPanel.this.scrollPaneMouseReleased(mouseEvent);
            }
        });
        this.accountTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.accountTable.setToolTipText("Double-click to display an account, right-click for more options");
        this.accountTable.setRowMargin(0);
        this.accountTable.setShowHorizontalLines(false);
        this.accountTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                AccountSelectionPanel.this.accountTableMousePressed(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                AccountSelectionPanel.this.accountTableMouseReleased(mouseEvent);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                AccountSelectionPanel.this.accountTableMouseClicked(mouseEvent);
            }
        });
        this.scrollPane.setViewportView(this.accountTable);
        this.add((Component)this.scrollPane, "Center");
        this.jPanel1.setLayout(new BorderLayout());
        this.totalLabel.setHorizontalAlignment(4);
        this.totalLabel.setText("0.00");
        this.jPanel1.add((Component)this.totalLabel, "East");
        this.showAllCheckBox.setText("Show All Accounts");
        this.showAllCheckBox.setToolTipText("Show accounts ordinarily hidden");
        this.showAllCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                AccountSelectionPanel.this.showAllCheckBoxItemStateChanged(itemEvent);
            }
        });
        this.jPanel1.add((Component)this.showAllCheckBox, "West");
        this.add((Component)this.jPanel1, "South");
    }

    private void newMenuItemActionPerformed(ActionEvent actionEvent) {
        this.newAccount();
    }

    private void accountTableMouseReleased(MouseEvent mouseEvent) {
        this.handleMenu(mouseEvent);
    }

    private void accountTableMousePressed(MouseEvent mouseEvent) {
        this.handleMenu(mouseEvent);
    }

    private void accountTableMouseClicked(MouseEvent mouseEvent) {
        this.actOnTableChange(mouseEvent);
    }

    private void refreshMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setupTable();
    }

    private void showAllCheckBoxItemStateChanged(ItemEvent itemEvent) {
        this.showAllAccounts(this.showAllCheckBox);
    }

    private void editMenuItemActionPerformed(ActionEvent actionEvent) {
        this.editAccount();
    }

    private void openMenuItemActionPerformed(ActionEvent actionEvent) {
        this.openAccount();
    }

    private void formComponentShown(ComponentEvent componentEvent) {
        this.updateTotal();
    }

    private void scrollPaneMouseReleased(MouseEvent mouseEvent) {
        this.handleMenu(mouseEvent);
    }

    private void scrollPaneMousePressed(MouseEvent mouseEvent) {
        this.handleMenu(mouseEvent);
    }

    private void closeAllMenuItemActionPerformed(ActionEvent actionEvent) {
        this.parent.displayHandler.closeAll();
    }

    final class MyTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public MyTableCellRenderer() {
            this.setOpaque(true);
            this.setVerticalAlignment(0);
            this.setFont(AccountSelectionPanel.this.displayFont);
            this.setBorder(AccountSelectionPanel.this.tableCellBorder);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setBackground((n & 1) == 0 ? AccountSelectionPanel.this.parent.programValues.db_EvenRowColor : AccountSelectionPanel.this.parent.programValues.db_OddRowColor);
            this.setForeground(AccountSelectionPanel.this.parent.programValues.db_BlackColor);
            this.setHorizontalAlignment(n2 < 2 ? 2 : 4);
            String string = "";
            Object e = AccountSelectionPanel.this.accountList.get(n);
            if (e instanceof Account) {
                Account account = (Account)e;
                switch (n2) {
                    case 0: {
                        string = account.db_Type;
                        break;
                    }
                    case 1: {
                        string = account.db_Name;
                        break;
                    }
                    case 2: {
                        string = String.valueOf(account.db_Transactions);
                        break;
                    }
                    case 3: {
                        if (!account.db_IncludeTotalInList) break;
                        double d = account.db_Balance;
                        AccountSelectionPanel.this.parent.commonCode.setTableCellTextColor(this, d, AccountSelectionPanel.this.parent.programValues.db_RedColor);
                        string = AccountSelectionPanel.this.parent.commonCode.getCurrencyDollarCentString(d, false);
                    }
                }
            }
            this.setText(string);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            }
            return this;
        }
    }
}

