/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.lang.reflect.Field;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public final class DataTableManager
extends JPanel {
    Vector vdata = null;
    TreeMap tdata = null;
    String tag;
    private Font displayFont;
    int rows;
    int columns;
    int[] colWidths;
    String[] fieldNames;
    String[] headerNames;
    String[] keys;
    JTextField[] formFields;
    private EmptyBorder tableCellBorder;
    PLCash parent;
    EditableList editableList;
    FloatingWindow floatingWindow;
    int index = 0;
    boolean dataSetChanged = false;
    boolean dataChanged = false;
    private JMenuItem newMenuItem;
    private JPanel formButtonPanel;
    private JPopupMenu tablePopupMenu;
    private JButton newButton;
    private JButton beginButton;
    private JButton deleteButton;
    private JPanel formContainerPanel;
    private JScrollPane scrollPane;
    private JPanel formPanel;
    private JButton endButton;
    private JButton previousButton;
    private JCheckBoxMenuItem viewTableContentsCheckBoxMenuItem;
    private JMenuItem close2MenuItem;
    private JCheckBox enterModeCheckBox;
    private JScrollPane jScrollPane2;
    private JTable dataTable;
    private JTabbedPane tabbedPane;
    private JButton cancelButton;
    private JTextField recordNumTextField;
    private JButton commitButton;
    private JMenuItem closeMenuItem;
    private JButton closeButton;
    private JPopupMenu formPopupMenu;
    private JMenuItem deleteMenuItem;
    private JMenuItem editInFormMenuItem;
    private JButton nextButton;

    public DataTableManager(PLCash pLCash, EditableList editableList) {
        this.parent = pLCash;
        this.editableList = editableList;
        this.initComponents();
        this.displayFont = new Font("Monospaced", 0, this.parent.programValues.db_TableFontSize);
        this.dataTable.setFont(this.displayFont);
        this.tableCellBorder = new EmptyBorder(0, 2, 0, 2);
        this.dataTable.getTableHeader().setFont(this.displayFont);
        this.setViewTableContents(false);
        this.floatingWindow = new FloatingWindow(this.displayFont);
        this.scrollPane.getVerticalScrollBar().addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                DataTableManager.this.scrollVertMouseDragged(mouseEvent);
            }
        });
        this.scrollPane.getVerticalScrollBar().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                DataTableManager.this.scrollVertMouseReleased(mouseEvent);
            }
        });
    }

    public void setupTable(TreeMap treeMap, String string) {
        if (treeMap == null || treeMap.size() == 0) {
            return;
        }
        this.vdata = null;
        this.tdata = treeMap;
        this.keys = this.tdata.keySet().toArray(new String[0]);
        this.rows = this.keys.length;
        this.tag = string;
        Object v = this.tdata.get(this.tdata.firstKey());
        this.setupTable(v);
    }

    public void setupTable(Vector vector, String string) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        this.vdata = vector;
        this.tdata = null;
        this.rows = this.vdata.size();
        this.tag = string;
        Object e = this.vdata.get(0);
        this.setupTable(e);
    }

    private void setupTable(Object object) {
        this.getHeaderData(object);
        this.columns = this.headerNames.length;
        DefaultTableModel defaultTableModel = new DefaultTableModel(this.headerNames, this.rows){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.dataTable.setModel(defaultTableModel);
        try {
            MyTableCellRenderer myTableCellRenderer = new MyTableCellRenderer();
            this.dataTable.setDefaultRenderer(Class.forName("java.lang.Object"), myTableCellRenderer);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        this.colWidths = new int[this.columns];
        this.getColumnWidthData(this.colWidths, 100, this.columns);
        this.setColumnWidths(this.colWidths, this.dataTable);
        this.setupForm();
        this.loadForm(this.index);
    }

    private void setColumnWidths(int[] nArray, JTable jTable) {
        TableColumn tableColumn = null;
        Font font = jTable.getFont();
        FontMetrics fontMetrics = jTable.getFontMetrics(font);
        int n = fontMetrics.charWidth('W');
        int n2 = fontMetrics.getAscent() + fontMetrics.getDescent() + fontMetrics.getLeading();
        jTable.setRowHeight(n2);
        for (int i = 0; i < this.columns; ++i) {
            tableColumn = jTable.getColumnModel().getColumn(i);
            if (nArray[i] <= 0) continue;
            Insets insets = this.tableCellBorder.getBorderInsets();
            int n3 = nArray[i] * n + insets.left * 2 + insets.right * 2;
            tableColumn.setPreferredWidth(n3);
        }
    }

    private void setupForm() {
        this.handleEnterMode(false);
        if (this.formPanel.getComponentCount() == 0) {
            this.formFields = new JTextField[this.columns];
            this.formPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.anchor = 11;
            gridBagConstraints.gridx = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints2.anchor = 11;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridx = 1;
            for (int i = 0; i < this.columns; ++i) {
                if (i == this.columns - 1) {
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints2.weighty = 1.0;
                }
                JLabel jLabel = new JLabel(this.headerNames[i]);
                jLabel.setHorizontalAlignment(2);
                gridBagConstraints.gridy = i;
                this.formPanel.add((Component)jLabel, gridBagConstraints);
                this.formFields[i] = new JTextField();
                this.formFields[i].addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyTyped(KeyEvent keyEvent) {
                        DataTableManager.this.setChanged(true);
                        DataTableManager.this.watchForLF(keyEvent);
                    }
                });
                this.formFields[i].setEditable(this.editableList.allowEditRecords(i));
                gridBagConstraints2.gridy = i;
                this.formPanel.add((Component)this.formFields[i], gridBagConstraints2);
            }
        }
    }

    private boolean loadForm(int n) {
        this.index = n;
        boolean bl = false;
        if (n >= 0 && n <= this.rows) {
            for (int i = 0; i < this.columns; ++i) {
                this.formFields[i].setText(this.fetchFieldData(n, i));
            }
            if (n >= this.rows) {
                this.recordNumTextField.setText("New record");
            } else {
                this.recordNumTextField.setText("Record " + (n + 1) + " of " + this.rows + " reccords");
            }
            bl = true;
            this.formPanel.repaint();
        }
        this.setChanged(false);
        return bl;
    }

    private void changeRow(int n) {
        n = n < 0 ? 0 : n;
        n = n > this.rows ? this.rows : n;
        this.loadForm(n);
    }

    public void makeIndexVisible(int n, boolean bl) {
        this.dataTable.scrollRectToVisible(this.dataTable.getCellRect(n, 0, true));
        if (bl) {
            this.dataTable.setRowSelectionInterval(n, n);
        }
    }

    private void getColumnWidthData(int[] nArray, int n, int n2) {
        int n3 = this.rows;
        if (n3 > n) {
            n3 = n;
        }
        for (int i = -1; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                String string = "";
                string = i < 0 ? this.headerNames[j] : this.fetchFieldData(i, j);
                if (string.length() <= nArray[j]) continue;
                nArray[j] = string.length();
            }
        }
    }

    private void getHeaderData(Object object) {
        Field[] fieldArray = object.getClass().getFields();
        this.fieldNames = DataTableManager.getFieldNames(fieldArray, this.tag);
        this.headerNames = DataTableManager.getHeaderNames(this.fieldNames, this.tag);
    }

    private static String[] getFieldNames(Field[] fieldArray, String string) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < fieldArray.length; ++i) {
            String string2 = fieldArray[i].getName();
            if (string2.indexOf(string) != 0) continue;
            vector.add(string2);
        }
        return vector.toArray(new String[vector.size()]);
    }

    private static String[] getHeaderNames(String[] stringArray, String string) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i].substring(string.length());
        }
        return stringArray2;
    }

    private String fetchFieldData(int n, int n2) {
        String string = "";
        try {
            if (n >= 0 && n < this.rows) {
                Object object = null;
                boolean bl = false;
                if (this.tdata == null) {
                    object = this.vdata.get(n);
                    bl = true;
                } else {
                    object = this.tdata.get(this.keys[n]);
                }
                Field field = object.getClass().getField(this.fieldNames[n2]);
                string = this.parent.commonCode.getFieldValueAsString(field, object);
            } else if (n == this.rows) {
                string = "";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private void commit(int n) {
        Object object = this.editableList.getDataObject(this.index);
        if (this.index >= 0 && this.index < this.rows && this.tdata != null) {
            this.editableList.deleteItem(this.keys[this.index]);
        }
        this.parent.commonCode.parseRecordValues(object, this.fieldNames, this.formFields);
        if (this.tdata != null) {
            String string = this.formFields[0].getText();
            this.editableList.addItem(string, object);
            this.index = this.editableList.rowForKey(string);
        } else {
            this.editableList.replaceItem(this.index, object);
            this.editableList.sortVector();
            this.index = this.editableList.rowForObject(object);
        }
        this.reloadTable();
        this.loadForm(this.index + n);
    }

    private void reloadTable() {
        if (this.tdata == null) {
            this.setupTable(this.vdata, this.tag);
        } else {
            this.setupTable(this.tdata, this.tag);
        }
    }

    private void deleteFormRecord() {
        if (!this.editableList.allowCreateDeleteRecords()) {
            this.parent.beep();
            return;
        }
        int[] nArray = new int[]{this.index};
        if (this.index >= this.rows - 1 && this.index > 0) {
            --this.index;
        }
        if (this.editableList.deleteRecords(nArray)) {
            this.reloadTable();
        }
    }

    private void deleteSelectedRecords() {
        if (!this.editableList.allowCreateDeleteRecords()) {
            this.parent.beep();
            return;
        }
        int[] nArray = this.dataTable.getSelectedRows();
        if (this.vdata == null) {
            if (this.editableList.deleteRecords(nArray)) {
                this.reloadTable();
            }
        } else if (this.editableList.deleteVecRecords(nArray)) {
            this.reloadTable();
        }
    }

    private boolean handleTableMouse(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.tablePopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            return true;
        }
        if (mouseEvent.getClickCount() == 2) {
            this.editInForm();
            return true;
        }
        return false;
    }

    private void handleFormMouse(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.formPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void closeThisWindow() {
        this.parent.displayHandler.closeSelectedTab();
    }

    public void editInForm() {
        int n = this.dataTable.getSelectedRow();
        if (this.loadForm(n)) {
            this.tabbedPane.setSelectedIndex(1);
        }
    }

    private void newRecord() {
        if (!this.editableList.allowCreateDeleteRecords()) {
            this.parent.beep();
            return;
        }
        if (this.tabbedPane.getSelectedIndex() != 1) {
            if (this.dataTable.getSelectedRow() == -1 && this.dataTable.getRowCount() > 0) {
                this.dataTable.getSelectionModel().setSelectionInterval(0, 0);
            }
            this.editInForm();
        }
        this.changeRow(this.rows);
    }

    private void scrollVertMouseDragged(MouseEvent mouseEvent) {
        if (!this.handleTableMouse(mouseEvent) && !this.parent.programValues.db_ShowTableContentsWhileScrolling) {
            this.scrollPane.getViewport().setVisible(false);
            JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
            double d = this.scrollPane.getViewport().getSize().height;
            double d2 = jScrollBar.getMaximum() - jScrollBar.getVisibleAmount();
            double d3 = jScrollBar.getValue();
            double d4 = d3 / d2;
            int n = this.dataTable.rowAtPoint(new Point(0, (int)(d3 += d4 * d)));
            if (n == -1) {
                n = this.dataTable.getRowCount() - 1;
            }
            this.floatingWindow.setMessage(this.fetchFieldData(n, 0));
            Point point = jScrollBar.getLocationOnScreen();
            int n2 = point.x - (this.floatingWindow.getSize().width + 8);
            int n3 = mouseEvent.getY() + point.y - this.floatingWindow.getSize().height / 2;
            this.floatingWindow.showAt(new Point(n2, n3));
        }
    }

    private void scrollVertMouseReleased(MouseEvent mouseEvent) {
        if (!this.handleTableMouse(mouseEvent) && !this.parent.programValues.db_ShowTableContentsWhileScrolling) {
            this.floatingWindow.hideWindow();
            this.scrollPane.getViewport().setVisible(true);
        }
    }

    private void setViewTableContents(boolean bl) {
        if (bl) {
            this.parent.programValues.db_ShowTableContentsWhileScrolling = this.viewTableContentsCheckBoxMenuItem.isSelected();
        } else {
            this.viewTableContentsCheckBoxMenuItem.setSelected(this.parent.programValues.db_ShowTableContentsWhileScrolling);
        }
    }

    protected void watchForLF(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n' && this.parent.programValues.db_EnterMode) {
            this.commit(1);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DataTableManager.this.setChanged(false);
                }
            });
        }
    }

    protected void setChanged(boolean bl) {
        this.dataChanged = bl;
        this.commitButton.setEnabled(bl);
        this.cancelButton.setEnabled(bl);
    }

    private void cancel() {
        int n = JOptionPane.showConfirmDialog(this.parent, "Discard Changes?", "Transaction Changed", 2);
        if (n == 0) {
            this.loadForm(this.index);
        }
    }

    private void handleEnterMode(boolean bl) {
        if (bl) {
            this.parent.programValues.db_EnterMode = this.enterModeCheckBox.isSelected();
        } else {
            this.enterModeCheckBox.setSelected(this.parent.programValues.db_EnterMode);
        }
    }

    private void initComponents() {
        this.tablePopupMenu = new JPopupMenu();
        this.editInFormMenuItem = new JMenuItem();
        this.newMenuItem = new JMenuItem();
        this.deleteMenuItem = new JMenuItem();
        this.viewTableContentsCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.closeMenuItem = new JMenuItem();
        this.formPopupMenu = new JPopupMenu();
        this.close2MenuItem = new JMenuItem();
        this.tabbedPane = new JTabbedPane();
        this.scrollPane = new JScrollPane();
        this.dataTable = new JTable();
        this.formContainerPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.formPanel = new JPanel();
        this.formButtonPanel = new JPanel();
        this.enterModeCheckBox = new JCheckBox();
        this.deleteButton = new MyJButton();
        this.beginButton = new MyJButton();
        this.previousButton = new MyJButton();
        this.recordNumTextField = new JTextField();
        this.nextButton = new MyJButton();
        this.endButton = new MyJButton();
        this.newButton = new MyJButton();
        this.commitButton = new MyJButton();
        this.cancelButton = new MyJButton();
        this.closeButton = new MyJButton();
        this.editInFormMenuItem.setText("Edit in form");
        this.editInFormMenuItem.setToolTipText("Edit this record in form display");
        this.editInFormMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataTableManager.this.editInFormMenuItemActionPerformed(actionEvent);
            }
        });
        this.tablePopupMenu.add(this.editInFormMenuItem);
        this.newMenuItem.setText("New");
        this.newMenuItem.setToolTipText("New Record");
        this.newMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataTableManager.this.newMenuItemActionPerformed(actionEvent);
            }
        });
        this.tablePopupMenu.add(this.newMenuItem);
        this.deleteMenuItem.setText("Delete ...");
        this.deleteMenuItem.setToolTipText("Delete selected record(s) (confirm)");
        this.deleteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataTableManager.this.deleteMenuItemActionPerformed(actionEvent);
            }
        });
        this.tablePopupMenu.add(this.deleteMenuItem);
        this.viewTableContentsCheckBoxMenuItem.setText("View contents while scrolling");
        this.viewTableContentsCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataTableManager.this.viewTableContentsCheckBoxMenuItemActionPerformed(actionEvent);
            }
        });
        this.tablePopupMenu.add(this.viewTableContentsCheckBoxMenuItem);
        this.closeMenuItem.setText("Close");
        this.closeMenuItem.setToolTipText("Close this window");
        this.closeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataTableManager.this.closeMenuItemActionPerformed(actionEvent);
            }
        });
        this.tablePopupMenu.add(this.closeMenuItem);
        this.close2MenuItem.setText("Close");
        this.close2MenuItem.setToolTipText("Close this window");
        this.close2MenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataTableManager.this.close2MenuItemActionPerformed(actionEvent);
            }
        });
        this.formPopupMenu.add(this.close2MenuItem);
        this.setLayout(new BorderLayout());
        this.scrollPane.setBackground(new Color(255, 255, 255));
        this.scrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                DataTableManager.this.scrollPaneMousePressed(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                DataTableManager.this.scrollPaneMouseReleased(mouseEvent);
            }
        });
        this.dataTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.dataTable.setRowMargin(0);
        this.dataTable.setShowHorizontalLines(false);
        this.dataTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                DataTableManager.this.dataTableMousePressed(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                DataTableManager.this.dataTableMouseReleased(mouseEvent);
            }
        });
        this.scrollPane.setViewportView(this.dataTable);
        this.tabbedPane.addTab("Table View", this.scrollPane);
        this.formContainerPanel.setLayout(new BorderLayout());
        this.formPanel.setLayout(new GridBagLayout());
        this.formPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                DataTableManager.this.formPanelMousePressed(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                DataTableManager.this.formPanelMouseReleased(mouseEvent);
            }
        });
        this.jScrollPane2.setViewportView(this.formPanel);
        this.formContainerPanel.add((Component)this.jScrollPane2, "Center");
        this.formButtonPanel.setLayout(new GridBagLayout());
        this.enterModeCheckBox.setText("Enter mode");
        this.enterModeCheckBox.setToolTipText("Pressing \"Enter\" completes transaction");
        this.enterModeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataTableManager.this.enterModeCheckBoxActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.formButtonPanel.add((Component)this.enterModeCheckBox, gridBagConstraints);
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Delete.png")));
        this.deleteButton.setToolTipText("Delete this record");
        this.deleteButton.setMinimumSize(new Dimension(34, 30));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataTableManager.this.deleteButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.formButtonPanel.add((Component)this.deleteButton, gridBagConstraints);
        this.beginButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/VCRBegin.png")));
        this.beginButton.setToolTipText("First record");
        this.beginButton.setMinimumSize(new Dimension(34, 30));
        this.beginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataTableManager.this.beginButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.formButtonPanel.add((Component)this.beginButton, gridBagConstraints);
        this.previousButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/VCRBack.png")));
        this.previousButton.setToolTipText("Previous record");
        this.previousButton.setMinimumSize(new Dimension(34, 30));
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataTableManager.this.previousButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.formButtonPanel.add((Component)this.previousButton, gridBagConstraints);
        this.recordNumTextField.setEditable(false);
        this.recordNumTextField.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.formButtonPanel.add((Component)this.recordNumTextField, gridBagConstraints);
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/VCRForward.png")));
        this.nextButton.setToolTipText("Next record");
        this.nextButton.setMinimumSize(new Dimension(34, 30));
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataTableManager.this.nextButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.formButtonPanel.add((Component)this.nextButton, gridBagConstraints);
        this.endButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/VCREnd.png")));
        this.endButton.setToolTipText("Last record");
        this.endButton.setMinimumSize(new Dimension(34, 30));
        this.endButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataTableManager.this.endButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.formButtonPanel.add((Component)this.endButton, gridBagConstraints);
        this.newButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/New.png")));
        this.newButton.setToolTipText("New record");
        this.newButton.setMinimumSize(new Dimension(34, 30));
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataTableManager.this.newButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.formButtonPanel.add((Component)this.newButton, gridBagConstraints);
        this.commitButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/DocumentIn.png")));
        this.commitButton.setToolTipText("Save changes");
        this.commitButton.setMinimumSize(new Dimension(34, 30));
        this.commitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataTableManager.this.commitButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.formButtonPanel.add((Component)this.commitButton, gridBagConstraints);
        this.cancelButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Undo.png")));
        this.cancelButton.setToolTipText("Cancel changes");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataTableManager.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.formButtonPanel.add((Component)this.cancelButton, new GridBagConstraints());
        this.closeButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/FolderOut.png")));
        this.closeButton.setToolTipText("Close this window");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataTableManager.this.closeButtonActionPerformed(actionEvent);
            }
        });
        this.formButtonPanel.add((Component)this.closeButton, new GridBagConstraints());
        this.formContainerPanel.add((Component)this.formButtonPanel, "South");
        this.tabbedPane.addTab("Form View", this.formContainerPanel);
        this.add((Component)this.tabbedPane, "Center");
    }

    private void newMenuItemActionPerformed(ActionEvent actionEvent) {
        this.newRecord();
    }

    private void enterModeCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.handleEnterMode(true);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.cancel();
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.closeThisWindow();
    }

    private void viewTableContentsCheckBoxMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setViewTableContents(true);
    }

    private void deleteButtonActionPerformed(ActionEvent actionEvent) {
        this.deleteFormRecord();
    }

    private void close2MenuItemActionPerformed(ActionEvent actionEvent) {
        this.closeThisWindow();
    }

    private void formPanelMouseReleased(MouseEvent mouseEvent) {
        this.handleFormMouse(mouseEvent);
    }

    private void formPanelMousePressed(MouseEvent mouseEvent) {
        this.handleFormMouse(mouseEvent);
    }

    private void deleteMenuItemActionPerformed(ActionEvent actionEvent) {
        this.deleteSelectedRecords();
    }

    private void editInFormMenuItemActionPerformed(ActionEvent actionEvent) {
        this.editInForm();
    }

    private void closeMenuItemActionPerformed(ActionEvent actionEvent) {
        this.closeThisWindow();
    }

    private void dataTableMouseReleased(MouseEvent mouseEvent) {
        this.handleTableMouse(mouseEvent);
    }

    private void dataTableMousePressed(MouseEvent mouseEvent) {
        this.handleTableMouse(mouseEvent);
    }

    private void scrollPaneMouseReleased(MouseEvent mouseEvent) {
        this.handleTableMouse(mouseEvent);
    }

    private void scrollPaneMousePressed(MouseEvent mouseEvent) {
        this.handleTableMouse(mouseEvent);
    }

    private void commitButtonActionPerformed(ActionEvent actionEvent) {
        this.commit(1);
    }

    private void newButtonActionPerformed(ActionEvent actionEvent) {
        this.newRecord();
    }

    private void nextButtonActionPerformed(ActionEvent actionEvent) {
        this.changeRow(this.index + 1);
    }

    private void previousButtonActionPerformed(ActionEvent actionEvent) {
        this.changeRow(this.index - 1);
    }

    private void endButtonActionPerformed(ActionEvent actionEvent) {
        this.changeRow(this.rows - 1);
    }

    private void beginButtonActionPerformed(ActionEvent actionEvent) {
        this.changeRow(0);
    }

    final class MyTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public MyTableCellRenderer() {
            this.setOpaque(true);
            this.setVerticalAlignment(0);
            this.setFont(DataTableManager.this.displayFont);
            this.setBorder(DataTableManager.this.tableCellBorder);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setBackground((n & 1) == 0 ? DataTableManager.this.parent.programValues.db_EvenRowColor : DataTableManager.this.parent.programValues.db_OddRowColor);
            this.setText(DataTableManager.this.fetchFieldData(n, n2));
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            }
            return this;
        }
    }
}

