/*
 * Decompiled with CFR 0.152.
 */
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JOptionPane;

public final class Memorized
extends EditableList {
    String fileName = "memorizedList" + ".tsv";
    public TreeMap lcMap = new TreeMap();

    public Memorized(PLCash pLCash) {
        super(pLCash);
    }

    public void displayData() {
        this.displayMap("Memorized Transactions", this, "");
    }

    public void readTSV(String string) {
        this.readTSV(string, this.fileName, this.dataMap, (Object)new MemorizedItem(this.parent), "");
        this.createLcMap();
        this.initializeAllMemorizedTransactions();
    }

    private void initializeAllMemorizedTransactions() {
        String[] stringArray = this.getDataKeys();
        for (int i = 0; i < stringArray.length; ++i) {
            MemorizedItem memorizedItem = (MemorizedItem)this.getDataObject(stringArray[i]);
            memorizedItem.init();
        }
    }

    private void createLcMap() {
        this.lcMap = new TreeMap();
        String[] stringArray = this.getDataKeys();
        for (int i = 0; i < stringArray.length; ++i) {
            this.lcMap.put(stringArray[i].toLowerCase(), this.getDataObject(stringArray[i]));
        }
    }

    @Override
    public void addItem(String string, Object object) {
        super.addItem(string, object);
        this.lcMap.put(string.toLowerCase(), object);
    }

    @Override
    public void deleteItem(String string) {
        super.deleteItem(string);
        this.lcMap.remove(string.toLowerCase());
    }

    public void writeTSV(String string) {
        this.writeTSV(string, this.fileName, this.dataMap, (Object)new MemorizedItem(this.parent), "");
    }

    public String nearestMatchString(String string) {
        MemorizedItem memorizedItem = this.nearestMatchValue(string);
        if (memorizedItem != null) {
            return memorizedItem.Payee;
        }
        return null;
    }

    public MemorizedItem nearestMatchValue(String string) {
        MemorizedItem memorizedItem = null;
        SortedMap sortedMap = this.dataMap.tailMap(string.toLowerCase());
        if (sortedMap.size() > 0) {
            memorizedItem = (MemorizedItem)sortedMap.get(sortedMap.firstKey());
        }
        return memorizedItem;
    }

    public String nearestMatchLCString(String string) {
        MemorizedItem memorizedItem = this.nearestMatchLCValue(string);
        if (memorizedItem != null) {
            return memorizedItem.Payee;
        }
        return null;
    }

    public MemorizedItem nearestMatchLCValue(String string) {
        MemorizedItem memorizedItem = null;
        SortedMap sortedMap = this.lcMap.tailMap(string.toLowerCase());
        if (sortedMap.size() > 0) {
            memorizedItem = (MemorizedItem)sortedMap.get(sortedMap.firstKey());
        }
        return memorizedItem;
    }

    public void createFromQIFData(TreeMap treeMap) {
        MemorizedItem memorizedItem = new MemorizedItem(this.parent);
        memorizedItem.Amount = this.parent.commonCode.zeroFailParseDouble(this.parent.commonCode.safeTreeGet(treeMap, "T"));
        memorizedItem.Payee = this.parent.commonCode.safeTreeGet(treeMap, "P");
        memorizedItem.Memo = this.parent.commonCode.safeTreeGet(treeMap, "M");
        memorizedItem.Category = this.parent.commonCode.safeTreeGet(treeMap, "L");
        memorizedItem.Type = this.parent.commonCode.safeTreeGet(treeMap, "K");
        memorizedItem.Cleared = this.parent.commonCode.safeTreeGet(treeMap, "C").toLowerCase().equals("x");
        Memorized.decodeAddress(treeMap, memorizedItem);
        int n = 1;
        String string = "";
        while (treeMap.containsKey("S" + string)) {
            String string2 = this.parent.commonCode.safeTreeGet(treeMap, "S" + string);
            String string3 = this.parent.commonCode.safeTreeGet(treeMap, "E" + string);
            String string4 = this.parent.commonCode.safeTreeGet(treeMap, "$" + string);
            double d = this.parent.commonCode.zeroFailParseDouble(string4);
            MemorizedItem memorizedItem2 = new MemorizedItem(this.parent, string2, string3, d);
            memorizedItem.addSplit(memorizedItem2, true);
            string = "" + ++n;
        }
        this.addMemorizedItem(memorizedItem);
    }

    public static void decodeAddress(TreeMap treeMap, MemorizedItem memorizedItem) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        String string = "";
        while (treeMap.containsKey("A" + string)) {
            stringBuffer.append((String)treeMap.get("A" + string) + "\\n");
            string = String.valueOf(++n);
        }
        if (stringBuffer.length() > 0) {
            memorizedItem.Address = stringBuffer.toString();
        }
    }

    public void addMemorizedItem(MemorizedItem memorizedItem) {
        this.addItem(memorizedItem.Payee, memorizedItem);
        this.lcMap.put(memorizedItem.Payee.toLowerCase(), memorizedItem);
    }

    public void deleteMemorizedItem(String string) {
        this.dataMap.remove(string);
        this.lcMap.remove(string.toLowerCase());
    }

    @Override
    public boolean allowEditRecords(int n) {
        return true;
    }

    @Override
    public Object getDataObject(String string) {
        return this.dataMap.get(string);
    }

    @Override
    public Object getDataObject(int n) {
        return new MemorizedItem(this.parent);
    }

    @Override
    public boolean allowCreateDeleteRecords() {
        return true;
    }

    public void memorizeTransaction(String string, Transaction transaction, String string2) {
        int n;
        if (this.keyExists(string) && (n = JOptionPane.showConfirmDialog(this.parent, "This memorized transaction already\nexists. Replace?", "Transaction exists", 0)) != 0) {
            return;
        }
        MemorizedItem memorizedItem = new MemorizedItem(this.parent, transaction, string2);
        this.addItem(memorizedItem.Payee, memorizedItem);
    }

    public void renameLinks(String string, String string2) {
        String[] stringArray = this.getDataKeys();
        int n = this.getDataSize();
        for (int i = 0; i < n; ++i) {
            MemorizedItem memorizedItem = (MemorizedItem)this.getDataObject(stringArray[i]);
            if (!memorizedItem.renameCategory(string, string2)) continue;
            this.dataChanged = true;
        }
    }
}

