/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.http;

import com.dropbox.core.util.IOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public abstract class HttpRequestor {
    public static final long DEFAULT_CONNECT_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(20L);
    public static final long DEFAULT_READ_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(2L);

    public abstract Response doGet(String var1, Iterable<Header> var2) throws IOException;

    public abstract Uploader startPost(String var1, Iterable<Header> var2) throws IOException;

    public Uploader startPostInStreamingMode(String url, Iterable<Header> headers) throws IOException {
        return this.startPost(url, headers);
    }

    public abstract Uploader startPut(String var1, Iterable<Header> var2) throws IOException;

    public static final class Response {
        private final int statusCode;
        private final InputStream body;
        private final Map<String, List<String>> headers;

        public Response(int statusCode, InputStream body, Map<String, ? extends List<String>> headers) {
            this.statusCode = statusCode;
            this.body = body;
            this.headers = Response.asUnmodifiableCaseInsensitiveMap(headers);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public InputStream getBody() {
            return this.body;
        }

        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        private static final Map<String, List<String>> asUnmodifiableCaseInsensitiveMap(Map<String, ? extends List<String>> original) {
            TreeMap<String, List<String>> insensitive = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            for (Map.Entry<String, ? extends List<String>> entry : original.entrySet()) {
                if (entry.getKey() == null || entry.getKey().trim().length() == 0) continue;
                insensitive.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
            }
            return Collections.unmodifiableMap(insensitive);
        }
    }

    public static abstract class Uploader {
        protected IOUtil.ProgressListener progressListener;

        public abstract OutputStream getBody();

        public abstract void close();

        public abstract void abort();

        public abstract Response finish() throws IOException;

        public void upload(File file) throws IOException {
            try {
                this.upload(new FileInputStream(file));
            }
            catch (IOUtil.ReadException ex) {
                throw ex.getCause();
            }
            catch (IOUtil.WriteException ex) {
                throw ex.getCause();
            }
        }

        public void upload(InputStream in, long limit) throws IOException {
            this.upload(IOUtil.limit(in, limit));
        }

        public void upload(InputStream in) throws IOException {
            OutputStream out = this.getBody();
            try {
                IOUtil.copyStreamToStream(in, out);
            }
            finally {
                out.close();
            }
        }

        public void upload(byte[] body) throws IOException {
            OutputStream out = this.getBody();
            try {
                out.write(body);
            }
            finally {
                out.close();
            }
        }

        public void setProgressListener(IOUtil.ProgressListener progressListener) {
            this.progressListener = progressListener;
        }
    }

    public static final class Header {
        private final String key;
        private final String value;

        public Header(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

