/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.users;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.users.PaperAsFilesValue;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class UserFeatureValue {
    public static final UserFeatureValue OTHER = new UserFeatureValue().withTag(Tag.OTHER);
    private Tag _tag;
    private PaperAsFilesValue paperAsFilesValue;

    private UserFeatureValue() {
    }

    private UserFeatureValue withTag(Tag _tag) {
        UserFeatureValue result = new UserFeatureValue();
        result._tag = _tag;
        return result;
    }

    private UserFeatureValue withTagAndPaperAsFiles(Tag _tag, PaperAsFilesValue paperAsFilesValue) {
        UserFeatureValue result = new UserFeatureValue();
        result._tag = _tag;
        result.paperAsFilesValue = paperAsFilesValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isPaperAsFiles() {
        return this._tag == Tag.PAPER_AS_FILES;
    }

    public static UserFeatureValue paperAsFiles(PaperAsFilesValue value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new UserFeatureValue().withTagAndPaperAsFiles(Tag.PAPER_AS_FILES, value);
    }

    public PaperAsFilesValue getPaperAsFilesValue() {
        if (this._tag != Tag.PAPER_AS_FILES) {
            throw new IllegalStateException("Invalid tag: required Tag.PAPER_AS_FILES, but was Tag." + this._tag.name());
        }
        return this.paperAsFilesValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.paperAsFilesValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof UserFeatureValue) {
            UserFeatureValue other = (UserFeatureValue)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case PAPER_AS_FILES: {
                    return this.paperAsFilesValue == other.paperAsFilesValue || this.paperAsFilesValue.equals(other.paperAsFilesValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<UserFeatureValue> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UserFeatureValue value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case PAPER_AS_FILES: {
                    g.writeStartObject();
                    this.writeTag("paper_as_files", g);
                    g.writeFieldName("paper_as_files");
                    PaperAsFilesValue.Serializer.INSTANCE.serialize(value.paperAsFilesValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public UserFeatureValue deserialize(JsonParser p) throws IOException, JsonParseException {
            UserFeatureValue value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("paper_as_files".equals(tag)) {
                PaperAsFilesValue fieldValue = null;
                Serializer.expectField("paper_as_files", p);
                fieldValue = PaperAsFilesValue.Serializer.INSTANCE.deserialize(p);
                value = UserFeatureValue.paperAsFiles(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        PAPER_AS_FILES,
        OTHER;

    }
}

