/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.swing;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import javax.swing.AbstractButton;

public class ButtonGroup
extends Observable {
    private List<AbstractButton> buttons = new ArrayList<AbstractButton>();
    private AbstractButton selected = null;
    private ItemListener listener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            AbstractButton b = (AbstractButton)e.getItem();
            if (e.getStateChange() == 1) {
                ButtonGroup.this.setSelected(b);
            } else if (ButtonGroup.this.selected == b) {
                if (ButtonGroup.this.autoDeselect) {
                    ButtonGroup.this.setSelected(null);
                } else {
                    ButtonGroup.this.selected.setSelected(true);
                }
            }
        }
    };
    private boolean autoDeselect = false;

    public void add(AbstractButton b) {
        if (b == null) {
            throw new NullPointerException();
        }
        this.buttons.add(b);
        b.addItemListener(this.listener);
        if (b.isSelected()) {
            this.setSelected(b);
        }
    }

    public void remove(AbstractButton b) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (this.buttons.remove(b)) {
            b.removeItemListener(this.listener);
            if (this.selected == b) {
                this.setSelected(null);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void clearSelection() {
        if (this.selected != null) {
            this.setSelected(null);
        }
    }

    public AbstractButton getSelected() {
        return this.selected;
    }

    public void setSelected(AbstractButton b) {
        if (b == this.selected) {
            return;
        }
        if (b != null && !this.buttons.contains(b)) {
            throw new IllegalArgumentException();
        }
        AbstractButton old = this.selected;
        this.selected = b;
        if (b != null) {
            b.setSelected(true);
        }
        if (old != null) {
            old.setSelected(false);
        }
        this.setChanged();
        this.notifyObservers(this.selected);
    }

    public void setAutoDeselect(boolean autoDeselect) {
        this.autoDeselect = autoDeselect;
    }
}

