/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.swing.framework;

import com.fathzer.soft.ajlib.swing.Utils;
import com.fathzer.soft.ajlib.swing.framework.MainMenu;
import com.fathzer.soft.ajlib.utilities.LocalizationData;
import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public abstract class Application {
    private JFrame frame;
    public static LocalizationData LOCALIZATION = LocalizationData.DEFAULT;

    public static String getString(String key) {
        return LOCALIZATION.getString(key);
    }

    public static String getString(String key, Locale locale) {
        return LOCALIZATION.getString(key, locale);
    }

    public final void launch() {
        this.setLookAndFeel();
        if (Application.isJava6()) {
            this.installEventQueue();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Application.this.installEventQueue();
                    }
                });
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Application.this.start();
            }
        });
    }

    private static boolean isJava6() {
        return "1.6".equals(System.getProperty("java.specification.version"));
    }

    private void installEventQueue() {
        EventQueue queue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        queue.push(new EventQueue(){

            @Override
            protected void dispatchEvent(AWTEvent event) {
                try {
                    super.dispatchEvent(event);
                }
                catch (Throwable t) {
                    Application.this.processException(t);
                    Window[] windows = Window.getWindows();
                    for (int i = 0; i < windows.length; ++i) {
                        if (windows[i] != Application.this.frame || windows[i].isVisible()) continue;
                        windows[i].dispatchEvent(new WindowEvent(windows[i], 201));
                    }
                }
            }
        });
    }

    protected void processException(Throwable e) {
        e.printStackTrace();
    }

    public String getName() {
        return "";
    }

    private void setLookAndFeel() {
        UIManager.LookAndFeelInfo[] installedLookAndFeels;
        String lookAndFeelName = this.getDefaultLookAndFeelName();
        String lookAndFeelClass = null;
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : installedLookAndFeels = UIManager.getInstalledLookAndFeels()) {
            if (!lookAndFeelInfo.getName().equals(lookAndFeelName)) continue;
            lookAndFeelClass = lookAndFeelInfo.getClassName();
            break;
        }
        if (lookAndFeelClass == null) {
            lookAndFeelClass = UIManager.getSystemLookAndFeelClassName();
        }
        try {
            UIManager.setLookAndFeel(lookAndFeelClass);
            UIManager.getLookAndFeelDefaults().setDefaultLocale(Locale.getDefault());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getDefaultLookAndFeelName() {
        return "Nimbus";
    }

    protected void saveState() {
        Utils.saveState(this.getJFrame(), this.getPreferences());
    }

    protected void restoreState() {
        Utils.restoreState(this.getJFrame(), this.getPreferences());
    }

    private Preferences getPreferences() {
        return Preferences.userRoot().node(this.getClass().getCanonicalName());
    }

    protected abstract Container buildMainPanel();

    protected JMenuBar buildMenuBar() {
        return new MainMenu(this);
    }

    private void start() {
        boolean quit;
        this.frame = new JFrame();
        this.frame.setDefaultCloseOperation(0);
        this.frame.setContentPane(this.buildMainPanel());
        this.frame.setTitle(this.getName());
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                Application.this.onClose(event);
            }
        });
        this.frame.setJMenuBar(this.buildMenuBar());
        this.frame.pack();
        this.restoreState();
        boolean bl = quit = !this.onStart();
        if (quit) {
            this.quit();
        } else {
            this.frame.setVisible(true);
            this.onVisible();
        }
    }

    protected JFrame getJFrame() {
        return this.frame;
    }

    protected void quit() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Application.this.frame.dispatchEvent(new WindowEvent(Application.this.frame, 201));
            }
        });
    }

    protected boolean onStart() {
        return true;
    }

    protected void onVisible() {
    }

    protected void onClose(WindowEvent event) {
        this.saveState();
        event.getWindow().dispose();
    }
}

