/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.swing.table;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public class JTableListener
extends MouseAdapter {
    private Action[] actions;
    private Action defaultAction;

    public JTableListener(Action[] actions, Action defaultAction) {
        this.actions = actions == null ? null : (Action[])actions.clone();
        this.defaultAction = defaultAction;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        JTable jTable = (JTable)e.getComponent();
        if (e.getClickCount() == 2 && e.getButton() == 1) {
            Action action;
            Point p = e.getPoint();
            int row = jTable.rowAtPoint(p);
            if (row >= 0 && (action = this.getDoubleClickAction()) != null) {
                action.actionPerformed(new ActionEvent(e.getSource(), e.getID(), ""));
            }
        } else {
            this.maybeShowPopup(e);
        }
    }

    protected Action getDoubleClickAction() {
        return this.defaultAction;
    }

    private void maybeShowPopup(MouseEvent e) {
        JTable jTable = (JTable)e.getComponent();
        if (e.isPopupTrigger()) {
            Point p = e.getPoint();
            int row = jTable.rowAtPoint(p);
            if (!jTable.isRowSelected(row)) {
                jTable.getSelectionModel().setSelectionInterval(row, row);
            }
            if (this.actions != null && this.actions.length > 0) {
                JPopupMenu popup = new JPopupMenu();
                this.fillPopUp(popup);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    protected void fillPopUp(JPopupMenu popup) {
        for (int i = 0; i < this.actions.length; ++i) {
            if (this.actions[i] == null) {
                popup.addSeparator();
                continue;
            }
            popup.add(new JMenuItem(this.actions[i]));
        }
    }
}

