/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.swing.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class AbstractTitledPanel<T>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel northPanel = null;
    private JLabel iconLabel = null;
    private JLabel textLabel = null;
    protected T data;

    public AbstractTitledPanel(String headerMessage, Icon headerIcon, T data) {
        this.data = data;
        this.initialize();
        this.setHeaderMessage(headerMessage);
        this.setHeaderIcon(headerIcon);
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getNorthPanel(), "North");
        this.add((Component)this.getCenterComponent(), "Center");
    }

    private JPanel getNorthPanel() {
        if (this.northPanel == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints1.gridy = 0;
            this.textLabel = new JLabel();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridy = 0;
            this.northPanel = new JPanel();
            this.northPanel.setLayout(new GridBagLayout());
            this.northPanel.add((Component)this.getIconLabel(), gridBagConstraints);
            this.northPanel.add((Component)this.textLabel, gridBagConstraints1);
        }
        return this.northPanel;
    }

    public void setHeaderMessage(String message) {
        this.textLabel.setText(message);
    }

    public String getHeaderMessage() {
        return this.textLabel.getText();
    }

    private JLabel getIconLabel() {
        if (this.iconLabel == null) {
            this.iconLabel = new JLabel();
        }
        return this.iconLabel;
    }

    public Icon getHeaderIcon() {
        return this.getIconLabel().getIcon();
    }

    public void setHeaderIcon(Icon icon) {
        this.getIconLabel().setIcon(icon);
    }

    public abstract JComponent getCenterComponent();
}

