/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.swing.widget;

import com.fathzer.soft.ajlib.swing.widget.NumberWidget;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;

public class CurrencyWidget
extends NumberWidget {
    private static final long serialVersionUID = 1L;
    private DecimalFormat numberFormat;

    public CurrencyWidget() {
        this(Locale.getDefault());
    }

    public CurrencyWidget(Locale locale) {
        super(locale);
    }

    @Override
    protected DecimalFormat buildFormat(Locale locale) {
        this.numberFormat = super.buildFormat(locale);
        return this.patchJavaBug4510618((DecimalFormat)NumberFormat.getCurrencyInstance(locale));
    }

    public Currency getCurrency() {
        return this.getFormat().getCurrency();
    }

    public void setCurrency(Currency currency) {
        this.getFormat().setCurrency(currency);
        int digits = currency.getDefaultFractionDigits();
        this.getFormat().setMaximumFractionDigits(digits);
        this.getFormat().setMinimumFractionDigits(digits);
        this.refreshText();
    }

    @Override
    protected Number parseValue(String text) {
        Number result = super.parseValue(text);
        if (result == null) {
            result = CurrencyWidget.safeParse(this.numberFormat, text);
        }
        return result;
    }
}

